/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.wsdl.OperationType;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.commons.logging.Log;

public class OperationDesc
implements Serializable {
    public static final int MSG_METHOD_BODYARRAY = 1;
    public static final int MSG_METHOD_SOAPENVELOPE = 2;
    public static final int MSG_METHOD_ELEMENTARRAY = 3;
    public static final int MSG_METHOD_DOCUMENT = 4;
    public static final int MSG_METHOD_NONCONFORMING = -4;
    public static Map mepStrings = new HashMap();
    protected static Log log;
    private ServiceDesc parent;
    private ArrayList parameters = new ArrayList();
    private String name;
    private QName elementQName;
    private transient Method method;
    private Style style = null;
    private Use use = null;
    private int numInParams = 0;
    private int numOutParams = 0;
    private String soapAction = null;
    private ArrayList faults = null;
    private ParameterDesc returnDesc = new ParameterDesc();
    private int messageOperationStyle = -1;
    private String documentation = null;
    private OperationType mep = OperationType.REQUEST_RESPONSE;

    public OperationDesc() {
        this.returnDesc.setMode((byte)2);
        this.returnDesc.setIsReturn(true);
    }

    public OperationDesc(String string, ParameterDesc[] parameterDescArray, QName qName) {
        this.name = string;
        this.returnDesc.setQName(qName);
        this.returnDesc.setMode((byte)2);
        this.returnDesc.setIsReturn(true);
        for (int i = 0; i < parameterDescArray.length; ++i) {
            this.addParameter(parameterDescArray[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public QName getReturnQName() {
        return this.returnDesc.getQName();
    }

    public void setReturnQName(QName qName) {
        this.returnDesc.setQName(qName);
    }

    public QName getReturnType() {
        return this.returnDesc.getTypeQName();
    }

    public void setReturnType(QName qName) {
        log.debug("@" + Integer.toHexString(this.hashCode()) + "setReturnType(" + qName + ")");
        this.returnDesc.setTypeQName(qName);
    }

    public Class getReturnClass() {
        return this.returnDesc.getJavaType();
    }

    public void setReturnClass(Class clazz) {
        this.returnDesc.setJavaType(clazz);
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public void setElementQName(QName qName) {
        this.elementQName = qName;
    }

    public ServiceDesc getParent() {
        return this.parent;
    }

    public void setParent(ServiceDesc serviceDesc) {
        this.parent = serviceDesc;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        if (this.style == null) {
            if (this.parent != null) {
                return this.parent.getStyle();
            }
            return Style.DEFAULT;
        }
        return this.style;
    }

    public void setUse(Use use) {
        this.use = use;
    }

    public Use getUse() {
        if (this.use == null) {
            if (this.parent != null) {
                return this.parent.getUse();
            }
            return Use.DEFAULT;
        }
        return this.use;
    }

    public void addParameter(ParameterDesc parameterDesc) {
        parameterDesc.setOrder(this.getNumParams());
        this.parameters.add(parameterDesc);
        if (parameterDesc.getMode() == 1 || parameterDesc.getMode() == 3) {
            ++this.numInParams;
        }
        if (parameterDesc.getMode() == 2 || parameterDesc.getMode() == 3) {
            ++this.numOutParams;
        }
        log.debug("@" + Integer.toHexString(this.hashCode()) + " added parameter >" + parameterDesc + "@" + Integer.toHexString(parameterDesc.hashCode()) + "<total parameters:" + this.getNumParams());
    }

    public void addParameter(QName qName, QName qName2, Class clazz, byte by, boolean bl, boolean bl2) {
        ParameterDesc parameterDesc = new ParameterDesc(qName, by, qName2, clazz, bl, bl2);
        this.addParameter(parameterDesc);
    }

    public ParameterDesc getParameter(int n) {
        if (this.parameters.size() <= n) {
            return null;
        }
        return (ParameterDesc)this.parameters.get(n);
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    public void setParameters(ArrayList arrayList) {
        this.parameters = new ArrayList();
        this.numInParams = 0;
        this.numOutParams = 0;
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            this.addParameter((ParameterDesc)listIterator.next());
        }
    }

    public int getNumInParams() {
        return this.numInParams;
    }

    public int getNumOutParams() {
        return this.numOutParams;
    }

    public int getNumParams() {
        return this.parameters.size();
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public boolean isReturnHeader() {
        return this.returnDesc.isOutHeader();
    }

    public void setReturnHeader(boolean bl) {
        this.returnDesc.setOutHeader(bl);
    }

    public ParameterDesc getParamByQName(QName qName) {
        for (ParameterDesc parameterDesc : this.parameters) {
            if (!parameterDesc.getQName().equals(qName)) continue;
            return parameterDesc;
        }
        return null;
    }

    public ParameterDesc getInputParamByQName(QName qName) {
        ParameterDesc parameterDesc = null;
        parameterDesc = this.getParamByQName(qName);
        if (parameterDesc == null || parameterDesc.getMode() == 2) {
            parameterDesc = null;
        }
        return parameterDesc;
    }

    public ParameterDesc getOutputParamByQName(QName qName) {
        ParameterDesc parameterDesc = null;
        for (ParameterDesc parameterDesc2 : this.parameters) {
            if (!parameterDesc2.getQName().equals(qName) || parameterDesc2.getMode() == 1) continue;
            parameterDesc = parameterDesc2;
            break;
        }
        if (parameterDesc == null) {
            if (null == this.returnDesc.getQName()) {
                parameterDesc = new ParameterDesc(this.returnDesc);
                parameterDesc.setQName(qName);
            } else if (qName.equals(this.returnDesc.getQName())) {
                parameterDesc = this.returnDesc;
            }
        }
        return parameterDesc;
    }

    public ArrayList getAllInParams() {
        ArrayList<ParameterDesc> arrayList = new ArrayList<ParameterDesc>();
        for (ParameterDesc parameterDesc : this.parameters) {
            if (parameterDesc.getMode() == 2) continue;
            arrayList.add(parameterDesc);
        }
        return arrayList;
    }

    public ArrayList getAllOutParams() {
        ArrayList<ParameterDesc> arrayList = new ArrayList<ParameterDesc>();
        for (ParameterDesc parameterDesc : this.parameters) {
            if (parameterDesc.getMode() == 1) continue;
            arrayList.add(parameterDesc);
        }
        return arrayList;
    }

    public ArrayList getOutParams() {
        ArrayList<ParameterDesc> arrayList = new ArrayList<ParameterDesc>();
        for (ParameterDesc parameterDesc : this.parameters) {
            if (parameterDesc.getMode() != 2) continue;
            arrayList.add(parameterDesc);
        }
        return arrayList;
    }

    public void addFault(FaultDesc faultDesc) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        this.faults.add(faultDesc);
    }

    public ArrayList getFaults() {
        return this.faults;
    }

    public FaultDesc getFaultByClass(Class clazz) {
        if (this.faults == null || clazz == null) {
            return null;
        }
        while (clazz != null) {
            for (FaultDesc faultDesc : this.faults) {
                if (!clazz.getName().equals(faultDesc.getClassName())) continue;
                return faultDesc;
            }
            if ((clazz = clazz.getSuperclass()) == null || !clazz.getName().startsWith("java.") && !clazz.getName().startsWith("javax.")) continue;
            clazz = null;
        }
        return null;
    }

    public FaultDesc getFaultByClass(Class clazz, boolean bl) {
        if (bl) {
            return this.getFaultByClass(clazz);
        }
        if (this.faults == null || clazz == null) {
            return null;
        }
        for (FaultDesc faultDesc : this.faults) {
            if (!clazz.getName().equals(faultDesc.getClassName())) continue;
            return faultDesc;
        }
        return null;
    }

    public FaultDesc getFaultByQName(QName qName) {
        if (this.faults != null) {
            for (FaultDesc faultDesc : this.faults) {
                if (!qName.equals(faultDesc.getQName())) continue;
                return faultDesc;
            }
        }
        return null;
    }

    public FaultDesc getFaultByXmlType(QName qName) {
        if (this.faults != null) {
            for (FaultDesc faultDesc : this.faults) {
                if (!qName.equals(faultDesc.getXmlType())) continue;
                return faultDesc;
            }
        }
        return null;
    }

    public ParameterDesc getReturnParamDesc() {
        return this.returnDesc;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        int n;
        String string2 = "";
        string2 = string2 + string + "name:        " + this.getName() + "\n";
        string2 = string2 + string + "returnQName: " + this.getReturnQName() + "\n";
        string2 = string2 + string + "returnType:  " + this.getReturnType() + "\n";
        string2 = string2 + string + "returnClass: " + this.getReturnClass() + "\n";
        string2 = string2 + string + "elementQName:" + this.getElementQName() + "\n";
        string2 = string2 + string + "soapAction:  " + this.getSoapAction() + "\n";
        string2 = string2 + string + "style:       " + this.getStyle().getName() + "\n";
        string2 = string2 + string + "use:         " + this.getUse().getName() + "\n";
        string2 = string2 + string + "numInParams: " + this.getNumInParams() + "\n";
        string2 = string2 + string + "method:" + this.getMethod() + "\n";
        for (n = 0; n < this.parameters.size(); ++n) {
            string2 = string2 + string + " ParameterDesc[" + n + "]:\n";
            string2 = string2 + string + ((ParameterDesc)this.parameters.get(n)).toString("  ") + "\n";
        }
        if (this.faults != null) {
            for (n = 0; n < this.faults.size(); ++n) {
                string2 = string2 + string + " FaultDesc[" + n + "]:\n";
                string2 = string2 + string + ((FaultDesc)this.faults.get(n)).toString("  ") + "\n";
            }
        }
        return string2;
    }

    public int getMessageOperationStyle() {
        return this.messageOperationStyle;
    }

    public void setMessageOperationStyle(int n) {
        this.messageOperationStyle = n;
    }

    public OperationType getMep() {
        return this.mep;
    }

    public void setMep(OperationType operationType) {
        this.mep = operationType;
    }

    public void setMep(String string) {
        OperationType operationType = (OperationType)mepStrings.get(string);
        if (operationType != null) {
            this.mep = operationType;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.method != null) {
            objectOutputStream.writeObject(this.method.getDeclaringClass());
            objectOutputStream.writeObject(this.method.getName());
            objectOutputStream.writeObject(this.method.getParameterTypes());
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Class clazz = (Class)objectInputStream.readObject();
        if (clazz != null) {
            String string = (String)objectInputStream.readObject();
            Class[] classArray = (Class[])objectInputStream.readObject();
            try {
                this.method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException("Unable to deserialize the operation's method: " + string);
            }
        }
    }

    static {
        mepStrings.put("request-response", OperationType.REQUEST_RESPONSE);
        mepStrings.put("oneway", OperationType.ONE_WAY);
        mepStrings.put("solicit-response", OperationType.SOLICIT_RESPONSE);
        mepStrings.put("notification", OperationType.NOTIFICATION);
        log = LogFactory.getLog(OperationDesc.class.getName());
    }
}

