/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.cache.MethodCache;

public class TypeDesc
implements Serializable {
    public static final Class[] noClasses = new Class[0];
    public static final Object[] noObjects = new Object[0];
    private static Map classMap = new Hashtable();
    private boolean lookedForAny = false;
    private boolean canSearchParents = true;
    private boolean hasSearchedParents = false;
    private TypeDesc parentDesc = null;
    private Class javaClass = null;
    private QName xmlType = null;
    private FieldDesc[] fields;
    private HashMap fieldNameMap = new HashMap();
    private HashMap fieldElementMap = null;
    private boolean _hasAttributes = false;
    private BeanPropertyDescriptor[] propertyDescriptors = null;
    private Map propertyMap = null;
    private BeanPropertyDescriptor anyDesc = null;

    public TypeDesc(Class clazz) {
        this(clazz, true);
    }

    public TypeDesc(Class clazz, boolean bl) {
        this.javaClass = clazz;
        this.canSearchParents = bl;
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && !clazz2.getName().startsWith("java.")) {
            this.parentDesc = TypeDesc.getTypeDescForClass(clazz2);
        }
    }

    public static void registerTypeDescForClass(Class clazz, TypeDesc typeDesc) {
        classMap.put(clazz, typeDesc);
    }

    public static TypeDesc getTypeDescForClass(Class clazz) {
        TypeDesc typeDesc = (TypeDesc)classMap.get(clazz);
        if (typeDesc == null) {
            try {
                Method method = MethodCache.getInstance().getMethod(clazz, "getTypeDesc", noClasses);
                if (method != null && (typeDesc = (TypeDesc)method.invoke(null, noObjects)) != null) {
                    classMap.put(clazz, typeDesc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return typeDesc;
    }

    public BeanPropertyDescriptor getAnyDesc() {
        return this.anyDesc;
    }

    public FieldDesc[] getFields() {
        return this.fields;
    }

    public FieldDesc[] getFields(boolean bl) {
        if (this.canSearchParents && bl && !this.hasSearchedParents) {
            FieldDesc[] fieldDescArray;
            if (this.parentDesc != null && (fieldDescArray = this.parentDesc.getFields(true)) != null) {
                if (this.fields != null) {
                    FieldDesc[] fieldDescArray2 = new FieldDesc[fieldDescArray.length + this.fields.length];
                    System.arraycopy(fieldDescArray, 0, fieldDescArray2, 0, fieldDescArray.length);
                    System.arraycopy(this.fields, 0, fieldDescArray2, fieldDescArray.length, this.fields.length);
                    this.fields = fieldDescArray2;
                } else {
                    FieldDesc[] fieldDescArray3 = new FieldDesc[fieldDescArray.length];
                    System.arraycopy(fieldDescArray, 0, fieldDescArray3, 0, fieldDescArray.length);
                    this.fields = fieldDescArray3;
                }
            }
            this.hasSearchedParents = true;
        }
        return this.fields;
    }

    public void setFields(FieldDesc[] fieldDescArray) {
        this.fieldNameMap = new HashMap();
        this.fields = fieldDescArray;
        this._hasAttributes = false;
        this.fieldElementMap = null;
        for (int i = 0; i < fieldDescArray.length; ++i) {
            FieldDesc fieldDesc = fieldDescArray[i];
            if (!fieldDesc.isElement()) {
                this._hasAttributes = true;
            }
            this.fieldNameMap.put(fieldDesc.getFieldName(), fieldDesc);
        }
    }

    public void addFieldDesc(FieldDesc fieldDesc) {
        if (fieldDesc == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullFieldDesc"));
        }
        int n = 0;
        if (this.fields != null) {
            n = this.fields.length;
        }
        FieldDesc[] fieldDescArray = new FieldDesc[n + 1];
        if (this.fields != null) {
            System.arraycopy(this.fields, 0, fieldDescArray, 0, n);
        }
        fieldDescArray[n] = fieldDesc;
        this.fields = fieldDescArray;
        this.fieldNameMap.put(fieldDesc.getFieldName(), fieldDesc);
        if (!this._hasAttributes && !fieldDesc.isElement()) {
            this._hasAttributes = true;
        }
    }

    public QName getElementNameForField(String string) {
        FieldDesc fieldDesc = (FieldDesc)this.fieldNameMap.get(string);
        if (fieldDesc == null) {
            if (this.canSearchParents && this.parentDesc != null) {
                return this.parentDesc.getElementNameForField(string);
            }
        } else if (fieldDesc.isElement()) {
            return fieldDesc.getXmlName();
        }
        return null;
    }

    public QName getAttributeNameForField(String string) {
        FieldDesc fieldDesc = (FieldDesc)this.fieldNameMap.get(string);
        if (fieldDesc == null) {
            if (this.canSearchParents && this.parentDesc != null) {
                return this.parentDesc.getAttributeNameForField(string);
            }
        } else if (!fieldDesc.isElement()) {
            QName qName = fieldDesc.getXmlName();
            if (qName == null) {
                qName = new QName("", string);
            }
            return qName;
        }
        return null;
    }

    public String getFieldNameForElement(QName qName, boolean bl) {
        String string;
        if (this.fieldElementMap != null && (string = (String)this.fieldElementMap.get(qName)) != null) {
            return string;
        }
        string = null;
        String string2 = qName.getLocalPart();
        for (int i = 0; this.fields != null && i < this.fields.length; ++i) {
            QName qName2;
            FieldDesc fieldDesc = this.fields[i];
            if (!fieldDesc.isElement() || !string2.equals((qName2 = fieldDesc.getXmlName()).getLocalPart()) || !bl && !qName.getNamespaceURI().equals(qName2.getNamespaceURI())) continue;
            string = fieldDesc.getFieldName();
            break;
        }
        if (string == null && this.canSearchParents && this.parentDesc != null) {
            string = this.parentDesc.getFieldNameForElement(qName, bl);
        }
        if (string != null) {
            if (this.fieldElementMap == null) {
                this.fieldElementMap = new HashMap();
            }
            this.fieldElementMap.put(qName, string);
        }
        return string;
    }

    public String getFieldNameForAttribute(QName qName) {
        String string = null;
        for (int i = 0; this.fields != null && i < this.fields.length; ++i) {
            FieldDesc fieldDesc = this.fields[i];
            if (fieldDesc.isElement()) continue;
            if (qName.equals(fieldDesc.getXmlName())) {
                return fieldDesc.getFieldName();
            }
            if (!qName.getNamespaceURI().equals("") || !qName.getLocalPart().equals(fieldDesc.getFieldName())) continue;
            string = fieldDesc.getFieldName();
        }
        if (string == null && this.canSearchParents && this.parentDesc != null) {
            string = this.parentDesc.getFieldNameForAttribute(qName);
        }
        return string;
    }

    public FieldDesc getFieldByName(String string) {
        FieldDesc fieldDesc = (FieldDesc)this.fieldNameMap.get(string);
        if (fieldDesc == null && this.canSearchParents && this.parentDesc != null) {
            fieldDesc = this.parentDesc.getFieldByName(string);
        }
        return fieldDesc;
    }

    public boolean hasAttributes() {
        if (this._hasAttributes) {
            return true;
        }
        if (this.canSearchParents && this.parentDesc != null) {
            return this.parentDesc.hasAttributes();
        }
        return false;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(QName qName) {
        this.xmlType = qName;
    }

    public BeanPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.makePropertyDescriptors();
        }
        return this.propertyDescriptors;
    }

    private synchronized void makePropertyDescriptors() {
        if (this.propertyDescriptors != null) {
            return;
        }
        this.propertyDescriptors = BeanUtils.getPd(this.javaClass, this);
        if (!this.lookedForAny) {
            this.anyDesc = BeanUtils.getAnyContentPD(this.javaClass);
            this.lookedForAny = true;
        }
    }

    public BeanPropertyDescriptor getAnyContentDescriptor() {
        if (!this.lookedForAny) {
            this.anyDesc = BeanUtils.getAnyContentPD(this.javaClass);
            this.lookedForAny = true;
        }
        return this.anyDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPropertyDescriptorMap() {
        TypeDesc typeDesc = this;
        synchronized (typeDesc) {
            if (this.propertyMap != null) {
                return this.propertyMap;
            }
            if (this.propertyDescriptors == null) {
                this.getPropertyDescriptors();
            }
            this.propertyMap = new HashMap();
            for (int i = 0; i < this.propertyDescriptors.length; ++i) {
                BeanPropertyDescriptor beanPropertyDescriptor = this.propertyDescriptors[i];
                this.propertyMap.put(beanPropertyDescriptor.getName(), beanPropertyDescriptor);
            }
        }
        return this.propertyMap;
    }
}

