/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.holders.QNameHolder;
import org.apache.axis.AxisProperties;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.encoding.XMLEncoder;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.types.HexBinary;
import org.apache.axis.utils.IDKey;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.utils.cache.MethodCache;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SerializationContext
implements javax.xml.rpc.encoding.SerializationContext {
    protected static Log log = LogFactory.getLog(SerializationContext.class.getName());
    private final boolean debugEnabled = log.isDebugEnabled();
    private NSStack nsStack = null;
    private boolean writingStartTag = false;
    private boolean onlyXML = true;
    private int indent = 0;
    private Stack elementStack = new Stack();
    private Writer writer;
    private int lastPrefixIndex = 1;
    private MessageContext msgContext;
    private QName currentXMLType;
    private QName itemQName;
    private QName itemType;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    private static QName multirefQName = new QName("", "multiRef");
    private static Class[] SERIALIZER_CLASSES = new Class[]{String.class, Class.class, QName.class};
    private static final String SERIALIZER_METHOD = "getSerializer";
    private boolean doMultiRefs = false;
    private boolean disablePrettyXML = false;
    private boolean enableNamespacePrefixOptimization = false;
    private boolean pretty = false;
    private boolean sendXMLDecl = true;
    private boolean sendXSIType = true;
    private Boolean sendNull = Boolean.TRUE;
    private HashMap multiRefValues = null;
    private int multiRefIndex = -1;
    private boolean noNamespaceMappings = true;
    private QName writeXMLType;
    private XMLEncoder encoder = null;
    protected boolean startOfDocument = true;
    private String encoding = "UTF-8";
    private HashSet secondLevelObjects = null;
    private Object forceSer = null;
    private boolean outputMultiRefsFlag = false;
    SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    HashMap preferredPrefixes = new HashMap();

    public SerializationContext(Writer writer) {
        this.writer = writer;
        this.initialize();
    }

    private void initialize() {
        this.preferredPrefixes.put(this.soapConstants.getEncodingURI(), "soapenc");
        this.preferredPrefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
        this.preferredPrefixes.put(this.schemaVersion.getXsdURI(), "xsd");
        this.preferredPrefixes.put(this.schemaVersion.getXsiURI(), "xsi");
        this.preferredPrefixes.put(this.soapConstants.getEnvelopeURI(), "soapenv");
        this.nsStack = new NSStack(this.enableNamespacePrefixOptimization);
    }

    public SerializationContext(Writer writer, MessageContext messageContext) {
        this.writer = writer;
        this.msgContext = messageContext;
        if (messageContext != null) {
            Boolean bl;
            Boolean bl2;
            Boolean bl3;
            this.soapConstants = messageContext.getSOAPConstants();
            this.schemaVersion = messageContext.getSchemaVersion();
            Boolean bl4 = (Boolean)messageContext.getProperty("sendXMLDeclaration");
            if (bl4 != null) {
                this.sendXMLDecl = bl4;
            }
            if ((bl3 = (Boolean)messageContext.getProperty("sendMultiRefs")) != null) {
                this.doMultiRefs = bl3;
            }
            if ((bl2 = (Boolean)messageContext.getProperty("disablePrettyXML")) != null) {
                this.disablePrettyXML = bl2;
            }
            this.enableNamespacePrefixOptimization = (bl = (Boolean)messageContext.getProperty("enableNamespacePrefixOptimization")) != null ? bl : JavaUtils.isTrue(AxisProperties.getProperty("enableNamespacePrefixOptimization", "true"));
            boolean bl5 = this.sendXSIType;
            OperationDesc operationDesc = messageContext.getOperation();
            if (operationDesc != null) {
                if (operationDesc.getUse() != Use.ENCODED) {
                    this.doMultiRefs = false;
                    bl5 = false;
                }
            } else {
                SOAPService sOAPService = messageContext.getService();
                if (sOAPService != null && sOAPService.getUse() != Use.ENCODED) {
                    this.doMultiRefs = false;
                    bl5 = false;
                }
            }
            if (!messageContext.isPropertyTrue("sendXsiTypes", bl5)) {
                this.sendXSIType = false;
            }
        } else {
            this.enableNamespacePrefixOptimization = JavaUtils.isTrue(AxisProperties.getProperty("enableNamespacePrefixOptimization", "true"));
        }
        this.initialize();
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean bl) {
        if (!this.disablePrettyXML) {
            this.pretty = bl;
        }
    }

    public boolean getDoMultiRefs() {
        return this.doMultiRefs;
    }

    public void setDoMultiRefs(boolean bl) {
        this.doMultiRefs = bl;
    }

    public void setSendDecl(boolean bl) {
        this.sendXMLDecl = bl;
    }

    public boolean shouldSendXSIType() {
        return this.sendXSIType;
    }

    public TypeMapping getTypeMapping() {
        if (this.msgContext == null) {
            return DefaultTypeMappingImpl.getSingletonDelegate();
        }
        String string = this.msgContext.getEncodingStyle();
        if (string == null) {
            string = this.soapConstants.getEncodingURI();
        }
        return (TypeMapping)this.msgContext.getTypeMappingRegistry().getTypeMapping(string);
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getTypeMappingRegistry();
    }

    public String getPrefixForURI(String string) {
        return this.getPrefixForURI(string, null, false);
    }

    public String getPrefixForURI(String string, String string2) {
        return this.getPrefixForURI(string, string2, false);
    }

    public String getPrefixForURI(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string3 = this.nsStack.getPrefix(string, bl);
        if (string3 == null) {
            string3 = (String)this.preferredPrefixes.get(string);
            if (string3 == null) {
                if (string2 == null) {
                    string3 = "ns" + this.lastPrefixIndex++;
                    while (this.nsStack.getNamespaceURI(string3) != null) {
                        string3 = "ns" + this.lastPrefixIndex++;
                    }
                } else {
                    string3 = string2;
                }
            }
            this.registerPrefixForURI(string3, string);
        }
        return string3;
    }

    public void registerPrefixForURI(String string, String string2) {
        if (this.debugEnabled) {
            log.debug(Messages.getMessage("register00", string, string2));
        }
        if (string2 != null && string != null) {
            String string3;
            if (this.noNamespaceMappings) {
                this.nsStack.push();
                this.noNamespaceMappings = false;
            }
            if ((string3 = this.nsStack.getPrefix(string2, true)) == null || !string3.equals(string)) {
                this.nsStack.add(string2, string);
            }
        }
    }

    public Message getCurrentMessage() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getCurrentMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public String getEncodingStyle() {
        return this.msgContext == null ? Use.DEFAULT.getEncoding() : this.msgContext.getEncodingStyle();
    }

    public boolean isEncoded() {
        return Constants.isSOAP_ENC(this.getEncodingStyle());
    }

    public String qName2String(QName qName, boolean bl) {
        String string = null;
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getLocalPart();
        if (string3 != null && string3.length() > 0) {
            int n = string3.indexOf(58);
            if (n != -1) {
                string = string3.substring(0, n);
                if (string.length() > 0 && !string.equals("urn")) {
                    this.registerPrefixForURI(string, string2);
                    string3 = string3.substring(n + 1);
                } else {
                    string = null;
                }
            }
            string3 = Utils.getLastLocalPart(string3);
        }
        if (string2.length() == 0) {
            String string4;
            if (bl && (string4 = this.nsStack.getNamespaceURI("")) != null && string4.length() > 0) {
                this.registerPrefixForURI("", "");
            }
        } else {
            string = this.getPrefixForURI(string2);
        }
        if (string == null || string.length() == 0) {
            return string3;
        }
        return string + ':' + string3;
    }

    public String qName2String(QName qName) {
        return this.qName2String(qName, false);
    }

    public String attributeQName2String(QName qName) {
        String string = null;
        String string2 = qName.getNamespaceURI();
        if (string2.length() > 0) {
            string = this.getPrefixForURI(string2, null, true);
        }
        if (string == null || string.length() == 0) {
            return qName.getLocalPart();
        }
        return string + ':' + qName.getLocalPart();
    }

    public QName getQNameForClass(Class clazz) {
        return this.getTypeMapping().getTypeQName(clazz);
    }

    public boolean isPrimitive(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == String.class) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (HexBinary.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Element.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz == byte[].class) {
            return true;
        }
        if (clazz.isArray()) {
            return true;
        }
        QName qName = this.getQNameForClass(clazz);
        return qName != null && Constants.isSchemaXSD(qName.getNamespaceURI()) && SchemaUtils.isSimpleSchemaType(qName);
    }

    public void serialize(QName qName, Attributes attributes, Object object) throws IOException {
        this.serialize(qName, attributes, object, null, null, null);
    }

    public void serialize(QName qName, Attributes attributes, Object object, QName qName2) throws IOException {
        this.serialize(qName, attributes, object, qName2, null, null);
    }

    public void serialize(QName qName, Attributes attributes, Object object, QName qName2, boolean bl, Boolean bl2) throws IOException {
        this.serialize(qName, attributes, object, qName2, bl ? Boolean.TRUE : Boolean.FALSE, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(QName qName, Attributes attributes, Object object, QName qName2, Boolean bl, Boolean bl2) throws IOException {
        boolean bl3 = this.sendXSIType;
        if (bl2 != null) {
            this.sendXSIType = bl2;
        }
        boolean bl4 = this.shouldSendXSIType();
        try {
            Object object2;
            Boolean bl5 = this.sendNull;
            if (bl != null) {
                this.sendNull = bl;
            } else {
                bl = this.sendNull;
            }
            if (object == null) {
                if (this.sendNull.booleanValue()) {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attributesImpl.setAttributes(attributes);
                    }
                    if (bl4) {
                        attributesImpl = (AttributesImpl)this.setTypeAttribute(attributesImpl, qName2);
                    }
                    String string = this.schemaVersion.getNilQName().getLocalPart();
                    attributesImpl.addAttribute(this.schemaVersion.getXsiURI(), string, "xsi:" + string, "CDATA", "true");
                    this.startElement(qName, attributesImpl);
                    this.endElement();
                }
                this.sendNull = bl5;
                return;
            }
            Message message = this.getCurrentMessage();
            if (null != message && null != (object2 = this.getCurrentMessage().getAttachmentsImpl()) && object2.isAttachment(object)) {
                this.serializeActual(qName, attributes, object, qName2, bl2);
                this.sendNull = bl5;
                return;
            }
            if (this.doMultiRefs && this.isEncoded() && object != this.forceSer && !this.isPrimitive(object)) {
                MultiRefItem multiRefItem;
                if (this.multiRefIndex == -1) {
                    this.multiRefValues = new HashMap();
                }
                if ((multiRefItem = (MultiRefItem)this.multiRefValues.get(this.getIdentityKey(object))) == null) {
                    ++this.multiRefIndex;
                    object2 = "id" + this.multiRefIndex;
                    multiRefItem = new MultiRefItem((String)object2, qName2, bl2, object);
                    this.multiRefValues.put(this.getIdentityKey(object), multiRefItem);
                    if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                        AttributesImpl attributesImpl = new AttributesImpl();
                        if (attributes != null && 0 < attributes.getLength()) {
                            attributesImpl.setAttributes(attributes);
                        }
                        attributesImpl.addAttribute("", "id", "id", "CDATA", (String)object2);
                        this.serializeActual(qName, attributesImpl, object, qName2, bl2);
                        this.sendNull = bl5;
                        return;
                    }
                    if (this.outputMultiRefsFlag) {
                        if (this.secondLevelObjects == null) {
                            this.secondLevelObjects = new HashSet();
                        }
                        this.secondLevelObjects.add(this.getIdentityKey(object));
                    }
                } else {
                    object2 = multiRefItem.id;
                }
                AttributesImpl attributesImpl = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attributesImpl.setAttributes(attributes);
                }
                attributesImpl.addAttribute("", this.soapConstants.getAttrHref(), this.soapConstants.getAttrHref(), "CDATA", '#' + (String)object2);
                this.startElement(qName, attributesImpl);
                this.endElement();
                this.sendNull = bl5;
                return;
            }
            if (object == this.forceSer) {
                this.forceSer = null;
            }
            this.serializeActual(qName, attributes, object, qName2, bl2);
        }
        finally {
            this.sendXSIType = bl3;
        }
    }

    private IDKey getIdentityKey(Object object) {
        return new IDKey(object);
    }

    public void outputMultiRefs() throws IOException {
        if (!this.doMultiRefs || this.multiRefValues == null || this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            return;
        }
        this.outputMultiRefsFlag = true;
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "", "", "");
        String string = this.soapConstants.getEncodingURI();
        String string2 = this.getPrefixForURI(string);
        String string3 = string2 + ":root";
        attributesImpl.addAttribute(string, "root", string3, "CDATA", "0");
        String string4 = this.msgContext != null ? this.msgContext.getEncodingStyle() : this.soapConstants.getEncodingURI();
        String string5 = this.getPrefixForURI(this.soapConstants.getEnvelopeURI()) + ':' + "encodingStyle";
        attributesImpl.addAttribute(this.soapConstants.getEnvelopeURI(), "encodingStyle", string5, "CDATA", string4);
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.multiRefValues.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            while (iterator.hasNext()) {
                AttributesImpl attributesImpl2 = new AttributesImpl(attributesImpl);
                Object e = iterator.next();
                MultiRefItem multiRefItem = (MultiRefItem)this.multiRefValues.get(e);
                attributesImpl2.setAttribute(0, "", "id", "id", "CDATA", multiRefItem.id);
                this.forceSer = multiRefItem.value;
                this.serialize(multirefQName, (Attributes)attributesImpl2, multiRefItem.value, multiRefItem.xmlType, this.sendNull, Boolean.TRUE);
            }
            if (this.secondLevelObjects == null) continue;
            iterator = this.secondLevelObjects.iterator();
            this.secondLevelObjects = null;
        }
        this.forceSer = null;
        this.outputMultiRefsFlag = false;
        this.multiRefValues = null;
        this.multiRefIndex = -1;
        this.secondLevelObjects = null;
    }

    public void writeXMLDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"");
        this.writer.write(this.encoding);
        this.writer.write("\"?>");
        this.startOfDocument = false;
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        CharSequence charSequence;
        ArrayList<CharSequence> arrayList = null;
        if (this.debugEnabled) {
            log.debug(Messages.getMessage("startElem00", "[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart()));
        }
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            if (this.pretty) {
                this.writer.write(10);
            }
            ++this.indent;
        }
        if (this.pretty) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        String string = this.qName2String(qName, true);
        this.writer.write(60);
        this.writer.write(string);
        if (this.writeXMLType != null) {
            attributes = this.setTypeAttribute(attributes, this.writeXMLType);
            this.writeXMLType = null;
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                charSequence = attributes.getQName(i);
                this.writer.write(32);
                String string2 = "";
                String string3 = attributes.getURI(i);
                if (string3 != null && string3.length() > 0) {
                    if (((String)charSequence).length() == 0) {
                        string2 = this.getPrefixForURI(string3);
                    } else {
                        int n = ((String)charSequence).indexOf(58);
                        if (n > -1) {
                            string2 = ((String)charSequence).substring(0, n);
                            string2 = this.getPrefixForURI(string3, string2, true);
                        }
                    }
                    charSequence = string2.length() > 0 ? string2 + ':' + attributes.getLocalName(i) : attributes.getLocalName(i);
                } else {
                    charSequence = attributes.getQName(i);
                    if (((String)charSequence).length() == 0) {
                        charSequence = attributes.getLocalName(i);
                    }
                }
                if (((String)charSequence).startsWith("xmlns")) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<CharSequence>();
                    }
                    arrayList.add(charSequence);
                }
                this.writer.write((String)charSequence);
                this.writer.write("=\"");
                this.getEncoder().writeEncoded(this.writer, attributes.getValue(i));
                this.writer.write(34);
            }
        }
        if (this.noNamespaceMappings) {
            this.nsStack.push();
        } else {
            Mapping mapping = this.nsStack.topOfFrame();
            while (mapping != null) {
                if (!(mapping.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") && mapping.getPrefix().equals("xmlns") || mapping.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") && mapping.getPrefix().equals("xml"))) {
                    charSequence = new StringBuffer("xmlns");
                    if (mapping.getPrefix().length() > 0) {
                        ((StringBuffer)charSequence).append(':');
                        ((StringBuffer)charSequence).append(mapping.getPrefix());
                    }
                    if (arrayList == null || arrayList.indexOf(((StringBuffer)charSequence).toString()) == -1) {
                        this.writer.write(32);
                        ((StringBuffer)charSequence).append("=\"");
                        ((StringBuffer)charSequence).append(mapping.getNamespaceURI());
                        ((StringBuffer)charSequence).append('\"');
                        this.writer.write(((StringBuffer)charSequence).toString());
                    }
                }
                mapping = this.nsStack.next();
            }
            this.noNamespaceMappings = true;
        }
        this.writingStartTag = true;
        this.elementStack.push(string);
        this.onlyXML = true;
    }

    public void endElement() throws IOException {
        String string = (String)this.elementStack.pop();
        if (this.debugEnabled) {
            log.debug(Messages.getMessage("endElem00", "" + string));
        }
        this.nsStack.pop();
        if (this.writingStartTag) {
            this.writer.write("/>");
            if (this.pretty) {
                this.writer.write(10);
            }
            this.writingStartTag = false;
            return;
        }
        if (this.onlyXML) {
            --this.indent;
            if (this.pretty) {
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write(32);
                }
            }
        }
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(62);
        if (this.pretty && this.indent > 0) {
            this.writer.write(10);
        }
        this.onlyXML = true;
    }

    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(cArray, n, n2));
        this.onlyXML = false;
    }

    public void writeString(String string) throws IOException {
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writer.write(string);
        this.onlyXML = false;
    }

    public void writeSafeString(String string) throws IOException {
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.getEncoder().writeEncoded(this.writer, string);
        this.onlyXML = false;
    }

    public void writeDOMElement(Element element) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (element instanceof org.apache.axis.message.Text) {
            this.writeSafeString(((Text)((Object)element)).getData());
            return;
        }
        AttributesImpl attributesImpl = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            attributesImpl = new AttributesImpl();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                object3 = (Attr)namedNodeMap.item(i);
                object2 = object3.getNamespaceURI();
                if (object2 != null && ((String)object2).equals("http://www.w3.org/2000/xmlns/")) {
                    object = object3.getLocalName();
                    if (object == null) continue;
                    if (((String)object).equals("xmlns")) {
                        object = "";
                    }
                    String string = object3.getValue();
                    this.registerPrefixForURI((String)object, string);
                    continue;
                }
                attributesImpl.addAttribute(object3.getNamespaceURI(), object3.getLocalName(), object3.getName(), "CDATA", object3.getValue());
            }
        }
        String string = element.getNamespaceURI();
        object3 = element.getLocalName();
        if (string == null || string.length() == 0) {
            object3 = element.getNodeName();
        }
        object2 = new QName(string, (String)object3);
        this.startElement((QName)object2, attributesImpl);
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node instanceof Element) {
                this.writeDOMElement((Element)node);
                continue;
            }
            if (node instanceof CDATASection) {
                this.writeString("<![CDATA[");
                this.writeString(((Text)node).getData());
                this.writeString("]]>");
                continue;
            }
            if (node instanceof Comment) {
                this.writeString("<!--");
                this.writeString(((CharacterData)node).getData());
                this.writeString("-->");
                continue;
            }
            if (!(node instanceof Text)) continue;
            this.writeSafeString(((Text)node).getData());
        }
        this.endElement();
    }

    public final Serializer getSerializerForJavaType(Class clazz) {
        SerializerFactory serializerFactory = null;
        Serializer serializer = null;
        try {
            serializerFactory = (SerializerFactory)this.getTypeMapping().getSerializer(clazz);
            if (serializerFactory != null) {
                serializer = (Serializer)serializerFactory.getSerializerAs("Axis SAX Mechanism");
            }
        }
        catch (JAXRPCException jAXRPCException) {
            // empty catch block
        }
        return serializer;
    }

    public Attributes setTypeAttribute(Attributes attributes, QName qName) {
        if (qName == null || qName.getLocalPart().indexOf(">") >= 0 || attributes != null && attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type") != -1) {
            return attributes;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        if (attributes != null && 0 < attributes.getLength()) {
            attributesImpl.setAttributes(attributes);
        }
        String string = this.getPrefixForURI("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        attributesImpl.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", string + ":type", "CDATA", this.attributeQName2String(qName));
        return attributesImpl;
    }

    private void serializeActual(QName qName, Attributes attributes, Object object, QName qName2, Boolean bl) throws IOException {
        boolean bl2;
        boolean bl3 = bl2 = bl == null ? this.shouldSendXSIType() : bl.booleanValue();
        if (object != null) {
            QNameHolder qNameHolder;
            Serializer serializer;
            Class<?> clazz = object.getClass();
            TypeMapping typeMapping = this.getTypeMapping();
            if (typeMapping == null) {
                throw new IOException(Messages.getMessage("noSerializer00", object.getClass().getName(), "" + this));
            }
            this.currentXMLType = qName2;
            if (Constants.equals(Constants.XSD_ANYTYPE, qName2)) {
                qName2 = null;
                bl2 = true;
            }
            if ((serializer = this.getSerializer(clazz, qName2, qNameHolder = new QNameHolder())) != null) {
                if (bl2 || qName2 != null && !qName2.equals(qNameHolder.value)) {
                    if (!this.isEncoded()) {
                        if (!(Constants.isSOAP_ENC(qNameHolder.value.getNamespaceURI()) || clazz.isArray() && qName2 != null && Constants.isSchemaXSD(qName2.getNamespaceURI()))) {
                            this.writeXMLType = qNameHolder.value;
                        }
                    } else {
                        this.writeXMLType = qNameHolder.value;
                    }
                }
                serializer.serialize(qName, attributes, object, this);
                return;
            }
            throw new IOException(Messages.getMessage("noSerializer00", object.getClass().getName(), "" + typeMapping));
        }
    }

    private Serializer getSerializerFromClass(Class clazz, QName qName) {
        Serializer serializer = null;
        try {
            Method method = MethodCache.getInstance().getMethod(clazz, SERIALIZER_METHOD, SERIALIZER_CLASSES);
            if (method != null) {
                serializer = (Serializer)method.invoke(null, this.getEncodingStyle(), clazz, qName);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return serializer;
    }

    public QName getCurrentXMLType() {
        return this.currentXMLType;
    }

    private SerializerFactory getSerializerFactoryFromInterface(Class clazz, QName qName, TypeMapping typeMapping) {
        SerializerFactory serializerFactory = null;
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                serializerFactory = (SerializerFactory)typeMapping.getSerializer(clazz2, qName);
                if (serializerFactory == null) {
                    serializerFactory = this.getSerializerFactoryFromInterface(clazz2, qName, typeMapping);
                }
                if (serializerFactory != null) break;
            }
        }
        return serializerFactory;
    }

    private Serializer getSerializer(Class clazz, QName qName, QNameHolder qNameHolder) {
        Serializer serializer;
        SerializerFactory serializerFactory = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (qNameHolder != null) {
            qNameHolder.value = null;
        }
        while (clazz != null && (serializerFactory = (SerializerFactory)typeMapping.getSerializer(clazz, qName)) == null) {
            serializer = this.getSerializerFromClass(clazz, qName);
            if (serializer != null) {
                TypeDesc typeDesc;
                if (qNameHolder != null && (typeDesc = TypeDesc.getTypeDescForClass(clazz)) != null) {
                    qNameHolder.value = typeDesc.getXmlType();
                }
                return serializer;
            }
            serializerFactory = this.getSerializerFactoryFromInterface(clazz, qName, typeMapping);
            if (serializerFactory != null) break;
            clazz = clazz.getSuperclass();
        }
        serializer = null;
        if (serializerFactory != null) {
            serializer = (Serializer)serializerFactory.getSerializerAs("Axis SAX Mechanism");
            if (qNameHolder != null) {
                if (serializerFactory instanceof BaseSerializerFactory) {
                    qNameHolder.value = ((BaseSerializerFactory)serializerFactory).getXMLType();
                }
                boolean bl = this.isEncoded();
                if (qNameHolder.value == null || !bl && (qNameHolder.value.equals(Constants.SOAP_ARRAY) || qNameHolder.value.equals(Constants.SOAP_ARRAY12))) {
                    qNameHolder.value = typeMapping.getXMLType(clazz, qName, bl);
                }
            }
        }
        return serializer;
    }

    public String getValueAsString(Object object, QName qName) throws IOException {
        Class<?> clazz = object.getClass();
        Serializer serializer = this.getSerializer(clazz, qName, null);
        if (!(serializer instanceof SimpleValueSerializer)) {
            throw new IOException(Messages.getMessage("needSimpleValueSer", serializer.getClass().getName()));
        }
        SimpleValueSerializer simpleValueSerializer = (SimpleValueSerializer)serializer;
        return simpleValueSerializer.getValueAsString(object, this);
    }

    public void setWriteXMLType(QName qName) {
        this.writeXMLType = qName;
    }

    public XMLEncoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = XMLUtils.getXMLEncoder(this.encoding);
        }
        return this.encoder;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public QName getItemQName() {
        return this.itemQName;
    }

    public void setItemQName(QName qName) {
        this.itemQName = qName;
    }

    public QName getItemType() {
        return this.itemType;
    }

    public void setItemType(QName qName) {
        this.itemType = qName;
    }

    class MultiRefItem {
        String id;
        QName xmlType;
        Boolean sendType;
        Object value;

        MultiRefItem(String string, QName qName, Boolean bl, Object object) {
            this.id = string;
            this.xmlType = qName;
            this.sendType = bl;
            this.value = object;
        }
    }
}

