/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis.encoding.DefaultJAXRPC11TypeMappingImpl;
import org.apache.axis.encoding.DefaultSOAPEncodingTypeMappingImpl;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingDelegate;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.utils.Messages;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry {
    private HashMap mapTM = new HashMap();
    private TypeMappingDelegate defaultDelTM;
    private boolean isDelegated = false;

    public TypeMappingRegistryImpl(TypeMappingImpl typeMappingImpl) {
        this.defaultDelTM = new TypeMappingDelegate(typeMappingImpl);
    }

    public TypeMappingRegistryImpl() {
        this(true);
    }

    public TypeMappingRegistryImpl(boolean bl) {
        if (bl) {
            this.defaultDelTM = DefaultTypeMappingImpl.getSingletonDelegate();
            TypeMappingDelegate typeMappingDelegate = new TypeMappingDelegate(new DefaultSOAPEncodingTypeMappingImpl());
            this.register("http://schemas.xmlsoap.org/soap/encoding/", typeMappingDelegate);
        } else {
            this.defaultDelTM = new TypeMappingDelegate(TypeMappingDelegate.placeholder);
        }
    }

    public void delegate(TypeMappingRegistry typeMappingRegistry) {
        if (this.isDelegated || typeMappingRegistry == null || typeMappingRegistry == this) {
            return;
        }
        this.isDelegated = true;
        String[] stringArray = typeMappingRegistry.getRegisteredEncodingStyleURIs();
        TypeMappingDelegate typeMappingDelegate = ((TypeMappingRegistryImpl)typeMappingRegistry).defaultDelTM;
        if (stringArray != null) {
            block2: for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string = stringArray[i];
                    TypeMappingDelegate typeMappingDelegate2 = (TypeMappingDelegate)this.mapTM.get(string);
                    if (typeMappingDelegate2 == null) {
                        typeMappingDelegate2 = (TypeMappingDelegate)this.createTypeMapping();
                        typeMappingDelegate2.setSupportedEncodings(new String[]{string});
                        this.register(string, typeMappingDelegate2);
                    }
                    if (typeMappingDelegate2 == null) continue;
                    TypeMappingDelegate typeMappingDelegate3 = (TypeMappingDelegate)((TypeMappingRegistryImpl)typeMappingRegistry).mapTM.get(string);
                    while (typeMappingDelegate3.next != null) {
                        TypeMappingDelegate typeMappingDelegate4 = new TypeMappingDelegate(typeMappingDelegate3.delegate);
                        typeMappingDelegate2.setNext(typeMappingDelegate4);
                        if (typeMappingDelegate3.next == typeMappingDelegate) {
                            typeMappingDelegate4.setNext(this.defaultDelTM);
                            continue block2;
                        }
                        typeMappingDelegate3 = typeMappingDelegate3.next;
                        typeMappingDelegate2 = typeMappingDelegate4;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.defaultDelTM.delegate != TypeMappingDelegate.placeholder) {
            this.defaultDelTM.setNext(typeMappingDelegate);
        } else {
            this.defaultDelTM.delegate = typeMappingDelegate.delegate;
        }
    }

    public javax.xml.rpc.encoding.TypeMapping register(String string, javax.xml.rpc.encoding.TypeMapping typeMapping) {
        if (typeMapping == null || !(typeMapping instanceof TypeMappingDelegate)) {
            throw new IllegalArgumentException(Messages.getMessage("badTypeMapping"));
        }
        if (string == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullNamespaceURI"));
        }
        TypeMappingDelegate typeMappingDelegate = (TypeMappingDelegate)typeMapping;
        TypeMappingDelegate typeMappingDelegate2 = (TypeMappingDelegate)this.mapTM.get(string);
        if (typeMappingDelegate2 == null) {
            typeMappingDelegate.setNext(this.defaultDelTM);
        } else {
            typeMappingDelegate.setNext(typeMappingDelegate2);
        }
        this.mapTM.put(string, typeMappingDelegate);
        return typeMappingDelegate2;
    }

    public void registerDefault(javax.xml.rpc.encoding.TypeMapping typeMapping) {
        if (typeMapping == null || !(typeMapping instanceof TypeMappingDelegate)) {
            throw new IllegalArgumentException(Messages.getMessage("badTypeMapping"));
        }
        if (this.defaultDelTM.getNext() != null) {
            throw new IllegalArgumentException(Messages.getMessage("defaultTypeMappingSet"));
        }
        this.defaultDelTM = (TypeMappingDelegate)typeMapping;
    }

    public void doRegisterFromVersion(String string) {
        if (string == null || string.equals("1.0") || string.equals("1.2")) {
            TypeMappingImpl.dotnet_soapenc_bugfix = false;
        } else {
            if (string.equals("1.1")) {
                TypeMappingImpl.dotnet_soapenc_bugfix = true;
                return;
            }
            if (string.equals("1.3")) {
                this.defaultDelTM = new TypeMappingDelegate(DefaultJAXRPC11TypeMappingImpl.getSingleton());
            } else {
                throw new RuntimeException(Messages.getMessage("j2wBadTypeMapping00"));
            }
        }
        this.registerSOAPENCDefault(new TypeMappingDelegate(DefaultSOAPEncodingTypeMappingImpl.getSingleton()));
    }

    private void registerSOAPENCDefault(TypeMappingDelegate typeMappingDelegate) {
        TypeMappingDelegate typeMappingDelegate2;
        if (!this.mapTM.containsKey("http://schemas.xmlsoap.org/soap/encoding/")) {
            this.mapTM.put("http://schemas.xmlsoap.org/soap/encoding/", typeMappingDelegate);
        } else {
            typeMappingDelegate2 = (TypeMappingDelegate)this.mapTM.get("http://schemas.xmlsoap.org/soap/encoding/");
            while (typeMappingDelegate2.getNext() != null && !(typeMappingDelegate2.delegate instanceof DefaultTypeMappingImpl)) {
                typeMappingDelegate2 = typeMappingDelegate2.getNext();
            }
            typeMappingDelegate2.setNext(this.defaultDelTM);
        }
        if (!this.mapTM.containsKey("http://www.w3.org/2003/05/soap-encoding")) {
            this.mapTM.put("http://www.w3.org/2003/05/soap-encoding", typeMappingDelegate);
        } else {
            typeMappingDelegate2 = (TypeMappingDelegate)this.mapTM.get("http://www.w3.org/2003/05/soap-encoding");
            while (typeMappingDelegate2.getNext() != null && !(typeMappingDelegate2.delegate instanceof DefaultTypeMappingImpl)) {
                typeMappingDelegate2 = typeMappingDelegate2.getNext();
            }
            typeMappingDelegate2.setNext(this.defaultDelTM);
        }
        typeMappingDelegate.setNext(this.defaultDelTM);
    }

    public javax.xml.rpc.encoding.TypeMapping getTypeMapping(String string) {
        TypeMapping typeMapping = (TypeMappingDelegate)this.mapTM.get(string);
        if (typeMapping == null) {
            typeMapping = (TypeMapping)this.getDefaultTypeMapping();
        }
        return typeMapping;
    }

    public TypeMapping getOrMakeTypeMapping(String string) {
        TypeMappingDelegate typeMappingDelegate = (TypeMappingDelegate)this.mapTM.get(string);
        if (typeMappingDelegate == null || typeMappingDelegate.delegate instanceof DefaultTypeMappingImpl) {
            typeMappingDelegate = (TypeMappingDelegate)this.createTypeMapping();
            typeMappingDelegate.setSupportedEncodings(new String[]{string});
            this.register(string, typeMappingDelegate);
        }
        return typeMappingDelegate;
    }

    public javax.xml.rpc.encoding.TypeMapping unregisterTypeMapping(String string) {
        return (TypeMappingDelegate)this.mapTM.remove(string);
    }

    public boolean removeTypeMapping(javax.xml.rpc.encoding.TypeMapping typeMapping) {
        String[] stringArray = this.getRegisteredEncodingStyleURIs();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.getTypeMapping(stringArray[i]) != typeMapping) continue;
            bl = true;
            this.unregisterTypeMapping(stringArray[i]);
        }
        return bl;
    }

    public javax.xml.rpc.encoding.TypeMapping createTypeMapping() {
        TypeMappingImpl typeMappingImpl = new TypeMappingImpl();
        TypeMappingDelegate typeMappingDelegate = new TypeMappingDelegate(typeMappingImpl);
        typeMappingDelegate.setNext(this.defaultDelTM);
        return typeMappingDelegate;
    }

    public String[] getRegisteredEncodingStyleURIs() {
        Set set = this.mapTM.keySet();
        if (set != null) {
            String[] stringArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
            return stringArray;
        }
        return null;
    }

    public void clear() {
        this.mapTM.clear();
    }

    public javax.xml.rpc.encoding.TypeMapping getDefaultTypeMapping() {
        return this.defaultDelTM;
    }
}

