/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ArrayDeserializer
extends DeserializerImpl {
    protected static Log log = LogFactory.getLog(ArrayDeserializer.class.getName());
    public QName arrayType = null;
    public int curIndex = 0;
    QName defaultItemType;
    int length;
    Class arrayClass = null;
    ArrayList mDimLength = null;
    ArrayList mDimFactor = null;
    SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;

    public void onStartElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        int n;
        int n2;
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("Enter: ArrayDeserializer::startElement()");
        }
        this.soapConstants = deserializationContext.getSOAPConstants();
        QName qName = deserializationContext.getTypeFromAttributes(string, string2, attributes);
        if (qName == null) {
            qName = this.getDefaultType();
        }
        if (qName != null && Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = null;
        }
        QName qName2 = deserializationContext.getQNameFromString(Constants.getValue(attributes, Constants.URIS_SOAP_ENC, this.soapConstants.getAttrItemType()));
        Object object2 = null;
        QName qName3 = null;
        String string4 = "";
        if (qName2 != null) {
            if (this.soapConstants != SOAPConstants.SOAP12_CONSTANTS) {
                object = qName2.getNamespaceURI();
                String string5 = qName2.getLocalPart();
                n2 = string5.lastIndexOf(91);
                n = string5.lastIndexOf(93);
                if (n2 == -1 || n == -1 || n < n2) {
                    throw new IllegalArgumentException(Messages.getMessage("badArrayType00", "" + qName2));
                }
                object2 = string5.substring(n2 + 1, n);
                if ((string5 = string5.substring(0, n2)).endsWith("]")) {
                    this.defaultItemType = Constants.SOAP_ARRAY;
                    int n3 = string5.indexOf("[");
                    qName3 = new QName((String)object, string5.substring(0, n3));
                    string4 = string5.substring(n3);
                } else {
                    this.defaultItemType = new QName((String)object, string5);
                }
            } else {
                object = attributes.getValue(this.soapConstants.getEncodingURI(), "arraySize");
                int n4 = ((String)object).lastIndexOf(42);
                if (n4 != -1) {
                    if (n4 != 0 || ((String)object).length() != 1) {
                        if (n4 == ((String)object).length() - 1) {
                            throw new IllegalArgumentException(Messages.getMessage("badArraySize00", "" + (String)object));
                        }
                        object2 = ((String)object).substring(n4 + 2);
                        qName3 = qName2;
                        string4 = ((String)object).substring(0, n4 + 1);
                    }
                } else {
                    object2 = object;
                }
                this.defaultItemType = string4 == null || string4.length() == 0 ? qName2 : Constants.SOAP_ARRAY12;
            }
        }
        if (!(this.defaultItemType != null || qName != null || (object = deserializationContext.getDestinationClass()) != null && ((Class)object).isArray())) {
            this.defaultItemType = Constants.XSD_ANYTYPE;
        }
        this.arrayClass = null;
        if (qName != null) {
            this.arrayClass = deserializationContext.getTypeMapping().getClassForQName(qName);
        }
        if (qName == null || this.arrayClass == null) {
            object = null;
            QName qName4 = this.defaultItemType;
            String string6 = "[]";
            if (qName3 != null) {
                qName4 = qName3;
                if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    n = 0;
                    while ((n = string4.indexOf(42, n)) != -1) {
                        string6 = string6 + "[]";
                        ++n;
                    }
                } else {
                    string6 = string6 + string4;
                }
            }
            if ((object = deserializationContext.getTypeMapping().getClassForQName(qName4)) != null) {
                try {
                    String string7 = JavaUtils.getLoadableClassName(JavaUtils.getTextClassName(((Class)object).getName()) + string6);
                    this.arrayClass = ClassUtils.forName(string7, true, ((Class)object).getClassLoader());
                }
                catch (Exception exception) {
                    throw new SAXException(Messages.getMessage("noComponent00", "" + this.defaultItemType));
                }
            }
        }
        if (this.arrayClass == null) {
            this.arrayClass = deserializationContext.getDestinationClass();
        }
        if (this.arrayClass == null) {
            throw new SAXException(Messages.getMessage("noComponent00", "" + this.defaultItemType));
        }
        if (object2 == null || ((String)object2).length() == 0) {
            this.value = new ArrayListExtension(this.arrayClass);
        } else {
            try {
                object = this.soapConstants == SOAPConstants.SOAP12_CONSTANTS ? new StringTokenizer((String)object2) : new StringTokenizer((String)object2, "[],");
                this.length = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (((StringTokenizer)object).hasMoreTokens()) {
                    this.mDimLength = new ArrayList();
                    this.mDimLength.add(new Integer(this.length));
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        this.mDimLength.add(new Integer(Integer.parseInt(((StringTokenizer)object).nextToken())));
                    }
                }
                ArrayListExtension arrayListExtension = new ArrayListExtension(this.arrayClass, this.length);
                this.value = arrayListExtension;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Messages.getMessage("badInteger00", (String)object2));
            }
        }
        object = Constants.getValue(attributes, Constants.URIS_SOAP_ENC, "offset");
        if (object != null) {
            if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                throw new SAXException(Messages.getMessage("noSparseArray"));
            }
            int n5 = ((String)object).lastIndexOf(91);
            n2 = ((String)object).lastIndexOf(93);
            if (n5 == -1 || n2 == -1 || n2 < n5) {
                throw new SAXException(Messages.getMessage("badOffset00", (String)object));
            }
            this.curIndex = this.convertToIndex(((String)object).substring(n5 + 1, n2), "badOffset00");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ArrayDeserializer::startElement()");
        }
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("Enter: ArrayDeserializer.onStartChild()");
        }
        if (attributes != null) {
            object = Constants.getValue(attributes, Constants.URIS_SOAP_ENC, "position");
            if (object != null) {
                if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    throw new SAXException(Messages.getMessage("noSparseArray"));
                }
                int n = ((String)object).lastIndexOf(91);
                int n2 = ((String)object).lastIndexOf(93);
                if (n == -1 || n2 == -1 || n2 < n) {
                    throw new SAXException(Messages.getMessage("badPosition00", (String)object));
                }
                this.curIndex = this.convertToIndex(((String)object).substring(n + 1, n2), "badPosition00");
            }
            if (deserializationContext.isNil(attributes)) {
                this.setChildValue(null, new Integer(this.curIndex++));
                return null;
            }
        }
        object = deserializationContext.getTypeFromAttributes(string, string2, attributes);
        Deserializer deserializer = null;
        if (object != null && deserializationContext.getCurElement().getHref() == null) {
            deserializer = deserializationContext.getDeserializerForType((QName)object);
        }
        if (deserializer == null) {
            QName qName = this.defaultItemType;
            Class<?> clazz = null;
            if (this.arrayClass != null && this.arrayClass.isArray() && qName == null) {
                clazz = this.arrayClass.getComponentType();
                qName = deserializationContext.getTypeMapping().getTypeQName(clazz);
            }
            if (object == null && deserializer == null && qName != null && SchemaUtils.isSimpleSchemaType(qName)) {
                deserializer = deserializationContext.getDeserializer(clazz, qName);
            }
            if (deserializer == null) {
                deserializer = new DeserializerImpl();
                if (object == null) {
                    deserializer.setDefaultType(qName);
                }
            }
        }
        deserializer.registerValueTarget(new DeserializerTarget(this, new Integer(this.curIndex)));
        this.addChildDeserializer(deserializer);
        ++this.curIndex;
        deserializationContext.setDestinationClass(this.arrayClass.getComponentType());
        if (log.isDebugEnabled()) {
            log.debug("Exit: ArrayDeserializer.onStartChild()");
        }
        return (SOAPHandler)((Object)deserializer);
    }

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        deserializationContext.setDestinationClass(this.arrayClass);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n;
        while (n < n2) {
            if (!Character.isWhitespace(cArray[n3])) {
                throw new SAXException(Messages.getMessage("charsInArray"));
            }
            ++n;
        }
    }

    public void setChildValue(Object object, Object object2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ArrayDeserializer::setValue(" + object + ", " + object2 + ")");
        }
        ArrayList arrayList = (ArrayList)this.value;
        int n = (Integer)object2;
        if (this.mDimLength == null) {
            while (arrayList.size() <= n) {
                arrayList.add(null);
            }
            arrayList.set(n, object);
        } else {
            ArrayList arrayList2 = this.toMultiIndex(n);
            for (int i = 0; i < this.mDimLength.size(); ++i) {
                int n2 = (Integer)this.mDimLength.get(i);
                int n3 = (Integer)arrayList2.get(i);
                while (arrayList.size() < n2) {
                    arrayList.add(null);
                }
                if (i < this.mDimLength.size() - 1) {
                    if (arrayList.get(n3) == null) {
                        arrayList.set(n3, new ArrayList());
                    }
                    arrayList = (ArrayList)arrayList.get(n3);
                    continue;
                }
                arrayList.set(n3, object);
            }
        }
    }

    public void valueComplete() throws SAXException {
        if (this.componentsReady()) {
            try {
                if (this.arrayClass != null) {
                    this.value = JavaUtils.convert(this.value, this.arrayClass);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        super.valueComplete();
    }

    private int convertToIndex(String string, String string2) throws SAXException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[],");
        int n = 0;
        try {
            if (this.mDimLength == null) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    throw new SAXException(Messages.getMessage(string2, string));
                }
            } else {
                int n2 = -1;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (stringTokenizer.hasMoreTokens()) {
                    if (++n2 >= this.mDimLength.size()) {
                        throw new SAXException(Messages.getMessage(string2, string));
                    }
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n3 < 0 || n3 >= (Integer)this.mDimLength.get(n2)) {
                        throw new SAXException(Messages.getMessage(string2, string));
                    }
                    arrayList.add(new Integer(n3));
                }
                n = this.toSingleIndex(arrayList);
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new SAXException(Messages.getMessage(string2, string));
        }
        return n;
    }

    private ArrayList toMultiIndex(int n) {
        int n2;
        int n3;
        if (this.mDimLength == null) {
            return null;
        }
        if (this.mDimFactor == null) {
            this.mDimFactor = new ArrayList();
            for (int i = 0; i < this.mDimLength.size(); ++i) {
                n3 = 1;
                for (n2 = i + 1; n2 < this.mDimLength.size(); ++n2) {
                    n3 *= ((Integer)this.mDimLength.get(n2)).intValue();
                }
                this.mDimFactor.add(new Integer(n3));
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < this.mDimLength.size(); ++n3) {
            n2 = (Integer)this.mDimFactor.get(n3);
            arrayList.add(new Integer(n / n2));
            n %= n2;
        }
        return arrayList;
    }

    private int toSingleIndex(ArrayList arrayList) {
        int n;
        int n2;
        if (this.mDimLength == null || arrayList == null) {
            return -1;
        }
        if (this.mDimFactor == null) {
            this.mDimFactor = new ArrayList();
            for (n2 = 0; n2 < this.mDimLength.size(); ++n2) {
                n = 1;
                for (int i = n2 + 1; i < this.mDimLength.size(); ++i) {
                    n *= ((Integer)this.mDimLength.get(i)).intValue();
                }
                this.mDimFactor.add(new Integer(n));
            }
        }
        n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            n2 += (Integer)this.mDimFactor.get(n) * (Integer)arrayList.get(n);
        }
        return n2;
    }

    public class ArrayListExtension
    extends ArrayList
    implements JavaUtils.ConvertCache {
        private HashMap table;
        private Class arrayClass;

        ArrayListExtension(Class clazz) {
            this.table = null;
            this.arrayClass = null;
            this.arrayClass = clazz;
            if (clazz == null || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                clazz = null;
            }
        }

        ArrayListExtension(Class clazz, int n) {
            super(n > 50000 ? 50000 : n);
            this.table = null;
            this.arrayClass = null;
            this.arrayClass = clazz;
            if (clazz == null || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                clazz = null;
            }
        }

        public void setConvertedValue(Class clazz, Object object) {
            if (this.table == null) {
                this.table = new HashMap();
            }
            this.table.put(clazz, object);
        }

        public Object getConvertedValue(Class clazz) {
            if (this.table == null) {
                return null;
            }
            return this.table.get(clazz);
        }

        public Class getDestClass() {
            return this.arrayClass;
        }
    }
}

