/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.Target;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class BeanPropertyTarget
implements Target {
    protected static Log log = LogFactory.getLog(BeanPropertyTarget.class.getName());
    private Object object;
    private BeanPropertyDescriptor pd;
    private int index = -1;

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor beanPropertyDescriptor) {
        this.object = object;
        this.pd = beanPropertyDescriptor;
        this.index = -1;
    }

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor beanPropertyDescriptor, int n) {
        this.object = object;
        this.pd = beanPropertyDescriptor;
        this.index = n;
    }

    public void set(Object object) throws SAXException {
        try {
            if (this.index < 0) {
                this.pd.set(this.object, object);
            } else {
                this.pd.set(this.object, this.index, object);
            }
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = this.pd.getType();
                if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive() && clazz.isArray() && clazz.getComponentType().equals(Object.class)) {
                    clazz = Array.newInstance(JavaUtils.getWrapperClass(object.getClass().getComponentType()), 0).getClass();
                }
                if (JavaUtils.isConvertable(object, clazz)) {
                    object = JavaUtils.convert(object, clazz);
                    if (this.index < 0) {
                        this.pd.set(this.object, object);
                    } else {
                        this.pd.set(this.object, this.index, object);
                    }
                }
                if (this.index == 0 && object.getClass().isArray() && !clazz.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object object2 = JavaUtils.convert(Array.get(object, i), clazz);
                        this.pd.set(this.object, i, object2);
                    }
                }
                throw exception;
            }
            catch (Exception exception2) {
                Object object3;
                String string = this.pd.getName();
                if (this.index >= 0) {
                    string = string + "[" + this.index + "]";
                }
                if (log.isErrorEnabled()) {
                    object3 = "null";
                    if (object != null) {
                        object3 = object.getClass().getName();
                    }
                    log.error(Messages.getMessage("cantConvert02", new String[]{object3, string, this.index >= 0 ? this.pd.getType().getComponentType().getName() : this.pd.getType().getName()}));
                }
                if (exception2 instanceof InvocationTargetException && (object3 = ((InvocationTargetException)exception2).getTargetException()) != null) {
                    String string2 = this.object.getClass().getName();
                    throw new SAXException(Messages.getMessage("cantConvert04", new String[]{string2, string, object == null ? null : object.toString(), ((Throwable)object3).getMessage()}));
                }
                throw new SAXException(exception2);
            }
        }
    }
}

