/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.FieldPropertyDescriptor;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    protected static Log log = LogFactory.getLog(BeanSerializer.class.getName());
    private static final QName MUST_UNDERSTAND_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
    private static final Object[] ZERO_ARGS = new Object[]{"0"};
    QName xmlType;
    Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected TypeDesc typeDesc = null;

    public BeanSerializer(Class clazz, QName qName) {
        this(clazz, qName, TypeDesc.getTypeDescForClass(clazz));
    }

    public BeanSerializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this(clazz, qName, typeDesc, null);
        this.propertyDescriptor = typeDesc != null ? typeDesc.getPropertyDescriptors() : BeanUtils.getPd(clazz, null);
    }

    public BeanSerializer(Class clazz, QName qName, TypeDesc typeDesc, BeanPropertyDescriptor[] beanPropertyDescriptorArray) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.typeDesc = typeDesc;
        this.propertyDescriptor = beanPropertyDescriptorArray;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        Object object2;
        boolean bl;
        Attributes attributes2 = this.getObjectAttributes(object, attributes, serializationContext);
        boolean bl2 = serializationContext.isEncoded();
        boolean bl3 = bl = !bl2 && qName.getNamespaceURI().equals("") && qName.getLocalPart().equals("any");
        if (!bl) {
            serializationContext.startElement(qName, attributes2);
        }
        if (object.getClass().isArray() && (object2 = JavaUtils.convert(object, this.javaType)) != null && this.javaType.isAssignableFrom(object2.getClass())) {
            object = object2;
        }
        try {
            BeanPropertyDescriptor beanPropertyDescriptor;
            Serializable serializable;
            Object object3;
            Object object4;
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Constructor constructor;
                Object object5;
                object4 = this.propertyDescriptor[i].getName();
                if (((String)object4).equals("class")) continue;
                object3 = null;
                QName qName2 = null;
                serializable = this.propertyDescriptor[i].getType();
                boolean bl4 = false;
                boolean bl5 = Types.isNullable((Class)serializable);
                boolean bl6 = false;
                QName qName3 = null;
                if (this.typeDesc != null && (object5 = this.typeDesc.getFieldByName((String)object4)) != null) {
                    if (!((FieldDesc)object5).isElement()) continue;
                    constructor = (ElementDesc)object5;
                    object3 = bl2 ? new QName(((FieldDesc)((Object)constructor)).getXmlName().getLocalPart()) : ((FieldDesc)((Object)constructor)).getXmlName();
                    bl4 = ((ElementDesc)((Object)constructor)).isMinOccursZero();
                    bl5 = ((ElementDesc)((Object)constructor)).isNillable();
                    bl6 = ((ElementDesc)((Object)constructor)).isMaxOccursUnbounded();
                    qName2 = ((FieldDesc)((Object)constructor)).getXmlType();
                    qName3 = ((ElementDesc)((Object)constructor)).getItemQName();
                    serializationContext.setItemQName(qName3);
                }
                if (object3 == null) {
                    object3 = new QName(bl2 ? "" : qName.getNamespaceURI(), (String)object4);
                }
                if (qName2 == null) {
                    qName2 = serializationContext.getQNameForClass((Class)serializable);
                }
                if (!this.propertyDescriptor[i].isReadable()) continue;
                if (qName3 != null || !this.propertyDescriptor[i].isIndexed() && !bl6) {
                    object5 = this.propertyDescriptor[i].get(object);
                    if (object5 == null) {
                        if (!bl5 && !bl4) {
                            if (Number.class.isAssignableFrom((Class<?>)serializable)) {
                                try {
                                    constructor = ((Class)serializable).getConstructor(SimpleDeserializer.STRING_CLASS);
                                    object5 = constructor.newInstance(ZERO_ARGS);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (object5 == null) {
                                throw new IOException(Messages.getMessage("nullNonNillableElement", (String)object4));
                            }
                        }
                        if (bl4 && !bl2) continue;
                    }
                    serializationContext.serialize((QName)object3, null, object5, qName2);
                    continue;
                }
                int n = 0;
                while (n >= 0) {
                    constructor = null;
                    try {
                        constructor = this.propertyDescriptor[i].get(object, n);
                        ++n;
                    }
                    catch (Exception exception) {
                        n = -1;
                    }
                    if (n < 0) continue;
                    serializationContext.serialize((QName)object3, null, constructor, qName2);
                }
            }
            BeanPropertyDescriptor beanPropertyDescriptor2 = beanPropertyDescriptor = this.typeDesc == null ? null : this.typeDesc.getAnyDesc();
            if (beanPropertyDescriptor != null && (object4 = beanPropertyDescriptor.get(object)) != null && object4 instanceof MessageElement[]) {
                object3 = (MessageElement[])object4;
                for (int i = 0; i < ((MessageElement[])object3).length; ++i) {
                    serializable = object3[i];
                    ((MessageElement)serializable).output(serializationContext);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            log.error(Messages.getMessage("exception00"), throwable);
            throw new IOException(throwable.toString());
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            throw new IOException(exception.toString());
        }
        if (!bl) {
            serializationContext.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        Object object;
        Object object2;
        Element element = types.createElement("complexType");
        Object object3 = null;
        Class clazz2 = clazz.getSuperclass();
        BeanPropertyDescriptor[] beanPropertyDescriptorArray = null;
        List list = types.getStopClasses();
        if (!(clazz2 == null || clazz2 == Object.class || clazz2 == Exception.class || clazz2 == Throwable.class || clazz2 == RuntimeException.class || clazz2 == RemoteException.class || clazz2 == AxisFault.class || list != null && list.contains(clazz2.getName()))) {
            object2 = types.writeType(clazz2);
            Element element2 = types.createElement("complexContent");
            element.appendChild(element2);
            object = types.createElement("extension");
            element2.appendChild((Node)object);
            object.setAttribute("base", (String)object2);
            object3 = object;
            TypeDesc typeDesc = TypeDesc.getTypeDescForClass(clazz2);
            beanPropertyDescriptorArray = typeDesc != null ? typeDesc.getPropertyDescriptors() : BeanUtils.getPd(clazz2, null);
        } else {
            object3 = element;
        }
        object2 = types.createElement("sequence");
        object3.appendChild((Node)object2);
        if (Modifier.isAbstract(clazz.getModifiers())) {
            element.setAttribute("abstract", "true");
        }
        for (int i = 0; i < this.propertyDescriptor.length; ++i) {
            Serializable serializable;
            Object object4;
            int n;
            object = this.propertyDescriptor[i].getName();
            boolean bl = true;
            if (((String)object).equals("class")) {
                bl = false;
            }
            if (beanPropertyDescriptorArray != null && bl) {
                for (n = 0; n < beanPropertyDescriptorArray.length && bl; ++n) {
                    if (!((String)object).equals(beanPropertyDescriptorArray[n].getName())) continue;
                    bl = false;
                }
            }
            if (!bl) continue;
            if (this.typeDesc != null) {
                Class clazz3 = this.propertyDescriptor[i].getType();
                object4 = this.typeDesc.getFieldByName((String)object);
                if (object4 != null) {
                    boolean bl2;
                    serializable = ((FieldDesc)object4).getXmlName();
                    QName qName = ((FieldDesc)object4).getXmlType();
                    boolean bl3 = bl2 = qName != null && qName.getLocalPart().startsWith(">");
                    if (serializable != null) {
                        object = ((QName)serializable).getLocalPart();
                    }
                    if (!((FieldDesc)object4).isElement()) {
                        this.writeAttribute(types, (String)object, clazz3, qName, element);
                        continue;
                    }
                    this.writeField(types, (String)object, qName, clazz3, this.propertyDescriptor[i].isIndexed(), ((FieldDesc)object4).isMinOccursZero(), (Element)object2, bl2, ((ElementDesc)object4).getItemQName());
                    continue;
                }
                this.writeField(types, (String)object, null, clazz3, this.propertyDescriptor[i].isIndexed(), false, (Element)object2, false, null);
                continue;
            }
            n = 0;
            if (this.propertyDescriptor[i] instanceof FieldPropertyDescriptor && types.getTypeQName((Class)(serializable = ((FieldPropertyDescriptor)(object4 = (FieldPropertyDescriptor)this.propertyDescriptor[i])).getField().getType())) != null) {
                this.writeField(types, (String)object, null, (Class)serializable, false, false, (Element)object2, false, null);
                n = 1;
            }
            if (n != 0) continue;
            this.writeField(types, (String)object, null, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), false, (Element)object2, false, null);
        }
        return element;
    }

    protected void writeField(Types types, String string, QName qName, Class clazz, boolean bl, boolean bl2, Element element, boolean bl3, QName qName2) throws Exception {
        Element element2;
        String string2 = null;
        if (bl3) {
            element2 = types.createElementWithAnonymousType(string, clazz, bl2, element.getOwnerDocument());
        } else {
            Object object;
            QName qName3;
            if (!SchemaUtils.isSimpleSchemaType(qName) && Types.isArray(clazz)) {
                qName = null;
            }
            if (qName2 != null && SchemaUtils.isSimpleSchemaType(qName) && Types.isArray(clazz)) {
                qName = null;
            }
            if ((string2 = types.getQNameString(qName3 = types.writeTypeAndSubTypeForPart(clazz, qName))) == null) {
                QName qName4 = Constants.XSD_ANYTYPE;
                object = types.getNamespaces().getCreatePrefix(qName4.getNamespaceURI());
                string2 = (String)object + ":" + qName4.getLocalPart();
            }
            boolean bl4 = Types.isNullable(clazz);
            if (this.typeDesc != null && (object = this.typeDesc.getFieldByName(string)) != null && ((FieldDesc)object).isElement()) {
                bl4 = ((ElementDesc)object).isNillable();
            }
            element2 = types.createElement(string, string2, bl4, bl2, element.getOwnerDocument());
        }
        if (bl) {
            element2.setAttribute("maxOccurs", "unbounded");
        }
        element.appendChild(element2);
    }

    protected void writeAttribute(Types types, String string, Class clazz, QName qName, Element element) throws Exception {
        if (!types.isAcceptableAsAttribute(clazz)) {
            throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", string, clazz.getName()));
        }
        Element element2 = types.createAttributeElement(string, clazz, qName, false, element.getOwnerDocument());
        element.appendChild(element2);
    }

    protected Attributes getObjectAttributes(Object object, Attributes attributes, SerializationContext serializationContext) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attributesImpl = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                FieldDesc fieldDesc;
                String string = this.propertyDescriptor[i].getName();
                if (string.equals("class") || (fieldDesc = this.typeDesc.getFieldByName(string)) == null || fieldDesc.isElement()) continue;
                QName qName = fieldDesc.getXmlName();
                if (qName == null) {
                    qName = new QName("", string);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed()) continue;
                Object object2 = this.propertyDescriptor[i].get(object);
                if (qName.equals(MUST_UNDERSTAND_QNAME)) {
                    if (object2.equals(Boolean.TRUE)) {
                        object2 = "1";
                    } else if (object2.equals(Boolean.FALSE)) {
                        object2 = "0";
                    }
                }
                if (object2 == null) continue;
                this.setAttributeProperty(object2, qName, fieldDesc.getXmlType(), attributesImpl, serializationContext);
            }
        }
        catch (Exception exception) {
            return attributesImpl;
        }
        return attributesImpl;
    }

    private void setAttributeProperty(Object object, QName qName, QName qName2, AttributesImpl attributesImpl, SerializationContext serializationContext) throws Exception {
        String string;
        String string2 = qName.getNamespaceURI();
        if (attributesImpl.getIndex(string2, string = qName.getLocalPart()) != -1) {
            return;
        }
        String string3 = serializationContext.getValueAsString(object, qName2);
        attributesImpl.addAttribute(string2, string, serializationContext.attributeQName2String(qName), "CDATA", string3);
    }
}

