/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.ser.SimpleSerializer;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class EnumSerializer
extends SimpleSerializer {
    protected static Log log = LogFactory.getLog(EnumSerializer.class.getName());
    private Method toStringMethod = null;

    public EnumSerializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        serializationContext.startElement(qName, attributes);
        serializationContext.writeString(this.getValueAsString(object, serializationContext));
        serializationContext.endElement();
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        try {
            if (this.toStringMethod == null) {
                this.toStringMethod = this.javaType.getMethod("toString", null);
            }
            return (String)this.toStringMethod.invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            return null;
        }
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        return types.writeEnumType(this.xmlType, clazz);
    }
}

