/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axis.Part;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class JAFDataHandlerSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(JAFDataHandlerSerializer.class.getName());

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        DataHandler dataHandler = (DataHandler)object;
        Attachments attachments = serializationContext.getCurrentMessage().getAttachmentsImpl();
        if (attachments == null) {
            throw new IOException(Messages.getMessage("noAttachments"));
        }
        SOAPConstants sOAPConstants = serializationContext.getMessageContext().getSOAPConstants();
        Part part = attachments.createAttachmentPart(dataHandler);
        AttributesImpl attributesImpl = new AttributesImpl();
        if (attributes != null && 0 < attributes.getLength()) {
            attributesImpl.setAttributes(attributes);
        }
        int n = -1;
        n = attributesImpl.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (n != -1) {
            attributesImpl.removeAttribute(n);
        }
        boolean bl = false;
        if (attachments.getSendType() == 3) {
            bl = true;
        }
        attributesImpl.addAttribute("", sOAPConstants.getAttrHref(), sOAPConstants.getAttrHref(), "CDATA", bl ? part.getContentId() : part.getContentIdRef());
        serializationContext.startElement(qName, attributesImpl);
        serializationContext.endElement();
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        return null;
    }
}

