/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private TypeDesc typeDesc = null;
    public static final String VALUE_PROPERTY = "_value";

    public SimpleSerializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.init();
    }

    public SimpleSerializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.typeDesc = typeDesc;
        this.init();
    }

    private void init() {
        if (this.typeDesc == null) {
            this.typeDesc = TypeDesc.getTypeDescForClass(this.javaType);
        }
        if (this.typeDesc != null) {
            this.propertyDescriptor = this.typeDesc.getPropertyDescriptors();
        } else if (!JavaUtils.isBasic(this.javaType)) {
            this.propertyDescriptor = BeanUtils.getPd(this.javaType, null);
        }
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        if (object != null && object.getClass() == Object.class) {
            throw new IOException(Messages.getMessage("cantSerialize02"));
        }
        attributes = this.getObjectAttributes(object, attributes, serializationContext);
        String string = null;
        if (object != null) {
            string = this.getValueAsString(object, serializationContext);
        }
        serializationContext.startElement(qName, attributes);
        if (string != null) {
            serializationContext.writeSafeString(string);
        }
        serializationContext.endElement();
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        BeanPropertyDescriptor beanPropertyDescriptor;
        if (object instanceof Float || object instanceof Double) {
            double d = 0.0;
            d = object instanceof Float ? ((Float)object).doubleValue() : ((Double)object).doubleValue();
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
        } else if (object instanceof QName) {
            return serializationContext.qName2String((QName)object);
        }
        if (this.propertyDescriptor != null && !(object instanceof SimpleType) && (beanPropertyDescriptor = BeanUtils.getSpecificPD(this.propertyDescriptor, VALUE_PROPERTY)) != null) {
            try {
                return beanPropertyDescriptor.get(object).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object.toString();
    }

    private Attributes getObjectAttributes(Object object, Attributes attributes, SerializationContext serializationContext) {
        if (this.typeDesc != null && !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attributesImpl = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; this.propertyDescriptor != null && i < this.propertyDescriptor.length; ++i) {
                Object object2;
                String string = this.propertyDescriptor[i].getName();
                if (string.equals("class")) continue;
                QName qName = null;
                if (this.typeDesc != null) {
                    object2 = this.typeDesc.getFieldByName(string);
                    if (object2 == null || ((FieldDesc)object2).isElement()) continue;
                    qName = ((FieldDesc)object2).getXmlName();
                } else if (string.equals(VALUE_PROPERTY)) continue;
                if (qName == null) {
                    qName = new QName("", string);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (object2 = this.propertyDescriptor[i].get(object)) == null) continue;
                String string2 = this.getValueAsString(object2, serializationContext);
                String string3 = qName.getNamespaceURI();
                String string4 = qName.getLocalPart();
                attributesImpl.addAttribute(string3, string4, serializationContext.qName2String(qName), "CDATA", string2);
            }
        }
        catch (Exception exception) {
            return attributesImpl;
        }
        return attributesImpl;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        Element element = types.createElement("complexType");
        types.writeSchemaTypeDecl(this.xmlType, element);
        element.setAttribute("name", this.xmlType.getLocalPart());
        Element element2 = types.createElement("simpleContent");
        element.appendChild(element2);
        Element element3 = types.createElement("extension");
        element2.appendChild(element3);
        String string = "string";
        for (int i = 0; this.propertyDescriptor != null && i < this.propertyDescriptor.length; ++i) {
            Serializable serializable;
            Object object;
            String string2 = this.propertyDescriptor[i].getName();
            if (!string2.equals("value")) {
                Class clazz2;
                if (this.typeDesc == null || (object = this.typeDesc.getFieldByName(string2)) == null) continue;
                if (((FieldDesc)object).isElement()) {
                    // empty if block
                }
                if ((serializable = ((FieldDesc)object).getXmlName()) == null) {
                    serializable = new QName("", string2);
                }
                if (!types.isAcceptableAsAttribute(clazz2 = this.propertyDescriptor[i].getType())) {
                    throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", string2, clazz2.getName()));
                }
                Element element4 = types.createAttributeElement(string2, clazz2, ((FieldDesc)object).getXmlType(), false, element3.getOwnerDocument());
                element3.appendChild(element4);
                continue;
            }
            object = this.propertyDescriptor[i];
            serializable = ((BeanPropertyDescriptor)object).getType();
            if (!types.isAcceptableAsAttribute((Class)serializable)) {
                throw new AxisFault(Messages.getMessage("AttrNotSimpleType01", ((Class)serializable).getName()));
            }
            string = types.writeType((Class)serializable);
            element3.setAttribute("base", string);
        }
        return element;
    }
}

