/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers.soap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.HandlerChainImpl;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.axis.handlers.soap.MustUnderstandChecker;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.session.Session;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;

public class SOAPService
extends SimpleTargetedChain {
    private static Log log = LogFactory.getLog(SOAPService.class.getName());
    private Vector validTransports = null;
    private boolean highFidelityRecording = true;
    private int sendType = 1;
    private ServiceDesc serviceDescription = new JavaServiceDesc();
    private AxisEngine engine;
    public Map serviceObjects = new HashMap();
    public int nextObjectID = 1;
    private static Hashtable sessions = new Hashtable();
    private boolean isRunning = true;
    ArrayList actors = new ArrayList();

    public void addSession(Session session) {
        Vector<Session> vector = (Vector<Session>)sessions.get(this.getName());
        if (vector == null) {
            vector = new Vector<Session>();
            sessions.put(this.getName(), vector);
        }
        if (!vector.contains(session)) {
            vector.add(session);
        }
    }

    public void clearSessions() {
        Vector vector = (Vector)sessions.get(this.getName());
        if (vector == null) {
            return;
        }
        for (Session session : vector) {
            session.remove(this.getName());
        }
    }

    public ArrayList getServiceActors() {
        return this.actors;
    }

    public ArrayList getActors() {
        ArrayList arrayList = (ArrayList)this.actors.clone();
        if (this.engine != null) {
            arrayList.addAll(this.engine.getActorURIs());
        }
        return arrayList;
    }

    public List getRoles() {
        return this.getActors();
    }

    public void setRoles(List list) {
        this.actors = new ArrayList(list);
    }

    public SOAPService() {
        this.setOptionsLockable(true);
        this.initHashtable();
        this.actors.add("");
    }

    public SOAPService(Handler handler, Handler handler2, Handler handler3) {
        this();
        this.init(handler, new MustUnderstandChecker(this), handler2, null, handler3);
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.serviceDescription.getTypeMappingRegistry();
    }

    public SOAPService(Handler handler) {
        this();
        this.init(null, new MustUnderstandChecker(this), handler, null, null);
    }

    public void setEngine(AxisEngine axisEngine) {
        if (axisEngine == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullEngine"));
        }
        this.engine = axisEngine;
        ((LockableHashtable)this.options).setParent(axisEngine.getOptions());
        TypeMappingRegistry typeMappingRegistry = axisEngine.getTypeMappingRegistry();
        this.getTypeMappingRegistry().delegate(typeMappingRegistry);
    }

    public AxisEngine getEngine() {
        return this.engine;
    }

    public boolean availableFromTransport(String string) {
        if (this.validTransports != null) {
            for (int i = 0; i < this.validTransports.size(); ++i) {
                if (!this.validTransports.elementAt(i).equals(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Style getStyle() {
        return this.serviceDescription.getStyle();
    }

    public void setStyle(Style style) {
        this.serviceDescription.setStyle(style);
    }

    public Use getUse() {
        return this.serviceDescription.getUse();
    }

    public void setUse(Use use) {
        this.serviceDescription.setUse(use);
    }

    public ServiceDesc getServiceDescription() {
        return this.serviceDescription;
    }

    public synchronized ServiceDesc getInitializedServiceDesc(MessageContext messageContext) throws AxisFault {
        if (!this.serviceDescription.isInitialized() && this.pivotHandler instanceof BasicProvider) {
            ((BasicProvider)this.pivotHandler).initServiceDesc(this, messageContext);
        }
        return this.serviceDescription;
    }

    public void setServiceDescription(ServiceDesc serviceDesc) {
        if (serviceDesc == null) {
            return;
        }
        this.serviceDescription = serviceDesc;
    }

    public void setPropertyParent(Hashtable hashtable) {
        if (this.options == null) {
            this.options = new LockableHashtable();
        }
        ((LockableHashtable)this.options).setParent(hashtable);
    }

    public void generateWSDL(MessageContext messageContext) throws AxisFault {
        if (this.serviceDescription == null || this.serviceDescription.getWSDLFile() == null) {
            super.generateWSDL(messageContext);
            return;
        }
        InputStream inputStream = null;
        try {
            Object object;
            String string = this.serviceDescription.getWSDLFile();
            File file = new File(string);
            if (file.exists()) {
                inputStream = new FileInputStream(string);
            } else if (messageContext.getStrProp("home.dir") != null && (file = new File((String)(object = messageContext.getStrProp("home.dir") + '/' + string))).exists()) {
                inputStream = new FileInputStream((String)object);
            }
            if (inputStream == null && (inputStream = ClassUtils.getResourceAsStream(this.getClass(), string)) == null) {
                object = Messages.getMessage("wsdlFileMissing", string);
                throw new AxisFault((String)object);
            }
            object = XMLUtils.newDocument(inputStream);
            messageContext.setProperty("WSDL", object);
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void enableTransport(String string) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enableTransport00", "" + this, string));
        }
        if (this.validTransports == null) {
            this.validTransports = new Vector();
        }
        this.validTransports.addElement(string);
    }

    public void disableTransport(String string) {
        if (this.validTransports != null) {
            this.validTransports.removeElement(string);
        }
    }

    public boolean needsHighFidelityRecording() {
        return this.highFidelityRecording;
    }

    public void setHighFidelityRecording(boolean bl) {
        this.highFidelityRecording = bl;
    }

    public int getSendType() {
        return this.sendType;
    }

    public void setSendType(int n) {
        this.sendType = n;
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        HandlerInfoChainFactory handlerInfoChainFactory = (HandlerInfoChainFactory)this.getOption("handlerInfoChain");
        HandlerChainImpl handlerChainImpl = null;
        if (handlerInfoChainFactory != null) {
            handlerChainImpl = (HandlerChainImpl)handlerInfoChainFactory.createHandlerChain();
        }
        boolean bl = true;
        try {
            if (handlerChainImpl != null) {
                try {
                    bl = handlerChainImpl.handleRequest(messageContext);
                }
                catch (SOAPFaultException sOAPFaultException) {
                    messageContext.setPastPivot(true);
                    handlerChainImpl.handleFault(messageContext);
                    if (handlerChainImpl != null) {
                        handlerChainImpl.destroy();
                    }
                    return;
                }
            }
            if (bl) {
                try {
                    super.invoke(messageContext);
                }
                catch (AxisFault axisFault) {
                    messageContext.setPastPivot(true);
                    if (handlerChainImpl != null) {
                        handlerChainImpl.handleFault(messageContext);
                    }
                    throw axisFault;
                }
            } else {
                messageContext.setPastPivot(true);
            }
            if (handlerChainImpl != null) {
                handlerChainImpl.handleResponse(messageContext);
            }
        }
        catch (SOAPFaultException sOAPFaultException) {
            messageContext.setPastPivot(true);
            throw AxisFault.makeFault(sOAPFaultException);
        }
        catch (RuntimeException runtimeException) {
            SOAPFault sOAPFault = new SOAPFault(new AxisFault("Server", "Server Error", null, null));
            SOAPEnvelope sOAPEnvelope = new SOAPEnvelope();
            sOAPEnvelope.addBodyElement(sOAPFault);
            Message message = new Message(sOAPEnvelope);
            message.setMessageType("response");
            messageContext.setResponseMessage(message);
            throw AxisFault.makeFault(runtimeException);
        }
        finally {
            if (handlerChainImpl != null) {
                handlerChainImpl.destroy();
            }
        }
    }
}

