/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.management;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.WSDDTransport;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.management.Registrar;
import org.apache.axis.management.jmx.DeploymentAdministrator;
import org.apache.axis.management.jmx.DeploymentQuery;
import org.apache.axis.management.jmx.ServiceAdministrator;
import org.apache.axis.server.AxisServer;

public class ServiceAdmin {
    private static AxisServer axisServer = null;

    public static void startService(String string) throws AxisFault, ConfigurationException {
        AxisServer axisServer = ServiceAdmin.getEngine();
        try {
            SOAPService sOAPService = axisServer.getConfig().getService(new QName("", string));
            sOAPService.start();
        }
        catch (ConfigurationException configurationException) {
            if (configurationException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configurationException.getContainedException();
            }
            throw configurationException;
        }
    }

    public static void stopService(String string) throws AxisFault, ConfigurationException {
        AxisServer axisServer = ServiceAdmin.getEngine();
        try {
            SOAPService sOAPService = axisServer.getConfig().getService(new QName("", string));
            sOAPService.stop();
        }
        catch (ConfigurationException configurationException) {
            if (configurationException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configurationException.getContainedException();
            }
            throw configurationException;
        }
    }

    public static String[] listServices() throws AxisFault, ConfigurationException {
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        AxisServer axisServer = ServiceAdmin.getEngine();
        try {
            iterator = axisServer.getConfig().getDeployedServices();
        }
        catch (ConfigurationException configurationException) {
            if (configurationException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configurationException.getContainedException();
            }
            throw configurationException;
        }
        while (iterator.hasNext()) {
            ServiceDesc serviceDesc = (ServiceDesc)iterator.next();
            String string = serviceDesc.getName();
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static AxisServer getEngine() throws AxisFault {
        if (axisServer == null) {
            throw new AxisFault("Unable to locate AxisEngine for ServiceAdmin Object");
        }
        return axisServer;
    }

    public static void setEngine(AxisServer axisServer, String string) {
        ServiceAdmin.axisServer = axisServer;
        Registrar.register(new ServiceAdministrator(), "axis:type=server", "ServiceAdministrator");
        Registrar.register(new DeploymentAdministrator(), "axis:type=deploy", "DeploymentAdministrator");
        Registrar.register(new DeploymentQuery(), "axis:type=query", "DeploymentQuery");
    }

    public static void start() {
        if (axisServer != null) {
            axisServer.start();
        }
    }

    public static void stop() {
        if (axisServer != null) {
            axisServer.stop();
        }
    }

    public static void restart() {
        if (axisServer != null) {
            axisServer.stop();
            axisServer.start();
        }
    }

    public static void saveConfiguration() {
        if (axisServer != null) {
            axisServer.saveConfiguration();
        }
    }

    private static WSDDEngineConfiguration getWSDDEngineConfiguration() {
        if (axisServer != null) {
            EngineConfiguration engineConfiguration = axisServer.getConfig();
            if (engineConfiguration instanceof WSDDEngineConfiguration) {
                return (WSDDEngineConfiguration)engineConfiguration;
            }
            throw new RuntimeException("WSDDDeploymentHelper.getWSDDEngineConfiguration(): EngineConguration not of type WSDDEngineConfiguration");
        }
        return null;
    }

    public static void setGlobalConfig(WSDDGlobalConfiguration wSDDGlobalConfiguration) {
        ServiceAdmin.getWSDDEngineConfiguration().getDeployment().setGlobalConfiguration(wSDDGlobalConfiguration);
    }

    public static WSDDGlobalConfiguration getGlobalConfig() {
        return ServiceAdmin.getWSDDEngineConfiguration().getDeployment().getGlobalConfiguration();
    }

    public static WSDDHandler getHandler(QName qName) {
        return ServiceAdmin.getWSDDEngineConfiguration().getDeployment().getWSDDHandler(qName);
    }

    public static WSDDHandler[] getHandlers() {
        return ServiceAdmin.getWSDDEngineConfiguration().getDeployment().getHandlers();
    }

    public static WSDDService getService(QName qName) {
        return ServiceAdmin.getWSDDEngineConfiguration().getDeployment().getWSDDService(qName);
    }

    public static WSDDService[] getServices() {
        return ServiceAdmin.getWSDDEngineConfiguration().getDeployment().getServices();
    }

    public static WSDDTransport getTransport(QName qName) {
        return ServiceAdmin.getWSDDEngineConfiguration().getDeployment().getWSDDTransport(qName);
    }

    public static WSDDTransport[] getTransports() {
        return ServiceAdmin.getWSDDEngineConfiguration().getDeployment().getTransports();
    }

    public static void deployHandler(WSDDHandler wSDDHandler) {
        ServiceAdmin.getWSDDEngineConfiguration().getDeployment().deployHandler(wSDDHandler);
    }

    public static void deployService(WSDDService wSDDService) {
        ServiceAdmin.getWSDDEngineConfiguration().getDeployment().deployService(wSDDService);
    }

    public static void deployTransport(WSDDTransport wSDDTransport) {
        ServiceAdmin.getWSDDEngineConfiguration().getDeployment().deployTransport(wSDDTransport);
    }

    public static void undeployHandler(QName qName) {
        ServiceAdmin.getWSDDEngineConfiguration().getDeployment().undeployHandler(qName);
    }

    public static void undeployService(QName qName) {
        ServiceAdmin.getWSDDEngineConfiguration().getDeployment().undeployService(qName);
    }

    public static void undeployTransport(QName qName) {
        ServiceAdmin.getWSDDEngineConfiguration().getDeployment().undeployTransport(qName);
    }
}

