/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.RPCParamTarget;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RPCHandler
extends SOAPHandler {
    protected static Log log = LogFactory.getLog(RPCHandler.class.getName());
    private RPCElement rpcElem;
    private RPCParam currentParam = null;
    private boolean isResponse;
    private OperationDesc operation;
    private boolean isHeaderElement;

    public RPCHandler(RPCElement rPCElement, boolean bl) throws SAXException {
        this.rpcElem = rPCElement;
        this.isResponse = bl;
    }

    public void setOperation(OperationDesc operationDesc) {
        this.operation = operationDesc;
    }

    public void setHeaderElement(boolean bl) {
        this.isHeaderElement = true;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        super.startElement(string, string2, string3, attributes, deserializationContext);
        this.currentParam = null;
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: RPCHandler.onStartChild()");
        }
        if (!deserializationContext.isDoneParsing()) {
            try {
                deserializationContext.pushNewElement(new MessageElement(string, string2, string3, attributes, deserializationContext));
            }
            catch (AxisFault axisFault) {
                throw new SAXException(axisFault);
            }
        }
        MessageElement messageElement = deserializationContext.getCurElement();
        QName qName = null;
        QName qName2 = new QName(string, string2);
        ParameterDesc parameterDesc = null;
        SOAPConstants sOAPConstants = deserializationContext.getSOAPConstants();
        if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS && Constants.QNAME_RPC_RESULT.equals(qName2)) {
            return new DeserializerImpl();
        }
        if (this.currentParam == null || !this.currentParam.getQName().getNamespaceURI().equals(string) || !this.currentParam.getQName().getLocalPart().equals(string2)) {
            this.currentParam = new RPCParam(string, string2, (Object)null);
            this.rpcElem.addParam(this.currentParam);
        }
        if ((qName = messageElement.getType()) == null) {
            qName = deserializationContext.getTypeFromAttributes(string, string2, attributes);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("typeFromAttr00", "" + qName));
        }
        Class clazz = null;
        if (this.operation != null) {
            parameterDesc = this.isResponse ? this.operation.getOutputParamByQName(qName2) : this.operation.getInputParamByQName(qName2);
            if (parameterDesc == null) {
                parameterDesc = this.isResponse ? this.operation.getReturnParamDesc() : this.operation.getParameter(this.rpcElem.getParams().size() - 1);
            }
            if (parameterDesc == null) {
                throw new SAXException(Messages.getMessage("noParmDesc"));
            }
            if (!this.isHeaderElement && (this.isResponse && parameterDesc.isOutHeader() || !this.isResponse && parameterDesc.isInHeader())) {
                throw new SAXException(Messages.getMessage("expectedHeaderParam", parameterDesc.getQName().toString()));
            }
            clazz = parameterDesc.getJavaType();
            if (clazz != null && clazz.isArray()) {
                deserializationContext.setDestinationClass(clazz);
            }
            this.currentParam.setParamDesc(parameterDesc);
            if (qName == null) {
                qName = parameterDesc.getTypeQName();
            }
        }
        if (qName != null && qName.equals(XMLType.AXIS_VOID)) {
            DeserializerImpl deserializerImpl = new DeserializerImpl();
            return deserializerImpl;
        }
        if (deserializationContext.isNil(attributes)) {
            DeserializerImpl deserializerImpl = new DeserializerImpl();
            deserializerImpl.registerValueTarget(new RPCParamTarget(this.currentParam));
            return deserializerImpl;
        }
        Deserializer deserializer = null;
        if (qName == null && string != null && !string.equals("")) {
            deserializer = deserializationContext.getDeserializerForType(qName2);
        } else {
            deserializer = deserializationContext.getDeserializer(clazz, qName);
            if (deserializer == null && clazz != null && clazz.isArray() && this.operation.getStyle() == Style.DOCUMENT) {
                deserializer = deserializationContext.getDeserializerForClass(clazz);
            }
        }
        if (deserializer == null) {
            if (qName != null) {
                Class clazz2;
                deserializer = deserializationContext.getDeserializerForType(qName);
                if (null != clazz && deserializer == null && Element.class.isAssignableFrom(clazz)) {
                    deserializer = deserializationContext.getDeserializerForType(Constants.SOAP_ELEMENT);
                }
                if (deserializer == null) {
                    deserializer = deserializationContext.getDeserializerForClass(clazz);
                }
                if (deserializer == null) {
                    throw new SAXException(Messages.getMessage("noDeser01", string2, "" + qName));
                }
                if (parameterDesc != null && parameterDesc.getJavaType() != null && null != (clazz2 = deserializationContext.getTypeMapping().getClassForQName(qName)) && !JavaUtils.isConvertable(clazz2, clazz)) {
                    throw new SAXException("Bad types (" + clazz2 + " -> " + clazz + ")");
                }
            } else {
                deserializer = deserializationContext.getDeserializerForClass(clazz);
                if (deserializer == null) {
                    deserializer = new DeserializerImpl();
                }
            }
        }
        deserializer.setDefaultType(qName);
        deserializer.registerValueTarget(new RPCParamTarget(this.currentParam));
        if (log.isDebugEnabled()) {
            log.debug("Exit: RPCHandler.onStartChild()");
        }
        return (SOAPHandler)((Object)deserializer);
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("setProp00", "MessageContext", "RPCHandler.endElement()."));
        }
        deserializationContext.getMessageContext().setProperty("RPC", this.rpcElem);
    }
}

