/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class SOAPHeader
extends MessageElement
implements javax.xml.soap.SOAPHeader {
    private static Log log = LogFactory.getLog(SOAPHeader.class.getName());
    private SOAPConstants soapConstants;

    SOAPHeader(SOAPEnvelope sOAPEnvelope, SOAPConstants sOAPConstants) {
        super("Header", "soapenv", sOAPConstants != null ? sOAPConstants.getEnvelopeURI() : Constants.DEFAULT_SOAP_VERSION.getEnvelopeURI());
        this.soapConstants = sOAPConstants != null ? sOAPConstants : Constants.DEFAULT_SOAP_VERSION;
        try {
            this.setParentElement(sOAPEnvelope);
        }
        catch (SOAPException sOAPException) {
            log.fatal(Messages.getMessage("exception00"), sOAPException);
        }
    }

    public SOAPHeader(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext, SOAPConstants sOAPConstants) throws AxisFault {
        super(string, string2, string3, attributes, deserializationContext);
        this.soapConstants = sOAPConstants != null ? sOAPConstants : Constants.DEFAULT_SOAP_VERSION;
    }

    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)sOAPElement;
            super.setParentElement(sOAPEnvelope);
            this.setEnvelope(sOAPEnvelope);
        }
        catch (Throwable throwable) {
            throw new SOAPException(throwable);
        }
    }

    public javax.xml.soap.SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(name);
        this.addChildElement(sOAPHeaderElement);
        return sOAPHeaderElement;
    }

    private Vector findHeaderElements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return this.getHeadersByActor(arrayList);
    }

    public Iterator examineHeaderElements(String string) {
        return this.findHeaderElements(string).iterator();
    }

    public Iterator extractHeaderElements(String string) {
        Vector vector = this.findHeaderElements(string);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((SOAPHeaderElement)iterator.next()).detachNode();
        }
        return vector.iterator();
    }

    public Iterator examineMustUnderstandHeaderElements(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = new Vector();
        List list = this.getChildren();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string2;
                SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)list.get(i);
                if (!sOAPHeaderElement.getMustUnderstand() || !string.equals(string2 = sOAPHeaderElement.getActor())) continue;
                vector.add(list.get(i));
            }
        }
        return vector.iterator();
    }

    public Iterator examineAllHeaderElements() {
        return this.getChildElements();
    }

    public Iterator extractAllHeaderElements() {
        Vector vector = new Vector();
        List list = this.getChildren();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                vector.add(list.get(i));
            }
            list.clear();
        }
        return vector.iterator();
    }

    Vector getHeaders() {
        this.initializeChildren();
        return new Vector(this.getChildren());
    }

    Vector getHeadersByActor(ArrayList arrayList) {
        Vector<SOAPHeaderElement> vector = new Vector<SOAPHeaderElement>();
        List list = this.getChildren();
        if (list == null) {
            return vector;
        }
        Iterator iterator = list.iterator();
        SOAPConstants sOAPConstants = this.getEnvelope().getSOAPConstants();
        boolean bl = sOAPConstants == SOAPConstants.SOAP12_CONSTANTS;
        String string = sOAPConstants.getNextRoleURI();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
            String string2 = sOAPHeaderElement.getActor();
            if (bl && "http://www.w3.org/2003/05/soap-envelope/role/none".equals(string2) || string2 != null && !string.equals(string2) && (!bl || !"http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver".equals(string2)) && (arrayList == null || !arrayList.contains(string2))) continue;
            vector.add(sOAPHeaderElement);
        }
        return vector;
    }

    void addHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("addHeader00"));
        }
        try {
            this.addChildElement(sOAPHeaderElement);
        }
        catch (SOAPException sOAPException) {
            log.fatal(Messages.getMessage("exception00"), sOAPException);
        }
    }

    void removeHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("removeHeader00"));
        }
        this.removeChild(sOAPHeaderElement);
    }

    SOAPHeaderElement getHeaderByName(String string, String string2, boolean bl) {
        MessageContext messageContext;
        QName qName = new QName(string, string2);
        SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.getChildElement(qName);
        if (!bl && (messageContext = MessageContext.getCurrentContext()) != null && sOAPHeaderElement != null) {
            String string3 = sOAPHeaderElement.getActor();
            String string4 = this.getEnvelope().getSOAPConstants().getNextRoleURI();
            if (string4.equals(string3)) {
                return sOAPHeaderElement;
            }
            SOAPService sOAPService = messageContext.getService();
            if (sOAPService != null) {
                ArrayList arrayList = messageContext.getService().getActors();
                if (!(string3 == null || arrayList != null && arrayList.contains(string3))) {
                    sOAPHeaderElement = null;
                }
            }
        }
        return sOAPHeaderElement;
    }

    Enumeration getHeadersByName(String string, String string2, boolean bl) {
        ArrayList arrayList = null;
        boolean bl2 = false;
        Vector<SOAPHeaderElement> vector = new Vector<SOAPHeaderElement>();
        List list = this.getChildren();
        if (list == null) {
            return vector.elements();
        }
        Iterator iterator = list.iterator();
        String string3 = this.getEnvelope().getSOAPConstants().getNextRoleURI();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
            if (!sOAPHeaderElement.getNamespaceURI().equals(string) || !sOAPHeaderElement.getName().equals(string2)) continue;
            if (!bl) {
                Object object;
                if (bl2) {
                    object = MessageContext.getCurrentContext();
                    if (object != null && ((MessageContext)object).getAxisEngine() != null) {
                        arrayList = ((MessageContext)object).getAxisEngine().getActorURIs();
                    }
                    bl2 = false;
                }
                if ((object = sOAPHeaderElement.getActor()) != null && !string3.equals(object) && (arrayList == null || !arrayList.contains(object))) continue;
            }
            vector.addElement(sOAPHeaderElement);
        }
        return vector.elements();
    }

    protected void outputImpl(SerializationContext serializationContext) throws Exception {
        List list = this.getChildren();
        if (list == null) {
            return;
        }
        boolean bl = serializationContext.getPretty();
        serializationContext.setPretty(true);
        if (log.isDebugEnabled()) {
            log.debug(list.size() + " " + Messages.getMessage("headers00"));
        }
        if (!list.isEmpty()) {
            serializationContext.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Header"), null);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((NodeImpl)iterator.next()).output(serializationContext);
            }
            serializationContext.endElement();
        }
        serializationContext.setPretty(bl);
    }

    public void addChild(MessageElement messageElement) throws SOAPException {
        if (!(messageElement instanceof SOAPHeaderElement)) {
            throw new SOAPException(Messages.getMessage("badSOAPHeader00"));
        }
        messageElement.setEnvelope(this.getEnvelope());
        super.addChild(messageElement);
    }

    public SOAPElement addChildElement(SOAPElement sOAPElement) throws SOAPException {
        if (!(sOAPElement instanceof SOAPHeaderElement)) {
            throw new SOAPException(Messages.getMessage("badSOAPHeader00"));
        }
        SOAPElement sOAPElement2 = super.addChildElement(sOAPElement);
        this.setDirty(true);
        return sOAPElement2;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(name);
        this.addChildElement(sOAPHeaderElement);
        return sOAPHeaderElement;
    }

    public SOAPElement addChildElement(String string) throws SOAPException {
        SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(this.getNamespaceURI(), string);
        this.addChildElement(sOAPHeaderElement);
        return sOAPHeaderElement;
    }

    public SOAPElement addChildElement(String string, String string2) throws SOAPException {
        SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(this.getNamespaceURI(string2), string);
        sOAPHeaderElement.setPrefix(string2);
        this.addChildElement(sOAPHeaderElement);
        return sOAPHeaderElement;
    }

    public SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(string3, string);
        sOAPHeaderElement.setPrefix(string2);
        sOAPHeaderElement.addNamespaceDeclaration(string2, string3);
        this.addChildElement(sOAPHeaderElement);
        return sOAPHeaderElement;
    }

    public Node appendChild(Node node) throws DOMException {
        SOAPHeaderElement sOAPHeaderElement = null;
        sOAPHeaderElement = node instanceof SOAPHeaderElement ? (SOAPHeaderElement)node : new SOAPHeaderElement((Element)node);
        try {
            this.addChildElement(sOAPHeaderElement);
        }
        catch (SOAPException sOAPException) {
            throw new DOMException(11, sOAPException.toString());
        }
        return sOAPHeaderElement;
    }
}

