/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.Attributes;

public class SOAPHeaderElement
extends MessageElement
implements javax.xml.soap.SOAPHeaderElement {
    protected boolean processed = false;
    protected String actor = "http://schemas.xmlsoap.org/soap/actor/next";
    protected boolean mustUnderstand = false;
    protected boolean relay = false;
    boolean alreadySerialized = false;

    public SOAPHeaderElement(String string, String string2) {
        super(string, string2);
    }

    public SOAPHeaderElement(Name name) {
        super(name);
    }

    public SOAPHeaderElement(QName qName) {
        super(qName);
    }

    public SOAPHeaderElement(String string, String string2, Object object) {
        super(string, string2, object);
    }

    public SOAPHeaderElement(QName qName, Object object) {
        super(qName, object);
    }

    public SOAPHeaderElement(Element element) {
        super(element);
        SOAPConstants sOAPConstants = this.getSOAPConstants();
        String string = element.getAttributeNS(sOAPConstants.getEnvelopeURI(), "mustUnderstand");
        try {
            this.setMustUnderstandFromString(string, sOAPConstants == SOAPConstants.SOAP12_CONSTANTS);
        }
        catch (AxisFault axisFault) {
            log.error(axisFault);
        }
        QName qName = sOAPConstants.getRoleAttributeQName();
        this.actor = element.getAttributeNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
            String string2 = element.getAttributeNS(sOAPConstants.getEnvelopeURI(), "relay");
            this.relay = string2 != null && (string2.equals("true") || string2.equals("1"));
        }
    }

    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        if (sOAPElement instanceof SOAPEnvelope) {
            log.warn(Messages.getMessage("bodyHeaderParent"));
            sOAPElement = ((SOAPEnvelope)sOAPElement).getHeader();
        }
        if (!(sOAPElement instanceof SOAPHeader)) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        super.setParentElement(sOAPElement);
    }

    public SOAPHeaderElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws AxisFault {
        super(string, string2, string3, attributes, deserializationContext);
        SOAPConstants sOAPConstants = this.getSOAPConstants();
        String string4 = attributes.getValue(sOAPConstants.getEnvelopeURI(), "mustUnderstand");
        this.setMustUnderstandFromString(string4, sOAPConstants == SOAPConstants.SOAP12_CONSTANTS);
        QName qName = sOAPConstants.getRoleAttributeQName();
        this.actor = attributes.getValue(qName.getNamespaceURI(), qName.getLocalPart());
        if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
            String string5 = attributes.getValue(sOAPConstants.getEnvelopeURI(), "relay");
            this.relay = string5 != null && (string5.equals("true") || string5.equals("1"));
        }
        this.processed = false;
        this.alreadySerialized = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMustUnderstandFromString(String string, boolean bl) throws AxisFault {
        if (string == null || string.length() <= 0) return;
        if ("0".equals(string)) {
            this.mustUnderstand = false;
            return;
        } else if ("1".equals(string)) {
            this.mustUnderstand = true;
            return;
        } else {
            if (!bl) throw new AxisFault(Messages.getMessage("badMUVal", string, new QName(this.namespaceURI, this.name).toString()));
            if ("true".equalsIgnoreCase(string)) {
                this.mustUnderstand = true;
                return;
            } else {
                if (!"false".equalsIgnoreCase(string)) throw new AxisFault(Messages.getMessage("badMUVal", string, new QName(this.namespaceURI, this.name).toString()));
                this.mustUnderstand = false;
            }
        }
    }

    public boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(boolean bl) {
        this.mustUnderstand = bl;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String string) {
        this.actor = string;
    }

    public String getRole() {
        return this.actor;
    }

    public void setRole(String string) {
        this.actor = string;
    }

    public boolean getRelay() {
        return this.relay;
    }

    public void setRelay(boolean bl) {
        this.relay = bl;
    }

    public void setProcessed(boolean bl) {
        this.processed = bl;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    protected void outputImpl(SerializationContext serializationContext) throws Exception {
        if (!this.alreadySerialized) {
            SOAPConstants sOAPConstants = this.getSOAPConstants();
            QName qName = sOAPConstants.getRoleAttributeQName();
            if (this.actor != null) {
                this.setAttribute(qName.getNamespaceURI(), qName.getLocalPart(), this.actor);
            }
            String string = serializationContext.getMessageContext() != null && serializationContext.getMessageContext().getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS ? (this.mustUnderstand ? "true" : "false") : (this.mustUnderstand ? "1" : "0");
            this.setAttribute(sOAPConstants.getEnvelopeURI(), "mustUnderstand", string);
            if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS && this.relay) {
                this.setAttribute(sOAPConstants.getEnvelopeURI(), "relay", "true");
            }
        }
        super.outputImpl(serializationContext);
    }

    public NamedNodeMap getAttributes() {
        this.makeAttributesEditable();
        SOAPConstants sOAPConstants = this.getSOAPConstants();
        String string = this.attributes.getValue(sOAPConstants.getEnvelopeURI(), "mustUnderstand");
        QName qName = sOAPConstants.getRoleAttributeQName();
        String string2 = this.attributes.getValue(qName.getNamespaceURI(), qName.getLocalPart());
        if (string == null) {
            if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
                this.setAttributeNS(sOAPConstants.getEnvelopeURI(), "mustUnderstand", "false");
            } else {
                this.setAttributeNS(sOAPConstants.getEnvelopeURI(), "mustUnderstand", "0");
            }
        }
        if (string2 == null) {
            this.setAttributeNS(qName.getNamespaceURI(), qName.getLocalPart(), this.actor);
        }
        return super.getAttributes();
    }

    private SOAPConstants getSOAPConstants() {
        SOAPConstants sOAPConstants = null;
        if (this.context != null) {
            return this.context.getSOAPConstants();
        }
        if (this.getNamespaceURI() != null && this.getNamespaceURI().equals(SOAPConstants.SOAP12_CONSTANTS.getEnvelopeURI())) {
            sOAPConstants = SOAPConstants.SOAP12_CONSTANTS;
        }
        if (sOAPConstants == null && this.getEnvelope() != null) {
            sOAPConstants = this.getEnvelope().getSOAPConstants();
        }
        if (sOAPConstants == null) {
            sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
        }
        return sOAPConstants;
    }
}

