/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.InternalException;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Text
extends NodeImpl
implements javax.xml.soap.Text {
    public Text(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException("Text value may not be null.");
        }
        this.textRep = characterData;
    }

    public Text(String string) {
        try {
            Document document = XMLUtils.newDocument();
            this.textRep = document.createTextNode(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalException(parserConfigurationException);
        }
    }

    public Text() {
        this((String)null);
    }

    public String getWholeText() {
        return null;
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public org.w3c.dom.Text replaceWholeText(String string) {
        return null;
    }

    public boolean isComment() {
        String string = this.textRep.getNodeValue().trim();
        return string.startsWith("<!--") && string.endsWith("-->");
    }

    public String getNodeValue() throws DOMException {
        return this.textRep.getNodeValue();
    }

    public void setNodeValue(String string) throws DOMException {
        this.setDirty(true);
        this.textRep.setNodeValue(string);
    }

    public org.w3c.dom.Text splitText(int n) throws DOMException {
        int n2 = this.textRep.getLength();
        String string = this.textRep.substringData(n, n2);
        this.textRep.deleteData(n, n2);
        Text text = new Text(string);
        Node node = this.getParentNode();
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).equals(this)) continue;
                node.insertBefore(text, this);
                return text;
            }
        }
        return text;
    }

    public String getData() throws DOMException {
        return this.textRep.getData();
    }

    public void setData(String string) throws DOMException {
        this.textRep.setData(string);
    }

    public int getLength() {
        return this.textRep.getLength();
    }

    public String substringData(int n, int n2) throws DOMException {
        return this.textRep.substringData(n, n2);
    }

    public void appendData(String string) throws DOMException {
        this.textRep.appendData(string);
    }

    public void insertData(int n, String string) throws DOMException {
        this.textRep.insertData(n, string);
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.textRep.replaceData(n, n2, string);
    }

    public void deleteData(int n, int n2) throws DOMException {
        this.textRep.deleteData(n, n2);
    }

    public String toString() {
        return this.textRep.getNodeValue();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Text)) {
            return false;
        }
        return this == object || this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        if (this.textRep == null) {
            return -1;
        }
        return this.textRep.getData() != null ? this.textRep.getData().hashCode() : 0;
    }
}

