/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers;

import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public abstract class BasicProvider
extends BasicHandler {
    public static final String OPTION_WSDL_PORTTYPE = "wsdlPortType";
    public static final String OPTION_WSDL_SERVICEELEMENT = "wsdlServiceElement";
    public static final String OPTION_WSDL_SERVICEPORT = "wsdlServicePort";
    public static final String OPTION_WSDL_TARGETNAMESPACE = "wsdlTargetNamespace";
    public static final String OPTION_WSDL_INPUTSCHEMA = "wsdlInputSchema";
    public static final String OPTION_WSDL_SOAPACTION_MODE = "wsdlSoapActionMode";
    public static final String OPTION_EXTRACLASSES = "extraClasses";
    protected static Log log = LogFactory.getLog(BasicProvider.class.getName());
    protected static Log entLog = LogFactory.getLog("org.apache.axis.enterprise");

    public abstract void initServiceDesc(SOAPService var1, MessageContext var2) throws AxisFault;

    public void addOperation(String string, QName qName) {
        Hashtable<QName, String> hashtable = (Hashtable<QName, String>)this.getOption("Operations");
        if (hashtable == null) {
            hashtable = new Hashtable<QName, String>();
            this.setOption("Operations", hashtable);
        }
        hashtable.put(qName, string);
    }

    public String getOperationName(QName qName) {
        Hashtable hashtable = (Hashtable)this.getOption("Operations");
        if (hashtable == null) {
            return null;
        }
        return (String)hashtable.get(qName);
    }

    public QName[] getOperationQNames() {
        Hashtable hashtable = (Hashtable)this.getOption("Operations");
        if (hashtable == null) {
            return null;
        }
        Object[] objectArray = hashtable.keySet().toArray();
        QName[] qNameArray = new QName[objectArray.length];
        System.arraycopy(objectArray, 0, qNameArray, 0, objectArray.length);
        return qNameArray;
    }

    public String[] getOperationNames() {
        Hashtable hashtable = (Hashtable)this.getOption("Operations");
        if (hashtable == null) {
            return null;
        }
        Object[] objectArray = hashtable.values().toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    public void generateWSDL(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: BasicProvider::generateWSDL (" + this + ")");
        }
        SOAPService sOAPService = messageContext.getService();
        ServiceDesc serviceDesc = sOAPService.getInitializedServiceDesc(messageContext);
        try {
            String string;
            String string2;
            String string3 = messageContext.getStrProp("axis.wsdlgen.serv.loc.url");
            if (string3 == null) {
                string3 = serviceDesc.getEndpointURL();
            }
            if (string3 == null) {
                string3 = messageContext.getStrProp("transport.url");
            }
            if ((string2 = messageContext.getStrProp("axis.wsdlgen.intfnamespace")) == null) {
                string2 = serviceDesc.getDefaultNamespace();
            }
            if (string2 == null) {
                string2 = string3;
            }
            Emitter emitter = new Emitter();
            String string4 = (String)sOAPService.getOption("alias");
            if (string4 != null) {
                emitter.setServiceElementName(string4);
            }
            emitter.setStyle(serviceDesc.getStyle());
            emitter.setUse(serviceDesc.getUse());
            if (serviceDesc instanceof JavaServiceDesc) {
                emitter.setClsSmart(((JavaServiceDesc)serviceDesc).getImplClass(), string3);
            }
            if ((string = (String)sOAPService.getOption(OPTION_WSDL_TARGETNAMESPACE)) == null || string.length() == 0) {
                string = string2;
            }
            emitter.setIntfNamespace(string);
            emitter.setLocationUrl(string3);
            emitter.setServiceDesc(serviceDesc);
            emitter.setTypeMappingRegistry(messageContext.getTypeMappingRegistry());
            String string5 = (String)sOAPService.getOption(OPTION_WSDL_PORTTYPE);
            String string6 = (String)sOAPService.getOption(OPTION_WSDL_SERVICEELEMENT);
            String string7 = (String)sOAPService.getOption(OPTION_WSDL_SERVICEPORT);
            String string8 = (String)sOAPService.getOption(OPTION_WSDL_INPUTSCHEMA);
            String string9 = (String)sOAPService.getOption(OPTION_WSDL_SOAPACTION_MODE);
            String string10 = (String)sOAPService.getOption(OPTION_EXTRACLASSES);
            if (string5 != null && string5.length() > 0) {
                emitter.setPortTypeName(string5);
            }
            if (string6 != null && string6.length() > 0) {
                emitter.setServiceElementName(string6);
            }
            if (string7 != null && string7.length() > 0) {
                emitter.setServicePortName(string7);
            }
            if (string8 != null && string8.length() > 0) {
                emitter.setInputSchema(string8);
            }
            if (string9 != null && string9.length() > 0) {
                emitter.setSoapAction(string9);
            }
            if (string10 != null && string10.length() > 0) {
                emitter.setExtraClasses(string10);
            }
            if (messageContext.isPropertyTrue("emitAllTypesInWSDL")) {
                emitter.setEmitAllTypes(true);
            }
            Document document = emitter.emit(0);
            messageContext.setProperty("WSDL", document);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            entLog.info(Messages.getMessage("toAxisFault00"), noClassDefFoundError);
            throw new AxisFault(noClassDefFoundError.toString(), noClassDefFoundError);
        }
        catch (Exception exception) {
            entLog.info(Messages.getMessage("toAxisFault00"), exception);
            throw AxisFault.makeFault(exception);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: BasicProvider::generateWSDL (" + this + ")");
        }
    }
}

