/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ServerException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class EJBProvider
extends RPCProvider {
    protected static Log log = LogFactory.getLog(EJBProvider.class.getName());
    protected static Log entLog = LogFactory.getLog("org.apache.axis.enterprise");
    public static final String OPTION_BEANNAME = "beanJndiName";
    public static final String OPTION_HOMEINTERFACENAME = "homeInterfaceName";
    public static final String OPTION_REMOTEINTERFACENAME = "remoteInterfaceName";
    public static final String OPTION_LOCALHOMEINTERFACENAME = "localHomeInterfaceName";
    public static final String OPTION_LOCALINTERFACENAME = "localInterfaceName";
    public static final String jndiContextClass = "jndiContextClass";
    public static final String jndiURL = "jndiURL";
    public static final String jndiUsername = "jndiUser";
    public static final String jndiPassword = "jndiPassword";
    protected static final Class[] empty_class_array = new Class[0];
    protected static final Object[] empty_object_array = new Object[0];
    private static InitialContext cached_context = null;

    protected Object makeNewServiceObject(MessageContext messageContext, String string) throws Exception {
        String string2;
        String string3 = this.getStrOption(OPTION_HOMEINTERFACENAME, messageContext.getService());
        String string4 = this.getStrOption(OPTION_LOCALHOMEINTERFACENAME, messageContext.getService());
        String string5 = string2 = string3 != null ? string3 : string4;
        if (string2 == null) {
            throw new AxisFault(Messages.getMessage("noOption00", OPTION_HOMEINTERFACENAME, messageContext.getTargetService()));
        }
        Class clazz = ClassUtils.forName(string2, true, messageContext.getClassLoader());
        if (string3 != null) {
            return this.createRemoteEJB(messageContext, string, clazz);
        }
        return this.createLocalEJB(messageContext, string, clazz);
    }

    private Object createRemoteEJB(MessageContext messageContext, String string, Class clazz) throws Exception {
        Object object = this.getEJBHome(messageContext.getService(), messageContext, string);
        Object object2 = PortableRemoteObject.narrow((Object)object, (Class)clazz);
        Method method = clazz.getMethod("create", empty_class_array);
        Object object3 = method.invoke(object2, empty_object_array);
        return object3;
    }

    private Object createLocalEJB(MessageContext messageContext, String string, Class clazz) throws Exception {
        Object object = this.getEJBHome(messageContext.getService(), messageContext, string);
        if (!clazz.isInstance(object)) {
            throw new ClassCastException(Messages.getMessage("badEjbHomeType"));
        }
        Object object2 = object;
        Method method = clazz.getMethod("create", empty_class_array);
        Object object3 = method.invoke(object2, empty_object_array);
        return object3;
    }

    private boolean isRemoteEjb(SOAPService sOAPService) {
        return this.getStrOption(OPTION_HOMEINTERFACENAME, sOAPService) != null;
    }

    private boolean isLocalEjb(SOAPService sOAPService) {
        return !this.isRemoteEjb(sOAPService) && this.getStrOption(OPTION_LOCALHOMEINTERFACENAME, sOAPService) != null;
    }

    protected String getServiceClassNameOptionName() {
        return OPTION_BEANNAME;
    }

    protected String getStrOption(String string, Handler handler) {
        String string2 = null;
        if (handler != null) {
            string2 = (String)handler.getOption(string);
        }
        if (string2 == null) {
            string2 = (String)this.getOption(string);
        }
        return string2;
    }

    private Class getRemoteInterfaceClassFromHome(String string, SOAPService sOAPService, MessageContext messageContext) throws Exception {
        Object object = this.getEJBHome(sOAPService, messageContext, string);
        String string2 = this.getStrOption(OPTION_HOMEINTERFACENAME, sOAPService);
        if (string2 == null) {
            throw new AxisFault(Messages.getMessage("noOption00", OPTION_HOMEINTERFACENAME, sOAPService.getName()));
        }
        ClassLoader classLoader = messageContext != null ? messageContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
        Class clazz = ClassUtils.forName(string2, true, classLoader);
        Object object2 = PortableRemoteObject.narrow((Object)object, (Class)clazz);
        Method method = clazz.getMethod("getEJBMetaData", empty_class_array);
        Object object3 = method.invoke(object2, empty_object_array);
        Method method2 = object3.getClass().getMethod("getRemoteInterfaceClass", empty_class_array);
        return (Class)method2.invoke(object3, empty_object_array);
    }

    protected Class getServiceClass(String string, SOAPService sOAPService, MessageContext messageContext) throws AxisFault {
        Class clazz;
        block5: {
            clazz = null;
            try {
                String string2;
                String string3 = this.getStrOption(OPTION_REMOTEINTERFACENAME, sOAPService);
                String string4 = this.getStrOption(OPTION_LOCALINTERFACENAME, sOAPService);
                String string5 = string2 = string3 != null ? string3 : string4;
                if (string2 != null) {
                    ClassLoader classLoader = messageContext != null ? messageContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
                    clazz = ClassUtils.forName(string2, true, classLoader);
                    break block5;
                }
                if (this.isRemoteEjb(sOAPService)) {
                    clazz = this.getRemoteInterfaceClassFromHome(string, sOAPService, messageContext);
                    break block5;
                }
                if (this.isLocalEjb(sOAPService)) {
                    throw new AxisFault(Messages.getMessage("noOption00", OPTION_LOCALINTERFACENAME, sOAPService.getName()));
                }
                throw new AxisFault(Messages.getMessage("noOption00", OPTION_HOMEINTERFACENAME, sOAPService.getName()));
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
        }
        return clazz;
    }

    private Object getEJBHome(SOAPService sOAPService, MessageContext messageContext, String string) throws AxisFault {
        Object object = null;
        try {
            InitialContext initialContext;
            String string2;
            String string3;
            String string4;
            Properties properties = null;
            String string5 = this.getStrOption(jndiUsername, sOAPService);
            if (string5 == null && messageContext != null) {
                string5 = messageContext.getUsername();
            }
            if (string5 != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.security.principal", string5);
            }
            if ((string4 = this.getStrOption(jndiPassword, sOAPService)) == null && messageContext != null) {
                string4 = messageContext.getPassword();
            }
            if (string4 != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.security.credentials", string4);
            }
            if ((string3 = this.getStrOption(jndiContextClass, sOAPService)) != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.factory.initial", string3);
            }
            if ((string2 = this.getStrOption(jndiURL, sOAPService)) != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.provider.url", string2);
            }
            if ((initialContext = this.getContext(properties)) == null) {
                throw new AxisFault(Messages.getMessage("cannotCreateInitialContext00"));
            }
            object = this.getEJBHome(initialContext, string);
            if (object == null) {
                throw new AxisFault(Messages.getMessage("cannotFindJNDIHome00", string));
            }
        }
        catch (Exception exception) {
            entLog.info(Messages.getMessage("toAxisFault00"), exception);
            throw AxisFault.makeFault(exception);
        }
        return object;
    }

    protected InitialContext getCachedContext() throws NamingException {
        if (cached_context == null) {
            cached_context = new InitialContext();
        }
        return cached_context;
    }

    protected InitialContext getContext(Properties properties) throws AxisFault, NamingException {
        return properties == null ? this.getCachedContext() : new InitialContext(properties);
    }

    protected Object getEJBHome(InitialContext initialContext, String string) throws AxisFault, NamingException {
        return initialContext.lookup(string);
    }

    protected Object invokeMethod(MessageContext messageContext, Method method, Object object, Object[] objectArray) throws Exception {
        try {
            return super.invokeMethod(messageContext, method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = this.getCause(invocationTargetException);
            if (throwable instanceof ServerException) {
                throw new InvocationTargetException(this.getCause(throwable));
            }
            throw invocationTargetException;
        }
    }

    private Throwable getCause(Throwable throwable) {
        try {
            Method method = throwable.getClass().getMethod("getCause", null);
            Throwable throwable2 = (Throwable)method.invoke((Object)throwable, (Object[])null);
            if (throwable2 != null) {
                return throwable2;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable3) {
            // empty catch block
        }
        return throwable;
    }
}

