/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.wsdl.OperationType;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Scope;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.session.Session;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public abstract class JavaProvider
extends BasicProvider {
    protected static Log log = LogFactory.getLog(JavaProvider.class.getName());
    protected static Log entLog = LogFactory.getLog("org.apache.axis.enterprise");
    public static final String OPTION_CLASSNAME = "className";
    public static final String OPTION_ALLOWEDMETHODS = "allowedMethods";
    public static final String OPTION_SCOPE = "scope";

    public Object getServiceObject(MessageContext messageContext, Handler handler, String string, IntHolder intHolder) throws Exception {
        String string2 = messageContext.getService().getName();
        Scope scope = Scope.getScope((String)handler.getOption(OPTION_SCOPE), Scope.DEFAULT);
        intHolder.value = scope.getValue();
        if (scope == Scope.REQUEST) {
            return this.getNewServiceObject(messageContext, string);
        }
        if (scope == Scope.SESSION) {
            Session session;
            if (string2 == null) {
                string2 = messageContext.getService().toString();
            }
            if ((session = messageContext.getSession()) != null) {
                return this.getSessionServiceObject(session, string2, messageContext, string);
            }
            intHolder.value = Scope.DEFAULT.getValue();
            return this.getNewServiceObject(messageContext, string);
        }
        if (scope == Scope.APPLICATION) {
            return this.getApplicationScopedObject(messageContext, string2, string, intHolder);
        }
        if (scope == Scope.FACTORY) {
            String string3 = messageContext.getStrProp("objectID");
            if (string3 == null) {
                return this.getApplicationScopedObject(messageContext, string2, string, intHolder);
            }
            SOAPService sOAPService = (SOAPService)handler;
            Object v = sOAPService.serviceObjects.get(string3);
            if (v == null) {
                throw new AxisFault("NoSuchObject", null, null, null);
            }
            return v;
        }
        return null;
    }

    private Object getApplicationScopedObject(MessageContext messageContext, String string, String string2, IntHolder intHolder) throws Exception {
        AxisEngine axisEngine = messageContext.getAxisEngine();
        Session session = axisEngine.getApplicationSession();
        if (session != null) {
            return this.getSessionServiceObject(session, string, messageContext, string2);
        }
        log.error(Messages.getMessage("noAppSession"));
        intHolder.value = Scope.DEFAULT.getValue();
        return this.getNewServiceObject(messageContext, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSessionServiceObject(Session session, String string, MessageContext messageContext, String string2) throws Exception {
        Object object = null;
        boolean bl = false;
        Object object2 = session.getLockObject();
        synchronized (object2) {
            object = session.get(string);
            if (object == null) {
                object = new LockObject();
                bl = true;
                session.set(string, object);
                messageContext.getService().addSession(session);
            }
        }
        if (LockObject.class == object.getClass()) {
            object2 = (LockObject)object;
            if (bl) {
                try {
                    object = this.getNewServiceObject(messageContext, string2);
                    session.set(string, object);
                    messageContext.getService().addSession(session);
                }
                catch (Exception exception) {
                    session.remove(string);
                    throw exception;
                }
                finally {
                    ((LockObject)object2).complete();
                }
            } else {
                ((LockObject)object2).waitUntilComplete();
                object = session.get(string);
            }
        }
        return object;
    }

    private Object getNewServiceObject(MessageContext messageContext, String string) throws Exception {
        Object object = this.makeNewServiceObject(messageContext, string);
        if (object != null && object instanceof ServiceLifecycle) {
            ((ServiceLifecycle)object).init(messageContext.getProperty("servletEndpointContext"));
        }
        return object;
    }

    public abstract void processMessage(MessageContext var1, SOAPEnvelope var2, SOAPEnvelope var3, Object var4) throws Exception;

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JavaProvider::invoke (" + this + ")");
        }
        String string = messageContext.getTargetService();
        SOAPService sOAPService = messageContext.getService();
        String string2 = this.getServiceClassName(sOAPService);
        if (string2 == null || string2.equals("")) {
            throw new AxisFault("Server.NoClassForService", Messages.getMessage("noOption00", this.getServiceClassNameOptionName(), string), null, null);
        }
        IntHolder intHolder = new IntHolder();
        Object object = null;
        try {
            Object object2;
            Message message;
            object = this.getServiceObject(messageContext, sOAPService, string2, intHolder);
            SOAPEnvelope sOAPEnvelope = null;
            OperationDesc operationDesc = messageContext.getOperation();
            if (operationDesc != null && OperationType.ONE_WAY.equals(operationDesc.getMep())) {
                messageContext.setResponseMessage(null);
            } else {
                message = messageContext.getResponseMessage();
                if (message == null) {
                    sOAPEnvelope = new SOAPEnvelope(messageContext.getSOAPConstants(), messageContext.getSchemaVersion());
                    message = new Message(sOAPEnvelope);
                    object2 = XMLUtils.getEncoding(messageContext);
                    message.setProperty("javax.xml.soap.character-set-encoding", object2);
                    messageContext.setResponseMessage(message);
                } else {
                    sOAPEnvelope = message.getSOAPEnvelope();
                }
            }
            message = messageContext.getRequestMessage();
            object2 = message.getSOAPEnvelope();
            this.processMessage(messageContext, (SOAPEnvelope)object2, sOAPEnvelope, object);
        }
        catch (SAXException sAXException) {
            entLog.debug(Messages.getMessage("toAxisFault00"), sAXException);
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            throw AxisFault.makeFault(exception);
        }
        catch (Exception exception) {
            entLog.debug(Messages.getMessage("toAxisFault00"), exception);
            AxisFault axisFault = AxisFault.makeFault(exception);
            if (exception instanceof RuntimeException) {
                axisFault.addFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION, "true");
            }
            throw axisFault;
        }
        finally {
            if (object != null && intHolder.value == Scope.REQUEST.getValue() && object instanceof ServiceLifecycle) {
                ((ServiceLifecycle)object).destroy();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JavaProvider::invoke (" + this + ")");
        }
    }

    private String getAllowedMethods(Handler handler) {
        String string = (String)handler.getOption(OPTION_ALLOWEDMETHODS);
        if (string == null || string.length() == 0) {
            string = (String)handler.getOption("methodName");
        }
        return string;
    }

    protected Object makeNewServiceObject(MessageContext messageContext, String string) throws Exception {
        ClassLoader classLoader = messageContext.getClassLoader();
        ClassCache classCache = messageContext.getAxisEngine().getClassCache();
        JavaClass javaClass = classCache.lookup(string, classLoader);
        return javaClass.getJavaClass().newInstance();
    }

    protected String getServiceClassName(Handler handler) {
        return (String)handler.getOption(this.getServiceClassNameOptionName());
    }

    protected String getServiceClassNameOptionName() {
        return OPTION_CLASSNAME;
    }

    protected Class getServiceClass(String string, SOAPService sOAPService, MessageContext messageContext) throws AxisFault {
        ClassLoader classLoader = null;
        Class clazz = null;
        AxisEngine axisEngine = sOAPService.getEngine();
        classLoader = messageContext != null ? messageContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
        if (axisEngine != null) {
            ClassCache classCache = axisEngine.getClassCache();
            try {
                JavaClass javaClass = classCache.lookup(string, classLoader);
                clazz = javaClass.getJavaClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error(Messages.getMessage("exception00"), classNotFoundException);
                throw new AxisFault(Messages.getMessage("noClassForService00", string), classNotFoundException);
            }
        }
        try {
            clazz = ClassUtils.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error(Messages.getMessage("exception00"), classNotFoundException);
            throw new AxisFault(Messages.getMessage("noClassForService00", string), classNotFoundException);
        }
        return clazz;
    }

    public void initServiceDesc(SOAPService sOAPService, MessageContext messageContext) throws AxisFault {
        String string;
        String string2 = this.getServiceClassName(sOAPService);
        if (string2 == null) {
            throw new AxisFault(Messages.getMessage("noServiceClass"));
        }
        Class clazz = this.getServiceClass(string2, sOAPService, messageContext);
        JavaServiceDesc javaServiceDesc = (JavaServiceDesc)sOAPService.getServiceDescription();
        if (javaServiceDesc.getAllowedMethods() == null && sOAPService != null && (string = this.getAllowedMethods(sOAPService)) != null && !"*".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            javaServiceDesc.setAllowedMethods(arrayList);
        }
        javaServiceDesc.loadServiceDescByIntrospection(clazz);
    }

    class LockObject
    implements Serializable {
        private boolean completed = false;

        LockObject() {
        }

        synchronized void waitUntilComplete() throws InterruptedException {
            while (!this.completed) {
                this.wait();
            }
        }

        synchronized void complete() {
            this.completed = true;
            this.notifyAll();
        }
    }
}

