/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.axis.AxisFault;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.DefaultAxisServerFactory;
import org.apache.axis.utils.Messages;

public class JNDIAxisServerFactory
extends DefaultAxisServerFactory {
    public AxisServer getServer(Map map) throws AxisFault {
        String string;
        log.debug("Enter: JNDIAxisServerFactory::getServer");
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            log.warn(Messages.getMessage("jndiNotFound00"), namingException);
        }
        ServletContext servletContext = null;
        try {
            servletContext = (ServletContext)map.get("servletContext");
        }
        catch (ClassCastException classCastException) {
            log.warn(Messages.getMessage("servletContextWrongClass00"), classCastException);
        }
        AxisServer axisServer = null;
        if (initialContext != null && servletContext != null && (string = servletContext.getRealPath("/WEB-INF/Server")) != null) {
            try {
                axisServer = (AxisServer)initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                axisServer = super.getServer(map);
                try {
                    initialContext.bind(string, (Object)axisServer);
                }
                catch (NamingException namingException2) {
                    // empty catch block
                }
            }
        }
        if (axisServer == null) {
            axisServer = super.getServer(map);
        }
        log.debug("Exit: JNDIAxisServerFactory::getServer");
        return axisServer;
    }
}

