/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.soap;

import java.net.MalformedURLException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Call;
import org.apache.axis.utils.Messages;

public class SOAPConnectionImpl
extends SOAPConnection {
    private boolean closed = false;
    private Integer timeout = null;

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer n) {
        this.timeout = n;
    }

    public SOAPMessage call(SOAPMessage sOAPMessage, Object object) throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        try {
            Object object2;
            Call call = new Call(object.toString());
            ((Message)sOAPMessage).setMessageContext(call.getMessageContext());
            Attachments attachments = ((Message)sOAPMessage).getAttachmentsImpl();
            if (attachments != null) {
                object2 = attachments.getAttachments().iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    call.addAttachmentPart(e);
                }
            }
            if ((object2 = this.checkForSOAPActionHeader(sOAPMessage)) != null) {
                call.setSOAPActionURI((String)object2);
            }
            call.setTimeout(this.timeout);
            call.setReturnClass(SOAPMessage.class);
            call.setProperty("call.CheckMustUnderstand", Boolean.FALSE);
            call.invoke((Message)sOAPMessage);
            return call.getResponseMessage();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SOAPException(malformedURLException);
        }
        catch (AxisFault axisFault) {
            throw new SOAPException(axisFault);
        }
    }

    private String checkForSOAPActionHeader(SOAPMessage sOAPMessage) {
        String[] stringArray;
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        if (mimeHeaders != null && (stringArray = mimeHeaders.getHeader("SOAPAction")) != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        this.closed = true;
    }
}

