/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.QSHandler;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public abstract class AbstractQueryStringHandler
implements QSHandler {
    private boolean development;
    protected Log exceptionLog;
    protected Log log;

    protected boolean isDevelopment() {
        return this.development;
    }

    protected void configureFromContext(MessageContext messageContext) {
        this.development = (Boolean)messageContext.getProperty("transport.http.plugin.isDevelopment");
        this.exceptionLog = (Log)messageContext.getProperty("transport.http.plugin.exceptionLog");
        this.log = (Log)messageContext.getProperty("transport.http.plugin.log");
    }

    protected void processAxisFault(AxisFault axisFault) {
        Element element = axisFault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (element != null) {
            this.exceptionLog.info(Messages.getMessage("axisFault00"), axisFault);
            axisFault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        } else if (this.exceptionLog.isDebugEnabled()) {
            this.exceptionLog.debug(Messages.getMessage("axisFault00"), axisFault);
        }
        if (!this.isDevelopment()) {
            axisFault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        }
    }

    protected void configureResponseFromAxisFault(HttpServletResponse httpServletResponse, AxisFault axisFault) {
        int n = this.getHttpServletResponseStatus(axisFault);
        if (n == 401) {
            httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
        }
        httpServletResponse.setStatus(n);
    }

    protected Message convertExceptionToAxisFault(Exception exception, Message message) {
        this.logException(exception);
        if (message == null) {
            AxisFault axisFault = AxisFault.makeFault(exception);
            this.processAxisFault(axisFault);
            message = new Message(axisFault);
        }
        return message;
    }

    private int getHttpServletResponseStatus(AxisFault axisFault) {
        return axisFault.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void logException(Exception exception) {
        this.exceptionLog.info(Messages.getMessage("exception00"), exception);
    }

    protected void writeFault(PrintWriter printWriter, AxisFault axisFault) {
        String string = XMLUtils.xmlEncodeString(axisFault.getLocalizedMessage());
        printWriter.println("<pre>Fault - " + string + "<br>");
        printWriter.println(axisFault.dumpToString());
        printWriter.println("</pre>");
    }
}

