/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.CommonsHTTPClientProperties;
import org.apache.axis.components.net.CommonsHTTPClientPropertiesFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NetworkUtils;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;

public class CommonsHTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(CommonsHTTPSender.class.getName());
    protected HttpConnectionManager connectionManager;
    protected CommonsHTTPClientProperties clientProperties;
    boolean httpChunkStream = true;

    public CommonsHTTPSender() {
        this.initialize();
    }

    protected void initialize() {
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        this.clientProperties = CommonsHTTPClientPropertiesFactory.create();
        multiThreadedHttpConnectionManager.getParams().setDefaultMaxConnectionsPerHost(this.clientProperties.getMaximumConnectionsPerHost());
        multiThreadedHttpConnectionManager.getParams().setMaxTotalConnections(this.clientProperties.getMaximumTotalConnections());
        if (this.clientProperties.getDefaultConnectionTimeout() > 0) {
            multiThreadedHttpConnectionManager.getParams().setConnectionTimeout(this.clientProperties.getDefaultConnectionTimeout());
        }
        if (this.clientProperties.getDefaultSoTimeout() > 0) {
            multiThreadedHttpConnectionManager.getParams().setSoTimeout(this.clientProperties.getDefaultSoTimeout());
        }
        this.connectionManager = multiThreadedHttpConnectionManager;
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        HttpMethodBase httpMethodBase = null;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "CommonsHTTPSender::invoke"));
        }
        try {
            String string;
            String string2;
            Object object;
            URL uRL = new URL(messageContext.getStrProp("transport.url"));
            HttpClient httpClient = new HttpClient(this.connectionManager);
            httpClient.getParams().setConnectionManagerTimeout(this.clientProperties.getConnectionPoolTimeout());
            HostConfiguration hostConfiguration = this.getHostConfiguration(httpClient, messageContext, uRL);
            boolean bl = true;
            if (messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && (object = messageContext.getStrProp("soap12.webmethod")) != null) {
                bl = ((String)object).equals("POST");
            }
            if (bl) {
                object = messageContext.getRequestMessage();
                httpMethodBase = new PostMethod(uRL.toString());
                httpMethodBase.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                this.addContextInfo(httpMethodBase, httpClient, messageContext, uRL);
                ((PostMethod)httpMethodBase).setRequestEntity(new MessageRequestEntity(httpMethodBase, (Message)object, this.httpChunkStream));
            } else {
                httpMethodBase = new GetMethod(uRL.toString());
                this.addContextInfo(httpMethodBase, httpClient, messageContext, uRL);
            }
            object = messageContext.getStrProp("axis.transport.version");
            if (object != null && ((String)object).equals(HTTPConstants.HEADER_PROTOCOL_V10)) {
                httpMethodBase.getParams().setVersion(HttpVersion.HTTP_1_0);
            }
            if (messageContext.getMaintainSession()) {
                HttpState httpState = httpClient.getState();
                httpMethodBase.getParams().setCookiePolicy("compatibility");
                string2 = hostConfiguration.getHost();
                string = uRL.getPath();
                boolean bl2 = hostConfiguration.getProtocol().isSecure();
                this.fillHeaders(messageContext, httpState, "Cookie", string2, string, bl2);
                this.fillHeaders(messageContext, httpState, "Cookie2", string2, string, bl2);
                httpClient.setState(httpState);
            }
            int n = httpClient.executeMethod(hostConfiguration, httpMethodBase, null);
            string2 = CommonsHTTPSender.getHeader(httpMethodBase, "Content-Type");
            string = CommonsHTTPSender.getHeader(httpMethodBase, "Content-Location");
            String string3 = CommonsHTTPSender.getHeader(httpMethodBase, "Content-Length");
            if (!(n > 199 && n < 300 || messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || string2 != null && !string2.equals("text/html") && n > 499 && n < 600)) {
                String string4 = httpMethodBase.getStatusText();
                AxisFault axisFault = new AxisFault("HTTP", "(" + n + ")" + string4, null, null);
                try {
                    axisFault.setFaultDetailString(Messages.getMessage("return01", "" + n, httpMethodBase.getResponseBodyAsString()));
                    axisFault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, Integer.toString(n));
                    throw axisFault;
                }
                catch (Throwable throwable) {
                    httpMethodBase.releaseConnection();
                    throw throwable;
                }
            }
            InputStream inputStream = this.createConnectionReleasingInputStream(httpMethodBase);
            Message message = new Message(inputStream, false, string2, string);
            Header[] headerArray = httpMethodBase.getResponseHeaders();
            MimeHeaders mimeHeaders = message.getMimeHeaders();
            for (int i = 0; i < headerArray.length; ++i) {
                Header header = headerArray[i];
                mimeHeaders.addHeader(header.getName(), header.getValue());
            }
            message.setMessageType("response");
            messageContext.setResponseMessage(message);
            if (log.isDebugEnabled()) {
                if (null == string3) {
                    log.debug("\n" + Messages.getMessage("no00", "Content-Length"));
                }
                log.debug("\n" + Messages.getMessage("xmlRecd00"));
                log.debug("-----------------------------------------------");
                log.debug(message.getSOAPPartAsString());
            }
            if (messageContext.getMaintainSession()) {
                Header[] headerArray2 = httpMethodBase.getResponseHeaders();
                for (int i = 0; i < headerArray2.length; ++i) {
                    if (headerArray2[i].getName().equalsIgnoreCase("Set-Cookie")) {
                        this.handleCookie("Cookie", headerArray2[i].getValue(), messageContext);
                        continue;
                    }
                    if (!headerArray2[i].getName().equalsIgnoreCase("Set-Cookie2")) continue;
                    this.handleCookie("Cookie2", headerArray2[i].getValue(), messageContext);
                }
            }
            if (messageContext.isPropertyTrue("axis.one.way")) {
                httpMethodBase.releaseConnection();
            }
        }
        catch (Exception exception) {
            log.debug(exception);
            throw AxisFault.makeFault(exception);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "CommonsHTTPSender::invoke"));
        }
    }

    public void handleCookie(String string, String string2, MessageContext messageContext) {
        int n = (string2 = this.cleanupCookie(string2)).indexOf("=");
        String string3 = n != -1 ? string2.substring(0, n) : string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = messageContext.getProperty(string);
        boolean bl = false;
        if (object != null) {
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if (string3 != null && string4.indexOf(string3) == 0) {
                        string4 = string2;
                        bl = true;
                    }
                    arrayList.add(string4);
                }
            } else {
                String string5 = (String)object;
                if (string3 != null && string5.indexOf(string3) == 0) {
                    string5 = string2;
                    bl = true;
                }
                arrayList.add(string5);
            }
        }
        if (!bl) {
            arrayList.add(string2);
        }
        if (arrayList.size() == 1) {
            messageContext.setProperty(string, arrayList.get(0));
        } else if (arrayList.size() > 1) {
            messageContext.setProperty(string, arrayList.toArray(new String[arrayList.size()]));
        }
    }

    private void fillHeaders(MessageContext messageContext, HttpState httpState, String string, String string2, String string3, boolean bl) {
        Object object = messageContext.getProperty(string);
        if (object != null) {
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addCookie(httpState, stringArray[i], string2, string3, bl);
                }
            } else {
                this.addCookie(httpState, (String)object, string2, string3, bl);
            }
        }
    }

    private void addCookie(HttpState httpState, String string, String string2, String string3, boolean bl) {
        int n = string.indexOf(61);
        httpState.addCookie(new Cookie(string2, string.substring(0, n), string.substring(n + 1), string3, null, bl));
    }

    private String cleanupCookie(String string) {
        int n = (string = string.trim()).indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected HostConfiguration getHostConfiguration(HttpClient httpClient, MessageContext messageContext, URL uRL) {
        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(uRL.getProtocol());
        int n = uRL.getPort();
        boolean bl = this.isHostInNonProxyList(uRL.getHost(), transportClientProperties.getNonProxyHosts());
        HostConfiguration hostConfiguration = new HostConfiguration();
        if (n == -1) {
            n = 80;
        }
        if (bl) {
            hostConfiguration.setHost(uRL.getHost(), n, uRL.getProtocol());
        } else if (transportClientProperties.getProxyHost().length() == 0 || transportClientProperties.getProxyPort().length() == 0) {
            hostConfiguration.setHost(uRL.getHost(), n, uRL.getProtocol());
        } else {
            if (transportClientProperties.getProxyUser().length() != 0) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(transportClientProperties.getProxyUser(), transportClientProperties.getProxyPassword());
                int n2 = transportClientProperties.getProxyUser().indexOf("\\");
                if (n2 > 0) {
                    String string = transportClientProperties.getProxyUser().substring(0, n2);
                    if (transportClientProperties.getProxyUser().length() > n2 + 1) {
                        String string2 = transportClientProperties.getProxyUser().substring(n2 + 1);
                        usernamePasswordCredentials = new NTCredentials(string2, transportClientProperties.getProxyPassword(), transportClientProperties.getProxyHost(), string);
                    }
                }
                httpClient.getState().setProxyCredentials(AuthScope.ANY, usernamePasswordCredentials);
            }
            int n3 = new Integer(transportClientProperties.getProxyPort());
            hostConfiguration.setProxy(transportClientProperties.getProxyHost(), n3);
        }
        return hostConfiguration;
    }

    private void addContextInfo(HttpMethodBase httpMethodBase, HttpClient httpClient, MessageContext messageContext, URL uRL) throws Exception {
        Hashtable hashtable;
        Object object2;
        int n;
        Object object3;
        Message message;
        String string;
        if (messageContext.getTimeout() != 0) {
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(messageContext.getTimeout());
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(messageContext.getTimeout());
        }
        String string2 = string = messageContext.useSOAPAction() ? messageContext.getSOAPActionURI() : "";
        if (string == null) {
            string = "";
        }
        if ((message = messageContext.getRequestMessage()) != null) {
            httpMethodBase.setRequestHeader(new Header("Content-Type", message.getContentType(messageContext.getSOAPConstants())));
        }
        httpMethodBase.setRequestHeader(new Header("SOAPAction", "\"" + string + "\""));
        Object object4 = messageContext.getUsername();
        String string3 = messageContext.getPassword();
        if (object4 == null && uRL.getUserInfo() != null) {
            object3 = uRL.getUserInfo();
            n = ((String)object3).indexOf(58);
            if (n >= 0 && n + 1 < ((String)object3).length()) {
                object4 = ((String)object3).substring(0, n);
                string3 = ((String)object3).substring(n + 1);
            } else {
                object4 = object3;
            }
        }
        if (object4 != null) {
            object3 = new UsernamePasswordCredentials((String)object4, string3);
            n = ((String)object4).indexOf("\\");
            if (n > 0) {
                object2 = ((String)object4).substring(0, n);
                if (((String)object4).length() > n + 1) {
                    String object5 = ((String)object4).substring(n + 1);
                    object3 = new NTCredentials(object5, string3, NetworkUtils.getLocalHostname(), (String)object2);
                }
            }
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)object3);
        }
        if ((object3 = message.getMimeHeaders()) != null) {
            Iterator iterator = ((MimeHeaders)object3).getAllHeaders();
            while (iterator.hasNext()) {
                object2 = (MimeHeader)iterator.next();
                String string4 = ((MimeHeader)object2).getName();
                if (string4.equals("Content-Type") || string4.equals("SOAPAction")) continue;
                httpMethodBase.addRequestHeader(((MimeHeader)object2).getName(), ((MimeHeader)object2).getValue());
            }
        }
        if ((hashtable = (Hashtable)messageContext.getProperty("HTTP-Request-Headers")) != null) {
            for (Map.Entry entry : hashtable.entrySet()) {
                Object k = entry.getKey();
                if (null == k) continue;
                String string5 = k.toString().trim();
                String string6 = entry.getValue().toString().trim();
                if (string5.equalsIgnoreCase("Expect") && string6.equalsIgnoreCase("100-continue")) {
                    httpMethodBase.getParams().setBooleanParameter("http.protocol.expect-continue", true);
                    continue;
                }
                if (string5.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
                    String string7 = entry.getValue().toString();
                    if (null == string7) continue;
                    this.httpChunkStream = JavaUtils.isTrue(string7);
                    continue;
                }
                httpMethodBase.addRequestHeader(string5, string6);
            }
        }
    }

    protected boolean isHostInNonProxyList(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("match00", new String[]{"HTTPSender", string, string3}));
            }
            if (!CommonsHTTPSender.match(string3, string, false)) continue;
            return true;
        }
        return false;
    }

    protected static boolean match(String string, String string2, boolean bl) {
        char c;
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = 0;
        int n3 = cArray.length - 1;
        int n4 = 0;
        int n5 = cArray2.length - 1;
        boolean bl2 = false;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '*') continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (n3 != n5) {
                return false;
            }
            for (n = 0; n <= n3; ++n) {
                char c2 = cArray[n];
                if (bl && c2 != cArray2[n]) {
                    return false;
                }
                if (bl || Character.toUpperCase(c2) == Character.toUpperCase(cArray2[n])) continue;
                return false;
            }
            return true;
        }
        if (n3 == 0) {
            return true;
        }
        while ((c = cArray[n2]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n4]) {
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4])) {
                return false;
            }
            ++n2;
            ++n4;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                return false;
            }
            return true;
        }
        while ((c = cArray[n3]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n5]) {
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n5])) {
                return false;
            }
            --n3;
            --n5;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                return false;
            }
            return true;
        }
        while (n2 != n3 && n4 <= n5) {
            int n6;
            n = -1;
            for (n6 = n2 + 1; n6 <= n3; ++n6) {
                if (cArray[n6] != '*') continue;
                n = n6;
                break;
            }
            if (n == n2 + 1) {
                ++n2;
                continue;
            }
            n6 = n - n2 - 1;
            int n7 = n5 - n4 + 1;
            int n8 = -1;
            block8: for (int i = 0; i <= n7 - n6; ++i) {
                for (int j = 0; j < n6; ++j) {
                    c = cArray[n2 + j + 1];
                    if (bl && c != cArray2[n4 + i + j] || !bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4 + i + j])) continue block8;
                }
                n8 = n4 + i;
                break;
            }
            if (n8 == -1) {
                return false;
            }
            n2 = n;
            n4 = n8 + n6;
        }
        for (n = n2; n <= n3; ++n) {
            if (cArray[n] == '*') continue;
            return false;
        }
        return true;
    }

    private static String getHeader(HttpMethodBase httpMethodBase, String string) {
        Header header = httpMethodBase.getResponseHeader(string);
        return header == null ? null : header.getValue().trim();
    }

    private InputStream createConnectionReleasingInputStream(final HttpMethodBase httpMethodBase) throws IOException {
        return new FilterInputStream(httpMethodBase.getResponseBodyAsStream()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    httpMethodBase.releaseConnection();
                }
            }
        };
    }

    private static class MessageRequestEntity
    implements RequestEntity {
        private HttpMethodBase method;
        private Message message;
        boolean httpChunkStream = true;

        public MessageRequestEntity(HttpMethodBase httpMethodBase, Message message) {
            this.message = message;
            this.method = httpMethodBase;
        }

        public MessageRequestEntity(HttpMethodBase httpMethodBase, Message message, boolean bl) {
            this.message = message;
            this.method = httpMethodBase;
            this.httpChunkStream = bl;
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeRequest(OutputStream outputStream) throws IOException {
            try {
                this.message.writeTo(outputStream);
            }
            catch (SOAPException sOAPException) {
                throw new IOException(sOAPException.getMessage());
            }
        }

        public long getContentLength() {
            if (this.method.getParams().getVersion() == HttpVersion.HTTP_1_0 || !this.httpChunkStream) {
                try {
                    return this.message.getContentLength();
                }
                catch (Exception exception) {
                    return -1L;
                }
            }
            return -1L;
        }

        public String getContentType() {
            return null;
        }
    }
}

