/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SocketFactory;
import org.apache.axis.components.net.SocketFactoryFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.ChunkedOutputStream;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.SocketHolder;
import org.apache.axis.transport.http.SocketInputStream;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.TeeOutputStream;
import org.apache.commons.logging.Log;

public class HTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(HTTPSender.class.getName());
    private static final String ACCEPT_HEADERS = "Accept: application/soap+xml, application/dime, multipart/related, text/*\r\nUser-Agent: " + Messages.getMessage("axisUserAgent") + "\r\n";
    private static final String CACHE_HEADERS = "Cache-Control: no-cache\r\nPragma: no-cache\r\n";
    private static final String CHUNKED_HEADER = HTTPConstants.HEADER_TRANSFER_ENCODING + ": " + HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED + "\r\n";
    private static final String HEADER_CONTENT_TYPE_LC = "Content-Type".toLowerCase();
    private static final String HEADER_LOCATION_LC = "Location".toLowerCase();
    private static final String HEADER_CONTENT_LOCATION_LC = "Content-Location".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH_LC = "Content-Length".toLowerCase();
    private static final String HEADER_TRANSFER_ENCODING_LC = HTTPConstants.HEADER_TRANSFER_ENCODING.toLowerCase();
    URL targetURL;

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "HTTPSender::invoke"));
        }
        SocketHolder socketHolder = new SocketHolder(null);
        try {
            BooleanHolder booleanHolder = new BooleanHolder(false);
            StringBuffer stringBuffer = new StringBuffer();
            this.targetURL = new URL(messageContext.getStrProp("transport.url"));
            String string = this.targetURL.getHost();
            int n = this.targetURL.getPort();
            InputStream inputStream = this.writeToSocket(socketHolder, messageContext, this.targetURL, stringBuffer, string, n, messageContext.getTimeout(), booleanHolder);
            Hashtable hashtable = new Hashtable();
            inputStream = this.readHeadersFromSocket(socketHolder, messageContext, inputStream, hashtable);
            this.readFromSocket(socketHolder, messageContext, inputStream, hashtable);
        }
        catch (Exception exception) {
            log.debug(exception);
            try {
                if (socketHolder.getSocket() != null) {
                    socketHolder.getSocket().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw AxisFault.makeFault(exception);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "HTTPDispatchHandler::invoke"));
        }
    }

    protected void getSocket(SocketHolder socketHolder, MessageContext messageContext, String string, String string2, int n, int n2, StringBuffer stringBuffer, BooleanHolder booleanHolder) throws Exception {
        SocketFactory socketFactory;
        Hashtable<String, String> hashtable = this.getOptions();
        if (n2 > 0) {
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            hashtable.put(DefaultSocketFactory.CONNECT_TIMEOUT, Integer.toString(n2));
        }
        if ((socketFactory = SocketFactoryFactory.getFactory(string, hashtable)) == null) {
            throw new IOException(Messages.getMessage("noSocketFactory", string));
        }
        Socket socket = socketFactory.create(string2, n, stringBuffer, booleanHolder);
        if (n2 > 0) {
            socket.setSoTimeout(n2);
        }
        socketHolder.setSocket(socket);
    }

    /*
     * WARNING - void declaration
     */
    private InputStream writeToSocket(SocketHolder socketHolder, MessageContext messageContext, URL uRL, StringBuffer stringBuffer, String string, int n, int n2, BooleanHolder booleanHolder) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Hashtable hashtable;
        CharSequence charSequence;
        String string2;
        CharSequence charSequence2 = messageContext.getUsername();
        String string3 = messageContext.getPassword();
        String string4 = string2 = messageContext.useSOAPAction() ? messageContext.getSOAPActionURI() : "";
        if (string2 == null) {
            string2 = "";
        }
        if (charSequence2 == null && uRL.getUserInfo() != null) {
            charSequence = uRL.getUserInfo();
            int n3 = ((String)charSequence).indexOf(58);
            if (n3 >= 0 && n3 + 1 < ((String)charSequence).length()) {
                charSequence2 = ((String)charSequence).substring(0, n3);
                string3 = ((String)charSequence).substring(n3 + 1);
            } else {
                charSequence2 = charSequence;
            }
        }
        if (charSequence2 != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append((String)charSequence2).append(":").append(string3 == null ? "" : string3);
            stringBuffer.append("Authorization").append(": Basic ").append(Base64.encode(((StringBuffer)charSequence).toString().getBytes())).append("\r\n");
        }
        if (messageContext.getMaintainSession()) {
            this.fillHeaders(messageContext, "Cookie", stringBuffer);
            this.fillHeaders(messageContext, "Cookie2", stringBuffer);
        }
        charSequence = new StringBuffer();
        String string5 = null;
        boolean bl = true;
        Message message = messageContext.getRequestMessage();
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        String string6 = null;
        String string7 = messageContext.getStrProp("axis.transport.version");
        if (null == string7) {
            string7 = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((string7 = string7.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            bl2 = false;
        }
        if ((hashtable = (Hashtable)messageContext.getProperty("HTTP-Request-Headers")) != null) {
            if (null == stringBuffer) {
                stringBuffer = new StringBuffer(1024);
            }
            for (Map.Entry object42 : hashtable.entrySet()) {
                object3 = object42.getKey();
                if (null == object3) continue;
                object2 = object3.toString().trim();
                if (((String)object2).equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (bl2 || null == (object = object42.getValue().toString()) || !((String)object).trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    bl3 = true;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("Connection")) {
                    if (bl2 || !((String)(object = object42.getValue().toString())).trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    string6 = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                if (!bl2 && ((String)object2).equalsIgnoreCase("Expect") && null != (object = object42.getValue().toString()) && ((String)object).trim().equalsIgnoreCase("100-continue")) {
                    bl4 = true;
                }
                stringBuffer.append((String)object2).append(": ").append(object42.getValue()).append("\r\n");
            }
        }
        if (!bl2) {
            string6 = HTTPConstants.HEADER_CONNECTION_CLOSE;
        }
        ((StringBuffer)charSequence).append(" ");
        ((StringBuffer)charSequence).append(bl2 ? "HTTP/1.0" : "HTTP/1.1").append("\r\n");
        MimeHeaders mimeHeaders = message.getMimeHeaders();
        if (bl) {
            void var23_27;
            object3 = mimeHeaders.getHeader("Content-Type");
            if (object3 != null && ((K)object3).length > 0) {
                String string8 = mimeHeaders.getHeader("Content-Type")[0];
            } else {
                String string9 = message.getContentType(messageContext.getSOAPConstants());
            }
            if (var23_27 == null || var23_27.equals("")) {
                throw new Exception(Messages.getMessage("missingContentType"));
            }
            ((StringBuffer)charSequence).append("Content-Type").append(": ").append((String)var23_27).append("\r\n");
        }
        ((StringBuffer)charSequence).append(ACCEPT_HEADERS).append("Host").append(": ").append(string).append(n == -1 ? "" : ":" + n).append("\r\n").append(CACHE_HEADERS).append("SOAPAction").append(": \"").append(string2).append("\"\r\n");
        if (bl) {
            if (!bl3) {
                ((StringBuffer)charSequence).append("Content-Length").append(": ").append(message.getContentLength()).append("\r\n");
            } else {
                ((StringBuffer)charSequence).append(CHUNKED_HEADER);
            }
        }
        if (mimeHeaders != null) {
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                object3 = (MimeHeader)iterator.next();
                object2 = ((MimeHeader)object3).getName();
                if (((String)object2).equals("Content-Type") || ((String)object2).equals("SOAPAction")) continue;
                ((StringBuffer)charSequence).append(((MimeHeader)object3).getName()).append(": ").append(((MimeHeader)object3).getValue()).append("\r\n");
            }
        }
        if (null != string6) {
            ((StringBuffer)charSequence).append("Connection");
            ((StringBuffer)charSequence).append(": ");
            ((StringBuffer)charSequence).append(string6);
            ((StringBuffer)charSequence).append("\r\n");
        }
        this.getSocket(socketHolder, messageContext, this.targetURL.getProtocol(), string, n, n2, stringBuffer, booleanHolder);
        if (null != stringBuffer) {
            ((StringBuffer)charSequence).append(stringBuffer.toString());
        }
        ((StringBuffer)charSequence).append("\r\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            string5 = messageContext.getStrProp("soap12.webmethod");
        }
        if (string5 == null) {
            string5 = "POST";
        } else {
            bl = string5.equals("POST");
        }
        stringBuffer2.append(string5).append(" ");
        if (booleanHolder.value) {
            stringBuffer2.append(uRL.toExternalForm());
        } else {
            stringBuffer2.append(uRL.getFile() == null || uRL.getFile().equals("") ? "/" : uRL.getFile());
        }
        stringBuffer2.append(((StringBuffer)charSequence).toString());
        object3 = socketHolder.getSocket().getOutputStream();
        if (!bl) {
            ((OutputStream)object3).write(stringBuffer2.toString().getBytes("iso-8859-1"));
            ((OutputStream)object3).flush();
            return null;
        }
        object2 = null;
        if (bl3 || bl4) {
            ((OutputStream)object3).write(stringBuffer2.toString().getBytes("iso-8859-1"));
        }
        if (bl4) {
            ((OutputStream)object3).flush();
            object = new Hashtable();
            object2 = this.readHeadersFromSocket(socketHolder, messageContext, null, (Hashtable)object);
            int n3 = -1;
            Integer n4 = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
            if (null != n4) {
                n3 = n4;
            }
            if (100 == n3) {
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            } else {
                String string10 = (String)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                AxisFault axisFault = new AxisFault("HTTP", "(" + n3 + ")" + string10, null, null);
                axisFault.setFaultDetailString(Messages.getMessage("return01", "" + n3, ""));
                throw axisFault;
            }
        }
        object = null;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("xmlSent00"));
            log.debug("---------------------------------------------------");
            object = new ByteArrayOutputStream();
        }
        if (bl3) {
            ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream((OutputStream)object3);
            object3 = new BufferedOutputStream(chunkedOutputStream, 8192);
            try {
                if (object != null) {
                    object3 = new TeeOutputStream((OutputStream)object3, (OutputStream)object);
                }
                message.writeTo((OutputStream)object3);
            }
            catch (SOAPException sOAPException) {
                log.error(Messages.getMessage("exception00"), sOAPException);
            }
            ((OutputStream)object3).flush();
            chunkedOutputStream.eos();
        } else {
            object3 = new BufferedOutputStream((OutputStream)object3, 8192);
            try {
                if (!bl4) {
                    ((OutputStream)object3).write(stringBuffer2.toString().getBytes("iso-8859-1"));
                }
                if (object != null) {
                    object3 = new TeeOutputStream((OutputStream)object3, (OutputStream)object);
                }
                message.writeTo((OutputStream)object3);
            }
            catch (SOAPException sOAPException) {
                log.error(Messages.getMessage("exception00"), sOAPException);
            }
            ((OutputStream)object3).flush();
        }
        if (log.isDebugEnabled()) {
            log.debug(stringBuffer2 + new String(((ByteArrayOutputStream)object).toByteArray()));
        }
        return object2;
    }

    private void fillHeaders(MessageContext messageContext, String string, StringBuffer stringBuffer) {
        Object object = messageContext.getProperty(string);
        if (object != null) {
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addCookie(stringBuffer, string, stringArray[i]);
                }
            } else {
                this.addCookie(stringBuffer, string, (String)object);
            }
        }
    }

    private void addCookie(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string).append(": ").append(string2).append("\r\n");
    }

    private InputStream readHeadersFromSocket(SocketHolder socketHolder, MessageContext messageContext, InputStream inputStream, Hashtable hashtable) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        if (null == inputStream) {
            inputStream = new BufferedInputStream(socketHolder.getSocket().getInputStream());
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4097);
        while (true) {
            String string;
            String string2;
            if (!bl) {
                n = (byte)inputStream.read();
            }
            if (n == -1) break;
            bl = false;
            if (n != 13 && n != 10) {
                if (n == 58 && n3 == -1) {
                    n3 = n2;
                }
                ++n2;
                byteArrayOutputStream.write(n);
                continue;
            }
            if (n == 13) continue;
            if (n2 == 0) break;
            n = (byte)inputStream.read();
            bl = true;
            if (n == 32 || n == 9) continue;
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            if (n3 != -1) {
                string2 = new String(byArray, 0, n3, "iso-8859-1");
                string = new String(byArray, n3 + 1, n2 - 1 - n3, "iso-8859-1");
                n3 = -1;
            } else {
                string2 = new String(byArray, 0, n2, "iso-8859-1");
                string = "";
            }
            if (log.isDebugEnabled()) {
                log.debug(string2 + string);
            }
            if (messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                int n5 = string2.indexOf(32) + 1;
                String string3 = string2.substring(n5).trim();
                int n6 = string3.indexOf(32);
                if (n6 != -1) {
                    string3 = string3.substring(0, n6);
                }
                n4 = Integer.parseInt(string3);
                messageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(n4));
                messageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, string2.substring(n5 + n6 + 1));
            } else if (messageContext.getMaintainSession()) {
                String string4 = string2.toLowerCase();
                if (string4.equalsIgnoreCase("Set-Cookie")) {
                    this.handleCookie("Cookie", null, string, messageContext);
                } else if (string4.equalsIgnoreCase("Set-Cookie2")) {
                    this.handleCookie("Cookie2", null, string, messageContext);
                } else {
                    hashtable.put(string2.toLowerCase(), string);
                }
            } else {
                hashtable.put(string2.toLowerCase(), string);
            }
            n2 = 0;
        }
        return inputStream;
    }

    private InputStream readFromSocket(SocketHolder socketHolder, MessageContext messageContext, InputStream inputStream, Hashtable hashtable) throws IOException {
        String string;
        String string2;
        Message message = null;
        Integer n = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        string2 = null == (string2 = (String)hashtable.get(HEADER_CONTENT_TYPE_LC)) ? null : string2.trim();
        String string3 = (String)hashtable.get(HEADER_LOCATION_LC);
        String string4 = string3 = null == string3 ? null : string3.trim();
        if (n2 > 199 && n2 < 300) {
            if (n2 == 202) {
                return inputStream;
            }
        } else if (messageContext.getSOAPConstants() != SOAPConstants.SOAP12_CONSTANTS && (string2 == null || string2.startsWith("text/html") || n2 <= 499 || n2 >= 600)) {
            byte by;
            if (string3 != null && (n2 == 302 || n2 == 307)) {
                inputStream.close();
                socketHolder.getSocket().close();
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                messageContext.setProperty("transport.url", string3);
                this.invoke(messageContext);
                return inputStream;
            }
            if (n2 == 100) {
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                this.readHeadersFromSocket(socketHolder, messageContext, inputStream, hashtable);
                return this.readFromSocket(socketHolder, messageContext, inputStream, hashtable);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4097);
            while (-1 != (by = (byte)inputStream.read())) {
                byteArrayOutputStream.write(by);
            }
            String string5 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            AxisFault axisFault = new AxisFault("HTTP", "(" + n2 + ")" + string5, null, null);
            axisFault.setFaultDetailString(Messages.getMessage("return01", "" + n2, byteArrayOutputStream.toString()));
            axisFault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, Integer.toString(n2));
            throw axisFault;
        }
        string = null == (string = (String)hashtable.get(HEADER_CONTENT_LOCATION_LC)) ? null : string.trim();
        String string6 = (String)hashtable.get(HEADER_CONTENT_LENGTH_LC);
        string6 = null == string6 ? null : string6.trim();
        String string7 = (String)hashtable.get(HEADER_TRANSFER_ENCODING_LC);
        if (null != string7 && (string7 = string7.trim().toLowerCase()).equals(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
            inputStream = new ChunkedInputStream(inputStream);
        }
        message = new Message(new SocketInputStream(inputStream, socketHolder.getSocket()), false, string2, string);
        MimeHeaders mimeHeaders = message.getMimeHeaders();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string8 = (String)enumeration.nextElement();
            mimeHeaders.addHeader(string8, ((String)hashtable.get(string8)).trim());
        }
        message.setMessageType("response");
        messageContext.setResponseMessage(message);
        if (log.isDebugEnabled()) {
            if (null == string6) {
                log.debug("\n" + Messages.getMessage("no00", "Content-Length"));
            }
            log.debug("\n" + Messages.getMessage("xmlRecd00"));
            log.debug("-----------------------------------------------");
            log.debug(message.getSOAPEnvelope().toString());
        }
        return inputStream;
    }

    public void handleCookie(String string, String string2, String string3, MessageContext messageContext) {
        int n = (string3 = this.cleanupCookie(string3)).indexOf("=");
        String string4 = n != -1 ? string3.substring(0, n) : string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = messageContext.getProperty(string);
        boolean bl = false;
        if (object != null) {
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string5 = stringArray[i];
                    if (string4 != null && string5.indexOf(string4) == 0) {
                        string5 = string3;
                        bl = true;
                    }
                    arrayList.add(string5);
                }
            } else {
                String string6 = (String)object;
                if (string4 != null && string6.indexOf(string4) == 0) {
                    string6 = string3;
                    bl = true;
                }
                arrayList.add(string6);
            }
        }
        if (!bl) {
            arrayList.add(string3);
        }
        if (arrayList.size() == 1) {
            messageContext.setProperty(string, arrayList.get(0));
        } else if (arrayList.size() > 1) {
            messageContext.setProperty(string, arrayList.toArray(new String[arrayList.size()]));
        }
    }

    private String cleanupCookie(String string) {
        int n = (string = string.trim()).indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

