/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.collections.LRUMap;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.threadpool.ThreadPool;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.management.ServiceAdmin;
import org.apache.axis.server.AxisServer;
import org.apache.axis.session.Session;
import org.apache.axis.session.SimpleSession;
import org.apache.axis.transport.http.SimpleAxisWorker;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NetworkUtils;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;

public class SimpleAxisServer
implements Runnable {
    protected static Log log = LogFactory.getLog(SimpleAxisServer.class.getName());
    private Map sessions;
    private int maxSessions;
    public static final int MAX_SESSIONS_DEFAULT = 100;
    private static ThreadPool pool;
    private static boolean doThreads;
    private static boolean doSessions;
    public static int sessionIndex;
    private static AxisServer myAxisServer;
    private EngineConfiguration myConfig = null;
    private boolean stopped = false;
    private ServerSocket serverSocket;

    public static ThreadPool getPool() {
        return pool;
    }

    public SimpleAxisServer() {
        this(100);
    }

    public SimpleAxisServer(int n) {
        this(n, 100);
    }

    public SimpleAxisServer(int n, int n2) {
        this.maxSessions = n2;
        this.sessions = new LRUMap(n2);
        pool = new ThreadPool(n);
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int n) {
        this.maxSessions = n;
        ((LRUMap)this.sessions).setMaximumSize(n);
    }

    protected boolean isSessionUsed() {
        return doSessions;
    }

    public void setDoThreads(boolean bl) {
        doThreads = bl;
    }

    public boolean getDoThreads() {
        return doThreads;
    }

    public EngineConfiguration getMyConfig() {
        return this.myConfig;
    }

    public void setMyConfig(EngineConfiguration engineConfiguration) {
        this.myConfig = engineConfiguration;
    }

    protected Session createSession(String string) {
        Session session = null;
        if (this.sessions.containsKey(string)) {
            session = (Session)this.sessions.get(string);
        } else {
            session = new SimpleSession();
            this.sessions.put(string, session);
        }
        return session;
    }

    public synchronized AxisServer getAxisServer() {
        if (myAxisServer == null) {
            if (this.myConfig == null) {
                this.myConfig = EngineConfigurationFactoryFinder.newFactory().getServerEngineConfig();
            }
            myAxisServer = new AxisServer(this.myConfig);
            ServiceAdmin.setEngine(myAxisServer, NetworkUtils.getLocalHostname() + "@" + this.serverSocket.getLocalPort());
        }
        return myAxisServer;
    }

    public void run() {
        log.info(Messages.getMessage("start01", "SimpleAxisServer", new Integer(this.getServerSocket().getLocalPort()).toString(), this.getCurrentDirectory()));
        while (!this.stopped) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                log.debug(Messages.getMessage("exception00"), exception);
                break;
            }
            if (socket == null) continue;
            SimpleAxisWorker simpleAxisWorker = new SimpleAxisWorker(this, socket);
            if (doThreads) {
                pool.addWorker(simpleAxisWorker);
                continue;
            }
            simpleAxisWorker.run();
        }
        log.info(Messages.getMessage("quit00", "SimpleAxisServer"));
    }

    private String getCurrentDirectory() {
        return System.getProperty("user.dir");
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void start(boolean bl) throws Exception {
        this.stopped = false;
        if (doThreads) {
            Thread thread = new Thread(this);
            thread.setDaemon(bl);
            thread.start();
        } else {
            this.run();
        }
    }

    public void start() throws Exception {
        this.start(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            log.info(Messages.getMessage("exception00"), iOException);
        }
        finally {
            this.serverSocket = null;
        }
        log.info(Messages.getMessage("quit00", "SimpleAxisServer"));
        pool.shutdown();
    }

    public static void main(String[] stringArray) {
        String string;
        Options options = null;
        try {
            options = new Options(stringArray);
        }
        catch (MalformedURLException malformedURLException) {
            log.error(Messages.getMessage("malformedURLException00"), malformedURLException);
            return;
        }
        String string2 = options.isValueSet('t');
        if (string2 == null) {
            string2 = "100";
        }
        if ((string = options.isValueSet('m')) == null) {
            string = "100";
        }
        SimpleAxisServer simpleAxisServer = new SimpleAxisServer(Integer.parseInt(string2), Integer.parseInt(string));
        try {
            doThreads = options.isFlagSet('t') > 0;
            int n = options.getPort();
            ServerSocket serverSocket = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    serverSocket = new ServerSocket(n);
                    break;
                }
                catch (BindException bindException) {
                    log.debug(Messages.getMessage("exception00"), bindException);
                    if (i >= 4) {
                        throw new Exception(Messages.getMessage("unableToStartServer00", Integer.toString(n)));
                    }
                    Thread.sleep(3000L);
                    continue;
                }
            }
            simpleAxisServer.setServerSocket(serverSocket);
            simpleAxisServer.start();
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            return;
        }
    }

    static {
        doThreads = true;
        doSessions = true;
        sessionIndex = 0;
        myAxisServer = null;
    }
}

