/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.transport.http.NonBlockingBufferedInputStream;
import org.apache.axis.transport.http.SimpleAxisServer;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NetworkUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class SimpleAxisWorker
implements Runnable {
    protected static Log log;
    private SimpleAxisServer server;
    private Socket socket;
    private static String transportName;
    private static byte[] OK;
    private static byte[] NOCONTENT;
    private static byte[] UNAUTH;
    private static byte[] SENDER;
    private static byte[] ISE;
    private static byte[] HTTP;
    private static byte[] XML_MIME_STUFF;
    private static byte[] HTML_MIME_STUFF;
    private static byte[] SEPARATOR;
    private static final byte[] toLower;
    private static final int BUFSIZ = 4096;
    private static final byte[] lenHeader;
    private static final int lenLen;
    private static final byte[] typeHeader;
    private static final int typeLen;
    private static final byte[] locationHeader;
    private static final int locationLen;
    private static final byte[] actionHeader;
    private static final int actionLen;
    private static final byte[] cookieHeader;
    private static final int cookieLen;
    private static final byte[] cookie2Header;
    private static final int cookie2Len;
    private static final byte[] authHeader;
    private static final int authLen;
    private static final byte[] getHeader;
    private static final byte[] postHeader;
    private static final byte[] headerEnder;
    private static final byte[] basicAuth;

    public SimpleAxisWorker(SimpleAxisServer simpleAxisServer, Socket socket) {
        this.server = simpleAxisServer;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.execute();
        }
        finally {
            SimpleAxisServer.getPool().workerDone(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        block59: {
            block58: {
                var1_1 = new byte[4096];
                var2_2 = this.server.getAxisServer();
                var3_3 = new MessageContext(var2_2);
                var4_4 = null;
                var5_5 = new NonBlockingBufferedInputStream();
                var6_6 = new StringBuffer();
                var7_7 = new StringBuffer();
                var8_8 = new StringBuffer();
                var9_9 = new StringBuffer();
                var10_10 = new StringBuffer();
                var11_11 = new StringBuffer();
                var12_12 = new StringBuffer();
                var13_13 = new StringBuffer();
                var14_14 = null;
                var3_3.setTransportName(SimpleAxisWorker.transportName);
                var14_14 = null;
                try {
                    block57: {
                        var15_15 = SimpleAxisWorker.OK;
                        var16_20 = false;
                        var17_21 = null;
                        var18_22 = null;
                        try {
                            if (this.server.isSessionUsed()) {
                                var9_9.delete(0, var9_9.length());
                                var10_10.delete(0, var10_10.length());
                            }
                            var11_11.delete(0, var11_11.length());
                            var5_5.setInputStream(this.socket.getInputStream());
                            var19_23 = new MimeHeaders();
                            var20_25 = this.parseHeaders(var5_5, var1_1, var12_12, var13_13, var6_6, var7_7, var8_8, var9_9, var10_10, var11_11, (MimeHeaders)var19_23);
                            var5_5.setContentLength(var20_25);
                            var21_28 = var8_8.toString().indexOf(63);
                            if (var21_28 != -1) {
                                var22_34 = var8_8.substring(var21_28 + 1);
                                var8_8.setLength(var21_28);
                                SimpleAxisWorker.log.debug(Messages.getMessage("filename00", var8_8.toString()));
                                SimpleAxisWorker.log.debug(Messages.getMessage("params00", (String)var22_34));
                                if ("wsdl".equalsIgnoreCase((String)var22_34)) {
                                    var16_20 = true;
                                }
                                if (var22_34.startsWith("method=")) {
                                    var18_22 = var22_34.substring(7);
                                }
                            }
                            var3_3.setProperty("realpath", var8_8.toString());
                            var3_3.setProperty("path", var8_8.toString());
                            var3_3.setProperty("jws.classDir", "jwsClasses");
                            var3_3.setProperty("home.dir", ".");
                            var22_34 = "http://" + SimpleAxisWorker.getLocalHost() + ":" + this.server.getServerSocket().getLocalPort() + "/" + var8_8.toString();
                            var3_3.setProperty("transport.url", var22_34);
                            var23_35 = var8_8.toString();
                            if (var23_35.startsWith("axis/services/")) {
                                var24_36 = var23_35.substring(14);
                                var25_37 = var24_36.indexOf(47);
                                if (var25_37 > -1) {
                                    var3_3.setProperty("objectID", var24_36.substring(var25_37 + 1));
                                    var24_36 = var24_36.substring(0, var25_37);
                                }
                                var3_3.setTargetService((String)var24_36);
                            }
                            if (var11_11.length() > 0) {
                                var24_36 = Base64.decode(var11_11.toString());
                                var25_38 = new StringBuffer();
                                var26_43 = new StringBuffer();
                                var27_45 = var25_38;
                                for (var28_46 = 0; var28_46 < ((Object)var24_36).length; ++var28_46) {
                                    if ((char)(var24_36[var28_46] & 127) == ':') {
                                        var27_45 = var26_43;
                                        continue;
                                    }
                                    var27_45.append((char)(var24_36[var28_46] & 127));
                                }
                                if (SimpleAxisWorker.log.isDebugEnabled()) {
                                    SimpleAxisWorker.log.debug(Messages.getMessage("user00", var25_38.toString()));
                                }
                                var3_3.setUsername(var25_38.toString());
                                var3_3.setPassword(var26_43.toString());
                            }
                            if (!var7_7.toString().equals("GET")) ** GOTO lbl-1000
                            var24_36 = this.socket.getOutputStream();
                            var24_36.write(SimpleAxisWorker.HTTP);
                            if (var8_8.length() == 0) {
                                var24_36.write("301 Redirect\nLocation: /axis/\n\n".getBytes());
                                var24_36.flush();
                                break block57;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Exception var19_24) {
                            if (var19_24 instanceof AxisFault) {
                                var20_26 = (AxisFault)var19_24;
                                SimpleAxisWorker.log.debug(Messages.getMessage("serverFault00"), var20_26);
                                var21_29 = var20_26.getFaultCode();
                                var15_15 = Constants.FAULT_SOAP12_SENDER.equals(var21_29) ? SimpleAxisWorker.SENDER : ("Server.Unauthorized".equals(var20_26.getFaultCode().getLocalPart()) ? SimpleAxisWorker.UNAUTH : SimpleAxisWorker.ISE);
                            } else {
                                var15_15 = SimpleAxisWorker.ISE;
                                var20_26 = AxisFault.makeFault(var19_24);
                            }
                            var14_14 = var3_3.getResponseMessage();
                            if (var14_14 == null) {
                                var14_14 = new Message(var20_26);
                                var14_14.setMessageContext(var3_3);
                                break block58;
                            } else {
                                try {
                                    var21_30 = var14_14.getSOAPEnvelope();
                                    var21_30.clearBody();
                                    var21_30.addBodyElement(new SOAPFault((AxisFault)var19_24));
                                }
                                catch (AxisFault var21_31) {
                                    // empty catch block
                                }
                            }
                            break block58;
                        }
                    }
                    try {
                        if (this.socket == null) return;
                        this.socket.close();
                        return;
                    }
                    catch (Exception var25_39) {
                        // empty catch block
                    }
                    return;
                }
                catch (Exception var15_17) {
                    SimpleAxisWorker.log.info(Messages.getMessage("exception00"), var15_17);
                    break block59;
                }
lbl-1000:
                // 1 sources

                {
                    block60: {
                        var24_36.write(var15_15);
                        if (var18_22 == null) break block60;
                        var25_40 = "<" + var18_22 + ">" + "</" + var18_22 + ">";
                        var26_43 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\"><SOAP-ENV:Body>" + (String)var25_40 + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
                        var27_45 = new ByteArrayInputStream(var26_43.getBytes());
                        var4_4 = new Message(var27_45);
                        ** GOTO lbl194
                    }
                    if (!var16_20) ** GOTO lbl-1000
                    var2_2.generateWSDL(var3_3);
                    var25_40 = (Document)var3_3.getProperty("WSDL");
                    if (var25_40 == null) ** GOTO lbl194
                    XMLUtils.normalize(var25_40.getDocumentElement());
                    var26_43 = XMLUtils.PrettyDocumentToString((Document)var25_40);
                    var27_45 = var26_43.getBytes();
                    var24_36.write(SimpleAxisWorker.XML_MIME_STUFF);
                    this.putInt(var1_1, (OutputStream)var24_36, ((Object)var27_45).length);
                    var24_36.write(SimpleAxisWorker.SEPARATOR);
                    var24_36.write((byte[])var27_45);
                    var24_36.flush();
                }
                try {
                    if (this.socket == null) return;
                    this.socket.close();
                    return;
                }
                catch (Exception var28_47) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    var25_41 = new StringBuffer();
                    var25_41.append("<h2>And now... Some Services</h2>\n");
                    var26_43 = var2_2.getConfig().getDeployedServices();
                    var25_41.append("<ul>\n");
                    while (var26_43.hasNext()) {
                        var27_45 = (ServiceDesc)var26_43.next();
                        var25_41.append("<li>\n");
                        var25_41.append(var27_45.getName());
                        var25_41.append(" <a href=\"services/");
                        var25_41.append(var27_45.getName());
                        var25_41.append("?wsdl\"><i>(wsdl)</i></a></li>\n");
                        var28_48 = var27_45.getOperations();
                        if (var28_48.isEmpty()) continue;
                        var25_41.append("<ul>\n");
                        for (OperationDesc var30_51 : var28_48) {
                            var25_41.append("<li>" + var30_51.getName());
                        }
                        var25_41.append("</ul>\n");
                    }
                    var25_41.append("</ul>\n");
                    var27_45 = var25_41.toString().getBytes();
                    var24_36.write(SimpleAxisWorker.HTML_MIME_STUFF);
                    this.putInt(var1_1, (OutputStream)var24_36, ((Object)var27_45).length);
                    var24_36.write(SimpleAxisWorker.SEPARATOR);
                    var24_36.write((byte[])var27_45);
                    var24_36.flush();
                }
                try {
                    if (this.socket == null) return;
                    this.socket.close();
                    return;
                }
                catch (Exception var28_49) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    var24_36 = var6_6.toString();
                    if (var24_36 != null) {
                        var3_3.setUseSOAPAction(true);
                        var3_3.setSOAPActionURI((String)var24_36);
                    }
                    var4_4 = new Message(var5_5, false, var12_12.toString(), var13_13.toString());
lbl194:
                    // 3 sources

                    var24_36 = var4_4.getMimeHeaders();
                    var25_42 = var19_23.getAllHeaders();
                    while (var25_42.hasNext()) {
                        var26_43 = (MimeHeader)var25_42.next();
                        var24_36.addHeader(var26_43.getName(), var26_43.getValue());
                    }
                    var3_3.setRequestMessage(var4_4);
                    var25_42 = (String)var4_4.getProperty("javax.xml.soap.character-set-encoding");
                    if (var25_42 != null) {
                        var3_3.setProperty("javax.xml.soap.character-set-encoding", var25_42);
                    }
                    if (this.server.isSessionUsed()) {
                        if (var9_9.length() > 0) {
                            var17_21 = var9_9.toString().trim();
                        } else if (var10_10.length() > 0) {
                            var17_21 = var10_10.toString().trim();
                        }
                        if (var17_21 == null) {
                            var26_44 = SimpleAxisServer.sessionIndex++;
                            var17_21 = "" + var26_44;
                        }
                        var3_3.setSession(this.server.createSession(var17_21));
                    }
                    var2_2.invoke(var3_3);
                    var14_14 = var3_3.getResponseMessage();
                    if (var14_14 != null) break block58;
                    var15_15 = SimpleAxisWorker.NOCONTENT;
                }
            }
            var19_23 = (String)var3_3.getProperty("javax.xml.soap.character-set-encoding");
            if (var19_23 != null && var14_14 != null) {
                var14_14.setProperty("javax.xml.soap.character-set-encoding", var19_23);
            }
            var20_27 = this.socket.getOutputStream();
            var20_27.write(SimpleAxisWorker.HTTP);
            var20_27.write(var15_15);
            if (var14_14 != null) {
                if (this.server.isSessionUsed() && null != var17_21 && 0 != var17_21.trim().length()) {
                    var21_32 = new StringBuffer();
                    var21_32.append("\r\nSet-Cookie: ").append(var17_21).append("\r\nSet-Cookie2: ").append(var17_21);
                    var20_27.write(var21_32.toString().getBytes());
                }
                var20_27.write(("\r\nContent-Type: " + var14_14.getContentType(var3_3.getSOAPConstants())).getBytes());
                var21_33 = var14_14.getMimeHeaders().getAllHeaders();
                while (var21_33.hasNext()) {
                    var22_34 = (MimeHeader)var21_33.next();
                    var20_27.write(13);
                    var20_27.write(10);
                    var20_27.write(var22_34.getName().getBytes());
                    var20_27.write(SimpleAxisWorker.headerEnder);
                    var20_27.write(var22_34.getValue().getBytes());
                }
                var20_27.write(SimpleAxisWorker.SEPARATOR);
                var14_14.writeTo(var20_27);
            }
            var20_27.flush();
        }
        if (var3_3.getProperty("quit.requested") == null) return;
        try {
            this.server.stop();
            return;
        }
        catch (Exception var15_19) {
            // empty catch block
        }
    }

    protected void invokeMethodFromGet(String string, String string2) throws Exception {
    }

    private int parseHeaders(NonBlockingBufferedInputStream nonBlockingBufferedInputStream, byte[] byArray, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4, StringBuffer stringBuffer5, StringBuffer stringBuffer6, StringBuffer stringBuffer7, StringBuffer stringBuffer8, MimeHeaders mimeHeaders) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.readLine(nonBlockingBufferedInputStream, byArray, 0, byArray.length);
        if (n4 < 0) {
            throw new IOException(Messages.getMessage("unexpectedEOS00"));
        }
        stringBuffer4.delete(0, stringBuffer4.length());
        stringBuffer5.delete(0, stringBuffer5.length());
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer2.delete(0, stringBuffer2.length());
        if (byArray[0] == getHeader[0]) {
            char c;
            stringBuffer4.append("GET");
            for (int i = 0; i < n4 - 5 && (c = (char)(byArray[i + 5] & 0x7F)) != ' '; ++i) {
                stringBuffer5.append(c);
            }
            log.debug(Messages.getMessage("filename01", "SimpleAxisServer", stringBuffer5.toString()));
            return 0;
        }
        if (byArray[0] == postHeader[0]) {
            stringBuffer4.append("POST");
            for (n2 = 0; n2 < n4 - 6 && (n = (int)(byArray[n2 + 6] & 0x7F)) != 32; ++n2) {
                stringBuffer5.append((char)n);
            }
            log.debug(Messages.getMessage("filename01", "SimpleAxisServer", stringBuffer5.toString()));
        } else {
            throw new IOException(Messages.getMessage("badRequest00"));
        }
        while ((n4 = this.readLine(nonBlockingBufferedInputStream, byArray, 0, byArray.length)) > 0 && (n4 > 2 || byArray[0] != 10 && byArray[0] != 13 || n3 <= 0)) {
            for (n2 = 0; n2 < n4 && toLower[byArray[n2]] != headerEnder[0]; ++n2) {
            }
            n = (n2 += 2) - 1;
            if (n2 == lenLen && this.matches(byArray, lenHeader)) {
                while (++n < n4 && byArray[n] >= 48 && byArray[n] <= 57) {
                    n3 = n3 * 10 + (byArray[n] - 48);
                }
                mimeHeaders.addHeader("Content-Length", String.valueOf(n3));
                continue;
            }
            if (n2 == actionLen && this.matches(byArray, actionHeader)) {
                stringBuffer3.delete(0, stringBuffer3.length());
                ++n;
                while (++n < n4 && byArray[n] != 34) {
                    stringBuffer3.append((char)(byArray[n] & 0x7F));
                }
                mimeHeaders.addHeader("SOAPAction", "\"" + stringBuffer3.toString() + "\"");
                continue;
            }
            if (this.server.isSessionUsed() && n2 == cookieLen && this.matches(byArray, cookieHeader)) {
                while (++n < n4 && byArray[n] != 59 && byArray[n] != 13 && byArray[n] != 10) {
                    stringBuffer6.append((char)(byArray[n] & 0x7F));
                }
                mimeHeaders.addHeader("Set-Cookie", stringBuffer6.toString());
                continue;
            }
            if (this.server.isSessionUsed() && n2 == cookie2Len && this.matches(byArray, cookie2Header)) {
                while (++n < n4 && byArray[n] != 59 && byArray[n] != 13 && byArray[n] != 10) {
                    stringBuffer7.append((char)(byArray[n] & 0x7F));
                }
                mimeHeaders.addHeader("Set-Cookie2", stringBuffer6.toString());
                continue;
            }
            if (n2 == authLen && this.matches(byArray, authHeader)) {
                if (this.matches(byArray, n2, basicAuth)) {
                    n += basicAuth.length;
                    while (++n < n4 && byArray[n] != 13 && byArray[n] != 10) {
                        if (byArray[n] == 32) continue;
                        stringBuffer8.append((char)(byArray[n] & 0x7F));
                    }
                    mimeHeaders.addHeader("Authorization", new String(basicAuth) + stringBuffer8.toString());
                    continue;
                }
                throw new IOException(Messages.getMessage("badAuth00"));
            }
            if (n2 == locationLen && this.matches(byArray, locationHeader)) {
                while (++n < n4 && byArray[n] != 13 && byArray[n] != 10) {
                    if (byArray[n] == 32) continue;
                    stringBuffer2.append((char)(byArray[n] & 0x7F));
                }
                mimeHeaders.addHeader("Content-Location", stringBuffer2.toString());
                continue;
            }
            if (n2 == typeLen && this.matches(byArray, typeHeader)) {
                while (++n < n4 && byArray[n] != 13 && byArray[n] != 10) {
                    if (byArray[n] == 32) continue;
                    stringBuffer.append((char)(byArray[n] & 0x7F));
                }
                mimeHeaders.addHeader("Content-Type", stringBuffer2.toString());
                continue;
            }
            String string = new String(byArray, 0, n2 - 2);
            StringBuffer stringBuffer9 = new StringBuffer();
            while (++n < n4 && byArray[n] != 13 && byArray[n] != 10) {
                if (byArray[n] == 32) continue;
                stringBuffer9.append((char)(byArray[n] & 0x7F));
            }
            mimeHeaders.addHeader(string, stringBuffer9.toString());
        }
        return n3;
    }

    public boolean matches(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (toLower[byArray[i]] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean matches(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (toLower[byArray[n + i]] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void putInt(byte[] byArray, OutputStream outputStream, int n) throws IOException {
        int n2 = 0;
        int n3 = byArray.length;
        if (n < 0) {
            byArray[--n3] = 45;
            n = -n;
            ++n2;
        }
        if (n == 0) {
            byArray[--n3] = 48;
            ++n2;
        }
        while (n > 0) {
            byArray[--n3] = (byte)(n % 10 + 48);
            n /= 10;
            ++n2;
        }
        outputStream.write(byArray, n3, n2);
    }

    private int readLine(NonBlockingBufferedInputStream nonBlockingBufferedInputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        while ((n3 = nonBlockingBufferedInputStream.read()) != -1) {
            int n5;
            if (n3 != 10 && n3 != 13) {
                byArray[n++] = (byte)n3;
                ++n4;
            }
            if (n4 != n2 && (10 != n3 || (n5 = nonBlockingBufferedInputStream.peek()) == 32 || n5 == 9)) continue;
            break;
        }
        return n4 > 0 ? n4 : -1;
    }

    public static String getLocalHost() {
        return NetworkUtils.getLocalHostname();
    }

    static {
        int n;
        log = LogFactory.getLog(SimpleAxisWorker.class.getName());
        transportName = "SimpleHTTP";
        OK = ("200 " + Messages.getMessage("ok00")).getBytes();
        NOCONTENT = ("202 " + Messages.getMessage("ok00") + "\n\n").getBytes();
        UNAUTH = ("401 " + Messages.getMessage("unauth00")).getBytes();
        SENDER = "400".getBytes();
        ISE = ("500 " + Messages.getMessage("internalError01")).getBytes();
        HTTP = "HTTP/1.0 ".getBytes();
        XML_MIME_STUFF = "\r\nContent-Type: text/xml; charset=utf-8\r\nContent-Length: ".getBytes();
        HTML_MIME_STUFF = "\r\nContent-Type: text/html; charset=utf-8\r\nContent-Length: ".getBytes();
        SEPARATOR = "\r\n\r\n".getBytes();
        toLower = new byte[256];
        for (n = 0; n < 256; ++n) {
            SimpleAxisWorker.toLower[n] = (byte)n;
        }
        for (n = 97; n <= 122; ++n) {
            SimpleAxisWorker.toLower[n + 65 - 97] = (byte)n;
        }
        lenHeader = "content-length: ".getBytes();
        lenLen = lenHeader.length;
        typeHeader = ("Content-Type".toLowerCase() + ": ").getBytes();
        typeLen = typeHeader.length;
        locationHeader = ("Content-Location".toLowerCase() + ": ").getBytes();
        locationLen = locationHeader.length;
        actionHeader = "soapaction: ".getBytes();
        actionLen = actionHeader.length;
        cookieHeader = "cookie: ".getBytes();
        cookieLen = cookieHeader.length;
        cookie2Header = "cookie2: ".getBytes();
        cookie2Len = cookie2Header.length;
        authHeader = "authorization: ".getBytes();
        authLen = authHeader.length;
        getHeader = "GET".getBytes();
        postHeader = "POST".getBytes();
        headerEnder = ": ".getBytes();
        basicAuth = "basic ".getBytes();
    }
}

