/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.Subscription;

public abstract class JMSEndpoint {
    private JMSConnector m_connector;

    protected JMSEndpoint(JMSConnector jMSConnector) {
        this.m_connector = jMSConnector;
    }

    abstract Destination getDestination(Session var1) throws Exception;

    public byte[] call(byte[] byArray, long l) throws Exception {
        return this.m_connector.getSendConnection().call(this, byArray, l, null);
    }

    public byte[] call(byte[] byArray, long l, HashMap hashMap) throws Exception {
        if (hashMap != null) {
            hashMap = (HashMap)hashMap.clone();
        }
        return this.m_connector.getSendConnection().call(this, byArray, l, hashMap);
    }

    public void send(byte[] byArray) throws Exception {
        this.m_connector.getSendConnection().send(this, byArray, null);
    }

    public void send(byte[] byArray, HashMap hashMap) throws Exception {
        if (hashMap != null) {
            hashMap = (HashMap)hashMap.clone();
        }
        this.m_connector.getSendConnection().send(this, byArray, hashMap);
    }

    public void registerListener(MessageListener messageListener) throws Exception {
        this.m_connector.getReceiveConnection().subscribe(this.createSubscription(messageListener, null));
    }

    public void registerListener(MessageListener messageListener, HashMap hashMap) throws Exception {
        if (hashMap != null) {
            hashMap = (HashMap)hashMap.clone();
        }
        this.m_connector.getReceiveConnection().subscribe(this.createSubscription(messageListener, hashMap));
    }

    public void unregisterListener(MessageListener messageListener) {
        this.m_connector.getReceiveConnection().unsubscribe(this.createSubscription(messageListener, null));
    }

    public void unregisterListener(MessageListener messageListener, HashMap hashMap) {
        if (hashMap != null) {
            hashMap = (HashMap)hashMap.clone();
        }
        this.m_connector.getReceiveConnection().unsubscribe(this.createSubscription(messageListener, hashMap));
    }

    protected Subscription createSubscription(MessageListener messageListener, HashMap hashMap) {
        return new Subscription(messageListener, this, hashMap);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof JMSEndpoint;
    }
}

