/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Transport;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.components.jms.JMSVendorAdapterFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSConnectorManager;
import org.apache.axis.transport.jms.JMSURLHelper;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class JMSTransport
extends Transport {
    protected static Log log = LogFactory.getLog(JMSTransport.class.getName());
    private static HashMap vendorConnectorPools = new HashMap();
    private HashMap defaultConnectorProps;
    private HashMap defaultConnectionFactoryProps;

    public JMSTransport() {
        this.transportName = "JMSTransport";
    }

    public JMSTransport(HashMap hashMap, HashMap hashMap2) {
        this();
        this.defaultConnectorProps = hashMap;
        this.defaultConnectionFactoryProps = hashMap2;
    }

    public void setupMessageContextImpl(MessageContext messageContext, Call call, AxisEngine axisEngine) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JMSTransport::setupMessageContextImpl");
        }
        JMSConnector jMSConnector = null;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        JMSVendorAdapter jMSVendorAdapter = null;
        JMSURLHelper jMSURLHelper = null;
        String string = call.getUsername();
        String string2 = call.getPassword();
        String string3 = call.getTargetEndpointAddress();
        if (string3 != null) {
            try {
                jMSURLHelper = new JMSURLHelper(new URL(string3));
                String string4 = jMSURLHelper.getVendor();
                if (string4 == null) {
                    string4 = "JNDI";
                }
                if (log.isDebugEnabled()) {
                    log.debug("JMSTransport.setupMessageContextImpl(): endpt=" + string3 + ", vendor=" + string4);
                }
                if ((jMSVendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter(string4)) == null) {
                    throw new AxisFault("cannotLoadAdapterClass:" + string4);
                }
                hashMap = jMSVendorAdapter.getJMSConnectorProperties(jMSURLHelper);
                hashMap2 = jMSVendorAdapter.getJMSConnectionFactoryProperties(jMSURLHelper);
            }
            catch (MalformedURLException malformedURLException) {
                log.error(Messages.getMessage("malformedURLException00"), malformedURLException);
                throw new AxisFault(Messages.getMessage("malformedURLException00"), malformedURLException);
            }
        } else {
            jMSVendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter();
            if (jMSVendorAdapter == null) {
                throw new AxisFault("cannotLoadAdapterClass");
            }
            hashMap = this.defaultConnectorProps;
            hashMap2 = this.defaultConnectionFactoryProps;
        }
        try {
            jMSConnector = JMSConnectorManager.getInstance().getConnector(hashMap, hashMap2, string, string2, jMSVendorAdapter);
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("cannotConnectError"), exception);
            if (exception instanceof AxisFault) {
                throw (AxisFault)exception;
            }
            throw new AxisFault("cannotConnect", exception);
        }
        messageContext.setProperty("transport.jms.Connector", jMSConnector);
        messageContext.setProperty("transport.jms.VendorAdapter", jMSVendorAdapter);
        jMSVendorAdapter.setupMessageContext(messageContext, call, jMSURLHelper);
        if (log.isDebugEnabled()) {
            log.debug("Exit: JMSTransport::setupMessageContextImpl");
        }
    }

    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JMSTransport::shutdown");
        }
        JMSTransport.closeAllConnectors();
        if (log.isDebugEnabled()) {
            log.debug("Exit: JMSTransport::shutdown");
        }
    }

    public static void closeAllConnectors() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JMSTransport::closeAllConnectors");
        }
        JMSConnectorManager.getInstance().closeAllConnectors();
        if (log.isDebugEnabled()) {
            log.debug("Exit: JMSTransport::closeAllConnectors");
        }
    }

    public static void closeMatchingJMSConnectors(String string, String string2, String string3) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JMSTransport::closeMatchingJMSConnectors");
        }
        try {
            JMSURLHelper jMSURLHelper = new JMSURLHelper(new URL(string));
            String string4 = jMSURLHelper.getVendor();
            JMSVendorAdapter jMSVendorAdapter = null;
            if (string4 == null) {
                string4 = "JNDI";
            }
            if ((jMSVendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter(string4)) == null) {
                return;
            }
            HashMap hashMap = jMSVendorAdapter.getJMSConnectorProperties(jMSURLHelper);
            HashMap hashMap2 = jMSVendorAdapter.getJMSConnectionFactoryProperties(jMSURLHelper);
            JMSConnectorManager.getInstance().closeMatchingJMSConnectors(hashMap, hashMap2, string2, string3, jMSVendorAdapter);
        }
        catch (MalformedURLException malformedURLException) {
            log.warn(Messages.getMessage("malformedURLException00"), malformedURLException);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JMSTransport::closeMatchingJMSConnectors");
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JMSTransport.closeAllConnectors();
            }
        });
    }
}

