/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class JMSURLHelper {
    private URL url;
    private String destination;
    private HashMap properties;
    private Vector requiredProperties;
    private Vector appProperties;

    public JMSURLHelper(URL uRL) throws MalformedURLException {
        this(uRL, null);
    }

    public JMSURLHelper(URL uRL, String[] stringArray) throws MalformedURLException {
        this.url = uRL;
        this.properties = new HashMap();
        this.appProperties = new Vector();
        this.destination = uRL.getPath();
        if (this.destination.startsWith("/")) {
            this.destination = this.destination.substring(1);
        }
        if (this.destination == null || this.destination.trim().length() < 1) {
            throw new MalformedURLException("Missing destination in URL");
        }
        String string = uRL.getQuery();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.startsWith("msgProp.")) {
                string3 = string3.substring("msgProp.".length());
                this.addApplicationProperty(string3);
            }
            this.properties.put(string3, string4);
        }
        this.addRequiredProperties(stringArray);
        this.validateURL();
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String string) {
        this.destination = string;
    }

    public String getVendor() {
        return this.getPropertyValue("vendor");
    }

    public String getDomain() {
        return this.getPropertyValue("domain");
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String string) {
        return (String)this.properties.get(string);
    }

    public void addRequiredProperties(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addRequiredProperty(stringArray[i]);
        }
    }

    public void addRequiredProperty(String string) {
        if (string == null) {
            return;
        }
        if (this.requiredProperties == null) {
            this.requiredProperties = new Vector();
        }
        this.requiredProperties.addElement(string);
    }

    public Vector getRequiredProperties() {
        return this.requiredProperties;
    }

    public void addApplicationProperty(String string) {
        if (string == null) {
            return;
        }
        if (this.appProperties == null) {
            this.appProperties = new Vector();
        }
        this.appProperties.addElement(string);
    }

    public void addApplicationProperty(String string, String string2) {
        if (string == null) {
            return;
        }
        if (this.appProperties == null) {
            this.appProperties = new Vector();
        }
        this.properties.put(string, string2);
        this.appProperties.addElement(string);
    }

    public Vector getApplicationProperties() {
        return this.appProperties;
    }

    public String getURLString() {
        StringBuffer stringBuffer = new StringBuffer("jms:/");
        stringBuffer.append(this.getDestination());
        stringBuffer.append("?");
        Map map = (Map)this.properties.clone();
        boolean bl = true;
        for (String string : this.properties.keySet()) {
            if (!bl) {
                stringBuffer.append("&");
            }
            if (this.appProperties.contains(string)) {
                stringBuffer.append("msgProp.");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(map.get(string));
            bl = false;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getURLString();
    }

    private void validateURL() throws MalformedURLException {
        Vector vector = this.getRequiredProperties();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (this.properties.get(string) != null) continue;
            throw new MalformedURLException();
        }
    }
}

