/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.mail;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.i18n.Messages;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.mail.MailWorker;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;

public class MailServer
implements Runnable {
    protected static Log log = LogFactory.getLog(MailServer.class.getName());
    private String host;
    private int port;
    private String userid;
    private String password;
    private static boolean doThreads = true;
    private static AxisServer myAxisServer = null;
    private boolean stopped = false;
    private POP3Client pop3;

    public MailServer(String string, int n, String string2, String string3) {
        this.host = string;
        this.port = n;
        this.userid = string2;
        this.password = string3;
    }

    public void setDoThreads(boolean bl) {
        doThreads = bl;
    }

    public boolean getDoThreads() {
        return doThreads;
    }

    public String getHost() {
        return this.host;
    }

    protected static synchronized AxisServer getAxisServer() {
        if (myAxisServer == null) {
            myAxisServer = new AxisServer();
        }
        return myAxisServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        log.info(Messages.getMessage("start00", "MailServer", this.host + ":" + this.port));
        while (!this.stopped) {
            try {
                this.pop3.connect(this.host, this.port);
                this.pop3.login(this.userid, this.password);
                POP3MessageInfo[] pOP3MessageInfoArray = this.pop3.listMessages();
                if (pOP3MessageInfoArray == null || pOP3MessageInfoArray.length <= 0) continue;
                for (int i = 0; i < pOP3MessageInfoArray.length; ++i) {
                    int n;
                    Reader reader = this.pop3.retrieveMessage(pOP3MessageInfoArray[i].number);
                    if (reader == null) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    BufferedReader bufferedReader = new BufferedReader(reader);
                    while ((n = bufferedReader.read()) != -1) {
                        stringBuffer.append((char)n);
                    }
                    bufferedReader.close();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
                    Properties properties = new Properties();
                    Session session = Session.getDefaultInstance(properties, null);
                    MimeMessage mimeMessage = new MimeMessage(session, byteArrayInputStream);
                    this.pop3.deleteMessage(pOP3MessageInfoArray[i].number);
                    if (mimeMessage == null) continue;
                    MailWorker mailWorker = new MailWorker(this, mimeMessage);
                    if (doThreads) {
                        Thread thread = new Thread(mailWorker);
                        thread.setDaemon(true);
                        thread.start();
                        continue;
                    }
                    mailWorker.run();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                log.debug(Messages.getMessage("exception00"), exception);
                break;
            }
            finally {
                try {
                    this.pop3.logout();
                    this.pop3.disconnect();
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    log.error(Messages.getMessage("exception00"), exception);
                }
            }
        }
        log.info(Messages.getMessage("quit00", "MailServer"));
    }

    public POP3Client getPOP3() {
        return this.pop3;
    }

    public void setPOP3(POP3Client pOP3Client) {
        this.pop3 = pOP3Client;
    }

    public void start(boolean bl) throws Exception {
        if (doThreads) {
            Thread thread = new Thread(this);
            thread.setDaemon(bl);
            thread.start();
        } else {
            this.run();
        }
    }

    public void start() throws Exception {
        this.start(false);
    }

    public void stop() throws Exception {
        this.stopped = true;
        log.info(Messages.getMessage("quit00", "MailServer"));
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Options options = null;
        try {
            options = new Options(stringArray);
        }
        catch (MalformedURLException malformedURLException) {
            log.error(Messages.getMessage("malformedURLException00"), malformedURLException);
            return;
        }
        try {
            doThreads = options.isFlagSet('t') > 0;
            String string = options.getHost();
            int n = options.isFlagSet('p') > 0 ? options.getPort() : 110;
            POP3Client pOP3Client = new POP3Client();
            MailServer mailServer = new MailServer(string, n, options.getUser(), options.getPassword());
            mailServer.setPOP3(pOP3Client);
            mailServer.start();
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            return;
        }
    }
}

