/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.types;

import java.io.Serializable;
import java.util.Calendar;
import org.apache.axis.utils.Messages;

public class Duration
implements Serializable {
    boolean isNegative = false;
    int years;
    int months;
    int days;
    int hours;
    int minutes;
    double seconds;

    public Duration() {
    }

    public Duration(boolean bl, int n, int n2, int n3, int n4, int n5, double d) {
        this.isNegative = bl;
        this.years = n;
        this.months = n2;
        this.days = n3;
        this.hours = n4;
        this.minutes = n5;
        this.setSeconds(d);
    }

    public Duration(String string) throws IllegalArgumentException {
        int n = 1;
        int n2 = string.indexOf("T");
        if (string.indexOf("P") == -1 || string.equals("P")) {
            throw new IllegalArgumentException(Messages.getMessage("badDuration"));
        }
        if (string.lastIndexOf("T") == string.length() - 1) {
            throw new IllegalArgumentException(Messages.getMessage("badDuration"));
        }
        if (string.startsWith("-")) {
            this.isNegative = true;
            ++n;
        }
        if (n2 != -1) {
            this.parseTime(string.substring(n2 + 1));
        } else {
            n2 = string.length();
        }
        if (n != n2) {
            this.parseDate(string.substring(n, n2));
        }
    }

    public Duration(boolean bl, Calendar calendar) throws IllegalArgumentException {
        this.isNegative = bl;
        this.years = calendar.get(1);
        this.months = calendar.get(2);
        this.days = calendar.get(5);
        this.hours = calendar.get(10);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        this.seconds += (double)calendar.get(14) / 100.0;
        if (this.years == 0 && this.months == 0 && this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds == 0.0) {
            throw new IllegalArgumentException(Messages.getMessage("badCalendarForDuration"));
        }
    }

    public void parseTime(String string) throws IllegalArgumentException {
        if (string.length() == 0 || string.indexOf("-") != -1) {
            throw new IllegalArgumentException(Messages.getMessage("badTimeDuration"));
        }
        if (!(string.endsWith("H") || string.endsWith("M") || string.endsWith("S"))) {
            throw new IllegalArgumentException(Messages.getMessage("badTimeDuration"));
        }
        try {
            int n = 0;
            int n2 = string.indexOf("H");
            if (n == n2) {
                throw new IllegalArgumentException(Messages.getMessage("badTimeDuration"));
            }
            if (n2 != -1) {
                this.hours = Integer.parseInt(string.substring(0, n2));
                n = n2 + 1;
            }
            if (n == (n2 = string.indexOf("M"))) {
                throw new IllegalArgumentException(Messages.getMessage("badTimeDuration"));
            }
            if (n2 != -1) {
                this.minutes = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
            }
            if (n == (n2 = string.indexOf("S"))) {
                throw new IllegalArgumentException(Messages.getMessage("badTimeDuration"));
            }
            if (n2 != -1) {
                this.setSeconds(Double.parseDouble(string.substring(n, n2)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(Messages.getMessage("badTimeDuration"));
        }
    }

    public void parseDate(String string) throws IllegalArgumentException {
        if (string.length() == 0 || string.indexOf("-") != -1) {
            throw new IllegalArgumentException(Messages.getMessage("badDateDuration"));
        }
        if (!(string.endsWith("Y") || string.endsWith("M") || string.endsWith("D"))) {
            throw new IllegalArgumentException(Messages.getMessage("badDateDuration"));
        }
        try {
            int n = 0;
            int n2 = string.indexOf("Y");
            if (n == n2) {
                throw new IllegalArgumentException(Messages.getMessage("badDateDuration"));
            }
            if (n2 != -1) {
                this.years = Integer.parseInt(string.substring(0, n2));
                n = n2 + 1;
            }
            if (n == (n2 = string.indexOf("M"))) {
                throw new IllegalArgumentException(Messages.getMessage("badDateDuration"));
            }
            if (n2 != -1) {
                this.months = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
            }
            if (n == (n2 = string.indexOf("D"))) {
                throw new IllegalArgumentException(Messages.getMessage("badDateDuration"));
            }
            if (n2 != -1) {
                this.days = Integer.parseInt(string.substring(n, n2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(Messages.getMessage("badDateDuration"));
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setNegative(boolean bl) {
        this.isNegative = bl;
    }

    public void setYears(int n) {
        this.years = n;
    }

    public void setMonths(int n) {
        this.months = n;
    }

    public void setDays(int n) {
        this.days = n;
    }

    public void setHours(int n) {
        this.hours = n;
    }

    public void setMinutes(int n) {
        this.minutes = n;
    }

    public void setSeconds(int n) {
        this.seconds = n;
    }

    public void setSeconds(double d) {
        this.seconds = (double)Math.round(d * 100.0) / 100.0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("P");
        if (this.years != 0) {
            stringBuffer.append(this.years + "Y");
        }
        if (this.months != 0) {
            stringBuffer.append(this.months + "M");
        }
        if (this.days != 0) {
            stringBuffer.append(this.days + "D");
        }
        if (this.hours != 0 || this.minutes != 0 || this.seconds != 0.0) {
            stringBuffer.append("T");
            if (this.hours != 0) {
                stringBuffer.append(this.hours + "H");
            }
            if (this.minutes != 0) {
                stringBuffer.append(this.minutes + "M");
            }
            if (this.seconds != 0.0) {
                if (this.seconds == (double)((int)this.seconds)) {
                    stringBuffer.append((int)this.seconds + "S");
                } else {
                    stringBuffer.append(this.seconds + "S");
                }
            }
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append("T0S");
        }
        if (this.isNegative) {
            stringBuffer.insert(0, "-");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Duration)) {
            return false;
        }
        Calendar calendar = this.getAsCalendar();
        Duration duration = (Duration)object;
        return this.isNegative == duration.isNegative && this.getAsCalendar().equals(duration.getAsCalendar());
    }

    public int hashCode() {
        int n = 0;
        if (this.isNegative) {
            ++n;
        }
        n += this.years;
        n += this.months;
        n += this.days;
        n += this.hours;
        n += this.minutes;
        n = (int)((double)n + this.seconds);
        n = (int)((double)n + this.seconds * 100.0 % 100.0);
        return n;
    }

    public Calendar getAsCalendar() {
        return this.getAsCalendar(Calendar.getInstance());
    }

    public Calendar getAsCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(1, this.years);
        calendar2.set(2, this.months);
        calendar2.set(5, this.days);
        calendar2.set(10, this.hours);
        calendar2.set(12, this.minutes);
        calendar2.set(13, (int)this.seconds);
        calendar2.set(14, (int)(this.seconds * 100.0 - (double)(Math.round(this.seconds) * 100L)));
        return calendar2;
    }
}

