/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.types;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;
import org.apache.axis.types.NonPositiveInteger;
import org.apache.axis.utils.Messages;

public class NegativeInteger
extends NonPositiveInteger {
    private BigInteger zero = new BigInteger("0");

    public NegativeInteger(byte[] byArray) {
        super(byArray);
        this.checkValidity();
    }

    public NegativeInteger(int n, byte[] byArray) {
        super(n, byArray);
        this.checkValidity();
    }

    public NegativeInteger(int n, int n2, Random random) {
        super(n, n2, random);
        this.checkValidity();
    }

    public NegativeInteger(int n, Random random) {
        super(n, random);
        this.checkValidity();
    }

    public NegativeInteger(String string) {
        super(string);
        this.checkValidity();
    }

    public NegativeInteger(String string, int n) {
        super(string, n);
        this.checkValidity();
    }

    private void checkValidity() {
        if (this.compareTo(this.zero) >= 0) {
            throw new NumberFormatException(Messages.getMessage("badnegInt00") + ":  " + this);
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        return new BigIntegerRep(this.toByteArray());
    }

    protected static class BigIntegerRep
    implements Serializable {
        private byte[] array;

        protected BigIntegerRep(byte[] byArray) {
            this.array = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            return new NegativeInteger(this.array);
        }
    }
}

