/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.types;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.axis.utils.Messages;

public class Time
implements Serializable {
    private Calendar _value;
    private static SimpleDateFormat zulu = new SimpleDateFormat("HH:mm:ss.SSS'Z'");

    public Time(Calendar calendar) {
        this._value = calendar;
        this._value.set(0, 0, 0);
    }

    public Time(String string) throws NumberFormatException {
        this._value = this.makeValue(string);
    }

    public Calendar getAsCalendar() {
        return this._value;
    }

    public void setTime(Calendar calendar) {
        this._value = calendar;
        this._value.set(0, 0, 0);
    }

    public void setTime(Date date) {
        this._value.setTime(date);
        this._value.set(0, 0, 0);
    }

    private Calendar makeValue(String string) throws NumberFormatException {
        Calendar calendar = Calendar.getInstance();
        this.validateSource(string);
        Date date = Time.ParseHoursMinutesSeconds(string);
        int n = 8;
        if (string != null) {
            int n2;
            int n3;
            if (n < string.length() && string.charAt(n) == '.') {
                n3 = 0;
                n2 = ++n;
                while (n < string.length() && Character.isDigit(string.charAt(n))) {
                    ++n;
                }
                String string2 = string.substring(n2, n);
                if (string2.length() == 3) {
                    n3 = Integer.parseInt(string2);
                } else if (string2.length() < 3) {
                    n3 = Integer.parseInt((string2 + "000").substring(0, 3));
                } else {
                    n3 = Integer.parseInt(string2.substring(0, 3));
                    if (string2.charAt(3) >= '5') {
                        ++n3;
                    }
                }
                date.setTime(date.getTime() + (long)n3);
            }
            if (n + 5 < string.length() && (string.charAt(n) == '+' || string.charAt(n) == '-')) {
                if (!(Character.isDigit(string.charAt(n + 1)) && Character.isDigit(string.charAt(n + 2)) && string.charAt(n + 3) == ':' && Character.isDigit(string.charAt(n + 4)) && Character.isDigit(string.charAt(n + 5)))) {
                    throw new NumberFormatException(Messages.getMessage("badTimezone00"));
                }
                n3 = (string.charAt(n + 1) - 48) * 10 + string.charAt(n + 2) - 48;
                n2 = (string.charAt(n + 4) - 48) * 10 + string.charAt(n + 5) - 48;
                int n4 = (n3 * 60 + n2) * 60 * 1000;
                if (string.charAt(n) == '+') {
                    n4 = -n4;
                }
                date.setTime(date.getTime() + (long)n4);
                n += 6;
            }
            if (n < string.length() && string.charAt(n) == 'Z') {
                ++n;
                calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            }
            if (n < string.length()) {
                throw new NumberFormatException(Messages.getMessage("badChars00"));
            }
        }
        calendar.setTime(date);
        calendar.set(0, 0, 0);
        return calendar;
    }

    private int getTimezoneNumberValue(char c) {
        int n = c - 48;
        if (n < 0 || n > 9) {
            throw new NumberFormatException(Messages.getMessage("badTimezone00"));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date ParseHoursMinutesSeconds(String string) {
        Date date;
        try {
            SimpleDateFormat simpleDateFormat = zulu;
            synchronized (simpleDateFormat) {
                String string2 = string == null ? null : string.substring(0, 8) + ".000Z";
                date = zulu.parse(string2);
            }
        }
        catch (Exception exception) {
            throw new NumberFormatException(exception.toString());
        }
        return date;
    }

    private void validateSource(String string) {
        if (string != null) {
            if (string.charAt(2) != ':' || string.charAt(5) != ':') {
                throw new NumberFormatException(Messages.getMessage("badTime00"));
            }
            if (string.length() < 8) {
                throw new NumberFormatException(Messages.getMessage("badTime00"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this._value == null) {
            return "unassigned Time";
        }
        SimpleDateFormat simpleDateFormat = zulu;
        synchronized (simpleDateFormat) {
            return zulu.format(this._value.getTime());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Time)) {
            return false;
        }
        Time time = (Time)object;
        if (this == object) {
            return true;
        }
        boolean bl = this._value == null && time._value == null || this._value != null && this._value.getTime().equals(time._value.getTime());
        return bl;
    }

    public int hashCode() {
        return this._value == null ? 0 : this._value.hashCode();
    }

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

