/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class BeanPropertyDescriptor {
    protected static Log log = LogFactory.getLog(BeanPropertyDescriptor.class.getName());
    protected PropertyDescriptor myPD = null;
    protected static final Object[] noArgs = new Object[0];

    public BeanPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.myPD = propertyDescriptor;
    }

    protected BeanPropertyDescriptor() {
    }

    public String getName() {
        return this.myPD.getName();
    }

    public boolean isReadable() {
        return this.myPD.getReadMethod() != null;
    }

    public boolean isWriteable() {
        return this.myPD.getWriteMethod() != null;
    }

    public boolean isIndexed() {
        return this.myPD instanceof IndexedPropertyDescriptor;
    }

    public boolean isIndexedOrArray() {
        return this.isIndexed() || this.isArray();
    }

    public boolean isArray() {
        return this.myPD.getPropertyType() != null && this.myPD.getPropertyType().isArray();
    }

    public Object get(Object object) throws InvocationTargetException, IllegalAccessException {
        Method method = this.myPD.getReadMethod();
        if (method != null) {
            return method.invoke(object, noArgs);
        }
        throw new IllegalAccessException(Messages.getMessage("badGetter00"));
    }

    public void set(Object object, Object object2) throws InvocationTargetException, IllegalAccessException {
        Method method = this.myPD.getWriteMethod();
        if (method == null) {
            throw new IllegalAccessException(Messages.getMessage("badSetter00"));
        }
        method.invoke(object, object2);
    }

    public Object get(Object object, int n) throws InvocationTargetException, IllegalAccessException {
        if (!this.isIndexed()) {
            return Array.get(this.get(object), n);
        }
        IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)this.myPD;
        return indexedPropertyDescriptor.getIndexedReadMethod().invoke(object, new Integer(n));
    }

    public void set(Object object, int n, Object object2) throws InvocationTargetException, IllegalAccessException {
        if (this.isIndexed()) {
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)this.myPD;
            this.growArrayToSize(object, indexedPropertyDescriptor.getIndexedPropertyType(), n);
            indexedPropertyDescriptor.getIndexedWriteMethod().invoke(object, new Integer(n), object2);
        } else {
            this.growArrayToSize(object, this.myPD.getPropertyType().getComponentType(), n);
            Array.set(this.get(object), n, object2);
        }
    }

    protected void growArrayToSize(Object object, Class clazz, int n) throws InvocationTargetException, IllegalAccessException {
        Object object2 = this.get(object);
        if (object2 == null || Array.getLength(object2) <= n) {
            Object object3 = Array.newInstance(clazz, n + 1);
            if (object2 != null) {
                System.arraycopy(object2, 0, object3, 0, Array.getLength(object2));
            }
            this.set(object, object3);
        }
    }

    public Class getType() {
        if (this.isIndexed()) {
            return ((IndexedPropertyDescriptor)this.myPD).getIndexedPropertyType();
        }
        return this.myPD.getPropertyType();
    }

    public Class getActualType() {
        return this.myPD.getPropertyType();
    }
}

