/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.util.ArrayList;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class NSStack {
    protected static Log log = LogFactory.getLog(NSStack.class.getName());
    private Mapping[] stack;
    private int top = 0;
    private int iterator = 0;
    private int currentDefaultNS = -1;
    private boolean optimizePrefixes = true;
    private final boolean traceEnabled = log.isTraceEnabled();

    public NSStack(boolean bl) {
        this.optimizePrefixes = bl;
        this.stack = new Mapping[32];
        this.stack[0] = null;
    }

    public NSStack() {
        this.stack = new Mapping[32];
        this.stack[0] = null;
    }

    public void push() {
        ++this.top;
        if (this.top >= this.stack.length) {
            Mapping[] mappingArray = new Mapping[this.stack.length * 2];
            System.arraycopy(this.stack, 0, mappingArray, 0, this.stack.length);
            this.stack = mappingArray;
        }
        if (this.traceEnabled) {
            log.trace("NSPush (" + this.stack.length + ")");
        }
        this.stack[this.top] = null;
    }

    public void pop() {
        this.clearFrame();
        --this.top;
        if (this.top < this.currentDefaultNS) {
            this.currentDefaultNS = this.top;
            while (this.currentDefaultNS > 0 && (this.stack[this.currentDefaultNS] == null || this.stack[this.currentDefaultNS].getPrefix().length() != 0)) {
                --this.currentDefaultNS;
            }
        }
        if (this.top == 0) {
            if (this.traceEnabled) {
                log.trace("NSPop (" + Messages.getMessage("empty00") + ")");
            }
            return;
        }
        if (this.traceEnabled) {
            log.trace("NSPop (" + this.stack.length + ")");
        }
    }

    public ArrayList cloneFrame() {
        if (this.stack[this.top] == null) {
            return null;
        }
        ArrayList<Mapping> arrayList = new ArrayList<Mapping>();
        Mapping mapping = this.topOfFrame();
        while (mapping != null) {
            arrayList.add(mapping);
            mapping = this.next();
        }
        return arrayList;
    }

    private void clearFrame() {
        while (this.stack[this.top] != null) {
            --this.top;
        }
    }

    public Mapping topOfFrame() {
        this.iterator = this.top;
        while (this.stack[this.iterator] != null) {
            --this.iterator;
        }
        ++this.iterator;
        return this.next();
    }

    public Mapping next() {
        if (this.iterator > this.top) {
            return null;
        }
        return this.stack[this.iterator++];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string, String string2) {
        int n = this.top;
        string2 = string2.intern();
        try {
            int n2 = this.top;
            while (this.stack[n2] != null) {
                if (this.stack[n2].getPrefix() == string2) {
                    this.stack[n2].setNamespaceURI(string);
                    n = n2;
                    return;
                }
                --n2;
            }
            this.push();
            this.stack[this.top] = new Mapping(string, string2);
            n = this.top;
        }
        finally {
            if (string2.length() == 0) {
                this.currentDefaultNS = n;
            }
        }
    }

    public String getPrefix(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.optimizePrefixes && !bl && this.currentDefaultNS > 0 && this.stack[this.currentDefaultNS] != null && string == this.stack[this.currentDefaultNS].getNamespaceURI()) {
            return "";
        }
        string = string.intern();
        block0: for (int i = this.top; i > 0; --i) {
            Mapping mapping = this.stack[i];
            if (mapping == null || mapping.getNamespaceURI() != string) continue;
            String string2 = mapping.getPrefix();
            if (bl && string2.length() == 0) continue;
            int n = this.top;
            while (n != i) {
                mapping = this.stack[n];
                if (mapping != null && string2 == mapping.getPrefix()) continue block0;
                --n;
            }
            return string2;
        }
        return null;
    }

    public String getPrefix(String string) {
        return this.getPrefix(string, false);
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            string = "";
        }
        string = string.intern();
        for (int i = this.top; i > 0; --i) {
            Mapping mapping = this.stack[i];
            if (mapping == null || mapping.getPrefix() != string) continue;
            return mapping.getNamespaceURI();
        }
        return null;
    }

    public void dump(String string) {
        for (int i = this.top; i > 0; --i) {
            Mapping mapping = this.stack[i];
            if (mapping == null) {
                log.trace(string + Messages.getMessage("stackFrame00"));
                continue;
            }
            log.trace(string + mapping.getNamespaceURI() + " -> " + mapping.getPrefix());
        }
    }
}

