/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.client.AdminClient;
import org.apache.axis.utils.Options;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPMonitor
extends JFrame
implements ActionListener,
ChangeListener {
    private JPanel main_panel = null;
    private JTabbedPane tabbed_pane = null;
    private JTabbedPane top_pane = null;
    private int port = 5001;
    private String axisHost = "localhost";
    private int axisPort = 8080;
    private String axisURL = null;
    private Vector pages = null;
    private final String titleStr = "SOAP Monitor Administration";
    private JPanel set_panel = null;
    private JLabel titleLabel = null;
    private JButton add_btn = null;
    private JButton del_btn = null;
    private JButton save_btn = null;
    private JButton login_btn = null;
    private DefaultListModel model1 = null;
    private DefaultListModel model2 = null;
    private JList list1 = null;
    private JList list2 = null;
    private HashMap serviceMap = null;
    private Document originalDoc = null;
    private static String axisUser = null;
    private static String axisPass = null;
    private AdminClient adminClient = new AdminClient();

    public static void main(String[] stringArray) throws Exception {
        SOAPMonitor sOAPMonitor = null;
        Options options = new Options(stringArray);
        if (options.isFlagSet('?') > 0) {
            System.out.println("Usage: SOAPMonitor [-l<url>] [-u<user>] [-w<password>] [-?]");
            System.exit(0);
        }
        sOAPMonitor = new SOAPMonitor();
        sOAPMonitor.axisURL = options.getURL();
        URL uRL = new URL(sOAPMonitor.axisURL);
        sOAPMonitor.axisHost = uRL.getHost();
        axisUser = options.getUser();
        axisPass = options.getPassword();
        sOAPMonitor.doLogin();
    }

    public SOAPMonitor() {
        this.setTitle("SOAP Monitor Application");
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setSize(640, 480);
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new MyWindowAdapter());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.main_panel = new JPanel();
        this.main_panel.setBackground(Color.white);
        this.main_panel.setLayout(new BorderLayout());
        this.top_pane = new JTabbedPane();
        this.set_panel = new JPanel();
        this.titleLabel = new JLabel("SOAP Monitor Administration");
        this.titleLabel.setFont(new Font("Serif", 1, 18));
        this.model1 = new DefaultListModel();
        this.list1 = new JList(this.model1);
        this.list1.setFixedCellWidth(250);
        JScrollPane jScrollPane = new JScrollPane(this.list1);
        this.model2 = new DefaultListModel();
        this.list2 = new JList(this.model2);
        this.list2.setFixedCellWidth(250);
        JScrollPane jScrollPane2 = new JScrollPane(this.list2);
        this.add_btn = new JButton("Turn On [ >> ]");
        this.del_btn = new JButton("[ << ] Turn Off");
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(this.add_btn, gridBagConstraints);
        jPanel.add(this.add_btn);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(this.del_btn, gridBagConstraints);
        jPanel.add(this.del_btn);
        this.save_btn = new JButton("Save changes");
        this.login_btn = new JButton("Change server");
        JPanel jPanel2 = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(this.save_btn, gridBagConstraints);
        jPanel2.add(this.save_btn);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(this.login_btn, gridBagConstraints);
        jPanel2.add(this.login_btn);
        this.set_panel.setLayout(new BorderLayout(5, 5));
        this.set_panel.add((Component)this.titleLabel, "North");
        this.set_panel.add((Component)jPanel2, "South");
        this.set_panel.add((Component)jScrollPane, "West");
        this.set_panel.add((Component)jScrollPane2, "East");
        this.set_panel.add((Component)jPanel, "Center");
        this.add_btn.addActionListener(this);
        this.del_btn.addActionListener(this);
        this.save_btn.addActionListener(this);
        this.login_btn.addActionListener(this);
        this.add_btn.setEnabled(false);
        this.del_btn.setEnabled(false);
        this.save_btn.setEnabled(false);
        this.login_btn.setEnabled(false);
        this.top_pane.add("Setting", this.set_panel);
        this.top_pane.add("Monitoring", this.main_panel);
        this.getContentPane().add(this.top_pane);
        this.tabbed_pane = new JTabbedPane(1);
        this.main_panel.add((Component)this.tabbed_pane, "Center");
        this.top_pane.addChangeListener(this);
        this.top_pane.setEnabled(false);
        this.setVisible(true);
    }

    private boolean doLogin() {
        Object object;
        Serializable serializable;
        Dimension dimension = null;
        LoginDlg loginDlg = new LoginDlg();
        loginDlg.show();
        if (!loginDlg.isLogin()) {
            this.login_btn.setEnabled(true);
            return false;
        }
        loginDlg.dispose();
        this.save_btn.setEnabled(false);
        this.login_btn.setEnabled(false);
        String string = loginDlg.getURL();
        try {
            serializable = new URL(string);
            this.axisHost = serializable.getHost();
            this.axisPort = serializable.getPort();
            if (this.axisPort == -1) {
                this.axisPort = 8080;
            }
            object = serializable.getPath();
            this.axisURL = "http://" + this.axisHost + ":" + this.axisPort + (String)object;
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane jOptionPane = new JOptionPane();
            String string2 = malformedURLException.toString();
            jOptionPane.setMessageType(2);
            jOptionPane.setMessage(string2);
            jOptionPane.setOptions(new String[]{"OK"});
            JDialog jDialog = jOptionPane.createDialog(null, "Login status");
            jDialog.setVisible(true);
            this.login_btn.setEnabled(true);
            return false;
        }
        this.titleLabel.setText("SOAP Monitor Administration for [" + this.axisHost + ":" + this.axisPort + "]");
        serializable = new JProgressBar(0, 100);
        object = new BarThread((JProgressBar)serializable);
        ((Thread)object).start();
        JFrame jFrame = new JFrame();
        dimension = new Dimension(250, 50);
        jFrame.setSize(dimension);
        dimension = this.getToolkit().getScreenSize();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.setTitle("Now loading data ...");
        jFrame.setLocation((dimension.width - jFrame.getWidth()) / 2, (dimension.height - jFrame.getHeight()) / 2);
        jFrame.show();
        this.pages = new Vector();
        this.addPage(new SOAPMonitorPage(this.axisHost));
        this.serviceMap = new HashMap();
        this.originalDoc = this.getServerWSDD();
        this.model1.clear();
        this.model2.clear();
        if (this.originalDoc != null) {
            String string3 = null;
            NodeList nodeList = this.originalDoc.getElementsByTagName("service");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap namedNodeMap = node.getAttributes();
                string3 = namedNodeMap.getNamedItem("name").getNodeValue();
                this.serviceMap.put(string3, node);
                if (!this.isMonitored(node)) {
                    this.model1.addElement(string3);
                    continue;
                }
                this.model2.addElement(string3);
            }
            if (this.model1.size() > 0) {
                this.add_btn.setEnabled(true);
            }
            if (this.model2.size() > 0) {
                this.del_btn.setEnabled(true);
            }
            jFrame.dispose();
            this.save_btn.setEnabled(true);
            this.login_btn.setEnabled(true);
            this.top_pane.setEnabled(true);
            return true;
        }
        jFrame.dispose();
        this.login_btn.setEnabled(true);
        return false;
    }

    private Document getServerWSDD() {
        Document document = null;
        try {
            String[] stringArray = new String[]{"-u" + axisUser, "-w" + axisPass, "-l " + this.axisURL, "list"};
            String string = this.adminClient.process(stringArray);
            document = XMLUtils.newDocument(new ByteArrayInputStream(string.getBytes()));
        }
        catch (Exception exception) {
            JOptionPane jOptionPane = new JOptionPane();
            String string = exception.toString();
            jOptionPane.setMessageType(2);
            jOptionPane.setMessage(string);
            jOptionPane.setOptions(new String[]{"OK"});
            JDialog jDialog = jOptionPane.createDialog(null, "Login status");
            jDialog.setVisible(true);
        }
        return document;
    }

    private boolean doDeploy(Document document) {
        String string = null;
        Options options = null;
        string = XMLUtils.DocumentToString(document);
        try {
            String[] stringArray = new String[]{"-u" + axisUser, "-w" + axisPass, "-l " + this.axisURL, ""};
            options = new Options(stringArray);
            this.adminClient.process(options, new ByteArrayInputStream(string.getBytes()));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private Document getNewDocumentAsNode(Node node) {
        Document document = null;
        Node node2 = null;
        try {
            document = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        node2 = document.importNode(node, true);
        document.appendChild(node2);
        return document;
    }

    private Node addMonitor(Node node) {
        Document document = null;
        Node node2 = null;
        Element element = null;
        Object var5_5 = null;
        NodeList nodeList = null;
        document = this.getNewDocumentAsNode(node);
        nodeList = document.getElementsByTagName("responseFlow");
        if (nodeList.getLength() == 0) {
            node2 = document.getDocumentElement().getFirstChild();
            element = document.createElement("responseFlow");
            document.getDocumentElement().insertBefore(element, node2);
        }
        if ((nodeList = document.getElementsByTagName("requestFlow")).getLength() == 0) {
            node2 = document.getDocumentElement().getFirstChild();
            element = document.createElement("requestFlow");
            document.getDocumentElement().insertBefore(element, node2);
        }
        nodeList = document.getElementsByTagName("requestFlow");
        node2 = nodeList.item(0).getFirstChild();
        element = document.createElement("handler");
        element.setAttribute("type", "soapmonitor");
        nodeList.item(0).insertBefore(element, node2);
        nodeList = document.getElementsByTagName("responseFlow");
        node2 = nodeList.item(0).getFirstChild();
        element = document.createElement("handler");
        element.setAttribute("type", "soapmonitor");
        nodeList.item(0).insertBefore(element, node2);
        return document.getDocumentElement();
    }

    private Node delMonitor(Node node) {
        Object object;
        int n;
        Document document = null;
        Node node2 = null;
        Node node3 = null;
        String string = null;
        NodeList nodeList = null;
        document = this.getNewDocumentAsNode(node);
        nodeList = document.getElementsByTagName("handler");
        int n2 = nodeList.getLength();
        Node[] nodeArray = new Node[n2];
        if (n2 > 0) {
            node3 = nodeList.item(0).getParentNode();
        }
        for (n = 0; n < n2; ++n) {
            node2 = nodeList.item(n);
            object = node2.getAttributes();
            string = object.getNamedItem("type").getNodeValue();
            if (!string.equals("soapmonitor")) continue;
            nodeArray[n] = node2;
        }
        for (n = 0; n < n2; ++n) {
            object = nodeArray[n];
            if (object == null) continue;
            object.getParentNode().removeChild((Node)object);
        }
        return document.getDocumentElement();
    }

    private boolean isMonitored(Node node) {
        Document document = null;
        Node node2 = null;
        String string = null;
        NodeList nodeList = null;
        int n = 0;
        document = this.getNewDocumentAsNode(node);
        nodeList = document.getElementsByTagName("handler");
        if (n < nodeList.getLength()) {
            node2 = nodeList.item(n);
            NamedNodeMap namedNodeMap = node2.getAttributes();
            string = namedNodeMap.getNamedItem("type").getNodeValue();
            return string.equals("soapmonitor");
        }
        return false;
    }

    private Node addAuthenticate(Node node) {
        NamedNodeMap namedNodeMap;
        int n;
        Document document = null;
        Node node2 = null;
        Element element = null;
        String string = null;
        NodeList nodeList = null;
        boolean bl = false;
        boolean bl2 = false;
        document = this.getNewDocumentAsNode(node);
        nodeList = document.getElementsByTagName("requestFlow");
        if (nodeList.getLength() == 0) {
            node2 = document.getDocumentElement().getFirstChild();
            element = document.createElement("requestFlow");
            document.getDocumentElement().insertBefore(element, node2);
        }
        nodeList = document.getElementsByTagName("handler");
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            namedNodeMap = node2.getAttributes();
            string = namedNodeMap.getNamedItem("type").getNodeValue();
            if (!string.equals("java:org.apache.axis.handlers.SimpleAuthorizationHandler")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            nodeList = document.getElementsByTagName("requestFlow");
            node2 = nodeList.item(0).getFirstChild();
            element = document.createElement("handler");
            element.setAttribute("type", "java:org.apache.axis.handlers.SimpleAuthorizationHandler");
            nodeList.item(0).insertBefore(element, node2);
        }
        bl = false;
        nodeList = document.getElementsByTagName("handler");
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            namedNodeMap = node2.getAttributes();
            string = namedNodeMap.getNamedItem("type").getNodeValue();
            if (!string.equals("java:org.apache.axis.handlers.SimpleAuthenticationHandler")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            nodeList = document.getElementsByTagName("requestFlow");
            node2 = nodeList.item(0).getFirstChild();
            element = document.createElement("handler");
            element.setAttribute("type", "java:org.apache.axis.handlers.SimpleAuthenticationHandler");
            nodeList.item(0).insertBefore(element, node2);
        }
        nodeList = document.getElementsByTagName("parameter");
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            namedNodeMap = node2.getAttributes();
            if ((node2 = namedNodeMap.getNamedItem("name")) == null || !(string = node2.getNodeValue()).equals("allowedRoles")) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            nodeList = document.getElementsByTagName("parameter");
            element = document.createElement("parameter");
            element.setAttribute("name", "allowedRoles");
            element.setAttribute("value", "admin");
            document.getDocumentElement().insertBefore(element, nodeList.item(0));
        }
        return document.getDocumentElement();
    }

    private void addPage(SOAPMonitorPage sOAPMonitorPage) {
        this.tabbed_pane.addTab("  " + sOAPMonitorPage.getHost() + "  ", sOAPMonitorPage);
        this.pages.addElement(sOAPMonitorPage);
    }

    private void delPage() {
        this.tabbed_pane.removeAll();
        this.pages.removeAllElements();
    }

    public void start() {
        Enumeration enumeration = this.pages.elements();
        while (enumeration.hasMoreElements()) {
            SOAPMonitorPage sOAPMonitorPage = (SOAPMonitorPage)enumeration.nextElement();
            if (sOAPMonitorPage == null) continue;
            sOAPMonitorPage.start();
        }
    }

    public void stop() {
        Enumeration enumeration = this.pages.elements();
        while (enumeration.hasMoreElements()) {
            SOAPMonitorPage sOAPMonitorPage = (SOAPMonitorPage)enumeration.nextElement();
            if (sOAPMonitorPage == null) continue;
            sOAPMonitorPage.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.add_btn) {
            int n;
            int[] nArray = this.list1.getSelectedIndices();
            for (int i = n = nArray.length - 1; i >= 0; --i) {
                this.model2.addElement(this.model1.getElementAt(nArray[i]));
                this.model1.remove(nArray[i]);
            }
            if (this.model1.size() == 0) {
                this.add_btn.setEnabled(false);
            }
            if (this.model2.size() > 0) {
                this.del_btn.setEnabled(true);
            }
        } else if (object == this.del_btn) {
            int n;
            int[] nArray = this.list2.getSelectedIndices();
            for (int i = n = nArray.length - 1; i >= 0; --i) {
                this.model1.addElement(this.model2.getElementAt(nArray[i]));
                this.model2.remove(nArray[i]);
            }
            if (this.model2.size() == 0) {
                this.del_btn.setEnabled(false);
            }
            if (this.model1.size() > 0) {
                this.add_btn.setEnabled(true);
            }
        } else if (object == this.login_btn) {
            if (this.doLogin()) {
                this.delPage();
                this.addPage(new SOAPMonitorPage(this.axisHost));
                this.start();
            } else {
                this.add_btn.setEnabled(false);
                this.del_btn.setEnabled(false);
            }
        } else if (object == this.save_btn) {
            String string3 = null;
            Node node = null;
            Node node2 = null;
            Document document = null;
            JOptionPane jOptionPane = null;
            JDialog jDialog = null;
            String string2 = null;
            try {
                document = XMLUtils.newDocument(new ByteArrayInputStream("<deployment name=\"SOAPMonitor\" xmlns=\"http://xml.apache.org/axis/wsdd/\" xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">\n <handler name=\"soapmonitor\" type=\"java:org.apache.axis.handlers.SOAPMonitorHandler\" />\n </deployment>".getBytes()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Set set = this.serviceMap.keySet();
            for (String string3 : set) {
                node = (Node)this.serviceMap.get(string3);
                node2 = this.model2.contains(string3) ? (this.isMonitored(node) ? document.importNode(node, true) : document.importNode(this.addMonitor(node), true)) : (this.isMonitored(node) ? document.importNode(this.delMonitor(node), true) : document.importNode(node, true));
                if (string3.equals("AdminService")) {
                    node2 = document.importNode(this.addAuthenticate(node2), true);
                }
                document.getDocumentElement().appendChild(node2);
            }
            jOptionPane = new JOptionPane();
            if (this.doDeploy(document)) {
                string2 = "The deploy was successful.";
                jOptionPane.setMessageType(1);
            } else {
                string2 = "The deploy was NOT successful.";
                jOptionPane.setMessageType(2);
            }
            jOptionPane.setOptions(new String[]{"OK"});
            jOptionPane.setMessage(string2);
            jDialog = jOptionPane.createDialog(null, "Deployment status");
            jDialog.setVisible(true);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        int n = jTabbedPane.getSelectedIndex();
        if (n == 1) {
            this.start();
        } else {
            this.stop();
        }
    }

    class SOAPMonitorTextArea
    extends JTextArea {
        private boolean format = false;
        private String original = "";
        private String formatted = null;

        public void setText(String string) {
            this.original = string;
            this.formatted = null;
            if (this.format) {
                this.doFormat();
                super.setText(this.formatted);
            } else {
                super.setText(this.original);
            }
        }

        public void setReflowXML(boolean bl) {
            this.format = bl;
            if (this.format) {
                if (this.formatted == null) {
                    this.doFormat();
                }
                super.setText(this.formatted);
            } else {
                super.setText(this.original);
            }
        }

        public void doFormat() {
            int n;
            Vector<String> vector = new Vector<String>();
            char[] cArray = this.original.toCharArray();
            int n2 = 0;
            String string = null;
            for (n = 0; n < cArray.length; ++n) {
                if (cArray[n] == '<') {
                    if (n2 < n) {
                        string = new String(cArray, n2, n - n2);
                        if ((string = string.trim()).length() > 0) {
                            vector.addElement(string);
                        }
                    }
                    n2 = n;
                }
                if (cArray[n] == '>') {
                    string = new String(cArray, n2, n - n2 + 1);
                    vector.addElement(string);
                    n2 = n + 1;
                }
                if (cArray[n] != '\n' && cArray[n] != '\r') continue;
                if (n2 < n) {
                    string = new String(cArray, n2, n - n2);
                    if ((string = string.trim()).length() > 0) {
                        vector.addElement(string);
                    }
                }
                n2 = n + 1;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = vector.toArray();
            int n3 = 0;
            int n4 = 0;
            for (n = 0; n < objectArray.length; ++n) {
                string = (String)objectArray[n];
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append('\n');
                if (string.startsWith("</")) {
                    --n3;
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(string);
                if (!string.startsWith("<") || string.startsWith("</") || string.endsWith("/>")) continue;
                ++n3;
                if (n + 2 >= objectArray.length || !(string = (String)objectArray[n + 2]).startsWith("</") || (string = (String)objectArray[n + 1]).startsWith("<")) continue;
                stringBuffer.append(string);
                string = (String)objectArray[n + 2];
                stringBuffer.append(string);
                n += 2;
                --n3;
            }
            this.formatted = new String(stringBuffer);
        }
    }

    class SOAPMonitorFilter
    implements ActionListener {
        private JDialog dialog = null;
        private JPanel panel = null;
        private JPanel buttons = null;
        private JButton ok_button = null;
        private JButton cancel_button = null;
        private ServiceFilterPanel include_panel = null;
        private ServiceFilterPanel exclude_panel = null;
        private JPanel status_panel = null;
        private JCheckBox status_box = null;
        private EmptyBorder empty_border = null;
        private EmptyBorder indent_border = null;
        private JPanel status_options = null;
        private ButtonGroup status_group = null;
        private JRadioButton status_active = null;
        private JRadioButton status_complete = null;
        private Vector filter_include_list = null;
        private Vector filter_exclude_list = new Vector();
        private boolean filter_active = false;
        private boolean filter_complete = false;
        private boolean ok_pressed = false;

        public SOAPMonitorFilter() {
            this.filter_exclude_list.addElement("NotificationService");
            this.filter_exclude_list.addElement("EventViewerService");
        }

        public Vector getFilterIncludeList() {
            return this.filter_include_list;
        }

        public Vector getFilterExcludeList() {
            return this.filter_exclude_list;
        }

        public boolean getFilterActive() {
            return this.filter_active;
        }

        public boolean getFilterComplete() {
            return this.filter_complete;
        }

        public void showDialog() {
            this.empty_border = new EmptyBorder(5, 5, 0, 5);
            this.indent_border = new EmptyBorder(5, 25, 5, 5);
            this.include_panel = new ServiceFilterPanel("Include messages based on target service:", this.filter_include_list);
            this.exclude_panel = new ServiceFilterPanel("Exclude messages based on target service:", this.filter_exclude_list);
            this.status_box = new JCheckBox("Filter messages based on status:");
            this.status_box.addActionListener(this);
            this.status_active = new JRadioButton("Active messages only");
            this.status_active.setSelected(true);
            this.status_active.setEnabled(false);
            this.status_complete = new JRadioButton("Complete messages only");
            this.status_complete.setEnabled(false);
            this.status_group = new ButtonGroup();
            this.status_group.add(this.status_active);
            this.status_group.add(this.status_complete);
            if (this.filter_active || this.filter_complete) {
                this.status_box.setSelected(true);
                this.status_active.setEnabled(true);
                this.status_complete.setEnabled(true);
                if (this.filter_complete) {
                    this.status_complete.setSelected(true);
                }
            }
            this.status_options = new JPanel();
            this.status_options.setLayout(new BoxLayout(this.status_options, 1));
            this.status_options.add(this.status_active);
            this.status_options.add(this.status_complete);
            this.status_options.setBorder(this.indent_border);
            this.status_panel = new JPanel();
            this.status_panel.setLayout(new BorderLayout());
            this.status_panel.add((Component)this.status_box, "North");
            this.status_panel.add((Component)this.status_options, "Center");
            this.status_panel.setBorder(this.empty_border);
            this.ok_button = new JButton("Ok");
            this.ok_button.addActionListener(this);
            this.cancel_button = new JButton("Cancel");
            this.cancel_button.addActionListener(this);
            this.buttons = new JPanel();
            this.buttons.setLayout(new FlowLayout());
            this.buttons.add(this.ok_button);
            this.buttons.add(this.cancel_button);
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(this.include_panel);
            this.panel.add(this.exclude_panel);
            this.panel.add(this.status_panel);
            this.panel.add(this.buttons);
            this.dialog = new JDialog();
            this.dialog.setTitle("SOAP Monitor Filter");
            this.dialog.setContentPane(this.panel);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setModal(true);
            this.dialog.pack();
            Dimension dimension = this.dialog.getToolkit().getScreenSize();
            this.dialog.setLocation((dimension.width - this.dialog.getWidth()) / 2, (dimension.height - this.dialog.getHeight()) / 2);
            this.ok_pressed = false;
            this.dialog.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.ok_button) {
                this.filter_include_list = this.include_panel.getServiceList();
                this.filter_exclude_list = this.exclude_panel.getServiceList();
                if (this.status_box.isSelected()) {
                    this.filter_active = this.status_active.isSelected();
                    this.filter_complete = this.status_complete.isSelected();
                } else {
                    this.filter_active = false;
                    this.filter_complete = false;
                }
                this.ok_pressed = true;
                this.dialog.dispose();
            }
            if (actionEvent.getSource() == this.cancel_button) {
                this.dialog.dispose();
            }
            if (actionEvent.getSource() == this.status_box) {
                this.status_active.setEnabled(this.status_box.isSelected());
                this.status_complete.setEnabled(this.status_box.isSelected());
            }
        }

        public boolean okPressed() {
            return this.ok_pressed;
        }
    }

    class ServiceFilterPanel
    extends JPanel
    implements ActionListener,
    ListSelectionListener,
    DocumentListener {
        private JCheckBox service_box = null;
        private Vector filter_list = null;
        private Vector service_data = null;
        private JList service_list = null;
        private JScrollPane service_scroll = null;
        private JButton remove_service_button = null;
        private JPanel remove_service_panel = null;
        private EmptyBorder indent_border = null;
        private EmptyBorder empty_border = new EmptyBorder(5, 5, 0, 5);
        private JPanel service_area = null;
        private JPanel add_service_area = null;
        private JTextField add_service_field = null;
        private JButton add_service_button = null;
        private JPanel add_service_panel = null;

        public ServiceFilterPanel(String string, Vector vector) {
            this.indent_border = new EmptyBorder(5, 25, 5, 5);
            this.service_box = new JCheckBox(string);
            this.service_box.addActionListener(this);
            this.service_data = new Vector();
            if (vector != null) {
                this.service_box.setSelected(true);
                this.service_data = (Vector)vector.clone();
            }
            this.service_list = new JList(this.service_data);
            this.service_list.setBorder(new EtchedBorder());
            this.service_list.setVisibleRowCount(5);
            this.service_list.addListSelectionListener(this);
            this.service_list.setEnabled(this.service_box.isSelected());
            this.service_scroll = new JScrollPane(this.service_list);
            this.service_scroll.setBorder(new EtchedBorder());
            this.remove_service_button = new JButton("Remove");
            this.remove_service_button.addActionListener(this);
            this.remove_service_button.setEnabled(false);
            this.remove_service_panel = new JPanel();
            this.remove_service_panel.setLayout(new FlowLayout());
            this.remove_service_panel.add(this.remove_service_button);
            this.service_area = new JPanel();
            this.service_area.setLayout(new BorderLayout());
            this.service_area.add((Component)this.service_scroll, "Center");
            this.service_area.add((Component)this.remove_service_panel, "East");
            this.service_area.setBorder(this.indent_border);
            this.add_service_field = new JTextField();
            this.add_service_field.addActionListener(this);
            this.add_service_field.getDocument().addDocumentListener(this);
            this.add_service_field.setEnabled(this.service_box.isSelected());
            this.add_service_button = new JButton("Add");
            this.add_service_button.addActionListener(this);
            this.add_service_button.setEnabled(false);
            this.add_service_panel = new JPanel();
            this.add_service_panel.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setBorder(this.empty_border);
            this.add_service_panel.add((Component)jPanel, "West");
            this.add_service_panel.add((Component)this.add_service_button, "East");
            this.add_service_area = new JPanel();
            this.add_service_area.setLayout(new BorderLayout());
            this.add_service_area.add((Component)this.add_service_field, "Center");
            this.add_service_area.add((Component)this.add_service_panel, "East");
            this.add_service_area.setBorder(this.indent_border);
            this.setLayout(new BorderLayout());
            this.add((Component)this.service_box, "North");
            this.add((Component)this.service_area, "Center");
            this.add((Component)this.add_service_area, "South");
            this.setBorder(this.empty_border);
        }

        public Vector getServiceList() {
            Vector vector = null;
            if (this.service_box.isSelected()) {
                vector = this.service_data;
            }
            return vector;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            if (actionEvent.getSource() == this.service_box) {
                this.service_list.setEnabled(this.service_box.isSelected());
                this.service_list.clearSelection();
                this.remove_service_button.setEnabled(false);
                this.add_service_field.setEnabled(this.service_box.isSelected());
                this.add_service_field.setText("");
                this.add_service_button.setEnabled(false);
            }
            if (actionEvent.getSource() == this.add_service_button || actionEvent.getSource() == this.add_service_field) {
                objectArray = this.add_service_field.getText();
                if (objectArray != null && objectArray.length() > 0) {
                    this.service_data.addElement(objectArray);
                    this.service_list.setListData(this.service_data);
                }
                this.add_service_field.setText("");
                this.add_service_field.requestFocus();
            }
            if (actionEvent.getSource() == this.remove_service_button) {
                objectArray = this.service_list.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.service_data.removeElement(objectArray[i]);
                }
                this.service_list.setListData(this.service_data);
                this.service_list.clearSelection();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            String string = this.add_service_field.getText();
            if (string != null && string.length() > 0) {
                this.add_service_button.setEnabled(true);
            } else {
                this.add_service_button.setEnabled(false);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.service_list.getSelectedIndex() == -1) {
                this.remove_service_button.setEnabled(false);
            } else {
                this.remove_service_button.setEnabled(true);
            }
        }
    }

    class SOAPMonitorTableModel
    extends AbstractTableModel {
        private final String[] column_names = new String[]{"Time", "Target Service", "Status"};
        private Vector data = new Vector();
        private Vector filter_include;
        private Vector filter_exclude;
        private boolean filter_active;
        private boolean filter_complete;
        private Vector filter_data;

        public SOAPMonitorTableModel() {
            SOAPMonitorData sOAPMonitorData = new SOAPMonitorData(null, null, null);
            this.data.addElement(sOAPMonitorData);
            this.filter_include = null;
            this.filter_exclude = null;
            this.filter_active = false;
            this.filter_complete = false;
            this.filter_data = null;
            this.filter_exclude = new Vector();
            this.filter_exclude.addElement("NotificationService");
            this.filter_exclude.addElement("EventViewerService");
            this.filter_data = new Vector();
            this.filter_data.addElement(sOAPMonitorData);
        }

        public int getColumnCount() {
            return this.column_names.length;
        }

        public int getRowCount() {
            int n = this.data.size();
            if (this.filter_data != null) {
                n = this.filter_data.size();
            }
            return n;
        }

        public String getColumnName(int n) {
            return this.column_names[n];
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            SOAPMonitorData sOAPMonitorData = (SOAPMonitorData)this.data.elementAt(n);
            if (this.filter_data != null) {
                sOAPMonitorData = (SOAPMonitorData)this.filter_data.elementAt(n);
            }
            switch (n2) {
                case 0: {
                    string = sOAPMonitorData.getTime();
                    break;
                }
                case 1: {
                    string = sOAPMonitorData.getTargetService();
                    break;
                }
                case 2: {
                    string = sOAPMonitorData.getStatus();
                }
            }
            return string;
        }

        public boolean filterMatch(SOAPMonitorData sOAPMonitorData) {
            String string;
            Enumeration enumeration;
            boolean bl = true;
            if (this.filter_include != null) {
                enumeration = this.filter_include.elements();
                bl = false;
                while (enumeration.hasMoreElements() && !bl) {
                    string = (String)enumeration.nextElement();
                    if (!string.equals(sOAPMonitorData.getTargetService())) continue;
                    bl = true;
                }
            }
            if (this.filter_exclude != null) {
                enumeration = this.filter_exclude.elements();
                while (enumeration.hasMoreElements() && bl) {
                    string = (String)enumeration.nextElement();
                    if (!string.equals(sOAPMonitorData.getTargetService())) continue;
                    bl = false;
                }
            }
            if (this.filter_active && sOAPMonitorData.getSOAPResponse() != null) {
                bl = false;
            }
            if (this.filter_complete && sOAPMonitorData.getSOAPResponse() == null) {
                bl = false;
            }
            if (sOAPMonitorData.getId() == null) {
                bl = true;
            }
            return bl;
        }

        public void addData(SOAPMonitorData sOAPMonitorData) {
            int n = this.data.size();
            this.data.addElement(sOAPMonitorData);
            if (this.filter_data != null) {
                if (this.filterMatch(sOAPMonitorData)) {
                    n = this.filter_data.size();
                    this.filter_data.addElement(sOAPMonitorData);
                    this.fireTableRowsInserted(n, n);
                }
            } else {
                this.fireTableRowsInserted(n, n);
            }
        }

        public SOAPMonitorData findData(Long l) {
            SOAPMonitorData sOAPMonitorData = null;
            for (int i = this.data.size(); i > 0 && sOAPMonitorData == null; --i) {
                sOAPMonitorData = (SOAPMonitorData)this.data.elementAt(i - 1);
                if (sOAPMonitorData.getId().longValue() == l.longValue()) continue;
                sOAPMonitorData = null;
            }
            return sOAPMonitorData;
        }

        public int findRow(SOAPMonitorData sOAPMonitorData) {
            int n = -1;
            n = this.filter_data != null ? this.filter_data.indexOf(sOAPMonitorData) : this.data.indexOf(sOAPMonitorData);
            return n;
        }

        public void clearAll() {
            int n = this.data.size() - 1;
            if (n > 0) {
                this.data.removeAllElements();
                SOAPMonitorData sOAPMonitorData = new SOAPMonitorData(null, null, null);
                this.data.addElement(sOAPMonitorData);
                if (this.filter_data != null) {
                    this.filter_data.removeAllElements();
                    this.filter_data.addElement(sOAPMonitorData);
                }
                this.fireTableDataChanged();
            }
        }

        public void removeRow(int n) {
            SOAPMonitorData sOAPMonitorData = null;
            if (this.filter_data == null) {
                sOAPMonitorData = (SOAPMonitorData)this.data.elementAt(n);
                this.data.remove(sOAPMonitorData);
            } else {
                sOAPMonitorData = (SOAPMonitorData)this.filter_data.elementAt(n);
                this.filter_data.remove(sOAPMonitorData);
                this.data.remove(sOAPMonitorData);
            }
            this.fireTableRowsDeleted(n, n);
        }

        public void setFilter(SOAPMonitorFilter sOAPMonitorFilter) {
            this.filter_include = sOAPMonitorFilter.getFilterIncludeList();
            this.filter_exclude = sOAPMonitorFilter.getFilterExcludeList();
            this.filter_active = sOAPMonitorFilter.getFilterActive();
            this.filter_complete = sOAPMonitorFilter.getFilterComplete();
            this.applyFilter();
        }

        public void applyFilter() {
            this.filter_data = null;
            if (this.filter_include != null || this.filter_exclude != null || this.filter_active || this.filter_complete) {
                this.filter_data = new Vector();
                Enumeration enumeration = this.data.elements();
                while (enumeration.hasMoreElements()) {
                    SOAPMonitorData sOAPMonitorData = (SOAPMonitorData)enumeration.nextElement();
                    if (!this.filterMatch(sOAPMonitorData)) continue;
                    this.filter_data.addElement(sOAPMonitorData);
                }
            }
            this.fireTableDataChanged();
        }

        public SOAPMonitorData getData(int n) {
            SOAPMonitorData sOAPMonitorData = null;
            sOAPMonitorData = this.filter_data == null ? (SOAPMonitorData)this.data.elementAt(n) : (SOAPMonitorData)this.filter_data.elementAt(n);
            return sOAPMonitorData;
        }

        public void updateData(SOAPMonitorData sOAPMonitorData) {
            if (this.filter_data == null) {
                int n = this.data.indexOf(sOAPMonitorData);
                if (n != -1) {
                    this.fireTableRowsUpdated(n, n);
                }
            } else {
                int n = this.filter_data.indexOf(sOAPMonitorData);
                if (n == -1) {
                    if (this.filterMatch(sOAPMonitorData)) {
                        int n2 = -1;
                        for (n = this.data.indexOf(sOAPMonitorData) + 1; n < this.data.size() && n2 == -1; ++n) {
                            n2 = this.filter_data.indexOf(this.data.elementAt(n));
                            if (n2 == -1) continue;
                            this.filter_data.add(n2, sOAPMonitorData);
                        }
                        if (n2 == -1) {
                            n2 = this.filter_data.size();
                            this.filter_data.addElement(sOAPMonitorData);
                        }
                        this.fireTableRowsInserted(n2, n2);
                    }
                } else if (this.filterMatch(sOAPMonitorData)) {
                    this.fireTableRowsUpdated(n, n);
                } else {
                    this.filter_data.remove(sOAPMonitorData);
                    this.fireTableRowsDeleted(n, n);
                }
            }
        }
    }

    class SOAPMonitorData {
        private Long id;
        private String time;
        private String target;
        private String soap_request;
        private String soap_response;

        public SOAPMonitorData(Long l, String string, String string2) {
            this.id = l;
            if (l == null) {
                this.time = "Most Recent";
                this.target = "---";
                this.soap_request = null;
                this.soap_response = null;
            } else {
                this.time = DateFormat.getTimeInstance().format(new Date());
                this.target = string;
                this.soap_request = string2;
                this.soap_response = null;
            }
        }

        public Long getId() {
            return this.id;
        }

        public String getTime() {
            return this.time;
        }

        public String getTargetService() {
            return this.target;
        }

        public String getStatus() {
            String string = "---";
            if (this.id != null) {
                string = "Complete";
                if (this.soap_response == null) {
                    string = "Active";
                }
            }
            return string;
        }

        public String getSOAPRequest() {
            return this.soap_request;
        }

        public void setSOAPResponse(String string) {
            this.soap_response = string;
        }

        public String getSOAPResponse() {
            return this.soap_response;
        }
    }

    class SOAPMonitorPage
    extends JPanel
    implements Runnable,
    ListSelectionListener,
    ActionListener {
        private final String STATUS_ACTIVE = "The SOAP Monitor is started.";
        private final String STATUS_STOPPED = "The SOAP Monitor is stopped.";
        private final String STATUS_CLOSED = "The server communication has been terminated.";
        private final String STATUS_NOCONNECT = "The SOAP Monitor is unable to communcate with the server.";
        private String host = null;
        private Socket socket = null;
        private ObjectInputStream in = null;
        private ObjectOutputStream out = null;
        private SOAPMonitorTableModel model = null;
        private JTable table = null;
        private JScrollPane scroll = null;
        private JPanel list_panel = null;
        private JPanel list_buttons = null;
        private JButton remove_button = null;
        private JButton remove_all_button = null;
        private JButton filter_button = null;
        private JPanel details_panel = null;
        private JPanel details_header = null;
        private JSplitPane details_soap = null;
        private JPanel details_buttons = null;
        private JLabel details_time = null;
        private JLabel details_target = null;
        private JLabel details_status = null;
        private JLabel details_time_value = null;
        private JLabel details_target_value = null;
        private JLabel details_status_value = null;
        private EmptyBorder empty_border = null;
        private EtchedBorder etched_border = null;
        private JPanel request_panel = null;
        private JPanel response_panel = null;
        private JLabel request_label = null;
        private JLabel response_label = null;
        private SOAPMonitorTextArea request_text = null;
        private SOAPMonitorTextArea response_text = null;
        private JScrollPane request_scroll = null;
        private JScrollPane response_scroll = null;
        private JButton layout_button = null;
        private JSplitPane split = null;
        private JPanel status_area = null;
        private JPanel status_buttons = null;
        private JButton start_button = null;
        private JButton stop_button = null;
        private JLabel status_text = null;
        private JPanel status_text_panel = null;
        private SOAPMonitorFilter filter = null;
        private GridBagLayout details_header_layout = null;
        private GridBagConstraints details_header_constraints = null;
        private JCheckBox reflow_xml = null;

        public SOAPMonitorPage(String string) {
            this.host = string;
            this.filter = new SOAPMonitorFilter();
            this.etched_border = new EtchedBorder();
            this.model = new SOAPMonitorTableModel();
            this.table = new JTable(this.model);
            this.table.setSelectionMode(0);
            this.table.setRowSelectionInterval(0, 0);
            this.table.setPreferredScrollableViewportSize(new Dimension(600, 96));
            this.table.getSelectionModel().addListSelectionListener(this);
            this.scroll = new JScrollPane(this.table);
            this.remove_button = new JButton("Remove");
            this.remove_button.addActionListener(this);
            this.remove_button.setEnabled(false);
            this.remove_all_button = new JButton("Remove All");
            this.remove_all_button.addActionListener(this);
            this.filter_button = new JButton("Filter ...");
            this.filter_button.addActionListener(this);
            this.list_buttons = new JPanel();
            this.list_buttons.setLayout(new FlowLayout());
            this.list_buttons.add(this.remove_button);
            this.list_buttons.add(this.remove_all_button);
            this.list_buttons.add(this.filter_button);
            this.list_panel = new JPanel();
            this.list_panel.setLayout(new BorderLayout());
            this.list_panel.add((Component)this.scroll, "Center");
            this.list_panel.add((Component)this.list_buttons, "South");
            this.list_panel.setBorder(this.empty_border);
            this.details_time = new JLabel("Time: ", 4);
            this.details_target = new JLabel("Target Service: ", 4);
            this.details_status = new JLabel("Status: ", 4);
            this.details_time_value = new JLabel();
            this.details_target_value = new JLabel();
            this.details_status_value = new JLabel();
            Dimension dimension = this.details_time.getPreferredSize();
            dimension.width = 1;
            this.details_time.setPreferredSize(dimension);
            this.details_target.setPreferredSize(dimension);
            this.details_status.setPreferredSize(dimension);
            this.details_time_value.setPreferredSize(dimension);
            this.details_target_value.setPreferredSize(dimension);
            this.details_status_value.setPreferredSize(dimension);
            this.details_header = new JPanel();
            this.details_header_layout = new GridBagLayout();
            this.details_header.setLayout(this.details_header_layout);
            this.details_header_constraints = new GridBagConstraints();
            this.details_header_constraints.fill = 1;
            this.details_header_constraints.weightx = 0.5;
            this.details_header_layout.setConstraints(this.details_time, this.details_header_constraints);
            this.details_header.add(this.details_time);
            this.details_header_layout.setConstraints(this.details_time_value, this.details_header_constraints);
            this.details_header.add(this.details_time_value);
            this.details_header_layout.setConstraints(this.details_target, this.details_header_constraints);
            this.details_header.add(this.details_target);
            this.details_header_constraints.weightx = 1.0;
            this.details_header_layout.setConstraints(this.details_target_value, this.details_header_constraints);
            this.details_header.add(this.details_target_value);
            this.details_header_constraints.weightx = 0.5;
            this.details_header_layout.setConstraints(this.details_status, this.details_header_constraints);
            this.details_header.add(this.details_status);
            this.details_header_layout.setConstraints(this.details_status_value, this.details_header_constraints);
            this.details_header.add(this.details_status_value);
            this.details_header.setBorder(this.etched_border);
            this.request_label = new JLabel("SOAP Request", 0);
            this.request_text = new SOAPMonitorTextArea();
            this.request_text.setEditable(false);
            this.request_scroll = new JScrollPane(this.request_text);
            this.request_panel = new JPanel();
            this.request_panel.setLayout(new BorderLayout());
            this.request_panel.add((Component)this.request_label, "North");
            this.request_panel.add((Component)this.request_scroll, "Center");
            this.response_label = new JLabel("SOAP Response", 0);
            this.response_text = new SOAPMonitorTextArea();
            this.response_text.setEditable(false);
            this.response_scroll = new JScrollPane(this.response_text);
            this.response_panel = new JPanel();
            this.response_panel.setLayout(new BorderLayout());
            this.response_panel.add((Component)this.response_label, "North");
            this.response_panel.add((Component)this.response_scroll, "Center");
            this.details_soap = new JSplitPane(1);
            this.details_soap.setTopComponent(this.request_panel);
            this.details_soap.setRightComponent(this.response_panel);
            this.details_soap.setResizeWeight(0.5);
            this.details_panel = new JPanel();
            this.layout_button = new JButton("Switch Layout");
            this.layout_button.addActionListener(this);
            this.reflow_xml = new JCheckBox("Reflow XML text");
            this.reflow_xml.addActionListener(this);
            this.details_buttons = new JPanel();
            this.details_buttons.setLayout(new FlowLayout());
            this.details_buttons.add(this.reflow_xml);
            this.details_buttons.add(this.layout_button);
            this.details_panel.setLayout(new BorderLayout());
            this.details_panel.add((Component)this.details_header, "North");
            this.details_panel.add((Component)this.details_soap, "Center");
            this.details_panel.add((Component)this.details_buttons, "South");
            this.details_panel.setBorder(this.empty_border);
            this.split = new JSplitPane(0);
            this.split.setTopComponent(this.list_panel);
            this.split.setRightComponent(this.details_panel);
            this.start_button = new JButton("Start");
            this.start_button.addActionListener(this);
            this.stop_button = new JButton("Stop");
            this.stop_button.addActionListener(this);
            this.status_buttons = new JPanel();
            this.status_buttons.setLayout(new FlowLayout());
            this.status_buttons.add(this.start_button);
            this.status_buttons.add(this.stop_button);
            this.status_text = new JLabel();
            this.status_text.setBorder(new BevelBorder(1));
            this.status_text_panel = new JPanel();
            this.status_text_panel.setLayout(new BorderLayout());
            this.status_text_panel.add((Component)this.status_text, "Center");
            this.status_text_panel.setBorder(this.empty_border);
            this.status_area = new JPanel();
            this.status_area.setLayout(new BorderLayout());
            this.status_area.add((Component)this.status_buttons, "West");
            this.status_area.add((Component)this.status_text_panel, "Center");
            this.status_area.setBorder(this.etched_border);
            this.setLayout(new BorderLayout());
            this.add((Component)this.split, "Center");
            this.add((Component)this.status_area, "South");
        }

        public String getHost() {
            return this.host;
        }

        public void setStatus(String string) {
            this.status_text.setForeground(Color.black);
            this.status_text.setText("  " + string);
        }

        public void setErrorStatus(String string) {
            this.status_text.setForeground(Color.red);
            this.status_text.setText("  " + string);
        }

        public void start() {
            String string = SOAPMonitor.this.axisHost;
            if (this.socket == null) {
                try {
                    this.socket = new Socket(string, SOAPMonitor.this.port);
                    this.out = new ObjectOutputStream(this.socket.getOutputStream());
                    this.out.flush();
                    this.in = new ObjectInputStream(this.socket.getInputStream());
                    new Thread(this).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.setErrorStatus("The SOAP Monitor is unable to communcate with the server.");
                    this.socket = null;
                }
            }
            if (this.socket != null) {
                this.start_button.setEnabled(false);
                this.stop_button.setEnabled(true);
                this.setStatus("The SOAP Monitor is started.");
            }
        }

        public void stop() {
            if (this.socket != null) {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.out = null;
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.in = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.socket = null;
                }
            }
            this.start_button.setEnabled(true);
            this.stop_button.setEnabled(false);
            this.setStatus("The SOAP Monitor is stopped.");
        }

        public void run() {
            while (this.socket != null) {
                try {
                    Integer n = (Integer)this.in.readObject();
                    switch (n) {
                        case 0: {
                            Long l = (Long)this.in.readObject();
                            String string = (String)this.in.readObject();
                            String string2 = (String)this.in.readObject();
                            SOAPMonitorData sOAPMonitorData = new SOAPMonitorData(l, string, string2);
                            this.model.addData(sOAPMonitorData);
                            int n2 = this.table.getSelectedRow();
                            if (n2 != 0 || !this.model.filterMatch(sOAPMonitorData)) break;
                            this.valueChanged(null);
                            break;
                        }
                        case 1: {
                            int n3;
                            Long l = (Long)this.in.readObject();
                            String string2 = (String)this.in.readObject();
                            SOAPMonitorData sOAPMonitorData = this.model.findData(l);
                            if (sOAPMonitorData == null) break;
                            boolean bl = false;
                            int n2 = this.table.getSelectedRow();
                            if (n2 == 0) {
                                bl = true;
                            }
                            if ((n3 = this.model.findRow(sOAPMonitorData)) != -1 && n3 == n2) {
                                bl = true;
                            }
                            sOAPMonitorData.setSOAPResponse(string2);
                            this.model.updateData(sOAPMonitorData);
                            if (!bl) break;
                            this.valueChanged(null);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.stop_button.isEnabled()) continue;
                    this.stop();
                    this.setErrorStatus("The server communication has been terminated.");
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.table.getSelectedRow();
            if (n > 0) {
                this.remove_button.setEnabled(true);
            } else {
                this.remove_button.setEnabled(false);
            }
            if (n == 0 && (n = this.model.getRowCount() - 1) == 0) {
                n = -1;
            }
            if (n == -1) {
                this.details_time_value.setText("");
                this.details_target_value.setText("");
                this.details_status_value.setText("");
                this.request_text.setText("");
                this.response_text.setText("");
            } else {
                SOAPMonitorData sOAPMonitorData = this.model.getData(n);
                this.details_time_value.setText(sOAPMonitorData.getTime());
                this.details_target_value.setText(sOAPMonitorData.getTargetService());
                this.details_status_value.setText(sOAPMonitorData.getStatus());
                if (sOAPMonitorData.getSOAPRequest() == null) {
                    this.request_text.setText("");
                } else {
                    this.request_text.setText(sOAPMonitorData.getSOAPRequest());
                    this.request_text.setCaretPosition(0);
                }
                if (sOAPMonitorData.getSOAPResponse() == null) {
                    this.response_text.setText("");
                } else {
                    this.response_text.setText(sOAPMonitorData.getSOAPResponse());
                    this.response_text.setCaretPosition(0);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.remove_button) {
                int n = this.table.getSelectedRow();
                this.model.removeRow(n);
                this.table.clearSelection();
                this.table.repaint();
                this.valueChanged(null);
            }
            if (actionEvent.getSource() == this.remove_all_button) {
                this.model.clearAll();
                this.table.setRowSelectionInterval(0, 0);
                this.table.repaint();
                this.valueChanged(null);
            }
            if (actionEvent.getSource() == this.filter_button) {
                this.filter.showDialog();
                if (this.filter.okPressed()) {
                    this.model.setFilter(this.filter);
                    this.table.repaint();
                }
            }
            if (actionEvent.getSource() == this.start_button) {
                this.start();
            }
            if (actionEvent.getSource() == this.stop_button) {
                this.stop();
            }
            if (actionEvent.getSource() == this.layout_button) {
                this.details_panel.remove(this.details_soap);
                this.details_soap.removeAll();
                this.details_soap = this.details_soap.getOrientation() == 1 ? new JSplitPane(0) : new JSplitPane(1);
                this.details_soap.setTopComponent(this.request_panel);
                this.details_soap.setRightComponent(this.response_panel);
                this.details_soap.setResizeWeight(0.5);
                this.details_panel.add((Component)this.details_soap, "Center");
                this.details_panel.validate();
                this.details_panel.repaint();
            }
            if (actionEvent.getSource() == this.reflow_xml) {
                this.request_text.setReflowXML(this.reflow_xml.isSelected());
                this.response_text.setReflowXML(this.reflow_xml.isSelected());
            }
        }
    }

    class LoginDlg
    extends JDialog
    implements ActionListener {
        private JButton ok_button = null;
        private JButton cancel_button = null;
        private JTextField user = new JTextField(20);
        private JPasswordField pass = new JPasswordField(20);
        private JTextField url = new JTextField(20);
        private boolean loginState = false;

        public LoginDlg() {
            this.setTitle("SOAP Monitor Login");
            UIManager.put("Label.font", new Font("Dialog", 1, 12));
            JPanel jPanel = new JPanel();
            this.ok_button = new JButton("OK");
            this.ok_button.addActionListener(this);
            this.cancel_button = new JButton("Cancel");
            this.cancel_button.addActionListener(this);
            this.url.setText(SOAPMonitor.this.axisURL);
            JLabel jLabel = new JLabel("User:");
            JLabel jLabel2 = new JLabel("Password:");
            JLabel jLabel3 = new JLabel("Axis URL:");
            jLabel.setHorizontalAlignment(4);
            jLabel2.setHorizontalAlignment(4);
            jLabel3.setHorizontalAlignment(4);
            jPanel.add(jLabel);
            jPanel.add(this.user);
            jPanel.add(jLabel2);
            jPanel.add(this.pass);
            jPanel.add(jLabel3);
            jPanel.add(this.url);
            jPanel.add(this.ok_button);
            jPanel.add(this.cancel_button);
            this.setContentPane(jPanel);
            this.user.setText(axisUser);
            this.pass.setText(axisPass);
            GridLayout gridLayout = new GridLayout(4, 2);
            gridLayout.setHgap(15);
            gridLayout.setVgap(5);
            jPanel.setLayout(gridLayout);
            this.setDefaultCloseOperation(2);
            this.setModal(true);
            this.pack();
            Dimension dimension = this.getToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.ok_button) {
                this.loginState = true;
                axisUser = this.user.getText();
                axisPass = new String(this.pass.getPassword());
                this.hide();
            } else if (actionEvent.getSource() == this.cancel_button) {
                this.dispose();
            }
        }

        public String getURL() {
            return this.url.getText();
        }

        public boolean isLogin() {
            return this.loginState;
        }
    }

    class MyWindowAdapter
    extends WindowAdapter {
        MyWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    class BarThread
    extends Thread {
        private int wait = 100;
        JProgressBar progressBar = null;

        public BarThread(JProgressBar jProgressBar) {
            this.progressBar = jProgressBar;
        }

        public void run() {
            int n = this.progressBar.getMinimum();
            int n2 = this.progressBar.getMaximum();
            Runnable runnable = new Runnable(){

                public void run() {
                    int n = BarThread.this.progressBar.getValue();
                    BarThread.this.progressBar.setValue(n + 1);
                }
            };
            for (int i = n; i < n2; ++i) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                    Thread.sleep(this.wait);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }
}

