/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.axis.InternalException;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StringUtils() {
    }

    public static boolean startsWithIgnoreWhitespaces(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = 32;
        int n6 = 32;
        for (n = 0; n2 < n3 && n < n4; ++n2, ++n) {
            while (n2 < n3) {
                char c = string.charAt(n2);
                n5 = c;
                if (!Character.isWhitespace(c)) break;
                ++n2;
            }
            while (n < n4) {
                char c = string2.charAt(n);
                n6 = c;
                if (!Character.isWhitespace(c)) break;
                ++n;
            }
            if (n2 == n3 && n == n4) {
                return true;
            }
            if (n5 == n6) continue;
            return false;
        }
        return n2 >= n3 || n < n4;
    }

    public static String[] split(String string, char c) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (n2 < n) {
            if (string.charAt(n2) == c) {
                if (bl) {
                    arrayList.add(string.substring(n3, n2));
                    bl = false;
                }
                n3 = ++n2;
                continue;
            }
            bl = true;
            ++n2;
        }
        if (bl) {
            arrayList.add(string.substring(n3, n2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String strip(String string) {
        return StringUtils.strip(string, null);
    }

    public static String strip(String string, String string2) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = StringUtils.getStripStart(string, string2);
        if (n2 == n) {
            return "";
        }
        int n3 = StringUtils.getStripEnd(string, string2);
        return n2 == 0 && n3 == n ? string : string.substring(n2, n3);
    }

    public static String stripStart(String string, String string2) {
        int n = StringUtils.getStripStart(string, string2);
        return n <= 0 ? string : string.substring(n);
    }

    private static int getStripStart(String string, String string2) {
        int n;
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return -1;
        }
        if (string2 == null) {
            for (n = 0; n != n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
        } else {
            if (string2.length() == 0) {
                return n;
            }
            while (n != n2 && string2.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
        }
        return n;
    }

    public static String stripEnd(String string, String string2) {
        int n = StringUtils.getStripEnd(string, string2);
        return n < 0 ? string : string.substring(0, n);
    }

    private static int getStripEnd(String string, String string2) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return -1;
        }
        if (string2 == null) {
            while (n != 0 && Character.isWhitespace(string.charAt(n - 1))) {
                --n;
            }
        } else {
            if (string2.length() == 0) {
                return n;
            }
            while (n != 0 && string2.indexOf(string.charAt(n - 1)) != -1) {
                --n;
            }
        }
        return n;
    }

    public static String escapeNumericChar(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length());
            StringUtils.escapeNumericChar(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void escapeNumericChar(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                writer.write("&#x");
                writer.write(Integer.toHexString(c).toUpperCase());
                writer.write(";");
                continue;
            }
            writer.write(c);
        }
    }

    public static String unescapeNumericChar(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length());
            StringUtils.unescapeNumericChar(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void unescapeNumericChar(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(4);
        StringBuffer stringBuffer2 = new StringBuffer(3);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                stringBuffer.append(c);
                if (stringBuffer.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuffer.toString(), 16);
                    writer.write((char)n2);
                    stringBuffer.setLength(0);
                    ++i;
                    bl = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InternalException(numberFormatException);
                }
            }
            if (c == '&') {
                if (i + 7 <= n) {
                    stringBuffer2.append(c);
                    stringBuffer2.append(string.charAt(i + 1));
                    stringBuffer2.append(string.charAt(i + 2));
                    if (stringBuffer2.toString().equals("&#x") && string.charAt(i + 7) == ';') {
                        bl = true;
                    } else {
                        writer.write(stringBuffer2.toString());
                    }
                    stringBuffer2.setLength(0);
                    i += 2;
                    continue;
                }
                writer.write(c);
                continue;
            }
            writer.write(c);
        }
    }
}

