/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.extensions.soap.SOAPFault;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.wsdl.symbolTable.MimeInfo;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;

public class BindingEntry
extends SymTabEntry {
    public static final int TYPE_SOAP = 0;
    public static final int TYPE_HTTP_GET = 1;
    public static final int TYPE_HTTP_POST = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int USE_ENCODED = 0;
    public static final int USE_LITERAL = 1;
    private Binding binding;
    private int bindingType;
    private Style bindingStyle;
    private boolean hasLiteral;
    private HashMap attributes;
    private HashMap parameters = new HashMap();
    private HashMap faults = new HashMap();
    private Map mimeTypes;
    private Map headerParts;
    private ArrayList dimeOps = new ArrayList();
    public static final int NO_HEADER = 0;
    public static final int IN_HEADER = 1;
    public static final int OUT_HEADER = 2;

    public BindingEntry(Binding binding, int n, Style style, boolean bl, HashMap hashMap, Map map, Map map2) {
        super(binding.getQName());
        this.binding = binding;
        this.bindingType = n;
        this.bindingStyle = style;
        this.hasLiteral = bl;
        this.attributes = hashMap == null ? new HashMap() : hashMap;
        this.mimeTypes = map == null ? new HashMap() : map;
        this.headerParts = map2 == null ? new HashMap() : map2;
    }

    public BindingEntry(Binding binding) {
        super(binding.getQName());
        this.binding = binding;
        this.bindingType = 3;
        this.bindingStyle = Style.DOCUMENT;
        this.hasLiteral = false;
        this.attributes = new HashMap();
        this.mimeTypes = new HashMap();
        this.headerParts = new HashMap();
    }

    public Parameters getParameters(Operation operation) {
        return (Parameters)this.parameters.get(operation);
    }

    public HashMap getParameters() {
        return this.parameters;
    }

    public void setParameters(HashMap hashMap) {
        this.parameters = hashMap;
    }

    public MimeInfo getMIMEInfo(String string, String string2) {
        Map map = (Map)this.mimeTypes.get(string);
        if (map == null) {
            return null;
        }
        return (MimeInfo)map.get(string2);
    }

    public Map getMIMETypes() {
        return this.mimeTypes;
    }

    public void setMIMEInfo(String string, String string2, String string3, String string4) {
        HashMap<String, MimeInfo> hashMap = (HashMap<String, MimeInfo>)this.mimeTypes.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, MimeInfo>();
            this.mimeTypes.put(string, hashMap);
        }
        hashMap.put(string2, new MimeInfo(string3, string4));
    }

    public void setOperationDIME(String string) {
        if (this.dimeOps.indexOf(string) == -1) {
            this.dimeOps.add(string);
        }
    }

    public boolean isOperationDIME(String string) {
        return this.dimeOps.indexOf(string) >= 0;
    }

    public boolean isInHeaderPart(String string, String string2) {
        return (this.headerPart(string, string2) & 1) > 0;
    }

    public boolean isOutHeaderPart(String string, String string2) {
        return (this.headerPart(string, string2) & 2) > 0;
    }

    private int headerPart(String string, String string2) {
        Map map = (Map)this.headerParts.get(string);
        if (map == null) {
            return 0;
        }
        Integer n = (Integer)map.get(string2);
        return n == null ? 0 : n;
    }

    public Map getHeaderParts() {
        return this.headerParts;
    }

    public void setHeaderPart(String string, String string2, int n) {
        Integer n2;
        HashMap<String, Integer> hashMap = (HashMap<String, Integer>)this.headerParts.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, Integer>();
            this.headerParts.put(string, hashMap);
        }
        int n3 = (n2 = (Integer)hashMap.get(string2)) == null ? n : n2 | n;
        hashMap.put(string2, new Integer(n3));
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int getBindingType() {
        return this.bindingType;
    }

    protected void setBindingType(int n) {
        if (n < 0 || n <= 3) {
            // empty if block
        }
        this.bindingType = n;
    }

    public Style getBindingStyle() {
        return this.bindingStyle;
    }

    protected void setBindingStyle(Style style) {
        this.bindingStyle = style;
    }

    public boolean hasLiteral() {
        return this.hasLiteral;
    }

    protected void setHasLiteral(boolean bl) {
        this.hasLiteral = bl;
    }

    public Use getInputBodyType(Operation operation) {
        OperationAttr operationAttr = (OperationAttr)this.attributes.get(operation);
        if (operationAttr == null) {
            return Use.ENCODED;
        }
        return operationAttr.getInputBodyType();
    }

    protected void setInputBodyType(Operation operation, Use use) {
        OperationAttr operationAttr = (OperationAttr)this.attributes.get(operation);
        if (operationAttr == null) {
            operationAttr = new OperationAttr();
            this.attributes.put(operation, operationAttr);
        }
        operationAttr.setInputBodyType(use);
        if (use == Use.LITERAL) {
            this.setHasLiteral(true);
        }
    }

    public Use getOutputBodyType(Operation operation) {
        OperationAttr operationAttr = (OperationAttr)this.attributes.get(operation);
        if (operationAttr == null) {
            return Use.ENCODED;
        }
        return operationAttr.getOutputBodyType();
    }

    protected void setOutputBodyType(Operation operation, Use use) {
        OperationAttr operationAttr = (OperationAttr)this.attributes.get(operation);
        if (operationAttr == null) {
            operationAttr = new OperationAttr();
            this.attributes.put(operation, operationAttr);
        }
        operationAttr.setOutputBodyType(use);
        if (use == Use.LITERAL) {
            this.setHasLiteral(true);
        }
    }

    protected void setBodyType(Operation operation, Use use, boolean bl) {
        if (bl) {
            this.setInputBodyType(operation, use);
        } else {
            this.setOutputBodyType(operation, use);
        }
    }

    public Use getFaultBodyType(Operation operation, String string) {
        OperationAttr operationAttr = (OperationAttr)this.attributes.get(operation);
        if (operationAttr == null) {
            return Use.ENCODED;
        }
        HashMap hashMap = operationAttr.getFaultBodyTypeMap();
        SOAPFault sOAPFault = (SOAPFault)hashMap.get(string);
        if (sOAPFault == null) {
            return Use.ENCODED;
        }
        String string2 = sOAPFault.getUse();
        if ("literal".equals(string2)) {
            return Use.LITERAL;
        }
        return Use.ENCODED;
    }

    public HashMap getFaults() {
        return this.faults;
    }

    public void setFaults(HashMap hashMap) {
        this.faults = hashMap;
    }

    public Set getOperations() {
        return this.attributes.keySet();
    }

    protected void setFaultBodyTypeMap(Operation operation, HashMap hashMap) {
        OperationAttr operationAttr = (OperationAttr)this.attributes.get(operation);
        if (operationAttr == null) {
            operationAttr = new OperationAttr();
            this.attributes.put(operation, operationAttr);
        }
        operationAttr.setFaultBodyTypeMap(hashMap);
    }

    protected static class OperationAttr {
        private Use inputBodyType;
        private Use outputBodyType;
        private HashMap faultBodyTypeMap;

        public OperationAttr(Use use, Use use2, HashMap hashMap) {
            this.inputBodyType = use;
            this.outputBodyType = use2;
            this.faultBodyTypeMap = hashMap;
        }

        public OperationAttr() {
            this.inputBodyType = Use.ENCODED;
            this.outputBodyType = Use.ENCODED;
            this.faultBodyTypeMap = null;
        }

        public Use getInputBodyType() {
            return this.inputBodyType;
        }

        protected void setInputBodyType(Use use) {
            this.inputBodyType = use;
        }

        public Use getOutputBodyType() {
            return this.outputBodyType;
        }

        protected void setOutputBodyType(Use use) {
            this.outputBodyType = use;
        }

        public HashMap getFaultBodyTypeMap() {
            return this.faultBodyTypeMap;
        }

        protected void setFaultBodyTypeMap(HashMap hashMap) {
            this.faultBodyTypeMap = hashMap;
        }
    }
}

