/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.io.IOException;
import java.util.Map;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Use;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;

public class FaultInfo {
    private Message message;
    private QName xmlType;
    private Use use;
    private QName qName;
    private String name;

    public FaultInfo(Fault fault, Use use, String string, SymbolTable symbolTable) {
        this.message = fault.getMessage();
        this.xmlType = this.getFaultType(symbolTable, this.getFaultPart());
        this.use = use != null ? use : Use.LITERAL;
        this.name = fault.getName();
        Part part = this.getFaultPart();
        this.qName = part == null ? null : (part.getTypeName() != null ? new QName(string, part.getName()) : part.getElementName());
    }

    public FaultInfo(SOAPHeaderFault sOAPHeaderFault, SymbolTable symbolTable) throws IOException {
        MessageEntry messageEntry = symbolTable.getMessageEntry(sOAPHeaderFault.getMessage());
        if (messageEntry == null) {
            throw new IOException(Messages.getMessage("noMsg", sOAPHeaderFault.getMessage().toString()));
        }
        this.message = messageEntry.getMessage();
        Part part = this.message.getPart(sOAPHeaderFault.getPart());
        this.xmlType = this.getFaultType(symbolTable, part);
        this.use = Use.getUse(sOAPHeaderFault.getUse());
        this.qName = part == null ? null : (part.getTypeName() != null ? new QName(sOAPHeaderFault.getNamespaceURI(), part.getName()) : part.getElementName());
        this.name = this.qName.getLocalPart();
    }

    public FaultInfo(QName qName, String string, String string2, String string3, SymbolTable symbolTable) throws IOException {
        MessageEntry messageEntry = symbolTable.getMessageEntry(qName);
        if (messageEntry == null) {
            throw new IOException(Messages.getMessage("noMsg", qName.toString()));
        }
        this.message = messageEntry.getMessage();
        Part part = this.message.getPart(string);
        this.xmlType = this.getFaultType(symbolTable, part);
        this.use = Use.getUse(string2);
        this.qName = part == null ? null : (part.getTypeName() != null ? new QName(string3, part.getName()) : part.getElementName());
        this.name = this.qName.getLocalPart();
    }

    public Message getMessage() {
        return this.message;
    }

    public QName getXMLType() {
        return this.xmlType;
    }

    public Use getUse() {
        return this.use;
    }

    public QName getQName() {
        return this.qName;
    }

    public String getName() {
        return this.name;
    }

    private Part getFaultPart() {
        Map map = this.message.getParts();
        if (map.size() == 0) {
            return null;
        }
        return (Part)map.values().iterator().next();
    }

    private QName getFaultType(SymbolTable symbolTable, Part part) {
        if (part != null) {
            if (part.getTypeName() != null) {
                return part.getTypeName();
            }
            Element element = symbolTable.getElement(part.getElementName());
            if (element != null && element.getRefType() != null) {
                return element.getRefType().getQName();
            }
        }
        return null;
    }
}

