/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.QNameHolder;
import org.apache.axis.Constants;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.URLHashSet;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionElement;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.MimeInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Undefined;
import org.apache.axis.wsdl.symbolTable.UndefinedElement;
import org.apache.axis.wsdl.symbolTable.UndefinedType;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SymbolTable {
    protected HashMap derivedTypes = new HashMap();
    private boolean addImports;
    private HashMap symbolTable = new HashMap();
    private final Map elementTypeEntries = new HashMap();
    private final Map elementIndex = Collections.unmodifiableMap(this.elementTypeEntries);
    private final Map typeTypeEntries = new HashMap();
    private final Map typeIndex = Collections.unmodifiableMap(this.typeTypeEntries);
    protected final Map node2ExtensionBase = new HashMap();
    private boolean verbose;
    protected boolean quiet;
    private BaseTypeMapping btm = null;
    private boolean nowrap;
    private boolean wrapped = false;
    public static final String ANON_TOKEN = ">";
    private Definition def = null;
    private String wsdlURI = null;
    private boolean wrapArrays;
    Set arrayTypeQNames = new HashSet();
    private final Map elementFormDefaults = new HashMap();
    private URLHashSet importedFiles = new URLHashSet();
    private static final int ABOVE_SCHEMA_LEVEL = -1;
    private static final int SCHEMA_LEVEL = 0;

    public SymbolTable(BaseTypeMapping baseTypeMapping, boolean bl, boolean bl2, boolean bl3) {
        this.btm = baseTypeMapping;
        this.addImports = bl;
        this.verbose = bl2;
        this.nowrap = bl3;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public HashMap getHashMap() {
        return this.symbolTable;
    }

    public Vector getSymbols(QName qName) {
        return (Vector)this.symbolTable.get(qName);
    }

    public SymTabEntry get(QName qName, Class clazz) {
        Vector vector = (Vector)this.symbolTable.get(qName);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
            if (!clazz.isInstance(symTabEntry)) continue;
            return symTabEntry;
        }
        return null;
    }

    public TypeEntry getTypeEntry(QName qName, boolean bl) {
        if (bl) {
            return this.getElement(qName);
        }
        return this.getType(qName);
    }

    public Type getType(QName qName) {
        return (Type)this.typeTypeEntries.get(qName);
    }

    public Element getElement(QName qName) {
        return (Element)this.elementTypeEntries.get(qName);
    }

    public MessageEntry getMessageEntry(QName qName) {
        return (MessageEntry)this.get(qName, MessageEntry.class);
    }

    public PortTypeEntry getPortTypeEntry(QName qName) {
        return (PortTypeEntry)this.get(qName, PortTypeEntry.class);
    }

    public BindingEntry getBindingEntry(QName qName) {
        return (BindingEntry)this.get(qName, BindingEntry.class);
    }

    public ServiceEntry getServiceEntry(QName qName) {
        return (ServiceEntry)this.get(qName, ServiceEntry.class);
    }

    public Vector getTypes() {
        Vector vector = new Vector();
        vector.addAll(this.elementTypeEntries.values());
        vector.addAll(this.typeTypeEntries.values());
        return vector;
    }

    public Map getElementIndex() {
        return this.elementIndex;
    }

    public Map getTypeIndex() {
        return this.typeIndex;
    }

    public int getTypeEntryCount() {
        return this.elementTypeEntries.size() + this.typeTypeEntries.size();
    }

    public Definition getDefinition() {
        return this.def;
    }

    public String getWSDLURI() {
        return this.wsdlURI;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean bl) {
        this.wrapped = bl;
    }

    public void dump(PrintStream printStream) {
        printStream.println();
        printStream.println(Messages.getMessage("symbolTable00"));
        printStream.println("-----------------------");
        for (Vector vector : this.symbolTable.values()) {
            for (int i = 0; i < vector.size(); ++i) {
                printStream.println(vector.elementAt(i).getClass().getName());
                printStream.println(vector.elementAt(i));
            }
        }
        printStream.println("-----------------------");
    }

    public void populate(String string) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.populate(string, null, null);
    }

    public void populate(String string, String string2, String string3) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (this.verbose) {
            System.out.println(Messages.getMessage("parsing00", string));
        }
        Document document = XMLUtils.newDocument(string, string2, string3);
        this.wsdlURI = string;
        try {
            File file = new File(string);
            if (file.exists()) {
                string = file.toURL().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.populate(string, document);
    }

    public void populate(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", this.verbose);
        this.def = wSDLReader.readWSDL(string, document);
        this.add(string, this.def, document);
    }

    protected void add(String string, Definition definition, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        URL uRL = string == null ? null : SymbolTable.getURL(null, string);
        this.populate(uRL, definition, document, null);
        this.processTypes();
        this.checkForUndefined();
        this.populateParameters();
        this.setReferences(definition, document);
    }

    private void checkForUndefined(Definition definition, String string) throws IOException {
        if (definition != null) {
            for (Object object : definition.getBindings().values()) {
                if (!object.isUndefined()) continue;
                if (string == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedBinding01", object.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedBinding02", object.getQName().getLocalPart(), string));
            }
            for (PortType portType : definition.getPortTypes().values()) {
                if (!portType.isUndefined()) continue;
                if (string == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedPort01", portType.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedPort02", portType.getQName().getLocalPart(), string));
            }
        }
    }

    private void checkForUndefined() throws IOException {
        for (Vector vector : this.symbolTable.values()) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.get(i);
                if (symTabEntry instanceof UndefinedType) {
                    QName qName = symTabEntry.getQName();
                    if (qName.getLocalPart().equals("dateTime") && !qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || qName.getLocalPart().equals("timeInstant") && qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        throw new IOException(Messages.getMessage("wrongNamespace00", qName.getLocalPart(), qName.getNamespaceURI()));
                    }
                    if (SchemaUtils.isSimpleSchemaType(qName)) {
                        throw new IOException(Messages.getMessage("unsupportedSchemaType00", qName.getLocalPart()));
                    }
                    throw new IOException(Messages.getMessage("undefined00", qName.toString()));
                }
                if (!(symTabEntry instanceof UndefinedElement)) continue;
                throw new IOException(Messages.getMessage("undefinedElem00", symTabEntry.getQName().toString()));
            }
        }
    }

    private void populate(URL uRL, Definition definition, Document document, String string) throws IOException, ParserConfigurationException, SAXException, WSDLException {
        if (document != null) {
            this.populateTypes(uRL, document);
            if (this.addImports) {
                this.lookForImports(uRL, document);
            }
        }
        if (definition != null) {
            this.checkForUndefined(definition, string);
            if (this.addImports) {
                Map map = definition.getImports();
                Object[] objectArray = map.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Vector vector = (Vector)map.get(objectArray[i]);
                    for (int j = 0; j < vector.size(); ++j) {
                        Import import_ = (Import)vector.get(j);
                        if (this.importedFiles.contains(import_.getLocationURI())) continue;
                        this.importedFiles.add(import_.getLocationURI());
                        URL uRL2 = SymbolTable.getURL(uRL, import_.getLocationURI());
                        this.populate(uRL2, import_.getDefinition(), XMLUtils.newDocument(uRL2.toString()), uRL2.toString());
                    }
                }
            }
            this.populateMessages(definition);
            this.populatePortTypes(definition);
            this.populateBindings(definition);
            this.populateServices(definition);
        }
    }

    private static URL getURL(URL uRL, String string) throws IOException {
        String string2 = string.replace('\\', '/');
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string2);
            if (uRL != null && uRL2.getProtocol().equals("file") && uRL.getProtocol().equals("file")) {
                uRL2 = SymbolTable.getFileURL(uRL, string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = SymbolTable.getFileURL(uRL, string2);
        }
        return uRL2;
    }

    private static URL getFileURL(URL uRL, String string) throws IOException {
        if (uRL != null) {
            String string2 = uRL.getFile();
            URL uRL2 = null;
            File file = new File(string2).getParentFile();
            if (file != null) {
                uRL2 = file.toURL();
            }
            if (uRL2 != null) {
                return new URL(uRL2, string);
            }
        }
        return new URL("file", "", string);
    }

    private void lookForImports(URL uRL, Node node) throws IOException, ParserConfigurationException, SAXException, WSDLException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("import".equals(node2.getLocalName())) {
                URL uRL2;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("namespace");
                if (node3 != null && this.isKnownNamespace(node3.getNodeValue())) continue;
                Node node4 = namedNodeMap.getNamedItem("schemaLocation");
                if (node4 != null && !this.importedFiles.contains(uRL2 = SymbolTable.getURL(uRL, node4.getNodeValue()))) {
                    this.importedFiles.add(uRL2);
                    String string = uRL2.toString();
                    this.populate(uRL2, null, XMLUtils.newDocument(string), string);
                }
            }
            this.lookForImports(uRL, node2);
        }
    }

    public boolean isKnownNamespace(String string) {
        if (Constants.isSOAP_ENC(string)) {
            return true;
        }
        if (Constants.isSchemaXSD(string)) {
            return true;
        }
        if (Constants.isSchemaXSI(string)) {
            return true;
        }
        return string.equals("http://www.w3.org/XML/1998/namespace");
    }

    public void populateTypes(URL uRL, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.addTypes(uRL, document, -1);
    }

    private void addTypes(URL uRL, Node node, int n) throws IOException, ParserConfigurationException, WSDLException, SAXException {
        Object object;
        if (node == null) {
            return;
        }
        String string = node.getLocalName();
        if (string != null) {
            Object object2;
            Object object3;
            Object object4;
            boolean bl = Constants.isSchemaXSD(node.getNamespaceURI());
            if (bl && string.equals("complexType") || string.equals("simpleType")) {
                object = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (object != null && Utils.getAttribute((Node)object, "base") != null) {
                    this.createTypeFromRef((Node)object);
                }
                if ((object4 = SchemaUtils.getListNode(node)) != null && Utils.getAttribute((Node)object4, "itemType") != null) {
                    this.createTypeFromRef((Node)object4);
                }
                if ((object3 = SchemaUtils.getUnionNode(node)) != null && (object2 = Utils.getMemberTypeQNames((Node)object3)) != null) {
                    for (int i = 0; i < ((QName[])object2).length; ++i) {
                        if (!SchemaUtils.isSimpleSchemaType(object2[i]) || this.getType(object2[i]) != null) continue;
                        this.symbolTablePut(new BaseType((QName)object2[i]));
                    }
                }
                this.createTypeFromDef(node, false, false);
            } else if (bl && string.equals("element")) {
                this.createTypeFromRef(node);
                object = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (object != null && Utils.getAttribute((Node)object, "base") != null) {
                    this.createTypeFromRef((Node)object);
                }
                this.createTypeFromDef(node, true, n > 0);
            } else if (bl && string.equals("attributeGroup")) {
                this.createTypeFromRef(node);
                this.createTypeFromDef(node, false, n > 0);
            } else if (bl && string.equals("group")) {
                this.createTypeFromRef(node);
                this.createTypeFromDef(node, false, n > 0);
            } else if (bl && string.equals("attribute")) {
                object = new BooleanHolder();
                object4 = Utils.getTypeQName(node, (BooleanHolder)object, false);
                if (object4 != null && !((BooleanHolder)object).value) {
                    this.createTypeFromRef(node);
                    if (object4 != null) {
                        object3 = this.getTypeEntry((QName)object4, false);
                        if (object3 != null && object3 instanceof Undefined) {
                            ((TypeEntry)object3).setSimpleType(true);
                        } else if (object3 == null || !(object3 instanceof BaseType) && !((TypeEntry)object3).isSimpleType()) {
                            throw new IOException(Messages.getMessage("AttrNotSimpleType01", ((QName)object4).toString()));
                        }
                    }
                }
                this.createTypeFromDef(node, true, n > 0);
            } else if (bl && string.equals("any")) {
                if (this.getType(Constants.XSD_ANY) == null) {
                    object = new BaseType(Constants.XSD_ANY);
                    this.symbolTablePut((SymTabEntry)object);
                }
            } else if (string.equals("part") && Constants.isWSDL(node.getNamespaceURI())) {
                this.createTypeFromRef(node);
            } else if (bl && string.equals("include") && (object = Utils.getAttribute(node, "schemaLocation")) != null) {
                org.w3c.dom.Element element;
                object4 = SymbolTable.getURL(uRL, (String)object);
                object3 = XMLUtils.newDocument(((URL)object4).toString());
                object2 = object3.getDocumentElement();
                if (!object2.hasAttribute("targetNamespace") && (element = (org.w3c.dom.Element)node.getParentNode()).hasAttribute("targetNamespace")) {
                    String string2 = element.getAttribute("targetNamespace");
                    object2.setAttribute("targetNamespace", string2);
                    object2.setAttribute("xmlns", string2);
                }
                this.populate((URL)object4, null, (Document)object3, ((URL)object4).toString());
            }
        }
        if (n == -1) {
            if (string != null && string.equals("schema")) {
                n = 0;
                String string3 = ((org.w3c.dom.Element)node).getAttribute("targetNamespace");
                object = ((org.w3c.dom.Element)node).getAttribute("elementFormDefault");
                if (string3 != null && string3.length() > 0) {
                    Object object5 = object = object == null || ((String)object).length() == 0 ? "unqualified" : object;
                    if (this.elementFormDefaults.get(string3) == null) {
                        this.elementFormDefaults.put(string3, object);
                    }
                }
            }
        } else {
            ++n;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.addTypes(uRL, nodeList.item(i), n);
        }
    }

    private void createTypeFromDef(Node node, boolean bl, boolean bl2) throws IOException {
        QName qName = Utils.getNodeNameQName(node);
        if (qName != null) {
            if (!bl && this.btm.getBaseName(qName) != null) {
                return;
            }
            BooleanHolder booleanHolder = new BooleanHolder();
            QName qName2 = Utils.getTypeQName(node, booleanHolder, false);
            if (qName2 != null) {
                if (qName.getLocalPart().length() == 0) {
                    String string = Utils.getAttribute(node, "name");
                    if (string == null) {
                        string = "unknown";
                    }
                    throw new IOException(Messages.getMessage("emptyref00", string));
                }
                TypeEntry typeEntry = this.getTypeEntry(qName2, booleanHolder.value);
                if (!bl2) {
                    if (typeEntry == null) {
                        throw new IOException(Messages.getMessage("absentRef00", qName2.toString(), qName.toString()));
                    }
                    this.symbolTablePut(new DefinedElement(qName, typeEntry, node, ""));
                }
            } else {
                IntHolder intHolder = new IntHolder();
                BooleanHolder booleanHolder2 = new BooleanHolder();
                QNameHolder qNameHolder = this.wrapArrays ? null : new QNameHolder();
                intHolder.value = 0;
                QName qName3 = SchemaUtils.getArrayComponentQName(node, intHolder, booleanHolder2, qNameHolder, this);
                if (qName3 != null) {
                    String string;
                    qName2 = qName3;
                    TypeEntry typeEntry = this.getTypeEntry(qName2, false);
                    if (typeEntry == null) {
                        string = this.btm.getBaseName(qName2);
                        typeEntry = string != null ? new BaseType(qName2) : new UndefinedType(qName2);
                        this.symbolTablePut(typeEntry);
                    }
                    string = "";
                    while (intHolder.value > 0) {
                        string = string + "[]";
                        --intHolder.value;
                    }
                    TypeEntry typeEntry2 = null;
                    if (bl) {
                        if (!bl2) {
                            typeEntry2 = new DefinedElement(qName, typeEntry, node, string);
                            typeEntry2.setComponentType(qName3);
                            if (qNameHolder != null) {
                                typeEntry2.setItemQName(qNameHolder.value);
                            }
                        }
                    } else {
                        typeEntry2 = new DefinedType(qName, typeEntry, node, string);
                        typeEntry2.setComponentType(qName3);
                        typeEntry2.setUnderlTypeNillable(booleanHolder2.value);
                        if (qNameHolder != null) {
                            typeEntry2.setItemQName(qNameHolder.value);
                        }
                    }
                    if (typeEntry2 != null) {
                        this.symbolTablePut(typeEntry2);
                    }
                } else {
                    String string = this.btm.getBaseName(qName);
                    if (string != null) {
                        this.symbolTablePut(new BaseType(qName));
                    } else {
                        TypeEntry typeEntry = null;
                        TypeEntry typeEntry3 = null;
                        if (!bl) {
                            typeEntry = new DefinedType(qName, node);
                            if (qName.getLocalPart().indexOf(ANON_TOKEN) >= 0) {
                                Node node2 = node.getParentNode();
                                QName qName4 = Utils.getNodeNameQName(node2);
                                typeEntry3 = this.getElement(qName4);
                            }
                        } else if (!bl2) {
                            typeEntry = new DefinedElement(qName, node);
                        }
                        if (typeEntry != null) {
                            if (SchemaUtils.isSimpleTypeOrSimpleContent(node)) {
                                typeEntry.setSimpleType(true);
                            }
                            typeEntry = (TypeEntry)this.symbolTablePut(typeEntry);
                            if (typeEntry3 != null) {
                                typeEntry3.setRefType(typeEntry);
                            }
                        }
                    }
                }
            }
        }
    }

    private void createTypeFromRef(Node node) throws IOException {
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName = Utils.getTypeQName(node, booleanHolder, false);
        if (qName == null || Constants.isSchemaXSD(qName.getNamespaceURI()) && qName.getLocalPart().equals("simpleRestrictionModel")) {
            return;
        }
        if (qName.getLocalPart().length() == 0) {
            String string = Utils.getAttribute(node, "name");
            if (string == null) {
                string = "unknown";
            }
            throw new IOException(Messages.getMessage("emptyref00", string));
        }
        TypeEntry typeEntry = this.getTypeEntry(qName, booleanHolder.value);
        if (typeEntry == null) {
            if (qName.getLocalPart().indexOf("[") > 0) {
                QName qName2 = Utils.getTypeQName(node, booleanHolder, true);
                TypeEntry typeEntry2 = this.getTypeEntry(qName2, booleanHolder.value);
                if (!booleanHolder.value) {
                    if (typeEntry2 == null) {
                        String string = this.btm.getBaseName(qName2);
                        typeEntry2 = string != null ? new BaseType(qName2) : new UndefinedType(qName2);
                        this.symbolTablePut(typeEntry2);
                    }
                    this.symbolTablePut(new CollectionType(qName, typeEntry2, node, "[]"));
                } else {
                    if (typeEntry2 == null) {
                        typeEntry2 = new UndefinedElement(qName2);
                        this.symbolTablePut(typeEntry2);
                    }
                    this.symbolTablePut(new CollectionElement(qName, typeEntry2, node, "[]"));
                }
            } else {
                String string = this.btm.getBaseName(qName);
                if (string != null) {
                    this.symbolTablePut(new BaseType(qName));
                } else if (qName.equals(Constants.SOAP_COMMON_ATTRS11)) {
                    this.symbolTablePut(new BaseType(qName));
                    if (this.getTypeEntry(Constants.XSD_ID, false) == null) {
                        this.symbolTablePut(new BaseType(Constants.XSD_ID));
                    }
                    if (this.getTypeEntry(Constants.XSD_ANYURI, false) == null) {
                        this.symbolTablePut(new BaseType(Constants.XSD_ANYURI));
                    }
                } else if (qName.equals(Constants.SOAP_COMMON_ATTRS12)) {
                    this.symbolTablePut(new BaseType(qName));
                    if (this.getTypeEntry(Constants.XSD_ID, false) == null) {
                        this.symbolTablePut(new BaseType(Constants.XSD_ID));
                    }
                } else if (qName.equals(Constants.SOAP_ARRAY_ATTRS11)) {
                    this.symbolTablePut(new BaseType(qName));
                    if (this.getTypeEntry(Constants.XSD_STRING, false) == null) {
                        this.symbolTablePut(new BaseType(Constants.XSD_STRING));
                    }
                } else if (qName.equals(Constants.SOAP_ARRAY_ATTRS12)) {
                    this.symbolTablePut(new BaseType(qName));
                    if (this.getTypeEntry(Constants.XSD_STRING, false) == null) {
                        this.symbolTablePut(new BaseType(Constants.XSD_STRING));
                    }
                    if (this.getTypeEntry(Constants.XSD_QNAME, false) == null) {
                        this.symbolTablePut(new BaseType(Constants.XSD_QNAME));
                    }
                } else if (!booleanHolder.value) {
                    this.symbolTablePut(new UndefinedType(qName));
                } else {
                    this.symbolTablePut(new UndefinedElement(qName));
                }
            }
        }
    }

    private void populateMessages(Definition definition) throws IOException {
        for (Message message : definition.getMessages().values()) {
            MessageEntry messageEntry = new MessageEntry(message);
            this.symbolTablePut(messageEntry);
        }
    }

    protected void ensureOperationMessageValid(Message message) throws IOException {
        if (message == null) {
            throw new IOException("<input>,<output>, or <fault> in <operation ..> without attribute 'message' found. Attribute 'message' is required.");
        }
        if (message.isUndefined()) {
            throw new IOException("<input ..>, <output ..> or <fault ..> in <portType> with undefined message found. message name is '" + message.getQName().toString() + "'");
        }
    }

    protected void ensureOperationValid(Operation operation) throws IOException {
        Map map;
        Output output;
        Message message;
        if (operation == null) {
            throw new IllegalArgumentException("parameter 'operation' must not be null");
        }
        Input input = operation.getInput();
        if (input != null) {
            message = input.getMessage();
            if (message == null) {
                throw new IOException("No 'message' attribute in <input> for operation '" + operation.getName() + "'");
            }
            this.ensureOperationMessageValid(message);
        }
        if ((output = operation.getOutput()) != null) {
            message = output.getMessage();
            if (message == null) {
                throw new IOException("No 'message' attribute in <output> for operation '" + operation.getName() + "'");
            }
            this.ensureOperationMessageValid(output.getMessage());
        }
        if ((map = operation.getFaults()) != null) {
            for (Fault fault : map.values()) {
                message = fault.getMessage();
                if (message == null) {
                    throw new IOException("No 'message' attribute in <fault> named '" + fault.getName() + "' for operation '" + operation.getName() + "'");
                }
                this.ensureOperationMessageValid(message);
            }
        }
    }

    protected void ensureOperationsOfPortTypeValid(PortType portType) throws IOException {
        if (portType == null) {
            throw new IllegalArgumentException("parameter 'portType' must not be null");
        }
        List list = portType.getOperations();
        if (list == null || list.size() == 0) {
            return;
        }
        for (Operation operation : list) {
            this.ensureOperationValid(operation);
        }
    }

    private void populatePortTypes(Definition definition) throws IOException {
        for (PortType portType : definition.getPortTypes().values()) {
            if (portType.isUndefined()) continue;
            this.ensureOperationsOfPortTypeValid(portType);
            PortTypeEntry portTypeEntry = new PortTypeEntry(portType);
            this.symbolTablePut(portTypeEntry);
        }
    }

    private void populateParameters() throws IOException {
        for (Vector vector : this.symbolTable.values()) {
            for (int i = 0; i < vector.size(); ++i) {
                BindingEntry bindingEntry;
                if (!(vector.get(i) instanceof BindingEntry) || (bindingEntry = (BindingEntry)vector.get(i)).getBindingType() != 0) continue;
                Binding binding = bindingEntry.getBinding();
                Set set = bindingEntry.getOperations();
                PortType portType = binding.getPortType();
                HashMap<Operation, Parameters> hashMap = new HashMap<Operation, Parameters>();
                for (Operation operation : portType.getOperations()) {
                    if (!set.contains(operation)) {
                        throw new IOException(Messages.getMessage("emitFailNoMatchingBindOperation01", operation.getName(), portType.getQName().getLocalPart()));
                    }
                    String string = portType.getQName().getNamespaceURI();
                    Parameters parameters = this.getOperationParameters(operation, string, bindingEntry);
                    hashMap.put(operation, parameters);
                }
                bindingEntry.setParameters(hashMap);
            }
        }
    }

    public Parameters getOperationParameters(Operation operation, String string, BindingEntry bindingEntry) throws IOException {
        int n;
        int n2;
        Iterator iterator;
        Vector<String> vector;
        Parameters parameters = new Parameters();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        List list = operation.getParameterOrdering();
        if (list != null && list.isEmpty()) {
            list = null;
        }
        Input input = operation.getInput();
        Output output = operation.getOutput();
        parameters.mep = operation.getStyle();
        if (list != null && !this.wrapped && input != null) {
            Message message = input.getMessage();
            Map map = message.getParts();
            vector = message.getOrderedParts(list);
            if (map.size() != vector.size()) {
                throw new IOException(Messages.getMessage("emitFail00", operation.getName()));
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        if (bindingEntry != null) {
            bl = bindingEntry.getInputBodyType(operation) == Use.LITERAL;
            boolean bl3 = bl2 = bindingEntry.getOutputBodyType(operation) == Use.LITERAL;
        }
        if (input != null && input.getMessage() != null) {
            this.getParametersFromParts(vector2, input.getMessage().getOrderedParts(null), bl, operation.getName(), bindingEntry);
        }
        if (output != null && output.getMessage() != null) {
            this.getParametersFromParts(vector3, output.getMessage().getOrderedParts(null), bl2, operation.getName(), bindingEntry);
        }
        if (list != null && !this.wrapped) {
            for (int i = 0; i < list.size(); ++i) {
                iterator = (String)list.get(i);
                n2 = this.getPartIndex((String)((Object)iterator), vector2);
                n = this.getPartIndex((String)((Object)iterator), vector3);
                if (n2 >= 0) {
                    this.addInishParm(vector2, vector3, n2, n, parameters, true);
                    continue;
                }
                if (n >= 0) {
                    this.addOutParm(vector3, n, parameters, true);
                    continue;
                }
                System.err.println(Messages.getMessage("noPart00", (String)((Object)iterator)));
            }
        }
        if (this.wrapped && vector2.size() == 1 && vector3.size() == 1 && Utils.getLastLocalPart(((Parameter)vector2.get(0)).getName()).equals(Utils.getLastLocalPart(((Parameter)vector3.get(0)).getName()))) {
            this.addInishParm(vector2, null, 0, -1, parameters, false);
        } else {
            for (int i = 0; i < vector2.size(); ++i) {
                iterator = (Parameter)vector2.get(i);
                n2 = this.getPartIndex(((Parameter)((Object)iterator)).getName(), vector3);
                this.addInishParm(vector2, vector3, i, n2, parameters, false);
            }
        }
        if (vector3.size() == 1) {
            parameters.returnParam = (Parameter)vector3.get(0);
            parameters.returnParam.setMode((byte)2);
            if (parameters.returnParam.getType() instanceof DefinedElement) {
                parameters.returnParam.setQName(parameters.returnParam.getType().getQName());
            }
            ++parameters.outputs;
        } else {
            for (int i = 0; i < vector3.size(); ++i) {
                this.addOutParm(vector3, i, parameters, false);
            }
        }
        parameters.faults = operation.getFaults();
        vector = new Vector<String>(parameters.list.size());
        for (Parameter parameter : parameters.list) {
            n = 2;
            while (vector.contains(parameter.getName())) {
                parameter.setName(parameter.getName() + Integer.toString(n++));
            }
            vector.add(parameter.getName());
        }
        return parameters;
    }

    private int getPartIndex(String string, Vector vector) {
        string = Utils.getLastLocalPart(string);
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = ((Parameter)vector.get(i)).getName();
            if (!string.equals(string2 = Utils.getLastLocalPart(string2))) continue;
            return i;
        }
        return -1;
    }

    private void addInishParm(Vector vector, Vector vector2, int n, int n2, Parameters parameters, boolean bl) {
        Object object;
        Parameter parameter = (Parameter)vector.get(n);
        if (parameter.getType() instanceof DefinedElement) {
            object = (DefinedElement)parameter.getType();
            parameter.setQName(((SymTabEntry)object).getQName());
        }
        if (parameter.getType() instanceof CollectionElement) {
            parameter.setQName(parameter.getType().getRefType().getQName());
        }
        if (bl) {
            vector.remove(n);
        }
        if (n2 >= 0) {
            TypeEntry typeEntry;
            object = (Parameter)vector2.get(n2);
            TypeEntry typeEntry2 = parameter.getType();
            if (typeEntry2.equals(typeEntry = ((Parameter)object).getType())) {
                vector2.remove(n2);
                parameter.setMode((byte)3);
                ++parameters.inouts;
            } else {
                ++parameters.inputs;
            }
        } else {
            ++parameters.inputs;
        }
        parameters.list.add(parameter);
    }

    private void addOutParm(Vector vector, int n, Parameters parameters, boolean bl) {
        Parameter parameter = (Parameter)vector.get(n);
        if (parameter.getType() instanceof DefinedElement) {
            DefinedElement definedElement = (DefinedElement)parameter.getType();
            parameter.setQName(definedElement.getQName());
        }
        if (parameter.getType() instanceof CollectionElement) {
            parameter.setQName(parameter.getType().getRefType().getQName());
        }
        if (bl) {
            vector.remove(n);
        }
        parameter.setMode((byte)2);
        ++parameters.outputs;
        parameters.list.add(parameter);
    }

    public void getParametersFromParts(Vector vector, Collection collection, boolean bl, String string, BindingEntry bindingEntry) throws IOException {
        int n = 0;
        boolean bl2 = false;
        for (Object object2 : collection) {
            if (object2.getElementName() == null) continue;
            ++n;
            if (!object2.getElementName().getLocalPart().equals(string)) continue;
            bl2 = true;
        }
        if (!this.nowrap && bl && n == 1 && bl2) {
            this.wrapped = true;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            object2 = new Parameter();
            Part part = (Part)iterator.next();
            QName qName = part.getElementName();
            QName qName2 = part.getTypeName();
            String string2 = part.getName();
            if (!bl || !this.wrapped || qName == null) {
                ((Parameter)object2).setName(string2);
                if (qName2 != null) {
                    ((Parameter)object2).setType(this.getType(qName2));
                } else if (qName != null) {
                    ((Parameter)object2).setType(this.getElement(qName));
                } else {
                    throw new IOException(Messages.getMessage("noTypeOrElement00", new String[]{string2, string}));
                }
                this.fillParamInfo((Parameter)object2, bindingEntry, string, string2);
                vector.add(object2);
                continue;
            }
            Node node = null;
            TypeEntry typeEntry = null;
            if (qName2 != null && (bindingEntry == null || bindingEntry.getMIMETypes().size() == 0)) {
                object = bindingEntry == null ? "unknown" : bindingEntry.getBinding().getQName().toString();
                throw new IOException(Messages.getMessage("literalTypePart00", new String[]{string2, string, object}));
            }
            typeEntry = this.getTypeEntry(qName, true);
            node = typeEntry.getNode();
            QName qName3 = Utils.getTypeQName(node, (BooleanHolder)(object = new BooleanHolder()), false);
            if (qName3 != null && !((BooleanHolder)object).value) {
                typeEntry = this.getTypeEntry(qName3, false);
                node = typeEntry.getNode();
            }
            Vector vector2 = null;
            if (node == null) {
                this.wrapped = false;
            } else {
                if (typeEntry.getContainedAttributes() != null) {
                    this.wrapped = false;
                }
                if (!SchemaUtils.isWrappedType(node)) {
                    typeEntry.setOnlyLiteralReference(false);
                    this.wrapped = false;
                }
                vector2 = typeEntry.getContainedElements();
            }
            if (vector2 != null && this.wrapped) {
                for (int i = 0; i < vector2.size(); ++i) {
                    ElementDecl elementDecl = (ElementDecl)vector2.elementAt(i);
                    Parameter parameter = new Parameter();
                    parameter.setQName(elementDecl.getQName());
                    String string3 = parameter.getName();
                    int n2 = string3.lastIndexOf(ANON_TOKEN);
                    if (n2 != 1) {
                        string3 = string3.substring(n2 + 1);
                    }
                    parameter.setName(string3);
                    parameter.setType(elementDecl.getType());
                    parameter.setOmittable(elementDecl.getMinOccursIs0());
                    this.fillParamInfo(parameter, bindingEntry, string, string2);
                    vector.add(parameter);
                }
                continue;
            }
            ((Parameter)object2).setName(string2);
            if (qName2 != null) {
                ((Parameter)object2).setType(this.getType(qName2));
            } else if (qName != null) {
                ((Parameter)object2).setType(this.getElement(qName));
            }
            this.fillParamInfo((Parameter)object2, bindingEntry, string, string2);
            vector.add(object2);
        }
    }

    private void fillParamInfo(Parameter parameter, BindingEntry bindingEntry, String string, String string2) {
        if (bindingEntry == null) {
            return;
        }
        this.setMIMEInfo(parameter, bindingEntry.getMIMEInfo(string, string2));
        boolean bl = false;
        if (bindingEntry.isInHeaderPart(string, string2)) {
            bl = true;
            parameter.setInHeader(true);
        }
        if (bindingEntry.isOutHeaderPart(string, string2)) {
            bl = true;
            parameter.setOutHeader(true);
        }
        if (bl && bindingEntry.getBinding() != null) {
            List list = bindingEntry.getBinding().getBindingOperations();
            for (int i = 0; list != null && i < list.size(); ++i) {
                QName qName;
                BindingOperation bindingOperation = (BindingOperation)list.get(i);
                if (!bindingOperation.getName().equals(string)) continue;
                if (parameter.isInHeader()) {
                    qName = this.getBindedParameterName(bindingOperation.getBindingInput().getExtensibilityElements(), parameter);
                    if (qName == null) continue;
                    parameter.setQName(qName);
                    continue;
                }
                if (!parameter.isOutHeader() || (qName = this.getBindedParameterName(bindingOperation.getBindingOutput().getExtensibilityElements(), parameter)) == null) continue;
                parameter.setQName(qName);
            }
        }
    }

    private QName getBindedParameterName(List list, Parameter parameter) {
        QName qName = null;
        String string = null;
        String string2 = parameter.getName();
        for (ExtensibilityElement extensibilityElement : list) {
            Object object;
            ExtensibilityElement extensibilityElement2;
            if (extensibilityElement instanceof SOAPBody) {
                extensibilityElement2 = (SOAPBody)extensibilityElement;
                object = extensibilityElement2.getParts();
                if (object == null || object.size() == 0) {
                    string = extensibilityElement2.getNamespaceURI();
                    continue;
                }
                boolean bl = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof String) || !string2.equals((String)e)) continue;
                    qName = new QName(extensibilityElement2.getNamespaceURI(), string2);
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (!(extensibilityElement instanceof SOAPHeader) || !string2.equals(object = (extensibilityElement2 = (SOAPHeader)extensibilityElement).getPart())) continue;
            qName = new QName(extensibilityElement2.getNamespaceURI(), string2);
            break;
        }
        if (qName == null && !parameter.isInHeader() && !parameter.isOutHeader()) {
            qName = string != null ? new QName(string, string2) : parameter.getQName();
        }
        return qName;
    }

    private void setMIMEInfo(Parameter parameter, MimeInfo mimeInfo) {
        QName qName;
        if (mimeInfo == null && parameter.getType() != null && (qName = parameter.getType().getQName()).getNamespaceURI().equals("http://xml.apache.org/xml-soap")) {
            if (Constants.MIME_IMAGE.equals(qName)) {
                mimeInfo = new MimeInfo("image/jpeg", "");
            } else if (Constants.MIME_PLAINTEXT.equals(qName)) {
                mimeInfo = new MimeInfo("text/plain", "");
            } else if (Constants.MIME_MULTIPART.equals(qName)) {
                mimeInfo = new MimeInfo("multipart/related", "");
            } else if (Constants.MIME_SOURCE.equals(qName)) {
                mimeInfo = new MimeInfo("text/xml", "");
            } else if (Constants.MIME_OCTETSTREAM.equals(qName)) {
                mimeInfo = new MimeInfo("application/octet-stream", "");
            }
        }
        parameter.setMIMEInfo(mimeInfo);
    }

    private void populateBindings(Definition definition) throws IOException {
        for (Binding binding : definition.getBindings().values()) {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            BindingEntry bindingEntry = new BindingEntry(binding);
            this.symbolTablePut(bindingEntry);
            for (Object object42 : binding.getExtensibilityElements()) {
                if (object42 instanceof SOAPBinding) {
                    bindingEntry.setBindingType(0);
                    object3 = (SOAPBinding)object42;
                    object2 = object3.getStyle();
                    if (!"rpc".equalsIgnoreCase((String)object2)) continue;
                    bindingEntry.setBindingStyle(Style.RPC);
                    continue;
                }
                if (object42 instanceof HTTPBinding) {
                    object3 = (HTTPBinding)object42;
                    if (object3.getVerb().equalsIgnoreCase("post")) {
                        bindingEntry.setBindingType(2);
                        continue;
                    }
                    bindingEntry.setBindingType(1);
                    continue;
                }
                if (!(object42 instanceof UnknownExtensibilityElement) || !((QName)(object2 = ((UnknownExtensibilityElement)(object3 = (UnknownExtensibilityElement)object42)).getElementType())).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !((QName)object2).getLocalPart().equals("binding")) continue;
                bindingEntry.setBindingType(0);
                object = ((UnknownExtensibilityElement)object3).getElement().getAttribute("style");
                if (!"rpc".equalsIgnoreCase((String)object)) continue;
                bindingEntry.setBindingStyle(Style.RPC);
            }
            object42 = new HashMap();
            object3 = binding.getBindingOperations();
            object2 = new HashMap();
            object = object3.iterator();
            while (object.hasNext()) {
                Object object5;
                String string;
                BindingOperation bindingOperation = (BindingOperation)object.next();
                Operation operation = bindingOperation.getOperation();
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                String string2 = bindingOperation.getName();
                String string3 = bindingInput == null ? null : bindingInput.getName();
                String string4 = string = bindingOutput == null ? null : bindingOutput.getName();
                if (binding.getPortType().getOperation(string2, string3, string) == null) {
                    throw new IOException(Messages.getMessage("unmatchedOp", new String[]{string2, string3, string}));
                }
                ArrayList arrayList = new ArrayList();
                if (bindingInput != null && bindingInput.getExtensibilityElements() != null) {
                    object5 = bindingInput.getExtensibilityElements().iterator();
                    this.fillInBindingInfo(bindingEntry, operation, (Iterator)object5, arrayList, true);
                }
                if (bindingOutput != null && bindingOutput.getExtensibilityElements() != null) {
                    object5 = bindingOutput.getExtensibilityElements().iterator();
                    this.fillInBindingInfo(bindingEntry, operation, (Iterator)object5, arrayList, false);
                }
                this.faultsFromSOAPFault(binding, bindingOperation, operation, arrayList);
                ((HashMap)object2).put(bindingOperation, arrayList);
                object5 = bindingEntry.getInputBodyType(operation);
                Use use = bindingEntry.getOutputBodyType(operation);
                ((HashMap)object42).put((Operation)bindingOperation.getOperation(), (BindingEntry.OperationAttr)new BindingEntry.OperationAttr((Use)object5, use, (HashMap)object2));
                if (object5 == Use.LITERAL || use == Use.LITERAL) {
                    bindingEntry.setHasLiteral(true);
                }
                bindingEntry.setFaultBodyTypeMap(operation, (HashMap)object2);
            }
            bindingEntry.setFaults((HashMap)object2);
        }
    }

    private void fillInBindingInfo(BindingEntry bindingEntry, Operation operation, Iterator iterator, ArrayList arrayList, boolean bl) throws IOException {
        while (iterator.hasNext()) {
            Object object2;
            ExtensibilityElement extensibilityElement;
            Object e = iterator.next();
            if (e instanceof SOAPBody) {
                this.setBodyType(((SOAPBody)e).getUse(), bindingEntry, operation, bl);
                continue;
            }
            if (e instanceof SOAPHeader) {
                extensibilityElement = (SOAPHeader)e;
                this.setBodyType(extensibilityElement.getUse(), bindingEntry, operation, bl);
                bindingEntry.setHeaderPart(operation.getName(), extensibilityElement.getPart(), bl ? 1 : 2);
                for (Object object2 : extensibilityElement.getSOAPHeaderFaults()) {
                    arrayList.add(new FaultInfo((SOAPHeaderFault)object2, this));
                }
                continue;
            }
            if (e instanceof MIMEMultipartRelated) {
                bindingEntry.setBodyType(operation, this.addMIMETypes(bindingEntry, (MIMEMultipartRelated)e, operation), bl);
                continue;
            }
            if (!(e instanceof UnknownExtensibilityElement)) continue;
            extensibilityElement = (UnknownExtensibilityElement)e;
            QName qName = ((UnknownExtensibilityElement)extensibilityElement).getElementType();
            if (qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2002/04/dime/wsdl/") && qName.getLocalPart().equals("message")) {
                this.fillInDIMEInformation((UnknownExtensibilityElement)extensibilityElement, bl, operation, bindingEntry);
            }
            if (qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") && qName.getLocalPart().equals("body")) {
                this.setBodyType(((UnknownExtensibilityElement)extensibilityElement).getElement().getAttribute("use"), bindingEntry, operation, bl);
            }
            if (!qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !qName.getLocalPart().equals("header")) continue;
            this.setBodyType(((UnknownExtensibilityElement)extensibilityElement).getElement().getAttribute("use"), bindingEntry, operation, bl);
            bindingEntry.setHeaderPart(operation.getName(), ((UnknownExtensibilityElement)extensibilityElement).getElement().getAttribute("part"), bl ? 1 : 2);
            object2 = ((UnknownExtensibilityElement)extensibilityElement).getElement().getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                String string = ((UnknownExtensibilityElement)extensibilityElement).getElement().getAttribute("message");
                String string2 = ((UnknownExtensibilityElement)extensibilityElement).getElement().getAttribute("part");
                String string3 = ((UnknownExtensibilityElement)extensibilityElement).getElement().getAttribute("use");
                String string4 = ((UnknownExtensibilityElement)extensibilityElement).getElement().getAttribute("namespace");
                QName qName2 = null;
                int n = string.indexOf(58);
                qName2 = n == -1 ? new QName(string) : new QName(string.substring(0, n), string.substring(n + 1));
                arrayList.add(new FaultInfo(qName2, string2, string3, string4, this));
            }
        }
    }

    private void fillInDIMEInformation(UnknownExtensibilityElement unknownExtensibilityElement, boolean bl, Operation operation, BindingEntry bindingEntry) {
        String string = unknownExtensibilityElement.getElement().getAttribute("layout");
        if (string.equals("http://schemas.xmlsoap.org/ws/2002/04/dime/closed-layout") || string.equals("http://schemas.xmlsoap.org/ws/2002/04/dime/open-layout")) {
            // empty if block
        }
        Map map = null;
        map = bl ? operation.getInput().getMessage().getParts() : operation.getOutput().getMessage().getParts();
        if (map != null) {
            for (Part part : map.values()) {
                Object object;
                Object object2;
                if (part == null) continue;
                String string2 = "";
                org.w3c.dom.Element element = null;
                if (part.getTypeName() != null) {
                    object2 = this.getType(part.getTypeName());
                    if (((TypeEntry)object2).getDimensions().length() > 0) {
                        string2 = ((TypeEntry)object2).getDimensions();
                        object2 = ((TypeEntry)object2).getRefType();
                    }
                    element = (org.w3c.dom.Element)((TypeEntry)object2).getNode();
                } else if (part.getElementName() != null) {
                    object2 = this.getElement(part.getElementName()).getRefType();
                    element = (org.w3c.dom.Element)((TypeEntry)object2).getNode();
                    object = SymbolTable.getInnerCollectionComponentQName(element);
                    if (object != null) {
                        string2 = string2 + "[]";
                        object2 = this.getType((QName)object);
                        element = (org.w3c.dom.Element)((TypeEntry)object2).getNode();
                    } else {
                        object = SymbolTable.getInnerTypeQName(element);
                        if (object != null) {
                            object2 = this.getType((QName)object);
                            element = (org.w3c.dom.Element)((TypeEntry)object2).getNode();
                        }
                    }
                }
                if (element == null || (object2 = (org.w3c.dom.Element)XMLUtils.findNode(element, new QName("http://schemas.xmlsoap.org/ws/2002/04/content-type/", "mediaType"))) == null) continue;
                object = object2.getAttribute("value");
                bindingEntry.setOperationDIME(operation.getName());
                bindingEntry.setMIMEInfo(operation.getName(), part.getName(), (String)object, string2);
            }
        }
    }

    private void faultsFromSOAPFault(Binding binding, BindingOperation bindingOperation, Operation operation, ArrayList arrayList) throws IOException {
        for (BindingFault bindingFault : bindingOperation.getBindingFaults().values()) {
            Object object2;
            String string = bindingFault.getName();
            if (string == null || string.length() == 0) {
                throw new IOException(Messages.getMessage("unNamedFault00", bindingOperation.getName(), binding.getQName().toString()));
            }
            boolean bl = false;
            String string2 = "";
            String string3 = "";
            for (Object object2 : bindingFault.getExtensibilityElements()) {
                UnknownExtensibilityElement unknownExtensibilityElement;
                QName qName;
                if (object2 instanceof SOAPFault) {
                    bl = true;
                    string2 = ((SOAPFault)object2).getUse();
                    string3 = ((SOAPFault)object2).getNamespaceURI();
                    break;
                }
                if (!(object2 instanceof UnknownExtensibilityElement) || !(qName = (unknownExtensibilityElement = (UnknownExtensibilityElement)object2).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !qName.getLocalPart().equals("fault")) continue;
                if (unknownExtensibilityElement.getElement().getAttribute("use") != null) {
                    string2 = unknownExtensibilityElement.getElement().getAttribute("use");
                }
                if (unknownExtensibilityElement.getElement().getAttribute("namespace") == null) continue;
                string3 = unknownExtensibilityElement.getElement().getAttribute("namespace");
            }
            if (!bl) {
                throw new IOException(Messages.getMessage("missingSoapFault00", string, bindingOperation.getName(), binding.getQName().toString()));
            }
            object2 = operation.getFault(bindingFault.getName());
            if (object2 == null) {
                throw new IOException(Messages.getMessage("noPortTypeFault", new String[]{bindingFault.getName(), bindingOperation.getName(), binding.getQName().toString()}));
            }
            arrayList.add(new FaultInfo((Fault)object2, Use.getUse(string2), string3, this));
        }
    }

    private void setBodyType(String string, BindingEntry bindingEntry, Operation operation, boolean bl) {
        if (string == null) {
            string = "literal";
        }
        if (string.equalsIgnoreCase("literal")) {
            bindingEntry.setBodyType(operation, Use.LITERAL, bl);
        }
    }

    private Use addMIMETypes(BindingEntry bindingEntry, MIMEMultipartRelated mIMEMultipartRelated, Operation operation) throws IOException {
        Use use = Use.ENCODED;
        List list = mIMEMultipartRelated.getMIMEParts();
        for (MIMEPart mIMEPart : list) {
            List list2 = mIMEPart.getExtensibilityElements();
            for (Object e : list2) {
                String string;
                Serializable serializable;
                Object object;
                if (e instanceof MIMEContent) {
                    Object object2;
                    object = (MIMEContent)e;
                    serializable = this.findPart(operation, object.getPart());
                    if (serializable == null) {
                        throw new RuntimeException(Messages.getMessage("cannotFindPartForOperation00", object.getPart(), operation.getName(), object.getType()));
                    }
                    string = ((TypeEntry)serializable).getDimensions();
                    if (string.length() <= 0 && ((TypeEntry)serializable).getRefType() != null && SymbolTable.getInnerCollectionComponentQName((Node)(object2 = ((TypeEntry)serializable).getRefType().getNode())) != null) {
                        string = string + "[]";
                    }
                    if ((object2 = object.getType()) == null || ((String)object2).length() == 0) {
                        object2 = "text/plain";
                    }
                    bindingEntry.setMIMEInfo(operation.getName(), object.getPart(), (String)object2, string);
                    continue;
                }
                if (e instanceof SOAPBody) {
                    object = ((SOAPBody)e).getUse();
                    if (object == null) {
                        throw new IOException(Messages.getMessage("noUse", operation.getName()));
                    }
                    if (!((String)object).equalsIgnoreCase("literal")) continue;
                    use = Use.LITERAL;
                    continue;
                }
                if (!(e instanceof UnknownExtensibilityElement) || !((QName)(serializable = ((UnknownExtensibilityElement)(object = (UnknownExtensibilityElement)e)).getElementType())).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !((QName)serializable).getLocalPart().equals("body")) continue;
                string = ((UnknownExtensibilityElement)object).getElement().getAttribute("use");
                if (string == null) {
                    throw new IOException(Messages.getMessage("noUse", operation.getName()));
                }
                if (!string.equalsIgnoreCase("literal")) continue;
                use = Use.LITERAL;
            }
        }
        return use;
    }

    private TypeEntry findPart(Operation operation, String string) {
        Map map = operation.getInput().getMessage().getParts();
        Iterator iterator = map.values().iterator();
        TypeEntry typeEntry = this.findPart(iterator, string);
        if (typeEntry == null) {
            map = operation.getOutput().getMessage().getParts();
            iterator = map.values().iterator();
            typeEntry = this.findPart(iterator, string);
        }
        return typeEntry;
    }

    private TypeEntry findPart(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            String string2;
            Part part = (Part)iterator.next();
            if (part == null || !string.equals(string2 = part.getName())) continue;
            if (part.getTypeName() != null) {
                return this.getType(part.getTypeName());
            }
            if (part.getElementName() == null) continue;
            return this.getElement(part.getElementName());
        }
        return null;
    }

    private void populateServices(Definition definition) throws IOException {
        for (Service service : definition.getServices().values()) {
            if (service.getQName() == null || service.getQName().getLocalPart() == null || service.getQName().getLocalPart().equals("")) {
                throw new IOException(Messages.getMessage("BadServiceName00"));
            }
            ServiceEntry serviceEntry = new ServiceEntry(service);
            this.symbolTablePut(serviceEntry);
            this.populatePorts(service.getPorts());
        }
    }

    private void populatePorts(Map map) throws IOException {
        if (map == null) {
            return;
        }
        for (Port port : map.values()) {
            String string = port.getName();
            Binding binding = port.getBinding();
            if (string == null) {
                throw new IOException(Messages.getMessage("missingPortNameException"));
            }
            if (binding == null) {
                throw new IOException(Messages.getMessage("missingBindingException"));
            }
            if (this.existsPortWithName(new QName(string))) {
                throw new IOException(Messages.getMessage("twoPortsWithSameName", string));
            }
            PortEntry portEntry = new PortEntry(port);
            this.symbolTablePut(portEntry);
        }
    }

    private void setReferences(Definition definition, Document document) {
        Map map = definition.getServices();
        if (map.isEmpty()) {
            map = definition.getBindings();
            if (map.isEmpty()) {
                map = definition.getPortTypes();
                if (map.isEmpty()) {
                    map = definition.getMessages();
                    if (map.isEmpty()) {
                        Iterator iterator = this.elementTypeEntries.values().iterator();
                        while (iterator.hasNext()) {
                            this.setTypeReferences((TypeEntry)iterator.next(), document, false);
                        }
                        iterator = this.typeTypeEntries.values().iterator();
                        while (iterator.hasNext()) {
                            this.setTypeReferences((TypeEntry)iterator.next(), document, false);
                        }
                    } else {
                        for (Message message : map.values()) {
                            MessageEntry messageEntry = this.getMessageEntry(message.getQName());
                            this.setMessageReferences(messageEntry, definition, document, false);
                        }
                    }
                } else {
                    for (PortType portType : map.values()) {
                        PortTypeEntry portTypeEntry = this.getPortTypeEntry(portType.getQName());
                        this.setPortTypeReferences(portTypeEntry, null, definition, document);
                    }
                }
            } else {
                for (Binding binding : map.values()) {
                    BindingEntry bindingEntry = this.getBindingEntry(binding.getQName());
                    this.setBindingReferences(bindingEntry, definition, document);
                }
            }
        } else {
            for (Service service : map.values()) {
                ServiceEntry serviceEntry = this.getServiceEntry(service.getQName());
                this.setServiceReferences(serviceEntry, definition, document);
            }
        }
    }

    private void setTypeReferences(TypeEntry typeEntry, Document document, boolean bl) {
        TypeEntry typeEntry2;
        Serializable serializable;
        Object object;
        Object object2;
        if (typeEntry.isReferenced() && !bl || typeEntry.isOnlyLiteralReferenced() && bl) {
            return;
        }
        if (this.wrapped) {
            if (!typeEntry.isReferenced() && bl) {
                typeEntry.setOnlyLiteralReference(true);
            } else if (typeEntry.isOnlyLiteralReferenced() && !bl) {
                typeEntry.setOnlyLiteralReference(false);
            }
        }
        Node node = typeEntry.getNode();
        if (this.addImports || node == null || node.getOwnerDocument() == document) {
            typeEntry.setIsReferenced(true);
            if (typeEntry instanceof DefinedElement) {
                object2 = new BooleanHolder();
                object = Utils.getTypeQName(node, (BooleanHolder)object2, false);
                if (object != null && (serializable = this.getTypeEntry((QName)object, ((BooleanHolder)object2).value)) != null) {
                    this.setTypeReferences((TypeEntry)serializable, document, bl);
                }
                if ((serializable = SchemaUtils.getElementAnonQName(typeEntry.getNode())) != null && (typeEntry2 = this.getType((QName)serializable)) != null) {
                    this.setTypeReferences(typeEntry2, document, bl);
                    return;
                }
            }
        }
        object2 = typeEntry.getNestedTypes(this, true);
        object = ((HashSet)object2).iterator();
        while (object.hasNext()) {
            serializable = (TypeEntry)object.next();
            typeEntry2 = typeEntry.getRefType();
            if (serializable == null) continue;
            if (typeEntry2 != null && !typeEntry2.equals(serializable) && ((TypeEntry)serializable).isOnlyLiteralReferenced()) {
                ((TypeEntry)serializable).setOnlyLiteralReference(false);
            }
            if (((SymTabEntry)((Object)serializable)).isReferenced() || serializable == typeEntry) continue;
            this.setTypeReferences((TypeEntry)serializable, document, false);
        }
    }

    private void setMessageReferences(MessageEntry messageEntry, Definition definition, Document document, boolean bl) {
        Message message = messageEntry.getMessage();
        if (this.addImports) {
            messageEntry.setIsReferenced(true);
        } else {
            Map map = definition.getMessages();
            if (map.containsValue(message)) {
                messageEntry.setIsReferenced(true);
            }
        }
        for (Part part : message.getParts().values()) {
            TypeEntry typeEntry = this.getType(part.getTypeName());
            if (typeEntry != null) {
                this.setTypeReferences(typeEntry, document, bl);
            }
            if ((typeEntry = this.getElement(part.getElementName())) == null) continue;
            this.setTypeReferences(typeEntry, document, bl);
            TypeEntry typeEntry2 = typeEntry.getRefType();
            if (typeEntry2 == null) continue;
            this.setTypeReferences(typeEntry2, document, bl);
        }
    }

    private void setPortTypeReferences(PortTypeEntry portTypeEntry, BindingEntry bindingEntry, Definition definition, Document document) {
        PortType portType = portTypeEntry.getPortType();
        if (this.addImports) {
            portTypeEntry.setIsReferenced(true);
        } else {
            Map map = definition.getPortTypes();
            if (map.containsValue(portType)) {
                portTypeEntry.setIsReferenced(true);
            }
        }
        for (Operation operation : portType.getOperations()) {
            Object object;
            Object object2;
            Input input = operation.getInput();
            Output output = operation.getOutput();
            boolean bl = false;
            boolean bl2 = false;
            if (bindingEntry != null) {
                bl = bindingEntry.getInputBodyType(operation) == Use.LITERAL;
                boolean bl3 = bl2 = bindingEntry.getOutputBodyType(operation) == Use.LITERAL;
            }
            if (input != null && (object2 = input.getMessage()) != null && (object = this.getMessageEntry(object2.getQName())) != null) {
                this.setMessageReferences((MessageEntry)object, definition, document, bl);
            }
            if (output != null && (object2 = output.getMessage()) != null && (object = this.getMessageEntry(object2.getQName())) != null) {
                this.setMessageReferences((MessageEntry)object, definition, document, bl2);
            }
            object2 = operation.getFaults().values().iterator();
            while (object2.hasNext()) {
                MessageEntry messageEntry;
                object = ((Fault)object2.next()).getMessage();
                if (object == null || (messageEntry = this.getMessageEntry(object.getQName())) == null) continue;
                this.setMessageReferences(messageEntry, definition, document, false);
            }
        }
    }

    private void setBindingReferences(BindingEntry bindingEntry, Definition definition, Document document) {
        if (bindingEntry.getBindingType() == 0) {
            Object object;
            Binding binding = bindingEntry.getBinding();
            if (this.addImports) {
                bindingEntry.setIsReferenced(true);
            } else {
                object = definition.getBindings();
                if (object.containsValue(binding)) {
                    bindingEntry.setIsReferenced(true);
                }
            }
            object = binding.getPortType();
            PortTypeEntry portTypeEntry = this.getPortTypeEntry(object.getQName());
            if (portTypeEntry != null) {
                this.setPortTypeReferences(portTypeEntry, bindingEntry, definition, document);
            }
        }
    }

    private void setServiceReferences(ServiceEntry serviceEntry, Definition definition, Document document) {
        Service service = serviceEntry.getService();
        if (this.addImports) {
            serviceEntry.setIsReferenced(true);
        } else {
            Map map = definition.getServices();
            if (map.containsValue(service)) {
                serviceEntry.setIsReferenced(true);
            }
        }
        for (Port port : service.getPorts().values()) {
            BindingEntry bindingEntry;
            Binding binding = port.getBinding();
            if (binding == null || (bindingEntry = this.getBindingEntry(binding.getQName())) == null) continue;
            this.setBindingReferences(bindingEntry, definition, document);
        }
    }

    private SymTabEntry symbolTablePut(SymTabEntry symTabEntry) throws IOException {
        QName qName = symTabEntry.getQName();
        SymTabEntry symTabEntry2 = this.get(qName, symTabEntry.getClass());
        if (symTabEntry2 == null) {
            symTabEntry2 = symTabEntry;
            if (symTabEntry instanceof Type && this.get(qName, UndefinedType.class) != null) {
                if (((TypeEntry)this.get(qName, UndefinedType.class)).isSimpleType() && !((TypeEntry)symTabEntry).isSimpleType()) {
                    throw new IOException(Messages.getMessage("AttrNotSimpleType01", qName.toString()));
                }
                Vector vector = (Vector)this.symbolTable.get(qName);
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (!(e instanceof UndefinedType)) continue;
                    vector.setElementAt(symTabEntry, i);
                    this.typeTypeEntries.put(qName, symTabEntry);
                    ((UndefinedType)e).update((Type)symTabEntry);
                }
            } else if (symTabEntry instanceof Element && this.get(qName, UndefinedElement.class) != null) {
                Vector vector = (Vector)this.symbolTable.get(qName);
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (!(e instanceof UndefinedElement)) continue;
                    vector.setElementAt(symTabEntry, i);
                    this.elementTypeEntries.put(qName, symTabEntry);
                    ((Undefined)e).update((Element)symTabEntry);
                }
            } else {
                Vector<SymTabEntry> vector = (Vector<SymTabEntry>)this.symbolTable.get(qName);
                if (vector == null) {
                    vector = new Vector<SymTabEntry>();
                    this.symbolTable.put(qName, vector);
                }
                vector.add(symTabEntry);
                if (symTabEntry instanceof Element) {
                    this.elementTypeEntries.put(qName, symTabEntry);
                } else if (symTabEntry instanceof Type) {
                    this.typeTypeEntries.put(qName, symTabEntry);
                }
            }
        } else if (!this.quiet) {
            System.out.println(Messages.getMessage("alreadyExists00", "" + qName));
        }
        return symTabEntry2;
    }

    protected boolean existsPortWithName(QName qName) {
        Vector vector = (Vector)this.symbolTable.get(qName);
        if (vector == null) {
            return false;
        }
        for (Object e : vector) {
            if (!(e instanceof PortEntry)) continue;
            return true;
        }
        return false;
    }

    private static QName getInnerCollectionComponentQName(Node node) {
        if (node == null) {
            return null;
        }
        QName qName = SchemaUtils.getCollectionComponentQName(node, new QNameHolder());
        if (qName != null) {
            return qName;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            qName = SymbolTable.getInnerCollectionComponentQName(nodeList.item(i));
            if (qName == null) continue;
            return qName;
        }
        return null;
    }

    private static QName getInnerTypeQName(Node node) {
        if (node == null) {
            return null;
        }
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName = Utils.getTypeQName(node, booleanHolder, true);
        if (qName != null) {
            return qName;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            qName = SymbolTable.getInnerTypeQName(nodeList.item(i));
            if (qName == null) continue;
            return qName;
        }
        return null;
    }

    protected void processTypes() {
        for (Type type : this.typeTypeEntries.values()) {
            Vector vector;
            Node node = type.getNode();
            Vector vector2 = SchemaUtils.getContainedAttributeTypes(node, this);
            if (vector2 != null) {
                type.setContainedAttributes(vector2);
            }
            if ((vector = SchemaUtils.getContainedElementDeclarations(node, this)) == null) continue;
            type.setContainedElements(vector);
        }
    }

    public List getMessageEntries() {
        ArrayList<SymTabEntry> arrayList = new ArrayList<SymTabEntry>();
        for (Vector vector : this.symbolTable.values()) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (!(symTabEntry instanceof MessageEntry)) continue;
                arrayList.add(symTabEntry);
            }
        }
        return arrayList;
    }

    public void setWrapArrays(boolean bl) {
        this.wrapArrays = bl;
    }

    public Map getElementFormDefaults() {
        return this.elementFormDefaults;
    }
}

