/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;
import org.apache.axis.wsdl.symbolTable.ContainedEntry;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    static final Map nsmap = new HashMap();

    static QName findQName(String string, String string2) {
        QName qName = null;
        HashMap<String, QName> hashMap = (HashMap<String, QName>)nsmap.get(string);
        if (null == hashMap) {
            hashMap = new HashMap<String, QName>();
            nsmap.put(string, hashMap);
            qName = new QName(string, string2);
            hashMap.put(string2, qName);
        } else {
            qName = (QName)hashMap.get(string2);
            if (null == qName) {
                qName = new QName(string, string2);
                hashMap.put(string2, qName);
            }
        }
        return qName;
    }

    public static String getScopedAttribute(Node node, String string) {
        if (node == null) {
            return null;
        }
        if (node.getAttributes() == null) {
            return Utils.getScopedAttribute(node.getParentNode(), string);
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return Utils.getScopedAttribute(node.getParentNode(), string);
    }

    public static String getAttribute(Node node, String string) {
        if (node == null || node.getAttributes() == null) {
            return null;
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static Vector getAttributesWithLocalName(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        if (node == null) {
            return vector;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2 == null || !node2.getLocalName().equals(string)) continue;
                vector.add(node2);
            }
        }
        return vector;
    }

    public static QName getNodeQName(Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getLocalName();
        if (string == null) {
            return null;
        }
        String string2 = node.getNamespaceURI();
        return Utils.findQName(string2, string);
    }

    public static QName getNodeNameQName(Node node) {
        Object object;
        if (node == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        string = Utils.getAttribute(node, "name");
        if (string == null && (object = Utils.getTypeQNameFromAttr(node, "ref")) != null) {
            string = ((QName)object).getLocalPart();
            string2 = ((QName)object).getNamespaceURI();
        }
        object = node.getParentNode();
        while (object != null) {
            String string3 = object.getLocalName();
            if (string3.equals("schema")) {
                object = null;
                continue;
            }
            if (string3.equals("element") || string3.equals("attribute")) {
                string = ">" + Utils.getNodeNameQName((Node)object).getLocalPart();
                object = null;
                continue;
            }
            if (string3.equals("complexType") || string3.equals("simpleType")) {
                string = Utils.getNodeNameQName((Node)object).getLocalPart() + ">" + string;
                object = null;
                continue;
            }
            object = object.getParentNode();
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = Utils.getScopedAttribute(node, "targetNamespace");
        }
        return Utils.findQName(string2, string);
    }

    public static QName getTypeQName(Node node, BooleanHolder booleanHolder, boolean bl) {
        String string;
        if (node == null) {
            return null;
        }
        booleanHolder.value = false;
        QName qName = Utils.getTypeQNameFromAttr(node, "type");
        if (qName == null) {
            string = node.getLocalName();
            if (!(string == null || string.equals("attributeGroup") || string.equals("group") || string.equals("list"))) {
                booleanHolder.value = true;
            }
            qName = Utils.getTypeQNameFromAttr(node, "ref");
        }
        if (qName == null) {
            qName = Utils.getTypeQNameFromAttr(node, "itemType");
        }
        if (!bl && qName != null) {
            string = Utils.getAttribute(node, "maxOccurs");
            String string2 = Utils.getAttribute(node, "minOccurs");
            if (string == null) {
                string = "1";
            }
            if (string2 == null) {
                string2 = "1";
            }
            if (!(string2.equals("0") && string.equals("1") || string.equals("1") && string2.equals("1"))) {
                String string3 = qName.getLocalPart();
                String string4 = "[";
                if (!string2.equals("1")) {
                    string4 = string4 + string2;
                }
                string4 = string4 + ",";
                if (!string.equals("1")) {
                    string4 = string4 + string;
                }
                string4 = string4 + "]";
                string3 = string3 + string4;
                qName = Utils.findQName(qName.getNamespaceURI(), string3);
            }
        }
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "element");
        }
        if (qName == null) {
            booleanHolder.value = false;
            qName = Utils.getTypeQNameFromAttr(node, "base");
        }
        return qName;
    }

    public static QName[] getMemberTypeQNames(Node node) {
        String string = Utils.getAttribute(node, "memberTypes");
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        QName[] qNameArray = new QName[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            qNameArray[n] = XMLUtils.getFullQNameFromString(string2, node);
            ++n;
        }
        return qNameArray;
    }

    private static QName getTypeQNameFromAttr(Node node, String string) {
        QName qName;
        if (node == null) {
            return null;
        }
        String string2 = Utils.getAttribute(node, string);
        if (string2 == null && string.equals("type") && Utils.getAttribute(node, "ref") == null && Utils.getAttribute(node, "base") == null && Utils.getAttribute(node, "element") == null) {
            qName = SchemaUtils.getElementAnonQName(node);
            if (qName == null) {
                qName = SchemaUtils.getAttributeAnonQName(node);
            }
            if (qName != null) {
                return qName;
            }
            String string3 = node.getLocalName();
            if (string3 != null && Constants.isSchemaXSD(node.getNamespaceURI()) && (string3.equals("element") || string3.equals("attribute"))) {
                return Constants.XSD_ANYTYPE;
            }
        }
        if (string2 == null) {
            return null;
        }
        qName = Utils.getQNameFromPrefixedName(node, string2);
        return qName;
    }

    public static QName getQNameFromPrefixedName(Node node, String string) {
        String string2 = string.substring(string.lastIndexOf(":") + 1);
        String string3 = null;
        string3 = string.length() == string2.length() ? Utils.getScopedAttribute(node, "xmlns") : Utils.getScopedAttribute(node, "xmlns:" + string.substring(0, string.lastIndexOf(":")));
        return Utils.findQName(string3, string2);
    }

    public static HashSet getDerivedTypes(TypeEntry typeEntry, SymbolTable symbolTable) {
        HashSet<SymTabEntry> hashSet = (HashSet<SymTabEntry>)symbolTable.derivedTypes.get(typeEntry);
        if (hashSet != null) {
            return hashSet;
        }
        hashSet = new HashSet<SymTabEntry>();
        symbolTable.derivedTypes.put(typeEntry, hashSet);
        if (typeEntry != null && typeEntry.getNode() != null) {
            Utils.getDerivedTypes(typeEntry, hashSet, symbolTable);
        } else if (typeEntry != null && Constants.isSchemaXSD(typeEntry.getQName().getNamespaceURI()) && (typeEntry.getQName().getLocalPart().equals("anyType") || typeEntry.getQName().getLocalPart().equals("any"))) {
            Collection collection = symbolTable.getTypeIndex().values();
            for (SymTabEntry symTabEntry : collection) {
                if (symTabEntry.getQName().getLocalPart().startsWith(">")) continue;
                hashSet.add(symTabEntry);
            }
        }
        return hashSet;
    }

    private static void getDerivedTypes(TypeEntry typeEntry, HashSet hashSet, SymbolTable symbolTable) {
        if (hashSet.size() == symbolTable.getTypeEntryCount()) {
            return;
        }
        for (Type type : symbolTable.getTypeIndex().values()) {
            if (!(type instanceof DefinedType) || type.getNode() == null || hashSet.contains(type) || ((DefinedType)type).getComplexTypeExtensionBase(symbolTable) != typeEntry) continue;
            hashSet.add(type);
            Utils.getDerivedTypes(type, hashSet, symbolTable);
        }
    }

    protected static HashSet getNestedTypes(TypeEntry typeEntry, SymbolTable symbolTable, boolean bl) {
        HashSet hashSet = new HashSet();
        Utils.getNestedTypes(typeEntry, hashSet, symbolTable, bl);
        return hashSet;
    }

    private static void getNestedTypes(TypeEntry typeEntry, HashSet hashSet, SymbolTable symbolTable, boolean bl) {
        TypeEntry typeEntry2;
        ContainedEntry containedEntry;
        Object object;
        Object object2;
        if (typeEntry == null) {
            return;
        }
        if (hashSet.size() == symbolTable.getTypeEntryCount()) {
            return;
        }
        if (bl) {
            object2 = Utils.getDerivedTypes(typeEntry, symbolTable);
            object = ((HashSet)object2).iterator();
            while (object.hasNext()) {
                TypeEntry typeEntry3 = (TypeEntry)object.next();
                if (hashSet.contains(typeEntry3)) continue;
                hashSet.add(typeEntry3);
                Utils.getNestedTypes(typeEntry3, hashSet, symbolTable, bl);
            }
        }
        if (typeEntry.getNode() == null) {
            return;
        }
        object2 = typeEntry.getNode();
        object = SchemaUtils.getContainedElementDeclarations((Node)object2, symbolTable);
        if (object != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                containedEntry = (ElementDecl)((Vector)object).get(i);
                if (hashSet.contains(containedEntry.getType())) continue;
                hashSet.add(containedEntry.getType());
                Utils.getNestedTypes(containedEntry.getType(), hashSet, symbolTable, bl);
            }
        }
        if ((object = SchemaUtils.getContainedAttributeTypes((Node)object2, symbolTable)) != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                containedEntry = (ContainedAttribute)((Vector)object).get(i);
                TypeEntry typeEntry4 = containedEntry.getType();
                if (hashSet.contains(typeEntry4)) continue;
                hashSet.add(typeEntry4);
                Utils.getNestedTypes(typeEntry4, hashSet, symbolTable, bl);
            }
        }
        if (typeEntry.getRefType() != null && !hashSet.contains(typeEntry.getRefType())) {
            hashSet.add(typeEntry.getRefType());
            Utils.getNestedTypes(typeEntry.getRefType(), hashSet, symbolTable, bl);
        }
        if ((typeEntry2 = SchemaUtils.getComplexElementExtensionBase((Node)object2, symbolTable)) != null && !hashSet.contains(typeEntry2)) {
            hashSet.add(typeEntry2);
            Utils.getNestedTypes(typeEntry2, hashSet, symbolTable, bl);
        }
    }

    public static String genQNameAttributeString(QName qName, String string) {
        if (qName.getNamespaceURI() == null || qName.getNamespaceURI().equals("")) {
            return qName.getLocalPart();
        }
        return string + ":" + qName.getLocalPart() + "\" xmlns:" + string + "=\"" + qName.getNamespaceURI();
    }

    public static String genQNameAttributeStringWithLastLocalPart(QName qName, String string) {
        String string2 = Utils.getLastLocalPart(qName.getLocalPart());
        if (qName.getNamespaceURI() == null || qName.getNamespaceURI().equals("")) {
            return string2;
        }
        return string + ":" + string2 + "\" xmlns:" + string + "=\"" + qName.getNamespaceURI();
    }

    public static String getLastLocalPart(String string) {
        int n = string.lastIndexOf(62);
        if (n > -1 && n < string.length() - 1) {
            string = string.substring(n + 1);
        }
        return string;
    }
}

