/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import javax.wsdl.Binding;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaImplWriter;
import org.apache.axis.wsdl.toJava.JavaInterfaceWriter;
import org.apache.axis.wsdl.toJava.JavaSkelWriter;
import org.apache.axis.wsdl.toJava.JavaStubWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaBindingWriter
implements Generator {
    protected Generator stubWriter = null;
    protected Generator skelWriter = null;
    protected Generator implWriter = null;
    protected Generator interfaceWriter = null;
    protected Emitter emitter;
    protected Binding binding;
    protected SymbolTable symbolTable;
    public static String INTERFACE_NAME = "interface name";

    public JavaBindingWriter(Emitter emitter, Binding binding, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.binding = binding;
        this.symbolTable = symbolTable;
    }

    protected Generator getJavaInterfaceWriter(Emitter emitter, PortTypeEntry portTypeEntry, BindingEntry bindingEntry, SymbolTable symbolTable) {
        return new JavaInterfaceWriter(emitter, portTypeEntry, bindingEntry, symbolTable);
    }

    protected Generator getJavaStubWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        return new JavaStubWriter(emitter, bindingEntry, symbolTable);
    }

    protected Generator getJavaSkelWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        return new JavaSkelWriter(emitter, bindingEntry, symbolTable);
    }

    protected Generator getJavaImplWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        return new JavaImplWriter(emitter, bindingEntry, symbolTable);
    }

    public void generate() throws IOException {
        this.setGenerators();
        this.postSetGenerators();
        if (this.interfaceWriter != null) {
            this.interfaceWriter.generate();
        }
        if (this.stubWriter != null) {
            this.stubWriter.generate();
        }
        if (this.skelWriter != null) {
            this.skelWriter.generate();
        }
        if (this.implWriter != null) {
            this.implWriter.generate();
        }
    }

    protected void setGenerators() {
        BindingEntry bindingEntry = this.symbolTable.getBindingEntry(this.binding.getQName());
        PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(this.binding.getPortType().getQName());
        if (portTypeEntry.isReferenced()) {
            this.interfaceWriter = this.getJavaInterfaceWriter(this.emitter, portTypeEntry, bindingEntry, this.symbolTable);
        }
        if (bindingEntry.isReferenced()) {
            this.stubWriter = this.getJavaStubWriter(this.emitter, bindingEntry, this.symbolTable);
            if (this.emitter.isServerSide()) {
                String string;
                if (this.emitter.isSkeletonWanted()) {
                    this.skelWriter = this.getJavaSkelWriter(this.emitter, bindingEntry, this.symbolTable);
                }
                string = (string = this.emitter.getImplementationClassName()) == null ? Utils.getJavaLocalName(bindingEntry.getName()) + "Impl.java" : Utils.getJavaLocalName(string) + ".java";
                try {
                    if (Utils.fileExists(string, this.binding.getQName().getNamespaceURI(), this.emitter.getNamespaces())) {
                        if (!this.emitter.isQuiet()) {
                            System.out.println(Messages.getMessage("wontOverwrite", string));
                        }
                    } else {
                        this.implWriter = this.getJavaImplWriter(this.emitter, bindingEntry, this.symbolTable);
                    }
                }
                catch (IOException iOException) {
                    System.err.println(Messages.getMessage("fileExistError00", string));
                }
            }
        }
    }

    protected void postSetGenerators() {
        if (this.emitter.isDeploy()) {
            this.interfaceWriter = null;
            this.stubWriter = null;
            this.skelWriter = null;
            this.implWriter = null;
        }
    }
}

