/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;

public class JavaBuildFileWriter
extends JavaWriter {
    protected Definition definition;
    protected SymbolTable symbolTable;

    public JavaBuildFileWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, "build");
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    protected String getFileName() {
        String string = this.emitter.getOutputDir();
        if (string == null) {
            string = ".";
        }
        return string + "/build.xml";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        printWriter.write("<?xml version=\"1.0\"?>\n");
        printWriter.write("<project basedir=\".\" default=\"jar\">\n");
        printWriter.write("    <property name=\"src\" location=\".\"/>\n");
        printWriter.write("    <property name=\"build.classes\" location=\"classes\"/>\n");
        printWriter.write("    <path id=\"classpath\">\n");
        StringTokenizer stringTokenizer = this.getClasspathComponets();
        while (stringTokenizer.hasMoreTokens()) {
            printWriter.write("        <pathelement location=\"" + stringTokenizer.nextToken() + "\"/>\n");
        }
        printWriter.write("    </path>\n");
        printWriter.write("    <target name=\"compile\">\n");
        printWriter.write("       <mkdir dir=\"${build.classes}\"/>\n");
        printWriter.write("        <javac destdir=\"${build.classes}\" debug=\"on\">\n");
        printWriter.write("            <classpath refid=\"classpath\" />\n");
        printWriter.write("            <src path=\"${src}\"/>\n");
        printWriter.write("        </javac>\n");
        printWriter.write("    </target>\n");
        printWriter.write("    <target name=\"jar\" depends=\"compile\">\n");
        printWriter.write("        <copy todir=\"${build.classes}\">\n");
        printWriter.write("            <fileset dir=\".\" casesensitive=\"yes\" >\n");
        printWriter.write("                <include name=\"**/*.wsdd\"/>\n");
        printWriter.write("            </fileset>\n");
        printWriter.write("        </copy>\n");
        printWriter.write("        <jar jarfile=\"" + this.getJarFileName(this.symbolTable.getWSDLURI()) + ".jar\" basedir=\"${build.classes}\" >\n");
        printWriter.write("        <include name=\"**\" />\n");
        printWriter.write("        <manifest>\n");
        printWriter.write("            <section name=\"org/apache/ws4j2ee\">\n");
        printWriter.write("            <attribute name=\"Implementation-Title\" value=\"Apache Axis\"/>\n");
        printWriter.write("            <attribute name=\"Implementation-Vendor\" value=\"Apache Web Services\"/>\n");
        printWriter.write("            </section>\n");
        printWriter.write("        </manifest>\n");
        printWriter.write("        </jar>\n");
        printWriter.write("        <delete dir=\"${build.classes}\"/>\n");
        printWriter.write("    </target>\n");
        printWriter.write("</project>\n");
        printWriter.close();
    }

    private StringTokenizer getClasspathComponets() {
        String string = System.getProperty("java.class.path");
        String string2 = ";";
        if (string.indexOf(59) < 0) {
            string2 = ":";
        }
        return new StringTokenizer(string, string2);
    }

    private String getJarFileName(String string) {
        int n = 0;
        n = string.lastIndexOf("/");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf("?")) > 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(46)) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public void generate() throws IOException {
        if (this.emitter.isBuildFileWanted()) {
            super.generate();
        }
    }
}

