/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.DuplicateFileException;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaFaultWriter;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaDefinitionWriter
implements Generator {
    protected Emitter emitter;
    protected Definition definition;
    protected SymbolTable symbolTable;
    private HashSet importedFiles = new HashSet();

    public JavaDefinitionWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        this.writeFaults();
    }

    protected void writeFaults() throws IOException {
        ArrayList arrayList = new ArrayList();
        this.collectFaults(this.definition, arrayList);
        HashSet<String> hashSet = new HashSet<String>();
        for (FaultInfo faultInfo : arrayList) {
            Object object;
            Message message = faultInfo.getMessage();
            String string = Utils.getFullExceptionName(message, this.symbolTable);
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            MessageEntry messageEntry = this.symbolTable.getMessageEntry(message.getQName());
            boolean bl = true;
            if (messageEntry != null && (object = (Boolean)messageEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT)) != null && ((Boolean)object).booleanValue()) {
                bl = false;
            }
            if (!bl) continue;
            try {
                object = new JavaFaultWriter(this.emitter, this.symbolTable, faultInfo);
                ((JavaWriter)object).generate();
            }
            catch (DuplicateFileException duplicateFileException) {
                System.err.println(Messages.getMessage("fileExistError00", duplicateFileException.getFileName()));
            }
        }
    }

    private void collectFaults(Definition definition, ArrayList arrayList) throws IOException {
        Serializable serializable;
        Object object;
        Map map = definition.getImports();
        Object[] objectArray = map.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Vector vector = (Vector)objectArray[i];
            for (int j = 0; j < vector.size(); ++j) {
                object = (Import)vector.get(j);
                if (this.importedFiles.contains(object.getLocationURI())) continue;
                this.importedFiles.add(object.getLocationURI());
                serializable = object.getDefinition();
                if (serializable == null) continue;
                this.collectFaults((Definition)serializable, arrayList);
            }
        }
        Map map2 = definition.getBindings();
        for (Binding binding : map2.values()) {
            object = this.symbolTable.getBindingEntry(binding.getQName());
            if (!((SymTabEntry)object).isReferenced()) continue;
            serializable = ((BindingEntry)object).getFaults();
            for (ArrayList arrayList2 : serializable.values()) {
                arrayList.addAll(arrayList2);
            }
        }
    }
}

