/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaEnumTypeWriter
extends JavaClassWriter {
    private Vector elements;
    private TypeEntry type;

    protected JavaEnumTypeWriter(Emitter emitter, TypeEntry typeEntry, Vector vector) {
        super(emitter, typeEntry.getName(), "enumType");
        this.elements = vector;
        this.type = typeEntry;
    }

    protected String getImplementsText() {
        return "implements java.io.Serializable ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        int n;
        String string;
        String string2 = this.getClassName();
        String string3 = string = ((TypeEntry)this.elements.get(0)).getName();
        if (string.indexOf("int") == 0) {
            string3 = "java.lang.Integer";
        } else if (string.indexOf("char") == 0) {
            string3 = "java.lang.Character";
        } else if (string.indexOf("short") == 0) {
            string3 = "java.lang.Short";
        } else if (string.indexOf("long") == 0) {
            string3 = "java.lang.Long";
        } else if (string.indexOf("double") == 0) {
            string3 = "java.lang.Double";
        } else if (string.indexOf("float") == 0) {
            string3 = "java.lang.Float";
        } else if (string.indexOf("byte") == 0) {
            string3 = "java.lang.Byte";
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i < this.elements.size(); ++i) {
            String string4 = (String)this.elements.get(i);
            if (string3.equals("java.lang.String")) {
                string4 = "\"" + string4 + "\"";
            } else if (string3.equals("java.lang.Character")) {
                string4 = "'" + string4 + "'";
            } else if (string3.equals("java.lang.Float")) {
                if (!string4.endsWith("F") && !string4.endsWith("f")) {
                    string4 = string4 + "F";
                }
            } else if (string3.equals("java.lang.Long")) {
                if (!string4.endsWith("L") && !string4.endsWith("l")) {
                    string4 = string4 + "L";
                }
            } else if (string3.equals("javax.xml.namespace.QName")) {
                string4 = org.apache.axis.wsdl.symbolTable.Utils.getQNameFromPrefixedName(this.type.getNode(), string4).toString();
                string4 = "javax.xml.namespace.QName.valueOf(\"" + string4 + "\")";
            } else if (string3.equals(string)) {
                string4 = "new " + string3 + "(\"" + string4 + "\")";
            }
            vector.add(string4);
        }
        Vector vector2 = JavaEnumTypeWriter.getEnumValueIds(this.elements);
        printWriter.println("    private " + string + " _value_;");
        printWriter.println("    private static java.util.HashMap _table_ = new java.util.HashMap();");
        printWriter.println("");
        printWriter.println("    // " + Messages.getMessage("ctor00"));
        printWriter.println("    protected " + string2 + "(" + string + " value) {");
        printWriter.println("        _value_ = value;");
        if (string3.equals("java.lang.String") || string3.equals(string)) {
            printWriter.println("        _table_.put(_value_,this);");
        } else {
            printWriter.println("        _table_.put(new " + string3 + "(_value_),this);");
        }
        printWriter.println("    }");
        printWriter.println("");
        for (n = 0; n < vector2.size(); ++n) {
            if (string.equals("org.apache.axis.types.URI")) {
                printWriter.println("    public static final " + string + " _" + vector2.get(n) + ";");
                printWriter.println("    static {");
                printWriter.println("    \ttry {");
                printWriter.println("            _" + vector2.get(n) + " = " + vector.get(n) + ";");
                printWriter.println("        }");
                printWriter.println("        catch (org.apache.axis.types.URI.MalformedURIException mue) {");
                printWriter.println("            throw new java.lang.RuntimeException(mue.toString());");
                printWriter.println("        }");
                printWriter.println("    }");
                printWriter.println("");
                continue;
            }
            printWriter.println("    public static final " + string + " _" + vector2.get(n) + " = " + vector.get(n) + ";");
        }
        for (n = 0; n < vector2.size(); ++n) {
            printWriter.println("    public static final " + string2 + " " + vector2.get(n) + " = new " + string2 + "(_" + vector2.get(n) + ");");
        }
        printWriter.println("    public " + string + " getValue() { return _value_;}");
        printWriter.println("    public static " + string2 + " fromValue(" + string + " value)");
        printWriter.println("          throws java.lang.IllegalArgumentException {");
        printWriter.println("        " + string2 + " enumeration = (" + string2 + ")");
        if (string3.equals("java.lang.String") || string3.equals(string)) {
            printWriter.println("            _table_.get(value);");
        } else {
            printWriter.println("            _table_.get(new " + string3 + "(value));");
        }
        printWriter.println("        if (enumeration==null) throw new java.lang.IllegalArgumentException();");
        printWriter.println("        return enumeration;");
        printWriter.println("    }");
        printWriter.println("    public static " + string2 + " fromString(java.lang.String value)");
        printWriter.println("          throws java.lang.IllegalArgumentException {");
        if (string3.equals("java.lang.String")) {
            printWriter.println("        return fromValue(value);");
        } else if (string3.equals("javax.xml.namespace.QName")) {
            printWriter.println("        try {");
            printWriter.println("            return fromValue(javax.xml.namespace.QName.valueOf(value));");
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("            throw new java.lang.IllegalArgumentException();");
            printWriter.println("        }");
        } else if (string3.equals(string)) {
            printWriter.println("        try {");
            printWriter.println("            return fromValue(new " + string3 + "(value));");
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("            throw new java.lang.IllegalArgumentException();");
            printWriter.println("        }");
        } else if (string3.equals("java.lang.Character")) {
            printWriter.println("        if (value != null && value.length() == 1);");
            printWriter.println("            return fromValue(value.charAt(0));");
            printWriter.println("        throw new java.lang.IllegalArgumentException();");
        } else if (string3.equals("java.lang.Integer")) {
            printWriter.println("        try {");
            printWriter.println("            return fromValue(java.lang.Integer.parseInt(value));");
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("            throw new java.lang.IllegalArgumentException();");
            printWriter.println("        }");
        } else {
            String string5 = "parse" + string3.substring(string3.lastIndexOf(".") + 1);
            printWriter.println("        try {");
            printWriter.println("            return fromValue(" + string3 + "." + string5 + "(value));");
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("            throw new java.lang.IllegalArgumentException();");
            printWriter.println("        }");
        }
        printWriter.println("    }");
        printWriter.println("    public boolean equals(java.lang.Object obj) {return (obj == this);}");
        printWriter.println("    public int hashCode() { return toString().hashCode();}");
        if (string3.equals("java.lang.String")) {
            printWriter.println("    public java.lang.String toString() { return _value_;}");
        } else if (string3.equals(string)) {
            printWriter.println("    public java.lang.String toString() { return _value_.toString();}");
        } else {
            printWriter.println("    public java.lang.String toString() { return java.lang.String.valueOf(_value_);}");
        }
        printWriter.println("    public java.lang.Object readResolve() throws java.io.ObjectStreamException { return fromValue(_value_);}");
        printWriter.println("    public static org.apache.axis.encoding.Serializer getSerializer(");
        printWriter.println("           java.lang.String mechType, ");
        printWriter.println("           java.lang.Class _javaType,  ");
        printWriter.println("           javax.xml.namespace.QName _xmlType) {");
        printWriter.println("        return ");
        printWriter.println("          new org.apache.axis.encoding.ser.EnumSerializer(");
        printWriter.println("            _javaType, _xmlType);");
        printWriter.println("    }");
        printWriter.println("    public static org.apache.axis.encoding.Deserializer getDeserializer(");
        printWriter.println("           java.lang.String mechType, ");
        printWriter.println("           java.lang.Class _javaType,  ");
        printWriter.println("           javax.xml.namespace.QName _xmlType) {");
        printWriter.println("        return ");
        printWriter.println("          new org.apache.axis.encoding.ser.EnumDeserializer(");
        printWriter.println("            _javaType, _xmlType);");
        printWriter.println("    }");
        printWriter.println("    // " + Messages.getMessage("typeMeta"));
        printWriter.println("    private static org.apache.axis.description.TypeDesc typeDesc =");
        printWriter.println("        new org.apache.axis.description.TypeDesc(" + Utils.getJavaLocalName(this.type.getName()) + ".class);");
        printWriter.println();
        printWriter.println("    static {");
        printWriter.println("        typeDesc.setXmlType(" + Utils.getNewQName(this.type.getQName()) + ");");
        printWriter.println("    }");
        printWriter.println("    /**");
        printWriter.println("     * " + Messages.getMessage("returnTypeMeta"));
        printWriter.println("     */");
        printWriter.println("    public static org.apache.axis.description.TypeDesc getTypeDesc() {");
        printWriter.println("        return typeDesc;");
        printWriter.println("    }");
        printWriter.println();
    }

    public static Vector getEnumValueIds(Vector vector) {
        boolean bl = true;
        for (int i = 1; i < vector.size() && bl; ++i) {
            String string = (String)vector.get(i);
            if (JavaUtils.isJavaId(string)) continue;
            bl = false;
        }
        Vector<String> vector2 = new Vector<String>();
        for (int i = 1; i < vector.size(); ++i) {
            if (!bl) {
                vector2.add("value" + i);
                continue;
            }
            vector2.add((String)vector.get(i));
        }
        return vector2;
    }

    public void generate() throws IOException {
        String string = this.getPackage() + "." + this.getClassName();
        if (this.emitter.isDeploy()) {
            if (!this.emitter.doesExist(string)) {
                super.generate();
            }
        } else {
            super.generate();
        }
    }
}

