/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.apache.axis.wsdl.gen.NoopGenerator;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaBuildFileWriter;
import org.apache.axis.wsdl.toJava.JavaDefinitionWriter;
import org.apache.axis.wsdl.toJava.JavaDeployWriter;
import org.apache.axis.wsdl.toJava.JavaServiceWriter;
import org.apache.axis.wsdl.toJava.JavaTypeWriter;
import org.apache.axis.wsdl.toJava.JavaUndeployWriter;
import org.apache.axis.wsdl.toJava.NamespaceSelector;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.commons.logging.Log;

public class JavaGeneratorFactory
implements GeneratorFactory {
    private static final Log log_ = LogFactory.getLog(JavaGeneratorFactory.class.getName());
    protected Emitter emitter;
    protected SymbolTable symbolTable;
    public static String COMPLEX_TYPE_FAULT = "ComplexTypeFault";
    public static String EXCEPTION_CLASS_NAME = "ExceptionClassName";
    public static String EXCEPTION_DATA_TYPE = "ExceptionDataType";
    private static final String SERVICE_SUFFIX = "_Service";
    private static final String PORT_TYPE_SUFFIX = "_PortType";
    private static final String TYPE_SUFFIX = "_Type";
    private static final String ELEMENT_SUFFIX = "_Element";
    private static final String EXCEPTION_SUFFIX = "_Exception";
    private static final String BINDING_SUFFIX = "_Binding";
    private Writers messageWriters = new Writers();
    private Writers portTypeWriters = new Writers();
    protected Writers bindingWriters = new Writers();
    protected Writers serviceWriters = new Writers();
    private Writers typeWriters = new Writers();
    private Writers defWriters = new Writers();
    BaseTypeMapping btm = null;

    public JavaGeneratorFactory() {
        this.addGenerators();
    }

    public JavaGeneratorFactory(Emitter emitter) {
        this.emitter = emitter;
        this.addGenerators();
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    private void addGenerators() {
        this.addMessageGenerators();
        this.addPortTypeGenerators();
        this.addBindingGenerators();
        this.addServiceGenerators();
        this.addTypeGenerators();
        this.addDefinitionGenerators();
    }

    protected void addMessageGenerators() {
    }

    protected void addPortTypeGenerators() {
    }

    protected void addBindingGenerators() {
    }

    protected void addServiceGenerators() {
    }

    protected void addTypeGenerators() {
    }

    protected void addDefinitionGenerators() {
        this.addGenerator(Definition.class, JavaDefinitionWriter.class);
        this.addGenerator(Definition.class, JavaDeployWriter.class);
        this.addGenerator(Definition.class, JavaUndeployWriter.class);
        this.addGenerator(Definition.class, JavaBuildFileWriter.class);
    }

    public void generatorPass(Definition definition, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.javifyNames(symbolTable);
        this.setFaultContext(symbolTable);
        this.resolveNameClashes(symbolTable);
        this.determineInterfaceNames(symbolTable);
        if (this.emitter.isAllWanted()) {
            this.setAllReferencesToTrue();
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        this.constructSignatures(symbolTable);
        this.determineIfHoldersNeeded(symbolTable);
    }

    public Generator getGenerator(Message message, SymbolTable symbolTable) {
        if (this.include(message.getQName())) {
            MessageEntry messageEntry = symbolTable.getMessageEntry(message.getQName());
            this.messageWriters.addStuff((Generator)new NoopGenerator(), messageEntry, symbolTable);
            return this.messageWriters;
        }
        return new NoopGenerator();
    }

    public Generator getGenerator(PortType portType, SymbolTable symbolTable) {
        if (this.include(portType.getQName())) {
            PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(portType.getQName());
            this.portTypeWriters.addStuff((Generator)new NoopGenerator(), portTypeEntry, symbolTable);
            return this.portTypeWriters;
        }
        return new NoopGenerator();
    }

    public Generator getGenerator(Binding binding, SymbolTable symbolTable) {
        if (this.include(binding.getQName())) {
            JavaBindingWriter javaBindingWriter = new JavaBindingWriter(this.emitter, binding, symbolTable);
            BindingEntry bindingEntry = symbolTable.getBindingEntry(binding.getQName());
            this.bindingWriters.addStuff((Generator)javaBindingWriter, bindingEntry, symbolTable);
            return this.bindingWriters;
        }
        return new NoopGenerator();
    }

    public Generator getGenerator(Service service, SymbolTable symbolTable) {
        if (this.include(service.getQName())) {
            JavaServiceWriter javaServiceWriter = new JavaServiceWriter(this.emitter, service, symbolTable);
            ServiceEntry serviceEntry = symbolTable.getServiceEntry(service.getQName());
            this.serviceWriters.addStuff((Generator)javaServiceWriter, serviceEntry, symbolTable);
            return this.serviceWriters;
        }
        return new NoopGenerator();
    }

    public Generator getGenerator(TypeEntry typeEntry, SymbolTable symbolTable) {
        if (this.include(typeEntry.getQName())) {
            JavaTypeWriter javaTypeWriter = new JavaTypeWriter(this.emitter, typeEntry, symbolTable);
            this.typeWriters.addStuff((Generator)javaTypeWriter, typeEntry, symbolTable);
            return this.typeWriters;
        }
        return new NoopGenerator();
    }

    public Generator getGenerator(Definition definition, SymbolTable symbolTable) {
        if (this.include(definition.getQName())) {
            this.defWriters.addStuff(null, definition, symbolTable);
            return this.defWriters;
        }
        return new NoopGenerator();
    }

    public void addGenerator(Class clazz, Class clazz2) {
        if (Message.class.isAssignableFrom(clazz)) {
            this.messageWriters.addGenerator(clazz2);
        } else if (PortType.class.isAssignableFrom(clazz)) {
            this.portTypeWriters.addGenerator(clazz2);
        } else if (Binding.class.isAssignableFrom(clazz)) {
            this.bindingWriters.addGenerator(clazz2);
        } else if (Service.class.isAssignableFrom(clazz)) {
            this.serviceWriters.addGenerator(clazz2);
        } else if (TypeEntry.class.isAssignableFrom(clazz)) {
            this.typeWriters.addGenerator(clazz2);
        } else if (Definition.class.isAssignableFrom(clazz)) {
            this.defWriters.addGenerator(clazz2);
        }
    }

    protected void javifyNames(SymbolTable symbolTable) {
        int n = 0;
        HashMap hashMap = new HashMap();
        for (Vector vector : symbolTable.getHashMap().values()) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (symTabEntry.getName() != null) continue;
                if (symTabEntry instanceof TypeEntry) {
                    n = this.javifyTypeEntryName(symbolTable, (TypeEntry)symTabEntry, hashMap, n);
                    continue;
                }
                symTabEntry.setName(this.emitter.getJavaName(symTabEntry.getQName()));
            }
        }
    }

    protected int javifyTypeEntryName(SymbolTable symbolTable, TypeEntry typeEntry, HashMap hashMap, int n) {
        TypeEntry typeEntry2;
        TypeEntry typeEntry3 = typeEntry;
        String string = typeEntry3.getDimensions();
        TypeEntry typeEntry4 = typeEntry3.getRefType();
        while (typeEntry4 != null) {
            typeEntry3 = typeEntry4;
            string = string + typeEntry3.getDimensions();
            typeEntry4 = typeEntry3.getRefType();
        }
        TypeEntry typeEntry5 = typeEntry3;
        while (typeEntry5 != null && (typeEntry2 = SchemaUtils.getBaseType(typeEntry5, symbolTable)) != null) {
            n = this.javifyTypeEntryName(symbolTable, typeEntry2, hashMap, n);
            if (Utils.getEnumerationBaseAndValues(typeEntry5.getNode(), symbolTable) == null && SchemaUtils.getComplexElementExtensionBase(typeEntry5.getNode(), symbolTable) == null && typeEntry5.getContainedAttributes() == null && !SchemaUtils.isSimpleTypeWithUnion(typeEntry5.getNode())) {
                if (typeEntry2.isSimpleType()) {
                    typeEntry5.setSimpleType(true);
                    typeEntry5.setName(typeEntry2.getName());
                    typeEntry5.setRefType(typeEntry2);
                }
                if (typeEntry2.isBaseType()) {
                    typeEntry5.setBaseType(true);
                    typeEntry5.setName(typeEntry2.getName());
                    typeEntry5.setRefType(typeEntry2);
                }
            }
            if (!typeEntry5.isSimpleType()) break;
            typeEntry5 = typeEntry2;
        }
        if (typeEntry3.getName() == null) {
            Vector vector;
            Object object;
            Serializable serializable;
            Object object2;
            boolean bl = false;
            QName qName = typeEntry3.getQName();
            QName qName2 = SchemaUtils.getListItemType(typeEntry3.getNode());
            if (qName2 != null) {
                object2 = symbolTable.getTypeEntry(qName2, false);
                this.javifyTypeEntryName(symbolTable, (TypeEntry)object2, hashMap, n);
                serializable = ((TypeEntry)object2).getRefType();
                object = serializable == null ? ((SymTabEntry)object2).getQName() : ((SymTabEntry)((Object)serializable)).getQName();
                qName = new QName(((QName)object).getNamespaceURI(), ((QName)object).getLocalPart() + "[]");
            }
            if (this.emitter.isDeploy() && (object2 = (Class)this.emitter.getQName2ClassMap().get(qName)) != null && !((Class)object2).isArray()) {
                typeEntry3.setName(JavaGeneratorFactory.getJavaClassName((Class)object2));
                bl = true;
            }
            if (!bl) {
                if (qName.getLocalPart().indexOf(">") < 0) {
                    typeEntry3.setName(this.emitter.getJavaName(qName));
                } else {
                    int n2;
                    object2 = qName.getLocalPart();
                    serializable = new StringBuffer((String)object2);
                    while ((n2 = ((StringBuffer)serializable).toString().indexOf(">")) > -1) {
                        ((StringBuffer)serializable).replace(n2, n2 + ">".length(), "");
                        char c = ((StringBuffer)serializable).charAt(n2);
                        if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
                        ((StringBuffer)serializable).setCharAt(n2, Character.toUpperCase(c));
                    }
                    object2 = ((StringBuffer)serializable).toString();
                    qName = new QName(qName.getNamespaceURI(), (String)object2);
                    if (this.emitter.isTypeCollisionProtection() && !this.emitter.getNamespaceExcludes().contains(new NamespaceSelector(qName.getNamespaceURI()))) {
                        if (symbolTable.getType(qName) != null || hashMap.get(qName) != null) {
                            object2 = (String)object2 + "Type" + n++;
                            qName = new QName(qName.getNamespaceURI(), (String)object2);
                        }
                        hashMap.put(qName, qName);
                    }
                    typeEntry3.setName(this.emitter.getJavaName(qName));
                }
            }
            if ((object2 = typeEntry3.getContainedElements()) != null) {
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    object = (ElementDecl)((Vector)object2).get(i);
                    String string2 = this.emitter.getJavaVariableName(qName, ((SymTabEntry)object).getQName(), true);
                    ((SymTabEntry)object).setName(string2);
                }
            }
            if ((vector = typeEntry3.getContainedAttributes()) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ContainedAttribute containedAttribute = (ContainedAttribute)vector.get(i);
                    String string3 = this.emitter.getJavaVariableName(qName, containedAttribute.getQName(), false);
                    containedAttribute.setName(string3);
                }
            }
        }
        typeEntry.setName(typeEntry3.getName() + string);
        return n;
    }

    private static String getJavaClassName(Class clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        String string = clazz2.getName();
        string.replace('$', '.');
        return string;
    }

    private void setFaultContext(SymbolTable symbolTable) {
        for (Vector vector : symbolTable.getHashMap().values()) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (!(symTabEntry instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                HashMap hashMap = bindingEntry.getFaults();
                for (ArrayList arrayList : hashMap.values()) {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        FaultInfo faultInfo = (FaultInfo)arrayList.get(j);
                        this.setFaultContext(faultInfo, symbolTable);
                    }
                }
            }
        }
    }

    private void setFaultContext(FaultInfo faultInfo, SymbolTable symbolTable) {
        SymTabEntry symTabEntry;
        QName qName = null;
        Vector vector = new Vector();
        try {
            symbolTable.getParametersFromParts(vector, faultInfo.getMessage().getOrderedParts(null), false, faultInfo.getName(), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            symTabEntry = ((Parameter)vector.elementAt(i)).getType();
            TypeEntry typeEntry = null;
            if (symTabEntry instanceof Element) {
                typeEntry = symTabEntry;
                symTabEntry = ((TypeEntry)symTabEntry).getRefType();
            }
            qName = symTabEntry.getQName();
            if (((TypeEntry)symTabEntry).getBaseType() != null || ((TypeEntry)symTabEntry).isSimpleType() || ((TypeEntry)symTabEntry).getDimensions().length() > 0 && ((TypeEntry)symTabEntry).getRefType().getBaseType() != null) continue;
            Boolean bl = (Boolean)symTabEntry.getDynamicVar(COMPLEX_TYPE_FAULT);
            if (bl == null || !bl.booleanValue()) {
                TypeEntry typeEntry22;
                symTabEntry.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
                if (typeEntry != null) {
                    symTabEntry.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
                }
                HashSet hashSet = org.apache.axis.wsdl.symbolTable.Utils.getDerivedTypes((TypeEntry)symTabEntry, symbolTable);
                for (TypeEntry typeEntry22 : hashSet) {
                    typeEntry22.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
                }
                typeEntry22 = SchemaUtils.getComplexElementExtensionBase(((TypeEntry)symTabEntry).getNode(), symbolTable);
                while (typeEntry22 != null) {
                    typeEntry22.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
                    typeEntry22 = SchemaUtils.getComplexElementExtensionBase(typeEntry22.getNode(), symbolTable);
                }
            }
            string = symTabEntry.getName();
        }
        String string2 = this.getExceptionJavaNameHook(faultInfo.getMessage().getQName());
        if (string2 != null) {
            string = string2;
        }
        if ((symTabEntry = symbolTable.getMessageEntry(faultInfo.getMessage().getQName())) != null) {
            symTabEntry.setDynamicVar(EXCEPTION_DATA_TYPE, qName);
            if (string != null) {
                symTabEntry.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
                symTabEntry.setDynamicVar(EXCEPTION_CLASS_NAME, string);
            } else {
                symTabEntry.setDynamicVar(EXCEPTION_CLASS_NAME, this.emitter.getJavaName(symTabEntry.getQName()));
            }
        }
    }

    protected String getExceptionJavaNameHook(QName qName) {
        return null;
    }

    protected void determineInterfaceNames(SymbolTable symbolTable) {
        for (Vector vector : symbolTable.getHashMap().values()) {
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                Object object2;
                SymTabEntry symTabEntry;
                SymTabEntry symTabEntry2 = (SymTabEntry)vector.elementAt(i);
                if (symTabEntry2 instanceof BindingEntry) {
                    symTabEntry = (BindingEntry)symTabEntry2;
                    object2 = symbolTable.getPortTypeEntry(((BindingEntry)symTabEntry).getBinding().getPortType().getQName());
                    object = this.getServiceEndpointInterfaceJavaNameHook((PortTypeEntry)object2, (BindingEntry)symTabEntry);
                    if (object == null) {
                        object = ((SymTabEntry)object2).getName();
                    }
                    symTabEntry.setDynamicVar(JavaBindingWriter.INTERFACE_NAME, object);
                    continue;
                }
                if (!(symTabEntry2 instanceof ServiceEntry)) continue;
                symTabEntry = (ServiceEntry)symTabEntry2;
                object2 = this.getServiceInterfaceJavaNameHook((ServiceEntry)symTabEntry);
                if (object2 != null) {
                    symTabEntry.setName((String)object2);
                }
                object = ((ServiceEntry)symTabEntry).getService();
                Map map = object.getPorts();
                for (Port port : map.values()) {
                    String string;
                    Binding binding = port.getBinding();
                    BindingEntry bindingEntry = symbolTable.getBindingEntry(binding.getQName());
                    if (bindingEntry.getBindingType() != 0 || (string = this.getPortJavaNameHook(port.getName())) == null) continue;
                    bindingEntry.setDynamicVar("port name:" + port.getName(), string);
                }
            }
        }
    }

    protected String getServiceEndpointInterfaceJavaNameHook(PortTypeEntry portTypeEntry, BindingEntry bindingEntry) {
        return null;
    }

    protected String getServiceInterfaceJavaNameHook(ServiceEntry serviceEntry) {
        return null;
    }

    protected String getPortJavaNameHook(String string) {
        return null;
    }

    protected void resolveNameClashes(SymbolTable symbolTable) {
        int n;
        Object object3;
        Object object22;
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Object object22 : symbolTable.getHashMap().keySet()) {
            object3 = ((QName)object22).getLocalPart();
            if (arrayList2.contains(object3)) continue;
            arrayList2.add((String)object3);
        }
        Map map = this.emitter.getNamespaces().getPkg2NamespacesMap();
        for (Object object3 : map.values()) {
            for (n = 0; n < arrayList2.size(); ++n) {
                Vector vector = new Vector();
                for (int i = 0; i < ((Vector)object3).size(); ++i) {
                    QName qName = new QName((String)((Vector)object3).get(i), (String)arrayList2.get(n));
                    if (symbolTable.getHashMap().get(qName) == null) continue;
                    vector.addAll((Vector)symbolTable.getHashMap().get(qName));
                }
                if (vector.size() <= 0) continue;
                arrayList.add(vector);
            }
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            Object object4;
            object3 = new Vector<Object>((Vector)object22.next());
            n = 0;
            while (n < ((Vector)object3).size()) {
                if (((Vector)object3).elementAt(n) instanceof MessageEntry) {
                    MessageEntry messageEntry = (MessageEntry)((Vector)object3).elementAt(n);
                    if (messageEntry.getDynamicVar(EXCEPTION_CLASS_NAME) == null) {
                        ((Vector)object3).removeElementAt(n);
                        continue;
                    }
                    ++n;
                    continue;
                }
                ++n;
            }
            if (((Vector)object3).size() <= 1) continue;
            boolean bl = true;
            if (((Vector)object3).size() == 2 && (((Vector)object3).elementAt(0) instanceof Element && ((Vector)object3).elementAt(1) instanceof Type || ((Vector)object3).elementAt(1) instanceof Element && ((Vector)object3).elementAt(0) instanceof Type)) {
                Element element = ((Vector)object3).elementAt(0) instanceof Element ? (Element)((Vector)object3).elementAt(0) : (Element)((Vector)object3).elementAt(1);
                BooleanHolder booleanHolder = new BooleanHolder();
                object4 = Utils.getTypeQName(element.getNode(), booleanHolder, false);
                if (object4 != null && ((QName)object4).equals(element.getQName()) && !booleanHolder.value) {
                    bl = false;
                }
            }
            if (bl) {
                bl = false;
                String string = null;
                for (int i = 0; i < ((Vector)object3).size() && !bl; ++i) {
                    object4 = (SymTabEntry)((Vector)object3).elementAt(i);
                    if (object4 instanceof MessageEntry || object4 instanceof BindingEntry) {
                        String string2 = (String)((SymTabEntry)object4).getDynamicVar(EXCEPTION_CLASS_NAME);
                        if (string2 == null) continue;
                        if (string == null) {
                            string = string2;
                            continue;
                        }
                        if (!string.equals(string2)) continue;
                        bl = true;
                        continue;
                    }
                    if (string == null) {
                        string = ((SymTabEntry)object4).getName();
                        continue;
                    }
                    if (!string.equals(((SymTabEntry)object4).getName())) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            boolean bl2 = true;
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                BindingEntry bindingEntry;
                Object object52;
                object4 = (SymTabEntry)((Vector)object3).elementAt(i);
                if (object4 instanceof Element) {
                    ((SymTabEntry)object4).setName(this.mangleName(((SymTabEntry)object4).getName(), ELEMENT_SUFFIX));
                    QName qName = new QName(((SymTabEntry)object4).getQName().getNamespaceURI(), ">" + ((SymTabEntry)object4).getQName().getLocalPart());
                    object52 = symbolTable.getType(qName);
                    if (object52 == null) continue;
                    ((SymTabEntry)object52).setName(((SymTabEntry)object4).getName());
                    hashSet.add(object52);
                    continue;
                }
                if (object4 instanceof TypeEntry) {
                    SymTabEntry symTabEntry;
                    Object object6;
                    if (bl2) {
                        bl2 = false;
                        for (Object object52 : symbolTable.getTypeIndex().values()) {
                            if (object52 == object4 || ((TypeEntry)object52).getBaseType() != null || !this.sameJavaClass(((SymTabEntry)object4).getName(), ((SymTabEntry)object52).getName())) continue;
                            ((Vector)object3).add(object52);
                        }
                    }
                    if (hashSet.contains(object4)) continue;
                    boolean bl3 = false;
                    for (int j = 0; j < ((Vector)object3).size(); ++j) {
                        object6 = (SymTabEntry)((Vector)object3).elementAt(j);
                        if (!(object6 instanceof PortTypeEntry) && !(object6 instanceof ServiceEntry) && !(object6 instanceof BindingEntry)) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) continue;
                    Boolean bl4 = (Boolean)((SymTabEntry)object4).getDynamicVar(COMPLEX_TYPE_FAULT);
                    if (bl4 != null && bl4.booleanValue()) {
                        ((SymTabEntry)object4).setName(this.mangleName(((SymTabEntry)object4).getName(), EXCEPTION_SUFFIX));
                    } else {
                        ((SymTabEntry)object4).setName(this.mangleName(((SymTabEntry)object4).getName(), TYPE_SUFFIX));
                    }
                    object6 = symbolTable.getElementIndex();
                    ArrayList arrayList3 = new ArrayList(object6.values());
                    for (int j = 0; j < object6.size(); ++j) {
                        TypeEntry typeEntry = (TypeEntry)arrayList3.get(j);
                        symTabEntry = typeEntry.getRefType();
                        if (symTabEntry == null || !((SymTabEntry)object4).getQName().equals(symTabEntry.getQName())) continue;
                        typeEntry.setName(((SymTabEntry)object4).getName());
                    }
                    if (bl4 == null || !bl4.booleanValue()) continue;
                    List list = symbolTable.getMessageEntries();
                    for (int j = 0; j < list.size(); ++j) {
                        symTabEntry = (MessageEntry)list.get(j);
                        Boolean bl5 = (Boolean)symTabEntry.getDynamicVar(COMPLEX_TYPE_FAULT);
                        if (bl5 == null || !bl5.booleanValue()) continue;
                        QName qName = (QName)symTabEntry.getDynamicVar(EXCEPTION_DATA_TYPE);
                        if (!((TypeEntry)object4).getQName().equals(qName)) continue;
                        String string = (String)symTabEntry.getDynamicVar(EXCEPTION_CLASS_NAME);
                        symTabEntry.setDynamicVar(EXCEPTION_CLASS_NAME, string + EXCEPTION_SUFFIX);
                    }
                    continue;
                }
                if (object4 instanceof PortTypeEntry) {
                    ((SymTabEntry)object4).setName(this.mangleName(((SymTabEntry)object4).getName(), PORT_TYPE_SUFFIX));
                    continue;
                }
                if (object4 instanceof ServiceEntry) {
                    ((SymTabEntry)object4).setName(this.mangleName(((SymTabEntry)object4).getName(), SERVICE_SUFFIX));
                    continue;
                }
                if (object4 instanceof MessageEntry) {
                    Boolean bl6 = (Boolean)((SymTabEntry)object4).getDynamicVar(COMPLEX_TYPE_FAULT);
                    if (bl6 != null && bl6.booleanValue()) continue;
                    object52 = (String)((SymTabEntry)object4).getDynamicVar(EXCEPTION_CLASS_NAME);
                    ((SymTabEntry)object4).setDynamicVar(EXCEPTION_CLASS_NAME, (String)object52 + EXCEPTION_SUFFIX);
                    continue;
                }
                if (!(object4 instanceof BindingEntry) || !(bindingEntry = (BindingEntry)object4).hasLiteral()) continue;
                ((SymTabEntry)object4).setName(this.mangleName(((SymTabEntry)object4).getName(), BINDING_SUFFIX));
            }
        }
    }

    private String mangleName(String string, String string2) {
        int n = string.indexOf("[");
        if (n >= 0) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n);
            return string3 + string2 + string4;
        }
        return string + string2;
    }

    private boolean sameJavaClass(String string, String string2) {
        int n = string.indexOf("[");
        int n2 = string2.indexOf("[");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        return string.equals(string2);
    }

    protected void setAllReferencesToTrue() {
        for (Vector vector : this.symbolTable.getHashMap().values()) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (symTabEntry instanceof BindingEntry && ((BindingEntry)symTabEntry).getBindingType() != 0) {
                    symTabEntry.setIsReferenced(false);
                    continue;
                }
                symTabEntry.setIsReferenced(true);
            }
        }
    }

    protected void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> vector = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> vector2 = new Vector<PortTypeEntry>();
        for (Vector vector3 : symbolTable.getHashMap().values()) {
            for (int i = 0; i < vector3.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector3.elementAt(i);
                if (!(symTabEntry instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                Binding binding = bindingEntry.getBinding();
                PortType portType = binding.getPortType();
                PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(portType.getQName());
                if (bindingEntry.getBindingType() == 0) {
                    vector2.add(portTypeEntry);
                    if (!vector.contains(portTypeEntry)) continue;
                    vector.remove(portTypeEntry);
                    continue;
                }
                bindingEntry.setIsReferenced(false);
                if (vector2.contains(portTypeEntry)) continue;
                vector.add(portTypeEntry);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            PortTypeEntry portTypeEntry = (PortTypeEntry)vector.get(i);
            portTypeEntry.setIsReferenced(false);
        }
    }

    protected void constructSignatures(SymbolTable symbolTable) {
        for (Vector vector : symbolTable.getHashMap().values()) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (!(symTabEntry instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                Binding binding = bindingEntry.getBinding();
                PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                PortType portType = portTypeEntry.getPortType();
                for (Operation operation : portType.getOperations()) {
                    String string = operation.getName();
                    OperationType operationType = operation.getStyle();
                    String string2 = this.getOperationJavaNameHook(bindingEntry, string);
                    if (string2 == null) {
                        string2 = operation.getName();
                    }
                    Parameters parameters = bindingEntry.getParameters(operation);
                    if (OperationType.SOLICIT_RESPONSE.equals(operationType)) {
                        parameters.signature = "    // " + Messages.getMessage("invalidSolResp00", string2);
                        System.err.println(Messages.getMessage("invalidSolResp00", string2));
                        continue;
                    }
                    if (OperationType.NOTIFICATION.equals(operationType)) {
                        parameters.signature = "    // " + Messages.getMessage("invalidNotif00", string2);
                        System.err.println(Messages.getMessage("invalidNotif00", string2));
                        continue;
                    }
                    if (parameters == null) continue;
                    String string3 = this.getReturnTypeJavaNameHook(bindingEntry, string);
                    if (string3 != null && parameters.returnParam != null) {
                        parameters.returnParam.getType().setName(string3);
                    }
                    for (int j = 0; j < parameters.list.size(); ++j) {
                        Parameter parameter = (Parameter)parameters.list.get(j);
                        String string4 = this.getParameterTypeJavaNameHook(bindingEntry, string, j);
                        if (string4 == null) continue;
                        parameter.getType().setName(string4);
                    }
                    parameters.signature = this.constructSignature(parameters, string2);
                }
            }
        }
    }

    protected String getOperationJavaNameHook(BindingEntry bindingEntry, String string) {
        return null;
    }

    protected String getReturnTypeJavaNameHook(BindingEntry bindingEntry, String string) {
        return null;
    }

    protected String getParameterTypeJavaNameHook(BindingEntry bindingEntry, String string, int n) {
        return null;
    }

    private String constructSignature(Parameters parameters, String string) {
        String string2;
        String string3 = Utils.xmlNameToJava(string);
        String string4 = "void";
        if (parameters != null && parameters.returnParam != null) {
            string4 = Utils.getParameterTypeName(parameters.returnParam);
        }
        String string5 = "    public " + string4 + " " + string3 + "(";
        boolean bl = false;
        for (int i = 0; parameters != null && i < parameters.list.size(); ++i) {
            Object object = (Parameter)parameters.list.get(i);
            if (bl) {
                string5 = string5 + ", ";
            } else {
                bl = true;
            }
            string2 = Utils.xmlNameToJava(((Parameter)object).getName());
            string5 = ((Parameter)object).getMode() == 1 ? string5 + Utils.getParameterTypeName((Parameter)object) + " " + string2 : string5 + Utils.holder((Parameter)object, this.emitter) + " " + string2;
        }
        string5 = string5 + ") throws java.rmi.RemoteException";
        if (parameters != null && parameters.faults != null) {
            for (Object object : parameters.faults.values()) {
                string2 = Utils.getFullExceptionName(object.getMessage(), this.symbolTable);
                if (string2 == null) continue;
                string5 = string5 + ", " + string2;
            }
        }
        return string5;
    }

    protected void determineIfHoldersNeeded(SymbolTable symbolTable) {
        for (Vector vector : symbolTable.getHashMap().values()) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.get(i) instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)vector.get(i);
                for (Parameters parameters : bindingEntry.getParameters().values()) {
                    for (int j = 0; j < parameters.list.size(); ++j) {
                        Type type;
                        QName qName;
                        Parameter parameter = (Parameter)parameters.list.get(j);
                        if (parameter.getMode() == 1) continue;
                        TypeEntry typeEntry = parameter.getType();
                        typeEntry.setDynamicVar("Holder is needed", Boolean.TRUE);
                        if (!typeEntry.isSimpleType() && typeEntry.getRefType() != null) {
                            typeEntry.getRefType().setDynamicVar("Holder is needed", Boolean.TRUE);
                        }
                        if ((qName = SchemaUtils.getElementAnonQName(parameter.getType().getNode())) == null || (type = symbolTable.getType(qName)) == null) continue;
                        type.setDynamicVar("Holder is needed", Boolean.TRUE);
                    }
                }
            }
        }
    }

    public void setBaseTypeMapping(BaseTypeMapping baseTypeMapping) {
        this.btm = baseTypeMapping;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){

                public String getBaseName(QName qName) {
                    QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart());
                    Class clazz = JavaGeneratorFactory.this.emitter.getDefaultTypeMapping().getClassForQName(qName2);
                    if (clazz == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(clazz.getName());
                }
            };
        }
        return this.btm;
    }

    protected boolean include(QName qName) {
        String string = qName != null && qName.getNamespaceURI() != null ? qName.getNamespaceURI() : "";
        boolean bl = false;
        NamespaceSelector namespaceSelector = new NamespaceSelector(string);
        if (qName == null || this.emitter == null || this.emitter.getNamespaceIncludes().contains(namespaceSelector) || this.emitter.getNamespaceIncludes().size() == 0 && !this.emitter.getNamespaceExcludes().contains(namespaceSelector)) {
            bl = true;
        } else {
            log_.info("excluding code generation for non-included QName:" + qName);
        }
        return bl;
    }

    protected class Writers
    implements Generator {
        Vector writers = new Vector();
        SymbolTable symbolTable = null;
        Generator baseWriter = null;
        SymTabEntry entry = null;
        Definition def = null;

        protected Writers() {
        }

        public void addGenerator(Class clazz) {
            this.writers.add(clazz);
        }

        public void addStuff(Generator generator, SymTabEntry symTabEntry, SymbolTable symbolTable) {
            this.baseWriter = generator;
            this.entry = symTabEntry;
            this.symbolTable = symbolTable;
        }

        public void addStuff(Generator generator, Definition definition, SymbolTable symbolTable) {
            this.baseWriter = generator;
            this.def = definition;
            this.symbolTable = symbolTable;
        }

        public void generate() throws IOException {
            Object[] objectArray;
            Class[] classArray;
            if (this.baseWriter != null) {
                this.baseWriter.generate();
            }
            if (this.entry != null) {
                classArray = new Class[]{Emitter.class, this.entry.getClass(), SymbolTable.class};
                objectArray = new Object[]{JavaGeneratorFactory.this.emitter, this.entry, this.symbolTable};
            } else {
                classArray = new Class[]{Emitter.class, Definition.class, SymbolTable.class};
                objectArray = new Object[]{JavaGeneratorFactory.this.emitter, this.def, this.symbolTable};
            }
            for (int i = 0; i < this.writers.size(); ++i) {
                Generator generator;
                Class clazz = (Class)this.writers.get(i);
                try {
                    Constructor constructor = clazz.getConstructor(classArray);
                    generator = (Generator)constructor.newInstance(objectArray);
                }
                catch (Throwable throwable) {
                    throw new IOException(Messages.getMessage("exception01", throwable.getMessage()));
                }
                generator.generate();
            }
        }
    }
}

