/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaTestCaseWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    private int counter = 1;

    protected JavaTestCaseWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry.getName() + "TestCase", "testCase");
        this.sEntry = serviceEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends junit.framework.TestCase ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        printWriter.print("    public ");
        printWriter.print(this.getClassName());
        printWriter.println("(java.lang.String name) {");
        printWriter.println("        super(name);");
        printWriter.println("    }");
        printWriter.println("");
        Map map = this.sEntry.getService().getPorts();
        for (Port port : map.values()) {
            Binding binding = port.getBinding();
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry.getBindingType() != 0) continue;
            String string = port.getName();
            if (!JavaUtils.isJavaId(string)) {
                string = Utils.xmlNameToJavaClass(string);
            }
            printWriter.println("    public void test" + string + "WSDL() throws Exception {");
            printWriter.println("        javax.xml.rpc.ServiceFactory serviceFactory = javax.xml.rpc.ServiceFactory.newInstance();");
            printWriter.println("        java.net.URL url = new java.net.URL(new " + this.sEntry.getName() + "Locator" + "().get" + string + "Address() + \"?WSDL\");");
            printWriter.println("        javax.xml.rpc.Service service = serviceFactory.createService(url, new " + this.sEntry.getName() + "Locator().getServiceName());");
            printWriter.println("        assertTrue(service != null);");
            printWriter.println("    }");
            printWriter.println("");
            PortType portType = binding.getPortType();
            this.writeComment(printWriter, port.getDocumentationElement(), true);
            this.writeServiceTestCode(printWriter, string, portType, bindingEntry);
        }
    }

    protected final void writeServiceTestCode(PrintWriter printWriter, String string, PortType portType, BindingEntry bindingEntry) {
        for (Operation operation : portType.getOperations()) {
            Object object;
            Object object2;
            Object object3;
            Parameter parameter;
            OperationType operationType = operation.getStyle();
            Parameters parameters = bindingEntry.getParameters(operation);
            BooleanHolder booleanHolder = new BooleanHolder(false);
            if (OperationType.NOTIFICATION.equals(operationType) || OperationType.SOLICIT_RESPONSE.equals(operationType)) {
                printWriter.println("    " + parameters.signature);
                continue;
            }
            String string2 = Utils.xmlNameToJavaClass(operation.getName());
            String string3 = "test" + this.counter++ + string + string2;
            printWriter.println("    public void " + string3 + "() throws Exception {");
            String string4 = bindingEntry.getName() + "Stub";
            this.writeBindingAssignment(printWriter, string4, string);
            printWriter.println("        // Test operation");
            String string5 = "";
            Map map = operation.getFaults();
            if (map != null && map.size() > 0) {
                printWriter.println("        try {");
                string5 = "    ";
            }
            if ((parameter = parameters.returnParam) != null) {
                object3 = parameter.getType();
                printWriter.print("        " + string5);
                printWriter.print(Utils.getParameterTypeName(parameter));
                printWriter.print(" value = ");
                if (parameter.getMIMEInfo() == null && !parameter.isOmittable() && Utils.isPrimitiveType((TypeEntry)object3)) {
                    if ("boolean".equals(((SymTabEntry)object3).getName())) {
                        printWriter.println("false;");
                    } else {
                        printWriter.println("-3;");
                    }
                } else {
                    printWriter.println("null;");
                }
            }
            printWriter.print("        " + string5);
            if (parameter != null) {
                printWriter.print("value = ");
            }
            printWriter.print("binding.");
            printWriter.print(Utils.xmlNameToJava(operation.getName()));
            printWriter.print("(");
            object3 = parameters.list.iterator();
            boolean bl = true;
            while (object3.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(", ");
                }
                object2 = (Parameter)object3.next();
                String string6 = "";
                if (((Parameter)object2).getMode() != 1) {
                    printWriter.print("new " + Utils.holder((Parameter)object2, this.emitter) + "(");
                    string6 = ")";
                }
                if (((Parameter)object2).getMode() != 2) {
                    object = Utils.getConstructorForParam((Parameter)object2, this.symbolTable, booleanHolder);
                    printWriter.print((String)object);
                }
                printWriter.print(string6);
            }
            printWriter.println(");");
            if (map != null && map.size() > 0) {
                printWriter.println("        }");
            }
            if (map != null) {
                object2 = map.values().iterator();
                int n = 0;
                while (object2.hasNext()) {
                    object = (Fault)object2.next();
                    printWriter.print("        catch (");
                    printWriter.print(Utils.getFullExceptionName(object.getMessage(), this.symbolTable));
                    printWriter.println(" e" + ++n + ") {");
                    printWriter.print("            ");
                    printWriter.println("throw new junit.framework.AssertionFailedError(\"" + object.getName() + " Exception caught: \" + e" + n + ");");
                    printWriter.println("        }");
                }
            }
            printWriter.println("        " + string5 + "// TBD - validate results");
            printWriter.println("    }");
            printWriter.println();
        }
    }

    public final void writeBindingAssignment(PrintWriter printWriter, String string, String string2) {
        printWriter.println("        " + string + " binding;");
        printWriter.println("        try {");
        printWriter.println("            binding = (" + string + ")");
        printWriter.print("                          new " + this.sEntry.getName());
        printWriter.println("Locator().get" + string2 + "();");
        printWriter.println("        }");
        printWriter.println("        catch (" + ServiceException.class.getName() + " jre) {");
        printWriter.println("            if(jre.getLinkedCause()!=null)");
        printWriter.println("                jre.getLinkedCause().printStackTrace();");
        printWriter.println("            throw new junit.framework.AssertionFailedError(\"JAX-RPC ServiceException caught: \" + jre);");
        printWriter.println("        }");
        printWriter.println("        assertNotNull(\"" + Messages.getMessage("null00", "binding") + "\", binding);");
        printWriter.println();
        printWriter.println("        // Time out after a minute");
        printWriter.println("        binding.setTimeout(60000);");
        printWriter.println();
    }
}

