/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Utils;

public class Namespaces
extends HashMap {
    private String root;
    private String defaultPackage = null;
    private static final char[] pkgSeparators = new char[]{'.', ':'};
    private static final char javaPkgSeparator = pkgSeparators[0];
    private Map pkg2NamespacesMap = new HashMap();

    private static String normalizePackageName(String string, char c) {
        for (int i = 0; i < pkgSeparators.length; ++i) {
            string = string.replace(pkgSeparators[i], c);
        }
        return string;
    }

    public Namespaces(String string) {
        this.root = string;
    }

    private Namespaces(Namespaces namespaces) {
        super(namespaces);
        this.root = namespaces.root;
        this.defaultPackage = namespaces.defaultPackage;
    }

    public Object clone() {
        return new Namespaces(this);
    }

    public String getCreate(String string) {
        return this.getCreate(string, true);
    }

    String getCreate(String string, boolean bl) {
        if (this.defaultPackage != null) {
            this.put(string, this.defaultPackage);
            return this.defaultPackage;
        }
        String string2 = (String)super.get(string);
        if (string2 == null && bl) {
            string2 = Namespaces.normalizePackageName(Utils.makePackageName(string), javaPkgSeparator);
            this.put(string, string2);
        }
        return string2;
    }

    public String getAsDir(String string) {
        if (this.defaultPackage != null) {
            return this.toDir(this.defaultPackage);
        }
        String string2 = (String)this.get(string);
        return this.toDir(string2);
    }

    public String toDir(String string) {
        String string2 = null;
        if (string != null) {
            string = Namespaces.normalizePackageName(string, File.separatorChar);
        }
        string2 = this.root == null ? string : this.root + File.separatorChar + string;
        return string2 == null ? "" : string2 + File.separatorChar;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            String string = (String)entry.getValue();
            string = this.javify(string);
            this.put(k, string);
        }
    }

    private String javify(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        string = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (JavaUtils.isJavaKeyword(string2)) {
                string2 = JavaUtils.makeNonJavaKeyword(string2);
            }
            string = string + string2;
            if (!stringTokenizer.hasMoreTokens()) continue;
            string = string + '.';
        }
        return string;
    }

    public void mkdir(String string) {
        String string2 = this.toDir(string);
        File file = new File(string2);
        file.mkdirs();
    }

    public void setDefaultPackage(String string) {
        this.defaultPackage = string;
    }

    public Object put(Object object, Object object2) {
        Vector vector = null;
        vector = !this.pkg2NamespacesMap.containsKey(object2) ? new Vector() : (Vector)this.pkg2NamespacesMap.get(object2);
        if (!vector.contains(object)) {
            vector.add(object);
        }
        this.pkg2NamespacesMap.put(object2, vector);
        return super.put(object, object2);
    }

    public Map getPkg2NamespacesMap() {
        return this.pkg2NamespacesMap;
    }
}

