/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.batik.transcoder.wmf.WMFConstants;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.StringRecord;

public class WMFRecordStore
implements WMFConstants {
    private transient URL url;
    protected transient int numRecords;
    protected transient int numObjects;
    public transient int lastObjectIdx;
    protected transient int vpX;
    protected transient int vpY;
    protected transient int vpW;
    protected transient int vpH;
    protected transient Vector records;
    protected transient Vector objectVector;
    protected transient boolean bReading = false;

    public WMFRecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0;
        this.vpY = 0;
        this.vpW = 1000;
        this.vpH = 1000;
        this.numObjects = 0;
        this.records = new Vector(20, 20);
        this.objectVector = new Vector();
    }

    private short readShort(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[2];
        dataInputStream.read(byArray);
        int n = (0xFF & byArray[1]) << 8;
        short s = (short)(0xFFFF & n);
        s = (short)(s | 0xFF & byArray[0]);
        return s;
    }

    private int readInt(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray);
        int n = (0xFF & byArray[3]) << 24;
        n |= (0xFF & byArray[2]) << 16;
        n |= (0xFF & byArray[1]) << 8;
        return n |= 0xFF & byArray[0];
    }

    public boolean read(DataInputStream dataInputStream) throws IOException {
        this.reset();
        this.setReading(true);
        int n = this.readInt(dataInputStream);
        if (n != -1698247209) {
            System.out.println("Unable to read file, it is not a Aldus Placable Metafile");
            this.setReading(false);
            return false;
        }
        this.readShort(dataInputStream);
        this.readShort(dataInputStream);
        this.readShort(dataInputStream);
        this.readShort(dataInputStream);
        this.readShort(dataInputStream);
        this.readShort(dataInputStream);
        this.readInt(dataInputStream);
        this.readShort(dataInputStream);
        this.readShort(dataInputStream);
        this.readShort(dataInputStream);
        this.readShort(dataInputStream);
        this.readInt(dataInputStream);
        short s = this.readShort(dataInputStream);
        this.readInt(dataInputStream);
        this.readShort(dataInputStream);
        int n2 = 1;
        int n3 = 0;
        this.numRecords = 0;
        this.numObjects = s;
        this.objectVector.ensureCapacity(this.numObjects);
        for (int i = 0; i < this.numObjects; ++i) {
            this.objectVector.addElement(new GdiObject(i, false));
        }
        while (n2 > 0) {
            n3 = this.readInt(dataInputStream);
            n3 -= 3;
            n2 = this.readShort(dataInputStream);
            if (n2 <= 0) break;
            MetaRecord metaRecord = new MetaRecord();
            switch (n2) {
                case 1583: {
                    for (int i = 0; i < n3; ++i) {
                        this.readShort(dataInputStream);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    int n4;
                    short s2 = this.readShort(dataInputStream);
                    short s3 = this.readShort(dataInputStream);
                    int n5 = this.readInt(dataInputStream);
                    int n6 = 2 * (n3 - 4);
                    byte[] byArray = new byte[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        byArray[n4] = dataInputStream.readByte();
                    }
                    while (n4 < n6) {
                        dataInputStream.readByte();
                        ++n4;
                    }
                    String string = new String(byArray);
                    metaRecord = new StringRecord(string);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.AddElement(new Integer(s3));
                    metaRecord.AddElement(new Integer(s2));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 1313: {
                    int n5;
                    int n7 = this.readShort(dataInputStream);
                    byte[] byArray = new byte[n7];
                    for (n5 = 0; n5 < n7; ++n5) {
                        byArray[n5] = dataInputStream.readByte();
                    }
                    n5 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    String string = new String(byArray);
                    metaRecord = new StringRecord(string);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(n5));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 763: {
                    int n4;
                    short s4 = this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    short s5 = this.readShort(dataInputStream);
                    int n5 = dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    int n6 = 2 * (n3 - 9);
                    byte[] byArray = new byte[n6];
                    for (n4 = 0; n4 < n6; ++n4) {
                        byArray[n4] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    metaRecord = new StringRecord(string);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.AddElement(new Integer(s4));
                    metaRecord.AddElement(new Integer(n5));
                    metaRecord.AddElement(new Integer(s5));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 523: 
                case 524: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    short s6 = this.readShort(dataInputStream);
                    short s7 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s7));
                    metaRecord.AddElement(new Integer(s6));
                    this.records.addElement(metaRecord);
                    if (n2 != 524) break;
                    this.vpW = s6;
                    this.vpH = s7;
                    break;
                }
                case 764: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    int n8 = this.readInt(dataInputStream);
                    int n9 = n8 & 0xFF;
                    int n5 = (n8 & 0xFF00) >> 8;
                    int n6 = (n8 & 0xFF0000) >> 16;
                    metaRecord.AddElement(new Integer(n9));
                    metaRecord.AddElement(new Integer(n5));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 762: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    Integer n10 = new Integer(this.readShort(dataInputStream));
                    metaRecord.AddElement(n10);
                    short s8 = this.readShort(dataInputStream);
                    int n5 = this.readInt(dataInputStream);
                    this.readShort(dataInputStream);
                    int n6 = n5 & 0xFF;
                    int n11 = (n5 & 0xFF00) >> 8;
                    int n4 = (n5 & 0xFF0000) >> 16;
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(n11));
                    metaRecord.AddElement(new Integer(n4));
                    metaRecord.AddElement(new Integer(s8));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 513: 
                case 521: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n12 = this.readInt(dataInputStream);
                    int n13 = n12 & 0xFF;
                    int n5 = (n12 & 0xFF00) >> 8;
                    int n6 = (n12 & 0xFF0000) >> 16;
                    metaRecord.AddElement(new Integer(n13));
                    metaRecord.AddElement(new Integer(n5));
                    metaRecord.AddElement(new Integer(n6));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 531: 
                case 532: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    short s9 = this.readShort(dataInputStream);
                    short s10 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s10));
                    metaRecord.AddElement(new Integer(s9));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 1336: {
                    int n6;
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n14 = this.readShort(dataInputStream);
                    int[] nArray = new int[n14];
                    int n5 = 0;
                    for (n6 = 0; n6 < n14; ++n6) {
                        nArray[n6] = this.readShort(dataInputStream);
                        n5 += nArray[n6];
                    }
                    metaRecord.AddElement(new Integer(n14));
                    for (n6 = 0; n6 < n14; ++n6) {
                        metaRecord.AddElement(new Integer(nArray[n6]));
                    }
                    for (n6 = 0; n6 < n14; ++n6) {
                        for (int i = 0; i < nArray[n6]; ++i) {
                            metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                            metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                        }
                    }
                    this.records.addElement(metaRecord);
                    break;
                }
                case 804: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n15 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n15));
                    for (int i = 0; i < n15; ++i) {
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    }
                    this.records.addElement(metaRecord);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    short s11 = this.readShort(dataInputStream);
                    short s12 = this.readShort(dataInputStream);
                    int n5 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(n5));
                    metaRecord.AddElement(new Integer(s12));
                    metaRecord.AddElement(new Integer(s11));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 1564: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    short s13 = this.readShort(dataInputStream);
                    short s14 = this.readShort(dataInputStream);
                    int n5 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    short s15 = this.readShort(dataInputStream);
                    int n4 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(n4));
                    metaRecord.AddElement(new Integer(s15));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(n5));
                    metaRecord.AddElement(new Integer(s14));
                    metaRecord.AddElement(new Integer(s13));
                    this.records.addElement(metaRecord);
                    break;
                }
                case 2071: 
                case 2074: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    short s16 = this.readShort(dataInputStream);
                    short s17 = this.readShort(dataInputStream);
                    int n5 = this.readShort(dataInputStream);
                    int n6 = this.readShort(dataInputStream);
                    short s18 = this.readShort(dataInputStream);
                    int n4 = this.readShort(dataInputStream);
                    short s19 = this.readShort(dataInputStream);
                    short s20 = this.readShort(dataInputStream);
                    metaRecord.AddElement(new Integer(s20));
                    metaRecord.AddElement(new Integer(s19));
                    metaRecord.AddElement(new Integer(n4));
                    metaRecord.AddElement(new Integer(s18));
                    metaRecord.AddElement(new Integer(n6));
                    metaRecord.AddElement(new Integer(n5));
                    metaRecord.AddElement(new Integer(s17));
                    metaRecord.AddElement(new Integer(s16));
                    this.records.addElement(metaRecord);
                    break;
                }
                default: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    for (int i = 0; i < n3; ++i) {
                        metaRecord.AddElement(new Integer(this.readShort(dataInputStream)));
                    }
                    this.records.addElement(metaRecord);
                }
            }
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public void addObject(int n, Object object) {
        int n2;
        for (int i = n2 = 0; i < this.numObjects; ++i) {
            GdiObject gdiObject = (GdiObject)this.objectVector.elementAt(i);
            if (gdiObject.used) continue;
            gdiObject.Setup(n, object);
            this.lastObjectIdx = i;
            break;
        }
    }

    synchronized void setReading(boolean bl) {
        this.bReading = bl;
    }

    synchronized boolean isReading() {
        return this.bReading;
    }

    public void addObjectAt(int n, Object object, int n2) {
        if (n2 == 0 || n2 > this.numObjects) {
            this.addObject(n, object);
            return;
        }
        this.lastObjectIdx = n2;
        for (int i = 0; i < this.numObjects; ++i) {
            GdiObject gdiObject = (GdiObject)this.objectVector.elementAt(i);
            if (i != n2) continue;
            gdiObject.Setup(n, object);
            break;
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public GdiObject getObject(int n) {
        return (GdiObject)this.objectVector.elementAt(n);
    }

    public MetaRecord getRecord(int n) {
        return (MetaRecord)this.records.elementAt(n);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getNumObjects() {
        return this.numObjects;
    }

    public int getVpX() {
        return this.vpX;
    }

    public int getVpY() {
        return this.vpY;
    }

    public int getVpW() {
        return this.vpW;
    }

    public int getVpH() {
        return this.vpH;
    }

    public void setVpX(int n) {
        this.vpX = n;
    }

    public void setVpY(int n) {
        this.vpY = n;
    }

    public void setVpW(int n) {
        this.vpW = n;
    }

    public void setVpH(int n) {
        this.vpH = n;
    }
}

