/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.Visitor;

public class FCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private float value;

    FCONST() {
    }

    public FCONST(float f) {
        super((short)11, (short)1);
        if ((double)f == 0.0) {
            this.opcode = (short)11;
        } else if ((double)f == 1.0) {
            this.opcode = (short)12;
        } else if ((double)f == 2.0) {
            this.opcode = (short)13;
        } else {
            throw new ClassGenException("FCONST can be used only for 0.0, 1.0 and 2.0: " + f);
        }
        this.value = f;
    }

    public Number getValue() {
        return new Float(this.value);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.FLOAT;
    }

    public void accept(Visitor visitor) {
        visitor.visitPushInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitTypedInstruction(this);
        visitor.visitConstantPushInstruction(this);
        visitor.visitFCONST(this);
    }
}

